#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# https://qiita.com/_x8/items/d52204b8c31b26c5c42e
# OpenCVとWebSocketで, リアルタイムで様子が見れるもの
#
#	$ pip3 install gevent
#	$ pip3 install gevent-websocket

from bottle import request, Bottle, abort, static_file, template
from gevent import sleep					# ③
from gevent.timeout import Timeout			# ③
from gevent.pywsgi import WSGIServer
from geventwebsocket import WebSocketError
from geventwebsocket.handler import WebSocketHandler, Client
# from geventwebsocket.websocket import WebSocket
# from typing import Any, Dict, List, Callable, Tuple, Type

# https://stackoverflow.com/questions/31188874/why-is-gevent-websocket-synchronous
from gevent.lock import Semaphore

import json

import time
import datetime				# UNIX時間（エポック秒）をdatetimeオブジェクトに変換する

########## ｻｰﾊﾞｰのIPｱﾄﾞﾚｽを求めます。 ##########
import socket
def get_ip_address():
	with socket.socket(socket.AF_INET, socket.SOCK_DGRAM) as s:
		s.connect(("8.8.8.8", 80))
		return s.getsockname()[0]

################################################
def main():
	try:
		app = Bottle()
#		server = WSGIServer(("0.0.0.0", 8088), app, handler_class=WebSocketHandler)
		ip = get_ip_address()								# IPｱﾄﾞﾚｽ を取得

		# トップページ
		@app.route('/')
		def top():
#			return static_file('index2.html', root='./')

			params = dict( { "IP":ip } )						# IPｱﾄﾞﾚｽ を設定

			return template('main5.html',params)				# ﾃﾝﾌﾟﾚｰﾄの初期ﾌｫﾙﾀﾞは､views

		# https://stackoverflow.com/questions/31188874/why-is-gevent-websocket-synchronous
		sem = Semaphore()	# sleep(0.1) だと、handler.server.clients.values() が途中で書き換わる

		# WebSocketの処理
		@app.route('/websocket')
		def handle_websocket() :
			print('handle_websocket')
			websocket = request.environ.get('wsgi.websocket')

			if not websocket:
				abort(400, 'Expected WebSocket request.')

			#予想だけど、WebSocketHandlerはクライアントごとに生成される？
			handler = websocket.handler
#			message = websocket.receive()		# ① ｸﾗｲｱﾝﾄからの送信を 1回だけ受ける。

	#		cnt = 0
			while True:
		#		message = None
				try:
		#			handler = websocket.handler
					body = websocket.receive()
					if body :
						print(body)
						message = json.loads(body)
					else :
						continue

		#			# this adds a timeout to the wait for recieve, since it will wait forever.
		#			with Timeout(2, False) as timeout:	# ③ ｸﾗｲｱﾝﾄからの送信をﾀｲﾑｱｳﾄで抜ける
		#				message = websocket.receive()	# ② ｸﾗｲｱﾝﾄからの送信が無いと、待ち状態になる。
														# これが無いと、新しいｸﾗｲｱﾝﾄからのｱｸｾｽを受け付けない。

					# 実際の動作に必要でないけど、以下のようなクラスのインスタンスが入ってるのが解る
			#		assert type(websocket.handler) == WebSocketHandler
			#		assert type(websocket.handler.server) == WSGIServer

					# WSGIServerには本来、clientというプロパティは無いけど、コレを継承しているWebSocketHandlerで動的に追加されてる。
					# なので、型ヒントが利用できない（？）のでignoreするように

					message["text"] = "【" + message["text"] + "】"
					print(message["date"])		# JavaScriptの Date.now() は、ミリ秒
					dt = datetime.datetime.fromtimestamp(int(message["date"])/1000)		# UNIX時間(エポック秒) の単位は秒
					message["new_txt"] = '新規書き込み {0:%Y-%m-%d %H:%M:%S}'.format( dt )

					# 同時書き込みを防止するため、
					with sem:
						for client in handler.server.clients.values():
							if client.ws.environ:
					#			print(client.ws.environ.get('HTTP_SEC_WEBSOCKET_KEY', ''))
								pass
							else:
			#					print('空。ブラウザを閉じたり画面を更新したりすると、クライアントから「切断したよ」、という情報が飛んでくる。')
								print('切断')

				#			client.ws.send('message: %s, (client_address :%s)' % (message, client.address))
			#				client.ws.send('address=[{}] , count={} , message={}'.format( client.address,cnt,message ))
			#				client.ws.send('address=[{}] , count={}'.format( client.address,cnt ))
							client.ws.send( json.dumps(message) )

		#				cnt += 1
			#			time.sleep(3)						# ① で受けたｸﾗｲｱﾝﾄに、連続してｻｰﾊﾞｰからPUSHする。
															# ｸﾗｲｱﾝﾄ側は、setTimeout で、load後に、1度だけｱｸｾｽする。

					sleep(0.1)							# gevent.sleep なら、受信をﾛｯｸしない
					# RuntimeError: dictionary changed size during iteration
					# どうも、タイミングだけの様で、sleep(0.1) にすると、上記エラーが発生する。
					# Semaphore で、for client 処理中は、ロックすることにする。

				except WebSocketError as ex:
					print( 'WebSocketError {}'.format(ex))	# 例外処理の内容をコンソールに表示
					break

		server = WSGIServer(("0.0.0.0", 8088), app, handler_class=WebSocketHandler)
		server.serve_forever()

	except KeyboardInterrupt:
		print( "\nCtl+C Stop" )
	except Exception as ex:
		print( datetime.today().strftime( '%Y/%m/%d %H:%M:%S' ) )
		print( ex )								# 例外処理の内容をコンソールに表示
		import traceback
		traceback.print_exc()					# Exception のトレース
	finally :
		print( "終了" )

################################################
if __name__=='__main__':
	main()
