// 
// Copyright (c) 2003-2010, MIST Project, Nagoya University
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
// 
// 2. Redistributions in binary form must reproduce the above copyright notice,
// this list of conditions and the following disclaimer in the documentation
// and/or other materials provided with the distribution.
// 
// 3. Neither the name of the Nagoya University nor the names of its contributors
// may be used to endorse or promote products derived from this software
// without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
// IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
// THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

/// @file mist/bspline.h
//!
//! @brief BXvCȐ`悷邽߂̃Cu
//!

#ifndef __INCLUDE_BSPLINE__
#define __INCLUDE_BSPLINE__

#ifndef __INCLUDE_MIST_CONF_H__
#include "config/mist_conf.h"
#endif

#include <vector>


// mistOԂ̎n܂
_MIST_BEGIN


/// @brief BXvC̊֐vZ֐\
//!
//! KBXvC֐̌vZs
//!
template < int K >
struct bspline_base
{
	/// @brief KBXvC֐̌vZs
	//! 
	//! @param[in] knot c BXvCŗpmbgxNg
	//! @param[in] i    c BXvC̐_ԍ
	//! @param[in] t    c BXvC̋Ԉʒu
	//! 
	//! @return w肳ꂽmbgxNgC_ԍCԈʒuɊÂ֐̒l
	//! 
	static double Base( const std::vector< double > &knot, std::vector< double >::size_type i, double t )
	{
		double B = 0.0;

		if( knot[ i + K - 1 ] - knot[ i ] != 0 )
		{
			B = ( t - knot[ i ] ) * bspline_base< K - 1 >::Base( knot, i, t ) / ( knot[ i + K - 1 ] - knot[ i ] );
		}

		if( knot[ i + K ] - knot[ i + 1 ] != 0 )
		{
			B += ( knot[ i + K ] - t ) * bspline_base< K - 1 >::Base( knot, i + 1, t ) / ( knot[ i + K ] - knot[ i + 1 ] );
		}
		return( B );
	}
};


/// @brief BXvC̊֐vZ֐\̂̓ꉻ
//!
//! 1BXvC֐̌vZs߂̓ꉻ
//!
template < >
struct bspline_base< 1 >
{
	/// @brief KBXvC֐̌vZs
	//! 
	//! @param[in] knot c BXvCŗpmbgxNg
	//! @param[in] i    c BXvC̐_ԍ
	//! @param[in] t    c BXvC̋Ԉʒu
	//! 
	//! @return w肳ꂽmbgxNgC_ԍCԈʒuɊÂ֐̒l
	//! 
	static double Base( const std::vector< double > &knot, std::vector< double >::size_type i, double t )
	{
		return( ( knot[ i ] <= t && t < knot[ i + 1 ] ) ? 1.0 : 0.0 );
	}
};


//! @addtogroup free_form_group RȐEȖ
//!  @{



//! @addtogroup bspline_group BXvCȐ
//!
//! @code ̃wb_CN[h
//! #include <mist/bspline.h>
//! @endcode
//!
//!  @{


/// @brief BXvCȐ߂̃NX
//!
//! KBXvCȐ`\Dό̐_ɑΉCCӂ̃mbgxNgɑΉBXvCȐ`
//!
//! @attention ͂f[^^CZƒP̃XJ[lSĂɑ鑀ƕƂ̊|ZT|[gKvD
//! @attention Cvector2Cvector3 ͐삷悤ɂȂĂD
//! @attention array MISTRei𗘗pۂɂ́CIy[^LɂKvD
//! 
//! @param T  c e_Eԓ_\f[^\widouble  vector3< double > Ȃǁj
//! @param K  c BXvCȐ̎
//!
//! @code BXvCȐ̍쐬
//! // 3ŕϐ̌^ double BXvC쐬
//! mist::bspline< double, 3 > b;
//! 
//! // _ǉ
//! b.push_back( 2.0 );
//! b.push_back( 3.0 );
//! ...
//! 
//! // mbgxNgȉ̕@̂ꂩpĐݒ
//! // EȐ̐ݒ
//! b.knot( mist::bspline< double >::ROUND );
//! // EŏƍŌ̐_ʂꍇ̐ݒ
//! b.knot( mist::bspline< double >::THROUGH );
//! // ECӂ̃mbgxNgݒ
//! b.knot( STL̃xNg^Cṽmbg̃Xg );
//! 
//! // ԓ_vZiԂ͂O`Pj
//! double p1 = b( 0.0 );
//! double p2 = b( 0.4 );
//! double p3 = b( 0.7 );
//! ...
//! 
//! @endcode
//!
template < class T, int K, class Allocator = std::allocator< T > >
class bspline : public std::vector< T, Allocator >
{
private:
	typedef std::vector< T, Allocator > base;
	typedef typename base::allocator_type allocator_type;		///< @brief STLReipAP[^^
	typedef typename base::reference reference;					///< @brief STL̃ReiɊi[f[^^̎Q
	typedef typename base::const_reference const_reference;		///< @brief STL̃ReiɊi[f[^^ const Q
	typedef typename base::value_type value_type;				///< @brief STL̃ReiɊi[f[^^
	typedef typename base::size_type size_type;					///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
	typedef typename base::difference_type difference_type;		///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ
	typedef typename base::pointer pointer;						///< @brief STL̃ReiɊi[f[^^̃|C^[^
	typedef typename base::const_pointer const_pointer;			///< @brief STL̃ReiɊi[f[^^ const |C^[^

	typedef std::vector< double > knot_list;

public:
	/// @brief mbgxNg蓮Őݒ肵Ȃꍇ̃ftHg̃[h
	enum BSplineMode
	{
		ROUND,					///< @brief Ȑ̐ݒ
		THROUGH,				///< @brief ŏƍŌ̐_ʂꍇ̐ݒ
	};

protected:
	knot_list knot_;			///< @brief mbgxNg
	BSplineMode mode_;			///< @brief ftHg̃mbgxNgݒ


public:
	/// @brief w肳ꂽʒuiԂO`PjɑΉCBXvCԌʂԂ
	//!
	//! @attention {P̐_͂ĂKvDȂꍇ́CftHg̃mbgxNgōŏD
	//!
	//! @param[in] t  c Ŝ̋ȐԂO`PƂɁCԂ_̈ʒu
	//!
	//! @return w肳ꂽ_̈ʒuɑΉBXvCȐ̕Ԍ
	//!
	value_type operator( )( double t )
	{
		size_type n = base::size( ) - 1;	// n + 1 ͐_̐
		size_type m = n + K; 				// m + 1 ̓mbgxNg̐
		if( knot_.size( ) < m + 1 )
		{
			// sK؂ȃmbgxNgݒ肳Ă܂
			knot( mode_ );
		}
		else if( base::empty( ) )
		{
			return( value_type( 0 ) );
		}

		t *= static_cast< double >( m - 2 * K + 2 );

		// ܂C[vf쐬
		value_type p = value_type( base::operator[]( 0 ) ) * 0;
		for( size_type i = 0 ; i < base::size( ) ; i++ )
		{
			double B = bspline_base< K >::Base( knot_, i, t );
			p += B * base::operator[]( i );
		}

		return( p );
	}

	/// @brief Cӂ̃mbgxNgݒ肷
	//!
	//! @attention  K Ő_ N ƂɁCmbgxNg̐ N + K + 1 Kvł
	//! 
	//! @param[in] kknot  c mbgxNg
	//!
	void knot( const knot_list &kknot )
	{
		knot_ = kknot;
	}

	/// @brief ftHg̃[hŃmbgxNgݒ肷
	//!
	//! {NXŒ`Ă񋓌^ BSplineMode ̂̈𗘗p
	//! 
	//! @param[in] mode  c Ȑ̃^Cv
	//!
	void knot( BSplineMode mode )
	{
		size_type n = base::size( ) - 1;	// n + 1 ͐_̐
		size_type m = n + K; 				// m + 1 ̓mbgxNg̐
		size_type i;

		knot_list kknot( m + 1 );
		switch( mode )
		{
		case ROUND:
			// Ȍꍇ
			for( i = 0 ; i <= m ; i++ )
			{
				kknot[ i ] = static_cast< double >( i - K + 1 );
			}
			break;

		case THROUGH:
			// ŏƍŌʂȐ̏ꍇ
			for( i = 0 ; i < K ; i++ )
			{
				kknot[ i ] = 0.0;
			}
			for( i = K ; i < m - K + 1 ; i++ )
			{
				kknot[ i ] = static_cast< double >( i - K + 1 );
			}
			for( i = m - K + 1 ; i <= m ; i++ )
			{
				kknot[ i ] = static_cast< double >( 2 + m - 2 * K );
			}
			break;
		}

		knot( kknot );
	}

	/// @brief Zq
	const bspline &operator =( const bspline &b )
	{
		if( this != &b )
		{
			base::operator =( b );
			knot_ = b.knot_;
			mode_ = b.mode_;
		}
		return( *this );
	}

	/// @brief Rs[RXgN^
	bspline( const bspline &b ) : base( b ), knot_( b.knot_ ), mode_( b.mode_ )
	{
	}

	/// @brief ftHg̃RXgN^
	//!
	//! mbgxNg̃ftHgluŏƍŌʂȐvɐݒ肷
	//!
	bspline( ) : mode_( THROUGH )
	{
	}
};

/// @}
//  BXvCO[v̏I


/// @}
//  RȐEȖʃO[v̏I


// mistOԂ̏I
_MIST_END


#endif // __INCLUDE_BSPLINE__
