// 
// Copyright (c) 2003-2010, MIST Project, Nagoya University
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
// 
// 2. Redistributions in binary form must reproduce the above copyright notice,
// this list of conditions and the following disclaimer in the documentation
// and/or other materials provided with the distribution.
// 
// 3. Neither the name of the Nagoya University nor the names of its contributors
// may be used to endorse or promote products derived from this software
// without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
// IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
// THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

/// @file mist/config/pointer.h
//!
//! @brief ̎JȂǂs߂̃NX
//!

#ifndef __INCLUDE_MIST_POINTER_H__
#define __INCLUDE_MIST_POINTER_H__


#ifndef __INCLUDE_MIST_CONF_H__
#include "mist_conf.h"
#endif

#include <iostream>
#include <map>


// mistOԂ̎n܂
_MIST_BEGIN




namespace __shared_memory__
{
	template < class T >
	struct shared_base
	{
	private:
		typedef T* pointer;

		struct shared_memory_conter
		{
			typedef T* pointer;
			pointer ptr;
			size_t ref_count;
			size_t ref_weak_count;

			shared_memory_conter( ) : ptr( NULL ), ref_count( 0 ), ref_weak_count( 0 ){ }
			shared_memory_conter( pointer p, size_t rc, size_t rwc ) : ptr( p ), ref_count( rc ), ref_weak_count( rwc ){ }
		};

		typedef shared_memory_conter counter_type;
		typedef std::map< pointer, counter_type > ref_table_type;
		typedef typename ref_table_type::iterator ref_table_iterator;

	protected:
		static ref_table_type &get_ref_table( )
		{
			static ref_table_type ref_table_singleton_;
			return( ref_table_singleton_ );
		}

		static ref_table_iterator get_ref_iterator( pointer p )
		{
			ref_table_type &ref_table_ = get_ref_table( );

			if( p == NULL )
			{
				return( get_null_reference( ) ); 
			}
			else
			{
				ref_table_iterator ite = ref_table_.find( p );

				if( ite == ref_table_.end( ) )
				{
					// ŏ̒ǉ̂߁Ce[u
					ite = ref_table_.insert( typename ref_table_type::value_type( p, counter_type( p, 0, 0 ) ) ).first;
				}
				return( ite ); 
			}
		}

		static ref_table_iterator get_null_reference( )
		{
			ref_table_type &ref_table_ = get_ref_table( );
			// NULLQƗp̃f[^炩ߑ}Ă
			static ref_table_iterator null_ite_ = ref_table_.insert( typename ref_table_type::value_type( NULL, counter_type( NULL, 0, 0 ) ) ).first;
			return( null_ite_ ); 
		}

		ref_table_iterator ref_ite_;

		shared_base( ) : ref_ite_( get_null_reference( ) ){ }
		shared_base( const shared_base &b ) : ref_ite_( b.ref_ite_ ){}

		pointer get_pointer( ) const { return( ref_ite_->second.ptr ); }

	protected:
		// null QƂɐݒ肷
		void null_ref( )
		{
			ref_ite_ = get_null_reference( );
		}

		// QƗp̎QƃJEg𑝉
		void add_ref( )
		{
			// QƃJEg𑝂₷
			ref_ite_->second.ref_count++;
		}

		// QƗp̎QƃJEg𑝉
		void add_ref( pointer p )
		{
			ref_ite_ = get_ref_iterator( p );

			// QƃJEg𑝂₷
			ref_ite_->second.ref_count++;
		}

		// QƗp̎QƃJEg𑝉
		void add_ref( const shared_base &p )
		{
			ref_ite_ = p.ref_ite_;

			// QƃJEg𑝂₷
			ref_ite_->second.ref_count++;
		}

		// QƗp̎QƃJEg𑝉
		void add_weak_ref( )
		{
			// QƃJEg𑝂₷
			ref_ite_->second.ref_weak_count++;
		}

		// QƗp̎QƃJEg𑝉
		void add_weak_ref( pointer p )
		{
			ref_ite_ = get_ref_iterator( p );

			// QƃJEg𑝂₷
			ref_ite_->second.ref_weak_count++;
		}

		// QƗp̎QƃJEg𑝉
		void add_weak_ref( const shared_base &p )
		{
			ref_ite_ = p.ref_ite_;

			// QƃJEg𑝂₷
			ref_ite_->second.ref_weak_count++;
		}

		void release( bool isArray )
		{
			counter_type &c = ref_ite_->second;
			if( c.ptr != NULL )
			{
				// QƃJEg炷
				c.ref_count--;

				// QƃJEgɂāC̊Js
				if( c.ref_count == 0 )
				{
					// QƃJEg 0 ɂȂ̂ŁCJe[u폜
					if( isArray )
					{
						delete [] c.ptr;
					}
					else
					{
						delete c.ptr;
					}

					// |C^ɑ΂QƂ݂Ȃꍇ́CNULL
					if( c.ref_weak_count == 0 )
					{
						ref_table_type &table = get_ref_table( );
						table.erase( ref_ite_ );
					}
					else
					{
						c.ptr = NULL;
					}
				}
			}
		}

		void release_weak( )
		{
			counter_type &c = ref_ite_->second;

			if( c.ptr != NULL )
			{
				// QƃJEg炷
				c.ref_weak_count--;

				if( c.ref_weak_count == 0 && c.ref_count == 0 )
				{
					// |C^ɑ΂QƂƎQƂ݂Ȃꍇ́Ce[u폜
					ref_table_type &table = get_ref_table( );
					table.erase( ref_ite_ );
				}
			}
		}
	};
}



//! @addtogroup pointer_group ̈̎Js|C^
//!
//! @code ̃wb_Q
//! #include <mist/config/pointer.h>
//! @endcode
//!
//! @{


/// @brief IuWFNg̃XR[v؂ƎIɃJs|C^
//! 
//! @attention zɑ΂Ă͗płȂ
//! @attention ǗĂ|C^𑼂̃IuWFNgɏn邱Ƃ͂łȂ
//! 
//! @code |C^̎gp
//! {
//!     mist::scoped_ptr< std::string > a( new std::string( "test" ) );
//!	    std::cout << *a << std::endl;
//! } // <-  a Ɋ蓖Ă̈悪CIɊJ
//! @endcode
//! 
template < class T >
class scoped_ptr
{
public:
	typedef size_t size_type;			///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
	typedef ptrdiff_t difference_type;	///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ
	typedef T value_type;				///< @brief f[^^DT Ɠ
	typedef T* pointer;					///< @brief f[^^̃|C^[^Ddata ̏ꍇCdata * ƂȂ
	typedef T& reference;				///< @brief f[^^̎QƁDdata ̏ꍇCdata & ƂȂ
	typedef const T& const_reference;	///< @brief f[^^ const QƁDdata ̏ꍇCconst data & ƂȂ
	typedef const T* const_pointer;		///< @brief f[^^ const |C^[^Ddata ̏ꍇCconst data * ƂȂ

private:
	pointer ptr_;		///< @brief Ǘ|C^

public:
	/// @brief Ǘ|C^ݒ
	scoped_ptr( pointer p ) : ptr_( p ){ }

	/// @brief Ǘ|C^J
	~scoped_ptr( ){ delete ptr_; }


public:
	reference operator *( ){ return( *ptr_ ); }
	const_reference operator *( ) const { return( *ptr_ ); }

	pointer operator ->( ){ return( ptr_ ); }
	const_pointer operator ->( ) const { return( ptr_ ); }


private:
	scoped_ptr( const scoped_ptr &p );
	const scoped_ptr &operator  =( const scoped_ptr &p );
};



/// @brief IuWFNg̃XR[v؂ƔzpɊmۂ̎Js|C^
//! 
//! @attention z̃|C^ɑ΂ĂpłȂ
//! @attention ǗĂ|C^𑼂̃IuWFNgɏn邱Ƃ͂łȂ
//! 
//! @code |C^̎gp
//! {
//!     mist::scoped_array< std::string > a( new std::string[ 2 ] );
//!	
//!	    a[ 0 ] = "test1";
//!	    a[ 1 ] = "test2";
//!	
//!	    std::cout << a[ 0 ] << a[ 1 ] << std::endl;
//! } // <-  a Ɋ蓖Ă̈悪CIɊJ
//! @endcode
//! 
template < class T >
class scoped_array
{
public:
	typedef size_t size_type;			///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
	typedef ptrdiff_t difference_type;	///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ
	typedef T value_type;				///< @brief f[^^DT Ɠ
	typedef T* pointer;					///< @brief f[^^̃|C^[^Ddata ̏ꍇCdata * ƂȂ
	typedef T& reference;				///< @brief f[^^̎QƁDdata ̏ꍇCdata & ƂȂ
	typedef const T& const_reference;	///< @brief f[^^ const QƁDdata ̏ꍇCconst data & ƂȂ
	typedef const T* const_pointer;		///< @brief f[^^ const |C^[^Ddata ̏ꍇCconst data * ƂȂ

private:
	pointer ptr_;		///< @brief Ǘ|C^

public:
	/// @brief  b ŏ
	scoped_array( pointer p ) : ptr_( p ){ }

	~scoped_array( ){ delete [] ptr_; }


public:
	reference operator *( ){ return( *ptr_ ); }
	const_reference operator *( ) const { return( *ptr_ ); }

	pointer operator ->( ){ return( ptr_ ); }
	const_pointer operator ->( ) const { return( ptr_ ); }

	reference operator []( difference_type index ){ return( ptr_[ index ] ); }
	const_reference operator []( difference_type index ) const { return( ptr_[ index ] ); }

private:
	scoped_array( const scoped_array &p );
	const scoped_array &operator  =( const scoped_array &p );
};



/// @brief IuWFNgւ̃|C^̎QƃJEgǗCǂQƂȂȂƂɃJ|C^
//! 
//! @attention zɑ΂Ă͗płȂ
//! @attention zQƂꍇ́CǗłȂ
//! 
//! @code |C^̎gp
//! {
//!     mist::shared_ptr< std::string > a;
//!     {
//!         mist::shared_ptr< std::string > b = new std::string( "test" );
//!	
//!	        a = b;    // a  b Ɠ̈QƂ悤ɂCQƃJEg𑝂₷
//!	
//!	    } // <- ł b Ɋ蓖Ă̈̎QƃJEg邪Ca ̈QƂĂ̂ŁC̈͊JȂ
//!	
//!  ...
//!	
//! } // <-  a Ɋ蓖Ă̈悪ǂQƂȂȂ邽߁C̈悪IɊJ
//! @endcode
//! 
template < class T >
class shared_ptr : public __shared_memory__::shared_base< T >
{
public:
	typedef size_t size_type;			///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
	typedef ptrdiff_t difference_type;	///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ
	typedef T value_type;				///< @brief f[^^DT Ɠ
	typedef T* pointer;					///< @brief f[^^̃|C^[^Ddata ̏ꍇCdata * ƂȂ
	typedef T& reference;				///< @brief f[^^̎QƁDdata ̏ꍇCdata & ƂȂ
	typedef const T& const_reference;	///< @brief f[^^ const QƁDdata ̏ꍇCconst data & ƂȂ
	typedef const T* const_pointer;		///< @brief f[^^ const |C^[^Ddata ̏ꍇCconst data * ƂȂ

private:
	typedef __shared_memory__::shared_base< T > base;


public:
	/// @brief Ǘ̃|C^ŏ
	shared_ptr( ){ }

	/// @brief Ǘ|C^ݒ肵CQƃJEg 1 ₷
	shared_ptr( pointer p ){ base::add_ref( p ); }

	/// @brief ̋L|C^pďCQƃJEg 1 ₷
	shared_ptr( const shared_ptr &p ) : base( p ){ base::add_ref( ); }

	/// @brief Ǘ|C^̎QƃJEg1炷
	//!
	//! ǂQƂȂȂ烁J
	//! 
	~shared_ptr( ){ base::release( false ); }


	/// @brief ̋L|C^
	//!
	//! @attention łɊǗĂ|C^ꍇ́CQƃJEg1炷
	//! @attention ̍ۂɁCǂQƂȂȂ烁J
	//! 
	const shared_ptr &operator =( const shared_ptr &p )
	{
		if( &p != this )
		{
			base::release( false );
			base::add_ref( p );
		}

		return( *this );
	}

public:
	/// @brief |C^weւ̎QƂԂ
	reference operator *( ){ return( *base::get_pointer( ) ); }

	/// @brief |C^weւ̎QƂԂ
	const_reference operator *( ) const { return( *base::get_pointer( ) ); }

	/// @brief |C^weւ̃ANZXs
	pointer operator ->( ){ return( base::get_pointer( ) ); }

	/// @brief |C^weւ̃ANZXs
	const_pointer operator ->( ) const { return( base::get_pointer( ) ); }



	/// @brief ǗĂ|C^̎QƃJEg炷
	//!
	//! @attention ǂQƂȂȂ烁J
	//! 
	void reset( )
	{ 
		base::release( false );
		base::null_ref( );
	}

public:
	/// @brief 2̃|C^ꂩǂ𔻒肷
	bool operator ==( const shared_ptr &p ) const { return( base::get_pointer( ) == p.get_pointer( ) ); }

	/// @brief 2̃|C^Ȃǂ𔻒肷
	bool operator !=( const shared_ptr &p ) const { return( base::get_pointer( ) != p.get_pointer( ) ); }

	/// @brief 2̃|C^ <  𔻒肷
	bool operator < ( const shared_ptr &p ) const { return( base::get_pointer( ) <  p.get_pointer( ) ); }

	/// @brief 2̃|C^ <= 𔻒肷
	bool operator <=( const shared_ptr &p ) const { return( base::get_pointer( ) <= p.get_pointer( ) ); }

	/// @brief 2̃|C^ >  𔻒肷
	bool operator > ( const shared_ptr &p ) const { return( base::get_pointer( ) >  p.get_pointer( ) ); }

	/// @brief 2̃|C^ >= 𔻒肷
	bool operator >=( const shared_ptr &p ) const { return( base::get_pointer( ) >= p.get_pointer( ) ); }


	/// @brief 2̃|C^ꂩǂ𔻒肷
	bool operator ==( const pointer &p ) const { return( base::get_pointer( ) == p ); }

	/// @brief 2̃|C^Ȃǂ𔻒肷
	bool operator !=( const pointer &p ) const { return( base::get_pointer( ) != p ); }

	/// @brief 2̃|C^ <  𔻒肷
	bool operator < ( const pointer &p ) const { return( base::get_pointer( ) <  p ); }

	/// @brief 2̃|C^ <= 𔻒肷
	bool operator <=( const pointer &p ) const { return( base::get_pointer( ) <= p ); }

	/// @brief 2̃|C^ >  𔻒肷
	bool operator > ( const pointer &p ) const { return( base::get_pointer( ) >  p ); }

	/// @brief 2̃|C^ >= 𔻒肷
	bool operator >=( const pointer &p ) const { return( base::get_pointer( ) >= p ); }

};

template < class T > inline bool operator ==( const typename shared_ptr< T >::pointer p1, const shared_ptr< T > &p2 ){ return( p2 == p1 ); }
template < class T > inline bool operator !=( const typename shared_ptr< T >::pointer p1, const shared_ptr< T > &p2 ){ return( p2 != p1 ); }

template < class T > inline bool operator < ( const typename shared_ptr< T >::pointer p1, const shared_ptr< T > &p2 ){ return( !( p2 <= p1 ) ); }
template < class T > inline bool operator <=( const typename shared_ptr< T >::pointer p1, const shared_ptr< T > &p2 ){ return( !( p2 <  p1 ) ); }
template < class T > inline bool operator > ( const typename shared_ptr< T >::pointer p1, const shared_ptr< T > &p2 ){ return( !( p2 >= p1 ) ); }
template < class T > inline bool operator >=( const typename shared_ptr< T >::pointer p1, const shared_ptr< T > &p2 ){ return( !( p2 >  p1 ) ); }




/// @brief zւ̃|C^̎QƃJEgǗCǂQƂȂȂƂɃJ|C^
//! 
//! ΏۂzƂƂ΁Cshared_ptr Ɠ
//! 
//! @attention zɑ΂ĂpłȂ
//! @attention zQƂꍇ́CǗłȂ
//! 
//! @code |C^̎gp
//! {
//!     mist::shared_ptr< std::string > a;
//!     {
//!         mist::shared_ptr< std::string > b = new std::string[ 2 ];
//!	
//!	        a = b;    // a  b Ɠ̈QƂ悤ɂCQƃJEg𑝂₷
//!	
//!	        a[ 0 ] = a[ 1 ] = "test";
//!	
//!	    } // <- ł b Ɋ蓖Ă̈̎QƃJEg邪Ca ̈QƂĂ̂ŁC̈͊JȂ
//!	
//!  ...
//!	
//! } // <-  a Ɋ蓖Ă̈悪ǂQƂȂȂ邽߁C̈悪IɊJ
//! @endcode
//! 
template < class T >
class shared_array : public __shared_memory__::shared_base< T >
{
public:
	typedef size_t size_type;			///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
	typedef ptrdiff_t difference_type;	///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ
	typedef T value_type;				///< @brief f[^^DT Ɠ
	typedef T* pointer;					///< @brief f[^^̃|C^[^Ddata ̏ꍇCdata * ƂȂ
	typedef T& reference;				///< @brief f[^^̎QƁDdata ̏ꍇCdata & ƂȂ
	typedef const T& const_reference;	///< @brief f[^^ const QƁDdata ̏ꍇCconst data & ƂȂ
	typedef const T* const_pointer;		///< @brief f[^^ const |C^[^Ddata ̏ꍇCconst data * ƂȂ

private:
	typedef __shared_memory__::shared_base< T > base;

public:
	/// @brief Ǘ̃|C^ŏ
	shared_array( ){ }

	/// @brief Ǘ|C^ݒ肵CQƃJEg 1 ₷
	shared_array( pointer p ){ base::add_ref( p ); }

	/// @brief ̋L|C^pďCQƃJEg 1 ₷
	shared_array( const shared_array &p ) : base( ) { base::add_ref( p ); }

	/// @brief Ǘ|C^̎QƃJEg1炷
	//!
	//! ǂQƂȂȂ烁J
	//! 
	~shared_array( ){ base::release( true ); }


	/// @brief ̋L|C^
	//!
	//! @attention łɊǗĂ|C^ꍇ́CQƃJEg1炷
	//! @attention ̍ۂɁCǂQƂȂȂ烁J
	//! 
	const shared_array &operator =( const shared_array &p )
	{
		if( &p != this )
		{
			base::release( true );
			base::add_ref( p );
		}

		return( *this );
	}

public:
	/// @brief |C^weւ̎QƂԂ
	reference operator *( ){ return( *base::get_pointer( ) ); }

	/// @brief |C^weւ̎QƂԂ
	const_reference operator *( ) const { return( *base::get_pointer( ) ); }

	/// @brief |C^weւ̃ANZXs
	pointer operator ->( ){ return( base::get_pointer( ) ); }

	/// @brief |C^weւ̃ANZXs
	const_pointer operator ->( ) const { return( base::get_pointer( ) ); }

	/// @brief z̗vfւ̃ANZXs
	reference operator []( difference_type index ){ return( base::get_pointer( )[ index ] ); }

	/// @brief z̗vfւ̃ANZXs
	const_reference operator []( difference_type index ) const { return( base::get_pointer( )[ index ] ); }


	/// @brief ǗĂ|C^̎QƃJEg炷
	//!
	//! @attention ǂQƂȂȂ烁J
	//! 
	void reset( )
	{ 
		base::release( true );
		base::null_ref( );
	}


public:
	/// @brief 2̃|C^ꂩǂ𔻒肷
	bool operator ==( const shared_array &p ) const { return( base::get_pointer( ) == p.get_pointer( ) ); }

	/// @brief 2̃|C^Ȃǂ𔻒肷
	bool operator !=( const shared_array &p ) const { return( base::get_pointer( ) != p.get_pointer( ) ); }

	/// @brief 2̃|C^ <  𔻒肷
	bool operator < ( const shared_array &p ) const { return( base::get_pointer( ) <  p.get_pointer( ) ); }

	/// @brief 2̃|C^ <= 𔻒肷
	bool operator <=( const shared_array &p ) const { return( base::get_pointer( ) <= p.get_pointer( ) ); }

	/// @brief 2̃|C^ >  𔻒肷
	bool operator > ( const shared_array &p ) const { return( base::get_pointer( ) >  p.get_pointer( ) ); }

	/// @brief 2̃|C^ >= 𔻒肷
	bool operator >=( const shared_array &p ) const { return( base::get_pointer( ) >= p.get_pointer( ) ); }


	/// @brief 2̃|C^ꂩǂ𔻒肷
	bool operator ==( const pointer &p ) const { return( base::get_pointer( ) == p ); }

	/// @brief 2̃|C^Ȃǂ𔻒肷
	bool operator !=( const pointer &p ) const { return( base::get_pointer( ) != p ); }

	/// @brief 2̃|C^ <  𔻒肷
	bool operator < ( const pointer &p ) const { return( base::get_pointer( ) <  p ); }

	/// @brief 2̃|C^ <= 𔻒肷
	bool operator <=( const pointer &p ) const { return( base::get_pointer( ) <= p ); }

	/// @brief 2̃|C^ >  𔻒肷
	bool operator > ( const pointer &p ) const { return( base::get_pointer( ) >  p ); }

	/// @brief 2̃|C^ >= 𔻒肷
	bool operator >=( const pointer &p ) const { return( base::get_pointer( ) >= p ); }

};

template < class T > inline bool operator ==( const typename shared_array< T >::pointer p1, const shared_array< T > &p2 ){ return( p2 == p1 ); }
template < class T > inline bool operator !=( const typename shared_array< T >::pointer p1, const shared_array< T > &p2 ){ return( p2 != p1 ); }

template < class T > inline bool operator < ( const typename shared_array< T >::pointer p1, const shared_array< T > &p2 ){ return( !( p2 <= p1 ) ); }
template < class T > inline bool operator <=( const typename shared_array< T >::pointer p1, const shared_array< T > &p2 ){ return( !( p2 <  p1 ) ); }
template < class T > inline bool operator > ( const typename shared_array< T >::pointer p1, const shared_array< T > &p2 ){ return( !( p2 >= p1 ) ); }
template < class T > inline bool operator >=( const typename shared_array< T >::pointer p1, const shared_array< T > &p2 ){ return( !( p2 >  p1 ) ); }



/// @brief QƃJEg^̃ɑ΂CQƂ|C^
//! 
//! QƃJEg 0 ɂۂɁCێ|C^ NULL ƂȂ
//! 
//! @attention weak_ptr g͎QƃJEgωȂ
//! 
//! @code Qƃ|C^̎gp
//! {
//! mist::weak_ptr< std::string > a;
//!	
//! std::cout << a << std::endl;    // <- a ͂ǂQƂĂȂ̂ NULL  Ă
//!	
//! {
//!     mist::shared_ptr< std::string > b = new std::string[ 2 ];
//!	
//!	    a = b;    // b ̎QƂ a ɐݒ肷
//!	
//!	    std::cout << a << std::endl;    // <- a  b QƂĂ̂ b ̎QƐ悪\
//!	
//!	} // <-  b Ɋ蓖Ă̈悪ǂQƂȂȂ邽߁C̈悪IɊJ
//!	
//! std::cout << a << std::endl;    // <- a QƂĂ b ݂͂Ȃ̂ŁC NULL Ă
//! @endcode
//! 
template < class T >
class weak_ptr : public __shared_memory__::shared_base< T >
{
public:
	typedef size_t size_type;			///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
	typedef ptrdiff_t difference_type;	///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ
	typedef T value_type;				///< @brief f[^^DT Ɠ
	typedef T* pointer;					///< @brief f[^^̃|C^[^Ddata ̏ꍇCdata * ƂȂ
	typedef T& reference;				///< @brief f[^^̎QƁDdata ̏ꍇCdata & ƂȂ
	typedef const T& const_reference;	///< @brief f[^^ const QƁDdata ̏ꍇCconst data & ƂȂ
	typedef const T* const_pointer;		///< @brief f[^^ const |C^[^Ddata ̏ꍇCconst data * ƂȂ

private:
	typedef __shared_memory__::shared_base< T > base;

public:
	/// @brief Ǘ̃|C^ŏ
	weak_ptr( ){ base::add_weak_ref( NULL ); }

	/// @brief L|C^̎QƂpď
	weak_ptr( shared_ptr< T > &p ){ base::add_weak_ref( p ); }

	/// @brief L|C^̎QƂpď
	weak_ptr( const shared_ptr< T > &p ){ base::add_weak_ref( p ); }

	/// @brief L^̔z|C^̎QƂpď
	weak_ptr( shared_array< T > &p ){ base::add_weak_ref( p ); }

	/// @brief L^̔z|C^̎QƂpď
	weak_ptr( const shared_array< T > &p ){ base::add_weak_ref( p ); }

	/// @brief QƂ̎QƃJEg1炷
	~weak_ptr( ){ base::release_weak( ); }


	/// @brief ̋L|C^
	//!
	//! @attention łɊǗĂ|C^ꍇ́CQƃJEg1炷
	//! @attention ̍ۂɁCǂQƂȂȂ烁J
	//! 
	const weak_ptr &operator =( const weak_ptr &p )
	{
		if( this != &p )
		{
			base::release_weak( );
			base::add_weak_ref( p );
		}

		return( *this );
	}

	/// @brief ̋L|C^
	//!
	//! @attention łɊǗĂ|C^ꍇ́CQƃJEg1炷
	//! @attention ̍ۂɁCǂQƂȂȂ烁J
	//! 
	const weak_ptr &operator =( const shared_ptr< T > &p )
	{
		base::release_weak( );
		base::add_weak_ref( p );

		return( *this );
	}

	/// @brief ̋L^̔z|C^
	//!
	//! @attention łɊǗĂ|C^ꍇ́CQƃJEg1炷
	//! @attention ̍ۂɁCǂQƂȂȂ烁J
	//! 
	const weak_ptr &operator =( const shared_array< T > &p )
	{
		base::release_weak( );
		base::add_weak_ref( p );

		return( *this );
	}


public:
	/// @brief |C^weւ̎QƂԂ
	reference operator *( ){ return( *base::get_pointer( ) ); }

	/// @brief |C^weւ̎QƂԂ
	const_reference operator *( ) const { return( *base::get_pointer( ) ); }

	/// @brief |C^weւ̃ANZXs
	pointer operator ->( ){ return( base::get_pointer( ) ); }

	/// @brief |C^weւ̃ANZXs
	const_pointer operator ->( ) const { return( base::get_pointer( ) ); }

	/// @brief z̗vfւ̃ANZXs
	reference operator []( difference_type index ){ return( base::get_pointer( )[ index ] ); }

	/// @brief z̗vfւ̃ANZXs
	const_reference operator []( difference_type index ) const { return( base::get_pointer( )[ index ] ); }


	/// @brief ǗĂ|C^̎QƃJEg炷
	//!
	//! @attention ǂQƂȂȂ烁J
	//! 
	void reset( )
	{ 
		base::release_weak( );
		base::null_ref( );
	}


public:
	/// @brief 2̃|C^ꂩǂ𔻒肷
	bool operator ==( const weak_ptr &p ) const { return( base::get_pointer( ) == p.get_pointer( ) ); }

	/// @brief 2̃|C^Ȃǂ𔻒肷
	bool operator !=( const weak_ptr &p ) const { return( base::get_pointer( ) != p.get_pointer( ) ); }

	/// @brief 2̃|C^ <  𔻒肷
	bool operator < ( const weak_ptr &p ) const { return( base::get_pointer( ) <  p.get_pointer( ) ); }

	/// @brief 2̃|C^ <= 𔻒肷
	bool operator <=( const weak_ptr &p ) const { return( base::get_pointer( ) <= p.get_pointer( ) ); }

	/// @brief 2̃|C^ >  𔻒肷
	bool operator > ( const weak_ptr &p ) const { return( base::get_pointer( ) >  p.get_pointer( ) ); }

	/// @brief 2̃|C^ >= 𔻒肷
	bool operator >=( const weak_ptr &p ) const { return( base::get_pointer( ) >= p.get_pointer( ) ); }


	/// @brief 2̃|C^ꂩǂ𔻒肷
	bool operator ==( const pointer &p ) const { return( base::get_pointer( ) == p ); }

	/// @brief 2̃|C^Ȃǂ𔻒肷
	bool operator !=( const pointer &p ) const { return( base::get_pointer( ) != p ); }

	/// @brief 2̃|C^ <  𔻒肷
	bool operator < ( const pointer &p ) const { return( base::get_pointer( ) <  p ); }

	/// @brief 2̃|C^ <= 𔻒肷
	bool operator <=( const pointer &p ) const { return( base::get_pointer( ) <= p ); }

	/// @brief 2̃|C^ >  𔻒肷
	bool operator > ( const pointer &p ) const { return( base::get_pointer( ) >  p ); }

	/// @brief 2̃|C^ >= 𔻒肷
	bool operator >=( const pointer &p ) const { return( base::get_pointer( ) >= p ); }

};


template < class T > inline bool operator ==( const typename weak_ptr< T >::pointer p1, const weak_ptr< T > &p2 ){ return( p2 == p1 ); }
template < class T > inline bool operator !=( const typename weak_ptr< T >::pointer p1, const weak_ptr< T > &p2 ){ return( p2 != p1 ); }

template < class T > inline bool operator < ( const typename weak_ptr< T >::pointer p1, const weak_ptr< T > &p2 ){ return( !( p2 <= p1 ) ); }
template < class T > inline bool operator <=( const typename weak_ptr< T >::pointer p1, const weak_ptr< T > &p2 ){ return( !( p2 <  p1 ) ); }
template < class T > inline bool operator > ( const typename weak_ptr< T >::pointer p1, const weak_ptr< T > &p2 ){ return( !( p2 >= p1 ) ); }
template < class T > inline bool operator >=( const typename weak_ptr< T >::pointer p1, const
											 
											 weak_ptr< T > &p2 ){ return( !( p2 >  p1 ) ); }


/// @brief w肳ꂽXg[Ƀf[^o͂
//! 
//! @param[in,out] out c ͂Əo͂sXg[
//! @param[in]     p   c scoped_ptr z
//! 
//! @return ͂ꂽXg[
//! 
template < class T >
inline std::ostream &operator <<( std::ostream &out, const scoped_ptr< T > &p )
{
	out << &( *p );
	return( out );
}


/// @brief w肳ꂽXg[Ƀf[^o͂
//! 
//! @param[in,out] out c ͂Əo͂sXg[
//! @param[in]     p   c scoped_array z
//! 
//! @return ͂ꂽXg[
//! 
template < class T >
inline std::ostream &operator <<( std::ostream &out, const scoped_array< T > &p )
{
	out << &( *p );
	return( out );
}


/// @brief w肳ꂽXg[Ƀf[^o͂
//! 
//! @param[in,out] out c ͂Əo͂sXg[
//! @param[in]     p   c shared_ptr z
//! 
//! @return ͂ꂽXg[
//! 
template < class T >
inline std::ostream &operator <<( std::ostream &out, const shared_ptr< T > &p )
{
	out << &( *p );
	return( out );
}

/// @brief w肳ꂽXg[Ƀf[^o͂
//! 
//! @param[in,out] out c ͂Əo͂sXg[
//! @param[in]     p   c weak_ptr z
//! 
//! @return ͂ꂽXg[
//! 
template < class T >
inline std::ostream &operator <<( std::ostream &out, const weak_ptr< T > &p )
{
	out << &( *p );
	return( out );
}

/// @}
//  ̈̎Js|C^



// mistOԂ̏I
_MIST_END


#endif // __INCLUDE_MIST_POINTER_H__
