#include <emsg: see ... '~$ sh aaa.sh.c -h'   (other opt:no/-m/-w/)>	/*
C='^[#]SH_'			;O=${0##*[/]};R=`dirname $0`/;R0=$R$O;Re=eval\ ;R=$R${O%%.*}
O=${0##*.};Rs=$R.$O;Rm=$R.tmp.$O;Rh=$R.h;R=$Rs$Rh$Rm;Rp='printf %s\n ';Rc=:;O="
";[ "${R##*$R0*}" = '' ]&&$Rp"$0:NGext"&&exit 1;R='sed -ne ';Cm=$R'"/[E]ND/!d;:l
n;p;b l"<$R0>$Rm;$Rp"$Rm"';Rw=$R'"/$C$R/!d;:l;n;/${C}ED/q;p;b l"<$R0';Cw="(R=LS
$Rw;$Rw>&3;R=HD;$Rw;R=SC;$Rw>&3)"'>$Rh 3>$Rs;$Rp"$Rh $Rs"';RB=$($R"s/${C}OP//p"\
<$R0|(F=mw;while read -r a b;do B=${a%:};F=`$Rp"$F"|$R"s#$B:*##;p"`${a%_};$Rp"
C$B=\$(cat<<'E'$O$b${O}E$O)";done;$Rp"R1=$F"));$Re"$RB";while getopts $R1 R;do
case $R in \?)exit 1;;*)$Re"O$R=\$OPTARG";Rc=$Rc$O`$Re'$Rp"$C'$R\"`;;esac;done
[ "$Rc" = : ]&&Rc=$Cm;shift $((OPTIND-1));$Re"$C_$O$Rc";exit #END  GPLv3+*/

#SH_LS
#!/bin/sh
# AGPLv3+
:<< 'EEE'
/* Copyright (C) 2018 Momi-g

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU Affero General Public License as
 published by the Free Software Foundation, either version 3 of the
 License, or (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU Affero General Public License for more details.
 
 You should have received a copy of the GNU Affero General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/
EEE

:<< 'EEE'
#SH_doc
title=*SH_bn* section=1 repnl=\040
@name *SH_bn*
@_brief move/resize x11 app window
@_syno
	w_resize [-hHV]
	w_resize [-w lv]
	w_resize -R [wid]
	w_resize [-mr val] [wid]
	([wid]  == 0x1234| -a| none(==mouse select) )
@tl_dr
		@(code)@
	~$ w_resize -a	#>> output cmd for make window state 
	#>> wmctrl -ir 0x1234 -e 1,70,868,1718,946
	
	~$ w_resize -m 10,100,3 0x1234		# move to x10,y100,pinpos=3
	~$ w_resize -r 100,200,1 0x1234		# resize to w100,h200,pinpos=1
	~$ w_resize -R 0x1234		# reset resize
		@()
@_opt
		@(list_o)
	-hHV: usage, version
	
	-w lv: wmctrl/w_resize fails if CPU is too fast. add wait 0(dfl)-9 --
		~$ w_resize -w 2 -m +10,y,1

	-a: use active window instead of wid
	
	-m val: move. val is x,y,p == 100,200,1 / p1,x100,y200 etc.--
		~$ w_resize -m 100,y,1 #>> no change y val--
		~$ w_resize -m x100a%-10,p9,y #>> scrwidth-10pix
		
	-r val: resize. val is w,h,p == 10,20,5 / w10,h20,p5 etc --
		~$ w_resize -r w,200,1 #>> no change width --
		~$ w_resize -r h200,p1,ww
		
	-R: reset resize
		@()--
	
@_desc
	window resize/move helper. some app wmctrl/xdotool has the same function,
	but cause gap by window flame. this pg adjusts the gap. 
	select window if wid isnt. --
	--
	-m/-r takes comma separated 3 values. basic seq is x,y,p / w,h,p. --
	if pfix 1 char 'x/y/m/h/p' is set, seq is ignored. y10,p3,x100 / p1,h10,w20 etc.--
	the last 'p' is resize/move pinning pos p=0-9. 
	p0 is autopos. p0==p2 if -m opt. p0==p1/3/7/9 if -r opt.
		@(code)--
  p1 *----*p2---* p3
     |          |     (app window)
  p4 *    *p5   * p6  
     |          | 
  p7 *----*p8---* p9
		@()--
	
	'xywh' takes coordinate values. each value takes 'num-like' token holds
	some chars '%+-xywhab'.
		@(code)--
     (case p1)
     +-----------------------+
     |          | 100y%      | screen
     | 100x%    |            | (workarea: taskbar is removed)
     | -------- +---+        |
     |          |win| 100h%  | 
     |          +---+        | 100b%  
     |          100w%        |   
     +-----------------------+
       100a%
       
     - 'x/y/w/h/a/b' == '100x%/100y%/100w%/100h%/100a%/100b%'
     - '100%': treat as 100a/b/w/h%, depends on opt -m/r.
		@()--
	
	value examples are the below:
		@(code)--
	value token ERE: /[xymhp]?([-+]?[0-9]*[abxymh]?[%]?)+/

	w_resize -m 100,200,3	#>> absolute, x=100,y=200. basic-syntax
	w_resize -m p3,x100,y200	#>> sequence free if prefix is
	w_resize -m x100,y200,p3

	w_resize -m 0,0,1		#>> fit upper-left
	w_resize -m a,0,p3	#>> fit upeer-right
	w_resize -m 50a%,b,8	#>> fit bottom-center
	w_resize -m xa,yb,p9	#>> fit bottom-right
	w_resize -m p1	#>> special value p0-9/0-9 for -m opt
	w_resize -m 9	#>> fit bottom-right

	w_resize -m x100%,yy,p3	#>> fit p3 to screen right. keep y
	w_resize -m 100%,y,3
	w_resize -m x100a%,y,p3
	w_resize -m yy,p3,x100a%
	w_resize -m x100%-w,yy,p1	#>> same. calc with '-w', p1 <-> p3

	w_resize -m +10,-0,p1	#>> relative: start with '-+'. now+10 pix
	w_resize -m +10,yy,p1
	w_resize -m y,p1,x+10
	w_resize -m y100y%,p1,xx+10

	w_resize -m x,y,p1	#>> no move
	w_resize -m +0,-0,p1
	w_resize -m +0,yy,p1
	w_resize -m x+0,+0,p1
	w_resize -m x+0,y+0,p1
	w_resize -m +0%,y,p1
	w_resize -m x+0%,y,p1
	w_resize -m x+0x%,y,p1
	w_resize -m p1,y,x+0%

	w_resize -m x+20h%-10x%,yy+10w%,p1	#>> valid

	w_resize -r 200w%+10,-0,1	#>> resize to width 200%+10 pix
	w_resize -r w+w+10,h,1
	w_resize -r w+100%+10,hh,p1
	w_resize -r p1,w200w%+10,h-0
		@()--

@exit_status suc/fail == 0/not0
@note 'wmctrl' fails to set resize. retry the same command to fix pos/size.
@depend	wmctrl, xprop, xwininfo
@compat	posix-shell
@copyright	Copyright (C) 2018 Momi-g, AGPLv3+
@_ver 2022-12-21 v2.0.3 (2018-XX-XX v1.0.0)
@_see
	`wmctrl(1), xprop(1), xwininfo(1)` --
	--
	https://specifications.freedesktop.org/wm-spec/wm-spec-latest.html#idm140200472552416 --
	http://xjman.dsl.gr.jp/X11R6/X11/CH14.html --
	https://www.x.org/releases/X11R7.7/doc/libX11/libX11/libX11.html#Setting_and_Reading_the_WM_NORMAL_HINTS_Property --

#SH_docE
EEE
#SH_ED

#SH_HD
#SH_ED

#SH_SC
f_err(){ echo "*SH_bn*:---err. $*" && exit 1;}>/dev/stderr
f_srr(){ while :;do echo "*SH_bn*:---errstop. $*"; sleep 1000;done; }>/dev/stderr
f_wrr(){ echo "*SH_bn*:---msg. $*";} >/dev/stderr
f_vrr(){ echo "*SH_bn*:---val";echo "$(s_val "$@")";} >/dev/stderr
s_val()(
	[ "${1##@*}" = "" ] && echo "$@" && return
	for _vbg; do
	set -- "$_vbg" "$(eval 'printf "%s@" "$'"$_vbg"'"')"
	printf '%s#%s:%s;\n' "$1" $((${#2}-1)) "${2%?}"
	done
)
f_grr(){
	tm=5000
	[ "$2" != "" ] && tm="$2"
	command -v notify-send >/dev/null 2>&1 || return
	notify-send "(*SH_bn*) $1" -t "$tm"
}

f_usage(){
cat << 'EEE'
HowTo (w_resize, X11 app window move/resize helper)
opt: -hHV(elp, ver), -mrR (move,resize,Reset), -a(ctive wid), -w(ait lv0-9)
------
eg) ~$ w_resize 0x1234		# nowid:select / -a:active wid
	#>> wmctrl -ir 0x1234 -e 0,0,31,734,461
	# window place the same pos/size if run this cmd.

eg) ~$ w_resize -r 200,100,1 -a		#>> keep width: 'w,100,1'
  p1 @----------+ p3       p1 @------+   p3
     |          |    ->       |      |   100     
     |          |             +------+
  p7 +----------+ p9       p7     200    p9
 
eg) ~$ w_resize -R 0x1234	#>> reset resize 
eg) ~$ w_resize -m 100,200,3	#>> move to p3=x100,y200
eg) ~$ w_resize -m p0,x+10h%-20,yy	#>> accept. see -H

optarg  : -m/r needs optarg. allow pfix w/h/x/y/p,  x100,y300,p2 etc
pinpos  : p1-9,p0(==auto)
wid     : 0x1111 / 1234 / -a / (none)==mouse select
this pg adds EHWM property for savedata (add/remove WR_BFINFO, ck ~$ xprop)
EEE
exit 0
}

f_usageH(){
	cat <<- 'E E'|sed -e'1d;$d'
	#SH_rf* *SH_bn*.1.txt
	E E
	exit 0
}

f_verinfo(){
		cat <<- 'EEE'
	*SH_bn* *SH_ver*
	*SH_copy* 
		EEE
	exit 0
}
#SH_TSS
eq(){ _eq "$@"; }
nq(){ _neq "$@"; }

test_0init(){
	f_grr "test start: needs 30s..." 8000
	eq 1 1
}
#SH_TSE

#SH_TSE

#-- f_svprop wid pname str
f_setprop()(
	#xprop -id $wid -format WR_BFINFO 8s -set WR_BFINFO "$w""_""$h""_""$pos"
	wid="$1"; pname="$2"; str="$3"
	xprop -id "$wid" -format "$pname" 8s -set "$pname" "$str"
)

#-- f_isprop wid pname
f_isprop()(
	wid="$1"; pname="$2"
	str=$(xprop -id "$wid" -notype -f "$pname" 8s '=$0' "$pname" 2>/dev/null)
	buf=${str##"$pname"=*}
#f_vrr buf
	[ "$buf" = "" ] && return 0
	return 1
)

#-- f_delprop wid pname
f_delprop()(
	wid="$1"; pname="$2"
 #	str=$(f_getprop "$@")
	xprop -id "$wid" -remove "$pname" >/dev/null 2>&1
 #	echo "$str"
)
#-- f_getprop wid pname
f_getprop()(
	#xprop -id $wid -format WR_BFINFO 8s -set WR_BFINFO "$w""_""$h""_""$pos"
	wid="$1"; pname="$2"
	str=$(xprop -id "$wid" -f "$pname" 8s '=$0' "$pname")
	str=${str#*=}
	cmd="printf %b $str"
	str=$(eval "$cmd")
	echo "$str"
)

#SH_TSS
test_prop(){
	eq 1 1
	wid=$( xprop -root 32x '\t$0' _NET_ACTIVE_WINDOW|cut -f 2 )
	pname="UNKO"
	str="echo hello,
	world"
 
 #-- testcode
	f_delprop "$wid" "$pname"
	_suc

 f_isprop "$wid" "$pname"
	_fail
	
	f_setprop "$wid" "$pname" "$str"
	xprop -id $wid $pname

 f_isprop "$wid" "$pname"
	_suc

	res=$(f_getprop "$wid" "$pname")
	eq "$res" "$str"
	
	f_delprop "$wid" "$pname"

 f_isprop "$wid" "$pname"
	_fail
	
	xprop -id $wid $pname|grep "not found"
	_suc
}
#SH_TSE

# Cliant Side Decolateでwin位置がずれる可能性があるので
# 0移動でoffsetを計測して補正値を乗っけて計算する
#-- ~$ f_req2cmd 0x1234 10,20,3 move/resize/current

#-- add wait: for fast PC(3GHz)
_delaynum=0
f_delay(){
	#-- 5-10ms wait in 3GHz
	for i in $(seq 1 $_delaynum);do
	#wmctrl -l>/dev/null
	xprop -root >/dev/null
	done
}
	
f_req2cmd(){
f_wrr(){ :; }
f_vrr(){ :; }
	f_delay
	#-- 1,1,1 wid mode
f_wrr 1st "$@"	
	 wid="$1"; req="$2"; mode="$3"
		#-- sv and values
	set -- $(f_wmctrl_cval "$wid")
f_wrr cval_ret "$@"	

	cmd="wmctrl -ir $wid -e '1,$(($1+$5)),$(($2+$6)),$(($3+$7)),$(($4+$8))'"
	_cmd="wmctrl -ir $wid -e '1,-1,-1,-1,-1'"
	cmd="{ $cmd; $_cmd; $cmd; }"
#	cmd="xdotool windowmove $wid $1 $2 windowsize $wid $3 $4"
	dx=$5;dy=$6;dw=$7;dh=$8
	x=$1;y=$2;w=$3;h=$4

f_vrr x y w h dx dy dw dh
	#-- ここのcorrdinatは正確な外形になる
	#-- 差分は外形に加えることでwmctrlに変換できる
	#-- extも含むが、それだけじゃない。フレーム情報としては想定外
	#-- flame_extの個別がないが計算では不要なのでオミット	
	[ "$mode" = "current" ] && echo "$cmd" && return

	#-- mx,my
	buf=$(xprop -root _NET_CURRENT_DESKTOP|awk '{print $NF}')
	fmt=$(printf '= $%d $%d $%d $%d\\n' $((buf)) $((buf+1)) $((buf+2)) $((buf+3)) )
	buf=$(xprop -root -f _NET_WORKAREA 32c "$fmt" _NET_WORKAREA|sed -e 's/.*=//')
	set -- $buf
	x0=$1; y0=$2; mx=$3; my=$4
	#------- ここ。x0とreqでずれが出るので相対計算で最後にずらすとか
	#--- 時的にx0をxから引いてmoveのときだけ戻す
	#--- syntaxでx,yの初期位置計算が必要だから
	x=$((x-x0)); y=$((y-y0))
	
f_vrr scr x y x0 y0 mx my
		#-- syntax kick
	# x+100w%-50h+10x% etc
	buf=$(echo "$req"| awk '/[xymhp]?([-+]?[0-9]*[abxymh]?[%]?)+/ {print}')
	[  "$buf" = "" ] && f_err "bad syntax: $req" && return 1
	
		#-- ag: sort && conv: set -- x100w%-50,y200,p4 == set -- 100-50 200 4
	#-- stable_sort
	set -- $(echo "$req"| tr ',' ' ')
	#-- add move syntax, p1,p2, single req
	[ "$mode" = "move" ] && [ $# = 1 ] && {
		case "$1" in
		(1|p1) set -- 0 0 1 ;;
		(2|p2|0|p0) set -- 50% 0 2 ;;
		(3|p3) set -- 100% 0 3 ;;
		(4|p4) set -- 0 50% 4 ;;
		(5|p5) set -- 50% 50% 5 ;;
		(6|p6) set -- 100% 50% 6 ;;
		(7|p7) set -- 0 100% 7 ;;
		(8|p8) set -- 50% 100% 8 ;;
		(9|p9) set -- 100% 100% 9 ;;
		esac
	}
	
	#-- 1st char xywh for target values
	a0=""; a1=""; a2=""; a3=""
	for s;do
		buf=${s#?}
		c=${s%$buf}
			case "$c" in
		([xw]) a1=_${s#[xywhp]} ;;	#-- fall>> c='y' etc
		([yh]) a2=_${s#[xywhp]} ;;
		(p) a3=_${s#[xywhp]} ;;
		(*) a0="$a0 _$s" ;;
			esac
	done
	set -- $a0
	a0=""
	[ "$a1" != "" ] && a0="$a0 $a1" || { a0="$a0 $1"; shift; }
	[ "$a2" != "" ] && a0="$a0 $a2" || { a0="$a0 $1"; shift; }
	[ "$a3" != "" ] && a0="$a0 $a3" || { a0="$a0 $1"; shift; }
	set -- $a0
f_wrr sort "$@"
	set -- "${1#_}" "${2#_}" "${3#_}"
		#-- conv_token 100w%-50+2-30w%,
	a0=""
	flg="xy"
	[ "$mode" = "resize" ] && flg="wh"
	
	for s;do
		nums=""
			#-- xywh 1char only: w_resize x,yy,p1 etc
			#-- blank ,_, == ,, == set '+0'
		[ "${s#xywh}" = "" ] && s="+0"

		while [ "$s" != "" ];do
		op="${s%%[!+-]*}"
 f_vrr token_loop s op flg
		s="${s#$op}"
			#-- relative >> add current 1st
		if [ "$nums" = "" ] && [ "$op" != "" ]; then
			[ "$flg" = "xy" ] && op="$x$op"
			[ "$flg" = "y" ] && op="$y$op"
			[ "$flg" = "wh" ] && op="$w$op"
			[ "$flg" = "h" ] && op="$h$op"
		fi
		
		num="${s%%[!0-9]*}"
		s="${s#$num}"
		
		sfix="${s%%[+-]*}"
		s="${s#$sfix}"
		#-- calc
		bnum=""
f_vrr num s sfix bnum	
		if [ "$sfix" = "%" ]; then 
			[ "$flg" = "xy" ] && bnum="$mx"
			[ "$flg" = "y" ] && bnum="$my"
			[ "$flg" = "wh" ] && bnum="$w"
			[ "$flg" = "h" ] && bnum="$h"
		fi
		[ "$sfix" = "a%" ] && bnum="$mx"
		[ "$sfix" = "b%" ] && bnum="$my"
		[ "$sfix" = "x%" ] && bnum="$x"		#-- current cooparate 100a% == no change
		[ "$sfix" = "y%" ] && bnum="$y"
		[ "$sfix" = "w%" ] && bnum="$w"
		[ "$sfix" = "h%" ] && bnum="$h"
		[ "$bnum" = "" ] || num=$((bnum*num/100))
		
			#-- xa,y0,p3 >> fit
		[ "$sfix" = "a" ] && num="$mx"
		[ "$sfix" = "b" ] && num="$my"
		[ "$sfix" = "x" ] && num="$x"
		[ "$sfix" = "y" ] && num="$y"
		[ "$sfix" = "w" ] && num="$w"
		[ "$sfix" = "h" ] && num="$h"
		
		#-- add
		nums="$nums$op$num"
 f_vrr bnum num op nums
		done
		flg="${flg#?}"
		a0="$a0 $(($nums))"
	done
	#--- token2num complete, 300,400,p4 etc
	set -- $a0	
f_wrr token2num "$@"
f_vrr mode
		#-- resolv_autopos
	[ "$3" = 0 ] && [ "$mode" = "move" ] && set -- "$1" "$2" "2"
	[ "$3" = 0 ] && [ "$mode" = "resize" ] && {
		p=""
f_wrr ck_vals_pre "$@"
		#--offset		#--x_center
		xc=$(( (x +w/2) - mx/2 ))
		yc=$(( (y +h/2) - my/2 ))
		[ $xc -ge 0 ] && [ $yc -ge 0 ] && p=9
		[ $xc -le 0 ] && [ $yc -ge 0 ] && p=7
		[ $xc -ge 0 ] && [ $yc -le 0 ] && p=3
		[ $xc -le 0 ] && [ $yc -le 0 ] && p=1
		set -- "$1" "$2" "$p"
f_wrr ck_vals "$@"
	}
	set -- "$(($1))" "$(($2))" "$(($3))"
	#--- normalize complete, (set -- 300 400 p4) etc

		#-- do_main
	[ "$mode" = "move" ] && {
		#--input + ext_taskbar etc		#-- fix_offset
		nx=$(($1+x0)); ny=$(($2+y0)); p=$3
		[ "${p#[258]}" = "" ] && nx=$((nx-w/2))
		[ "${p#[369]}" = "" ] && nx=$((nx-w))
		
		[ "${p#[456]}" = "" ] && ny=$((ny-h/2))
		[ "${p#[789]}" = "" ] && ny=$((ny-h))
		p=1
		cmd="wmctrl -ir $wid -e '1,$((nx+dx)),$((ny+dy)),-1,-1' "
	}

	[ "$mode" = "resize" ] && {
		nx=$((x+x0))
		ny=$((y+y0))
		nw="$1"
		nh="$2"
		p="$3"
		dww=$((nw-w))
		dhh=$((nh-h))
f_vrr nx ny dx dy nw nh dw dh dww dhh p
		[ "${p#[258]}" = "" ] && nx=$((nx-dww/2))
		[ "${p#[369]}" = "" ] && nx=$((nx-dww))
		
		[ "${p#[456]}" = "" ] && ny=$((ny-dhh/2))
		[ "${p#[789]}" = "" ] && ny=$((ny-dhh))
		p=1
		cmd="wmctrl -ir $wid -e '1,$((nx+dx)),$((ny+dy)),$((nw+dw)),$((nh+dh))'"
		cmd="{ $cmd; $_cmd; $cmd; }"
#		cmd="xdotool windowmove $wid $1 $2 windowsize $wid $3 $4"
#		cmd="{ $cmd; $cmd; }"
	}
		#-- result
	echo "$cmd"
}

#SH_TSS
test_r2c(){
	#-- CPU test: less 50ms  == fast CPU, add wait
	buf=$( (time -p xprop -root) 2>&1| awk '$1=="real" {print 0.06/($2+0.01)}' )
	_delaynum=${buf%.*}

	eq 1 1
	command -v xterm || return
	xterm &
	pid=$!
	
	for i in $(seq 1 10); do
		wid=$(xprop -root 32x '\t$0' _NET_ACTIVE_WINDOW|cut -f 2)
		buf=$(xprop -id $wid 32c '\t$0' _NET_WM_PID|cut -f 2)
		[ "$buf" = "$pid" ] && break
f_wrr "wait xterm... 1-10"
		sleep 1
	done
	[ "$buf" = "$pid" ] || return

	wmctrl -r :ACTIVE: -e 1,200,100,400,300
	wid=$( xprop -root 32x '\t$0' _NET_ACTIVE_WINDOW|cut -f 2 )
	#return
		#--save dfl
	buf=$(f_req2cmd $wid 0,0,0 current)
	buf0="$buf"
	echo "$buf"
	eval "$buf"

		#--- test start
	#-- move_test
	buff=$(f_req2cmd $wid 0,0,0 current)
	for i in $(seq 1 10);do :
	#	buf=$(f_req2cmd $wid +10w%,y,1 move)
		buf=$(f_req2cmd $wid +10w%,y,1 move)
		echo "$buf"; eval "$buf" #; sleep 1
	done
	buf=$(f_req2cmd $wid -w,y,1 move)
	echo "$buf"; eval "$buf" #; sleep 1
	buf=$(f_req2cmd $wid 0,0,0 current)
	eq "$buf" "$buff"
	
	#-- add move syntax: w_resize -m p1 $wid
	buf=$(f_req2cmd $wid p1 move)
	buff=$(f_req2cmd $wid 0,0,p1 move)
	eq "$buf" "$buff"
	
	buf=$(f_req2cmd $wid 2 move)
	buff=$(f_req2cmd $wid 50%,0,2 move)
	eq "$buf" "$buff"
	
	f_wrr p3 $(f_req2cmd $wid p3 move)
	f_wrr p4 $(f_req2cmd $wid 4 move)
	f_wrr p5 $(f_req2cmd $wid 5 move)

	buf=$(f_req2cmd $wid p9 move)
	buff=$(f_req2cmd $wid a,b,9 move)
	eq "$buf" "$buff"

		#-- syntax test
	buf0=$(f_req2cmd $wid w,h,1 resize)
	list='
	+0,-0,1
	ww,hh,1
	+10a%+10b%+10x%+10y%+10w%+10h%-10a%-10b%-10x%-10y%-10w%-10h%,+0,1
	+x-100x%,h,1
	+w-100w%+100%-w+100x%-100x%,hh,1
	w+w-100w%,hh,1
	'
f_vrr list
	for i in $list;do
f_vrr 12345 i
		buf=$(f_req2cmd $wid $i resize)
		echo "$buf0 $buf"
		eq "$buf0" "$buf"
	done

		#--auto test
	buf=$(f_req2cmd $wid +10,+10,0 resize)
	echo "$buf"; eval "$buf" #; sleep 1
	buff="$buf"
	buf=$(f_req2cmd $wid -10,-10,0 resize)
	echo "$buf"; eval "$buf" #; sleep 1
	_eq "$buf" "$buf0"
	
	buf=$(f_req2cmd $wid +10,+10,1 resize)
 f_vrr buf buff
 #return
	echo "$buf"; eval "$buf" #; sleep 1
	_eq "$buf" "$buff"	
	eval "$buf0" #; sleep 1
#return

		#--- basic
	buf=$(f_req2cmd $wid 0,0b%,1 move)
	eval "$buf"
	echo "$buf"
	buf=$(f_req2cmd $wid xa,yb,1 resize)
	echo "$buf"
	eval "$buf"
#	sleep 1
	eval "$buf0"
#	sleep 1

#	buf=$(f_req2cmd 0,y,1 $wid move)
#	echo "$buf"
#	eval "$buf"
#	sleep 1
		
		#-- resize_test
	f_(){
		pp=$1
		buf=$(f_req2cmd $wid +100,+100,1 resize)
		echo "$buf"; eval "$buf" #; sleep 1
	
		buf=$(f_req2cmd $wid -100,-100,$pp resize)
		echo "$buf"; eval "$buf" #; sleep 1
	
		buf=$(f_req2cmd $wid +100,+100,$pp resize)
		echo "$buf"; eval "$buf" #; sleep 1
	
		buf=$(f_req2cmd $wid -100,-100,1 resize)
		echo "$buf"; eval "$buf" #; sleep 1
		
		echo "$buf0"
		_eq "$buf" "$buf0"
	}
	for i in $(seq 1 9);do
		f_ $i
	done
	
	buf=$(f_req2cmd $wid 0,0,0 current)
	_eq "$buf" "$buf0"
	echo "$buf"
	eval "$buf"
#	kill $pid


	buf=$(f_req2cmd $wid 0,y,1 move)
	echo "$buf"
	eval "$buf"
#	sleep 1

	buf=$(f_req2cmd $wid x,0,1 move)
	echo "$buf"
	eval "$buf"
#	sleep 1

	buf=$(f_req2cmd $wid 50x%,50y%,1 move)
	echo "$buf"
	eval "$buf"
#	sleep 1

	buf=$(f_req2cmd $wid 50x%,50y%,5 move)
	echo "$buf"
	eval "$buf"
#	sleep 1
	
	buf=$(f_req2cmd $wid 50x%,50y%,2 move)
	echo "$buf"
	eval "$buf"
#	sleep 1

#---
	buf=$(f_req2cmd $wid 0,0,1 move)
	echo "$buf"
	eval "$buf"
#	sleep 1

	buf=$(f_req2cmd $wid 50%,0,2 move)
	echo "$buf"
	eval "$buf"
#	sleep 1

	buf=$(f_req2cmd $wid 100%,0%,3 move)
	echo "$buf"
	eval "$buf"
#	sleep 1

	buf=$(f_req2cmd $wid 0%,50%,4 move)
	echo "$buf"
	eval "$buf"
#	sleep 1

	buf=$(f_req2cmd $wid 50%,50%,5 move)
	echo "$buf"
	eval "$buf"
#	sleep 1

	buf=$(f_req2cmd $wid 100%,50%,6 move)
	echo "$buf"
	eval "$buf"
#	sleep 1

	buf=$(f_req2cmd $wid 0%,100%,7 move)
	echo "$buf"
	eval "$buf"
#	sleep 1

	buf=$(f_req2cmd $wid 50%,100%,8 move)
	echo "$buf"
	eval "$buf"
#	sleep 1

	buf=$(f_req2cmd $wid 100%,100%,9 move)
	echo "$buf"
	eval "$buf"
#	sleep 1

	kill $pid
};
#SH_TSE

# -- main code
#-- retは$1-$4==xywh外形, $5-8==d(xywh) wmctrl==x+dx...
f_wmctrl_cval()(
	wid=$1
	f_(){
	xwininfo -all -id $wid | tr ',' ' ' | awk -v wid=$wid '
	$0~ /Absolute upper-left X/ { x=$NF }
	$0~ /Absolute upper-left Y/ { y=$NF }
	$1~ /Width/ {w=$NF}
	$1~ /Height/{h=$NF}
	$0~ /Frame extents/{
		l=$(NF-3)
		r=$(NF-2)
		u=$(NF-1)
		d=$(NF-0)
	}
	END{
		x=x-l
		y=y-u
		w=w
		h=h
		printf("x=%d\ny=%d\nw=%d\nh=%d\nl=%d\nr=%d\nu=%d\nd=%d\n",x,y,w,h,l,r,u,d)
		}'
	}
	#-- チラつきを抑えるため-lで事前に近づける
	#-- x,yの出力は外形だけどw,hは内径 wmctrlが狂ってるため
	eval "$(f_)"
	wmctrl -ir $wid -e 1,$x,$y,$w,$h
	
	#-- 本来なら0のはず 差分で正確な値をとる	
	eval "$(f_|sed -e s/^/b/g)"
	# fix
	dx=$((x-bx))
	dy=$((y-by))
	dw=$((w-bw))
	dh=$((h-bh))

#f_wrr "wmctrl -ir $aid -e 0,$x,$y,$w,$h"
	x=$((x+dx))
	y=$((y+dy))
	w=$((w+dw))
	h=$((h+dh))
	
	#-- adjust
	[ $dx = 0 ] && [ $dy = 0 ] && [ $dw = 0 ] && [ $dh = 0 ] ||
		wmctrl -ir $wid -e 1,$x,$y,$w,$h
	
	#-- x,yは外形だが、whは内側. wmctrlのせい, 外形補正
	#-- wmctrlの非対称でxはflame不要
	dw=$((dw-l-r))
	dh=$((dh-u-d))
	w=$((w-dw))
	h=$((h-dh))
	echo "$x $y $w $h $dx $dy $dw $dh"
)

#SH_TSS
test_cpos(){
	wid=$(xprop -root 32x '\t$0' _NET_ACTIVE_WINDOW|cut -f 2)
	set -- $(f_wmctrl_cval "$wid")
	buf=$(xwininfo -id $wid)
	wmctrl -ir $wid -e '1,$1,$2,$3,$4'
	buff=$(xwininfo -id $wid)
	eq "$buf" "$buff"
	echo "$@"
}
#SH_TSE

# $1=wid
f_cmd_cpos()(
	wid=$1
	set -- `f_wmctrl_cval $1`
	echo "wmctrl -ir $wid -e 1,$1,$2,$3,$4"
)

# f() wid x y 2: == 0x1234 100 200 4, 0x1234 100%-w 100%-h 1 
f_mvwin()(
	wid="$1"
	rx="$2"
	ry="$3"
	pos="$4"
	[ "$pos" = 0 ] && pos=1
	buf=`echo $pos | tr -d '1379'`
	[ "$buf" != "" ] && f_err "err. move pos need 1/3/7/9"

	set -- $(f_wmctrl_cval $wid)
	# wininfo_c
	x=$1;	y=$2;	w=$3	h=$4
	lf=$5;	rf=$6;	uf=$7;	df=$8
	ww=$((w+lf+rf))
	hh=$((h+uf+df))
	dx=0
	dy=0
		# same
	[ "$rx" = "" ] && rx=$x
	[ "$ry" = "" ] && ry=$y
	
	# 位置特殊指定,計算可能にしておく max-10% 0+100 x,y,w,h はそれぞれ数値に変換される
	rx=$((rx))
	ry=$((ry))
	
	# posからx,yを直接演算可能なように補正する
	# pinning shift
	if [ "$pos" = "3" ] || [ "$pos" = "9" ] ; then dx=$((-ww)); fi
	if [ "$pos" = "7" ] || [ "$pos" = "9" ] ; then dy=$((-hh)); fi
	nx=$((rx+dx))	
	ny=$((ry+dy))

	wmctrl -ir $wid -e 0,$nx,$ny,-1,-1
	wmctrl -m >/dev/null 2>&1
	wmctrl -ir $wid -e 0,$nx,$ny,-1,-1	# 見きれている時は盛り上がってくるので二回。
)

# f_szwin "$wid"  w h p 
f_szwin()(
	wid="$1"
	rw="$2"
	rh="$3"
	pos="$4"

	# 現在のwh情報をロード時に使えるように加工保存
	buf=$(f_wmctrl_cval $wid)
	set -- $buf
	# pos+flame
	x=$1;	y=$2;	w=$3;	h=$4
	lf=$5;	rf=$6;	uf=$7;	df=$8
	
	# current basicsize
	xx=$x
	yy=$y
	ww=$((w+lf+rf))
	hh=$((h+uf+df))
		
	#-- same sz
	[ "$rw" = "" ] && rw="$ww"
	[ "$rh" = "" ] && rh="$hh"
	
	# 位置依存pos
	buf="1379"
	[ "${buf#*$pos}" = "$buf" ] && pos=`f_w1379 $xx $yy $ww $hh`

	# save present position
	buf="$w $h $pos"
	#xprop -id $wid -format WR_BFINFO 8s -set WR_BFINFO "$w""_""$h""_""$pos"
	xprop -id $wid -format WR_BFINFO 8s -set WR_BFINFO "$buf"
	
	# win resize
	# 大抵フレーム込みの値で要求するだろうけどXwinはフレーム無しで処理するので補正
	# https://specifications.freedesktop.org/wm-spec/wm-spec-latest.html#idm140200472552416
	# _NET_FRAME_EXTENTS, left, right, top, bottom, CARDINAL[4]/32
	nw=$((rw-$lf-$rf))
	nh=$((rh-$uf-$df))
	nx=$xx
	ny=$yy
	
	# min check: windowには最小サイズ指定があったりなかったり
	# program specified minimum size: 482 by 73
	# https://specifications.freedesktop.org/wm-spec/wm-spec-latest.html#idm140200472552416
	buf=`xprop -id $wid | grep "program specified minimum size" | tr -c '0123456789' ' '`
	if [ "$buf" != "" ] ; then
		set -- $buf
		[ $nw -lt $1 ] && nw="$1"
		[ $nh -lt $2 ] && nh="$2"
	fi

	# pinning shift
	if [ "$pos" = "3" ] || [ "$pos" = "9" ]; then nx=$((nx+w-nw)); fi
	if [ "$pos" = "7" ] || [ "$pos" = "9" ]; then ny=$((ny+h-nh)); fi
	
#f_wrr "wmctrl -ir $wid -e 0,$nx,$ny,$nw,$nh"
	wmctrl -ir $wid -e 0,$nx,$ny,$nw,$nh
	wmctrl -m >/dev/null 2>&1	#dummycode sleep 0.0001 or 'wait wmctrl effective' 
	wmctrl -ir $wid -e 0,$nx,$ny,$nw,$nh
	# 155だったり172だったりタイミングでズレる。ダミーを挟んでもう一回やれば治る。
	# ズレるのはwmctrlがEHWMに投げっぱなしのせいか。メッセージのみだから。
	# wmctrl -ir $wid -e 0,$nx,$ny,$nw,$nh と比較すれば一応チェック可能だけど、結局レースコンディション。
	# wmctrl -m でwm情報が帰ってくるからそれで時間稼ぎ。sleepの代わり。
)

# win_propからとりだしてwmctrlするだけ
f_resetwin() (
	wid="$1"
	buf=$(xprop -id "$wid" -f WR_BFINFO 8s '=$0\n' "WR_BFINFO" 2>/dev/null)
	[ $? != 0 ] && return 1

	set -- $(echo "${buf#*=}"| tr '"_' ' ')
	bw=$1;bh=$2;pos=$3
	
	set -- $(f_wmctrl_cval $wid)
	x=$1;	y=$2;	w=$3;	h=$4
	
	# posによってx,yが変化するので計算
	dw=$((bw-w))
	dh=$((bh-h))
	
	if [ "$pos" = "3" ] || [ "$pos" = "9" ]; then x=$((x-dw)); fi
	if [ "$pos" = "7" ] || [ "$pos" = "9" ]; then y=$((y-dh)); fi
	wmctrl -ir $wid -e 0,$x,$y,$bw,$bh
	wmctrl -m >/dev/null 2>&1
	wmctrl -ir $wid -e 0,$x,$y,$bw,$bh
	xprop -id $wid -remove WR_BFINFO 2>/dev/null
)

# winがどの象限に属するか: func_posck x100 y200 w50 h60
f_w1379()(
	x=$1;y=$2;w=$3;h=$4
	# ポジションauto

	# get disp width...1280 960 etc. 32x \t ... format select
	# http://xjman.dsl.gr.jp/X11R6/X11/CH14.html
	# https://www.x.org/releases/X11R7.7/doc/libX11/libX11/libX11.html#Setting_and_Reading_the_WM_NORMAL_HINTS_Property
	
	set -- `xprop -root 32x '\t$0 $1' _NET_DESKTOP_GEOMETRY | awk '{printf("%d %d",$2,$3)}'`
	[ "$#" != "2" ] && f_err "failed to get display size(1024x768 etc). exit"
	x5=$((nx+w/2))
	y5=$((ny+h/2))
	mx5=$((${1}/2))
	my5=$((${2}/2))
	while :;do
	[ $x5 -le $mx5 ] && [ $y5 -le $my5 ] && pos=1 && break
	[ $x5 -gt $mx5 ] && [ $y5 -le $my5 ] &&	pos=3 && break
	[ $x5 -le $mx5 ] && [ $y5 -gt $my5 ] &&	pos=7 && break
	[ $x5 -gt $mx5 ] && [ $y5 -gt $my5 ] && pos=9 && break
	done
	echo $pos
)

*SH_bn*()(
	cmd=""
	wid=""
	pname="WR_BFINFO"
	
		while getopts ":hHVar:Rm:w:" c; do case "$c" in				
	(h) f_usage	;;
	(H) f_usageH	;;
	(V) f_verinfo	;;
	
	(a) wid=$(xprop -root 32x '\t$0' _NET_ACTIVE_WINDOW|cut -f 2);;
	(r) mode="resize";opt="$OPTARG";;
	(R) mode="reset";;
	(m) mode="move";opt="$OPTARG";;
	(w) _delaynum="$OPTARG"; [ -z "${OPTARG#[0-9]}" ]|| f_err "bad opt:-w $OPTARG";;
	([?:]) f_err "bad opt: $OPTARG: $*" ;;	
		esac; done; shift $(($OPTIND-1))
	
	[ "$wid" = "" ] && wid="$1"
	[ "$wid" = "" ] &&	wid=$(xwininfo|grep ^xwininfo|grep "Window id:"|awk '{print $4}')

	# 4 mainworks. info/move/set/reset
		# info
	[ "$mode" = "" ] && {
		echo $(f_req2cmd $wid 0,0,0 current)
		exit 0
	}
		# reset:  ~$ w_resize.sh R,0x1234	#>> load/restore window size, 's'et >> 'l'oad.
	[ "$mode" = "reset" ] && {
		cmd=":"
		f_isprop "$wid" "$pname" && {
			cmd=$(f_getprop "$wid" "$pname")
			f_delprop "$wid" "$pname"
		}
		eval "$cmd"
		exit 0 
	}
		# resize:  ~$ w_resize.sh r,0x1234,w200,h100,p1 #>> 's'et,wid,width:height:pinning
	[ "$mode" = "resize" ] && {
		f_isprop "$wid" "$pname" || {
			cmd=$(f_req2cmd "$wid" "$opt" current)
			f_setprop "$wid" "$pname" "$cmd"
		}
		cmd=$(f_req2cmd $wid "$opt" resize)
		eval "$cmd"
		exit 0 
	}

	[ "$mode" = "move" ] && {
		cmd=$(f_req2cmd $wid "$opt" move)
		eval "$cmd"
		exit 0 
	}
)

*SH_bn*_main()( *SH_bn* "$@" )
*SH_bn*_main "$@" || exit	#SH_MAIN

#SH_TSS
test_cmd(){
	eq 1 1
	cmd="*SH_bn*"
	./$cmd -h;	_suc help
	./$cmd -H;	_suc HELP
	./$cmd -V;	_suc Ver

	wid=$(xprop -root 32x '\t$0' _NET_ACTIVE_WINDOW|cut -f 2)
	./$cmd $wid;	_suc disp_cmd
	./$cmd -r +100,h,1 $wid;	_suc resize
	./$cmd -m +100,y,1 $wid;	_suc move
	./$cmd -R $wid;	_suc reset
};
#SH_TSE

#SH_TSS
test_bm1_(){
	eq 1 1
	wid=$( xprop -root 32x '\t$0' _NET_ACTIVE_WINDOW|cut -f 2 )

	#-- 100ms >> 70ms
	time f_wmctrl_cval $wid
	#-- 140ms, xpropの多重起動のせい。最適化すれば1/10ぐらいにはなりそう
	#-- cvalを借用して同時になった
	#-- >> 64ms
	time f_req2cmd $wid 0,0,0 current
	
	#-- >> 80ms full calc
	time f_req2cmd $wid 0,0,1 move
	
	#--110ms full cmd
	time eval $(f_req2cmd $wid x,y,1 move)
}
#SH_TSE


#SH_TSS_
test_w_(){
	awkcode='
function f_impl(s,	a,b,arr){
	return s
}

function f_sort(arr,	mdx,suc){
	for(i in arr){mdx++}
	suc=1; while(suc) {suc=0; for(i=2;i<=mdx;i++) {
	if(arr[i-1]>arr[i]) {buf=arr[i]; arr[i]=arr[i-1] ;arr[i-1]=buf; suc=1; }
	} }
}
function f_uniq(arr, 	mdx,bi,brr){
	for(i in arr){mdx++}
	for(i=1;i<=mdx;i++){ if(arr[i] != brr[bi+0]){ bi++; brr[bi]=arr[i] } }
	split("",arr)
	for(i in brr){ arr[i]=brr[i] }
}
function _runtest(){	#"function _runtest()" >> "0" for ignore but save testcode
	eq(10, 10)
	return
	
	s="{+s+c+l+m1+m2+m3+m4+m5}"
	q="+Control+Lock+Mod1+Mod2+Mod3+Mod4+Mod5+Shift "
	s=f_impl(s)
	eq(s, q)
}
'
awk '
BEGIN{
	_runtest()
	printf("fail/all: %s/%s\n", test_fail+0, test_all+0) > "/dev/stderr"
	exit(0)
}

#*SH_rf* 0 awktool.awk

'"$awkcode"
	nq 1 0
}
#SH_TSE

:<<'EEE'
 change log
 --
2022-12-21  Momi-g	<dmy@dmy.dmy>

	* w_resize(main): add -w opt. v2.0.3
	* (f_req2cmd): add f_delay()

2022-12-17  Momi-g	<dmy@dmy.dmy>

	* w_resize(f_req2cmd): add 'w_resize -m p1 0x1234' syntax. v2.0.2.

2022-12-13  Momi-g	<dmy@dmy.dmy>

	* w_resize(all): rewrite. add p1-9, '100w%' syntax v2.0.1

2022-11-24  Momi-g	<dmy@dmy.dmy>

	* w_resize(all): rewrite. v2.0.0

2020-10-28  Momi-g	<dmy@dmy.dmy>

	* w_resize.sh: v1.1.0 release
	* (func_wininfo): add wmctrl test.
	* (-): add v(mouse select) cmdin

EEE

#SH_ED

#SH_OP _ a=`sed -ne "/${C}DF/!d;:l;n;/${C}DE/q;p;bl"<$R0`;eval "$a";set +e	#*/
#SH_OP h $p"-tsbS:test/eg/.o/.so -LMP:leak,mem,prof -f:funcs -o:bldout	GPLv3+"	 #*/
#SH_OP f sed -ne "/${C}DF/q;/;/d;/^[a-z].*)/p"<$R0|tr -d ' \t'|grep -F '()' #*/
#SH_OP t $e"$CW";ftt "$@";$p"bash --posix $Ox $tf"|fvd
#SH_OP T $e"$CW";ftt "$@";$p"dash $Ox $tf"|fvd
#SH_OP i $e"$Cb";$p'shellcheck -s sh -e SC2046,SC2086,SC2004,SC2154,SC2015,SC2006,SC2030,SC2031 $bn.sh'|fv
#SH_OP s fgr0 "${C}SMP" "${C}SMPE"<$R0>eg.sh #;$p"luajit eg.lua"|fv
#SH_OP x Ox="-x";fvd(){ fv 2>&1|tee dbg.txt; } 
#SH_OP v Ov="-v2"

#SH_OP b $e"$CW"
#SH_OP W $e"$Cm$O$Cw">/dev/null;fborn;chmod 755 $bn $bn.sh;$e"$Cs";$p"$bn $Rs $Rh $tf"	#*/
#SH_OP o $e"$CW";$p'fman $Rh 1'|fv		#*/

#SH_DF
#-- noob
fman()( $p"fgr0 '${C}doc' '${C}docE'<$1|amn >$bn.$2
 mandoc -Thtml <$bn.$2 >$bn.$2.html
 man -Tutf8 -l -<$bn.$2|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt
 "|fv
 #(echo '.mso ja.tmac';cat $bn.$2)|man -Tutf8 -l -|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt"|fv
)

#-- vars
bn=`basename ${Rs%.*}`; tf=${Rs%/*}/${bn}.ts.${Rs##*.}; e="eval "; p="$Rp"
#-- mod
fv()(while read -r a;do $e"cat<<E$O# $a${O}E"|sed -e 's@-L.*-L[^ ]*@-L(omit)@g'>/dev/stderr;$e"$a";done)
fvd(){ fv; }

fbn()(sed -e "s@\*${C##*]}bn\*@$bn@g"|frv|fry|flit|frf)
fsn()(tr -s ' \t' '\n')
fsl()(tr -s '\n' ' ')
fu()(fsn|sort -u)
fU()(fu|fsl;$p)

fgr()(sed -e "/$1/!d;:l;/$2/{p;d};n;bl")	#切出
fgr0()(sed -ne "/$1/!d;:l;n;/$2/d;p;bl")	#抜き切出
fgR()(sed -ne "/$1/bl;p;d;:l;n;/$2/d;bl")	#切すて
fg()(sed -ne "s/.*${C##*]}co\*\([^*]*\).*$/\1/p" "$@"|fsn|awk '!a[$0]{a[$0]=1;print}'|fsl)

#-- longcmd
frf()(
 # *sh_rf* 0 a.txt b.txt ...でcat纏めて出力 top0でsrcinfoは無し出力
 awk -v tg="${C##*]}rf" -v cs='#' -v ce='' 'index($0,tg){
 s=substr($0, index($0,tg)+length(tg)+1);split(s, a)
 m="[ -f \"%s\" ]&&(echo \"%s--copyfrom %s %s\";cat \"%s\";echo \"%s--copyend %s %s\")"
 mm="[ -f \"%s\" ]&&(_=\"%s%s%s\";cat \"%s\";_=\"%s%s%s\")"
 for(i=1;i in a;i++){v=a[i];if(v==0){m=mm;continue};system(sprintf(m,v,cs,v,ce,v,cs,v,ce))}
 next
 }
 {print}'
)
frv()(buf=`awk '$1=="@_ver" {print $3;exit}'<$R0`;sed -e "s@\*${C##*]}ver\*@$buf@g")
fry()(buf=`awk '$1~ /^@license|^@copy/ {$1="";print;exit}'<$R0`;sed -e "s@\*${C##*]}copy\*@$buf@g")
flit()(sed -ne "/${C}lit/bl;p;d;:l;n;/${C}litE/d;"'s/[\]/&&/g;s/"/\\"/g;s@.*@"&\\n"@g;p;bl')

fte()(
 cat > $Rm-
 suite=$(cat $Rm-|awk '$1~/^test_[^(]*\(\)/{print $1}'|sed -e 's/[(].*//g'|$e"$gfn")
 [ $# = 0 ] && suite="$suite $suite"|| suite="$suite $@"
 suite=`$p'%s\n' "$suite"|tr '[ \t]' '\n'|sort|uniq -d|fsl`
 (cat $bn $Rm-|grep -vF "${C##*]}MAIN"
 $p'[ $# = 0 ]&&set -- '"$suite"';for fc;do echo "--$fc():">/dev/stderr;$fc;done;_res')
 rm -f $Rm-
)
ftt()(shunit_m $Ov>$Rm;fte "$@"<$tf>>$Rm;mv $Rm $tf)

fborn(){
 gfn="grep -v '_$'";fgR "${C}TSS_" "${C}TSE"<$R0 |fgr0 "${C}TSS" "${C}TSE"|fbn|fte>tests.code
 gfn="cat -";fgr0 "${C}TSS" "${C}TSE"<$R0|fbn>$tf
 fgR "${C}TSS" "${C}TSE"<$Rs|fbn|tee $Rm>$bn;mv -f $Rm $Rs;fbn<$Rh>$Rm;mv $Rm $Rh
}
#SH_DE
