/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackInitializer;
import org.jivesoftware.smack.provider.ProviderFileLoader;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.FileUtils;

public abstract class UrlProviderFileInitializer
implements SmackInitializer {
    private static final Logger log = Logger.getLogger(UrlProviderFileInitializer.class.getName());

    @Override
    public void initialize() {
        String filePath = this.getFilePath();
        try {
            InputStream is = FileUtils.getStreamForUrl(filePath, this.getClassLoader());
            if (is != null) {
                log.log(Level.INFO, "Loading providers for file [" + filePath + "]");
                ProviderManager.getInstance().addLoader(new ProviderFileLoader(is));
            } else {
                log.log(Level.WARNING, "No input stream created for " + filePath);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error trying to load provider file " + filePath, e);
        }
    }

    protected abstract String getFilePath();

    protected ClassLoader getClassLoader() {
        return null;
    }
}

