/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.foldermenu;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileSystemView;
import jp.sourceforge.users.yutang.omegat.plugin.foldermenu.FilterHelper;
import jp.sourceforge.users.yutang.omegat.plugin.foldermenu.L10n;
import jp.sourceforge.users.yutang.omegat.plugin.foldermenu.MenuManager;
import jp.sourceforge.users.yutang.omegat.plugin.foldermenu.ShellLinkMenu;
import jp.sourceforge.users.yutang.omegat.plugin.foldermenu.filepreview.FilePreview;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.util.Log;
import org.omegat.util.Platform;
import org.omegat.util.StaticUtils;

public class MenuHelper {
    private static final FileSystemView fs = FileSystemView.getFileSystemView();
    private static final FileFilter ff = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.getName().startsWith(".") && !file.isHidden();
        }
    };
    private static final ActionListener al = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuHelper.open((JMenuItem)e.getSource());
        }
    };
    private static final MenuKeyListener mkl = new MenuKeyListener(){

        @Override
        public void menuKeyTyped(MenuKeyEvent e) {
        }

        @Override
        public void menuKeyPressed(MenuKeyEvent e) {
            JMenu menu;
            MenuSelectionManager manager;
            MenuElement[] selectedPath;
            MenuElement selection;
            if (e.getKeyCode() == 10 && (selection = (selectedPath = (manager = e.getMenuSelectionManager()).getSelectedPath())[selectedPath.length - 1]) instanceof JMenu && (menu = (JMenu)selection).isEnabled()) {
                manager.clearSelectedPath();
                MenuHelper.open(menu);
            }
        }

        @Override
        public void menuKeyReleased(MenuKeyEvent e) {
        }
    };
    private static final MouseListener mol = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent e) {
            MenuHelper.open((JMenuItem)e.getSource());
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    };
    private static final MenuListener mel = new MenuListener(){

        @Override
        public void menuSelected(MenuEvent e) {
            ((ShellLinkMenu)e.getSource()).createChildren();
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    };
    private static final MenuListener melRoot = new MenuListener(){

        @Override
        public void menuSelected(MenuEvent e) {
            String currentFile;
            IProject project = Core.getProject();
            File sourceFile = null;
            File translatedFile = null;
            if (project.isProjectLoaded() && (currentFile = Core.getEditor().getCurrentFile()) != null) {
                String sourceRoot = project.getProjectProperties().getSourceRoot();
                sourceFile = new File(sourceRoot + currentFile);
                translatedFile = FilterHelper.getTargetFile(currentFile);
            }
            if (sourceFile == null || !sourceFile.isFile()) {
                if (prevSourceFile != null) {
                    menuManager.unlinkCurrentSourceFile();
                    prevSourceFile = null;
                }
                if (prevTranslatedFile != null) {
                    menuManager.unlinkCurrentTargetFile();
                    prevTranslatedFile = null;
                }
                return;
            }
            try {
                if (!sourceFile.equals(prevSourceFile)) {
                    menuManager.linkCurrentSourceFile(sourceFile);
                    prevSourceFile = sourceFile;
                }
            }
            catch (IOException ex) {
                Log.log(ex.getMessage());
                menuManager.unlinkCurrentSourceFile();
                prevSourceFile = null;
            }
            if (translatedFile == null || !translatedFile.isFile()) {
                if (prevTranslatedFile != null) {
                    menuManager.unlinkCurrentTargetFile();
                    prevTranslatedFile = null;
                }
            } else {
                try {
                    if (!translatedFile.equals(prevTranslatedFile)) {
                        menuManager.linkCurrentTargetFile(translatedFile);
                        prevTranslatedFile = translatedFile;
                    }
                }
                catch (IOException ex) {
                    Log.log(ex.getMessage());
                    menuManager.unlinkCurrentTargetFile();
                    prevTranslatedFile = null;
                }
            }
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            for (Component c : menu.getMenuComponents()) {
                JMenu m;
                if (!(c instanceof JMenu) || !(m = (JMenu)c).isEnabled()) continue;
                m.removeAll();
            }
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    };
    private static final Comparator<File> comp = new Comparator<File>(){

        @Override
        public int compare(File f1, File f2) {
            if (f1.isFile() == f2.isFile()) {
                return f1.getName().compareToIgnoreCase(f2.getName());
            }
            return f1.isFile() ? 1 : -1;
        }
    };
    private static MenuManager menuManager;
    private static File prevSourceFile;
    private static File prevTranslatedFile;

    private MenuHelper() {
    }

    public static Icon getIcon(File file) {
        return fs.getSystemIcon(file);
    }

    public static File[] getFilteredListFiles(File folder) {
        return folder.listFiles(ff);
    }

    public static ActionListener getActionListener() {
        return al;
    }

    public static MenuKeyListener getMenuKeyListener() {
        return mkl;
    }

    public static MouseListener getMouseListener() {
        return mol;
    }

    public static MenuListener getMenuListener() {
        return mel;
    }

    public static MenuListener getRootMenuListener() {
        return melRoot;
    }

    public static Comparator<File> getComparator() {
        return comp;
    }

    private static void open(JMenuItem item) {
        if (!item.isEnabled()) {
            return;
        }
        String path = item.getActionCommand();
        try {
            switch (Platform.getOsType()) {
                case WIN64: 
                case WIN32: {
                    File file = new File(path);
                    if (!FilePreview.open(file)) {
                        Desktop.getDesktop().open(file);
                    }
                    break;
                }
                case MAC64: 
                case MAC32: {
                    new ProcessBuilder("open", path).start();
                    break;
                }
                default: {
                    new ProcessBuilder("xdg-open", path).start();
                    break;
                }
            }
        }
        catch (IOException ex) {
            Log.log(ex);
            Core.getMainWindow().showMessageDialog(StaticUtils.format(L10n.getErrMsgFileHasNoAssoc(), path));
        }
    }

    public static void setMenuManager(MenuManager manager) {
        menuManager = manager;
    }
}

