/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.foldermenu;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import jp.sourceforge.users.yutang.omegat.plugin.foldermenu.MenuHelper;
import jp.sourceforge.users.yutang.omegat.plugin.foldermenu.ShellLinkMenuItem;
import org.omegat.util.Log;
import org.openide.awt.Mnemonics;

public class ShellLinkMenu
extends JMenu {
    public ShellLinkMenu(File folder, String label) throws IOException {
        this(folder);
        Mnemonics.setLocalizedText((AbstractButton)this, (String)label);
    }

    public ShellLinkMenu(File folder) throws IOException {
        super(folder.getName());
        this.addMenuListener(MenuHelper.getMenuListener());
        this.addMouseListener(MenuHelper.getMouseListener());
        this.setIcon(MenuHelper.getIcon(folder));
        this.setActionCommand(folder.getCanonicalPath());
    }

    public ShellLinkMenu(String label) throws IOException {
        Mnemonics.setLocalizedText((AbstractButton)this, (String)label);
        this.addMenuListener(MenuHelper.getMenuListener());
        this.addMouseListener(MenuHelper.getMouseListener());
        this.setEnabled(false);
    }

    public void createChildren() {
        if (this.isEnabled() && this.getItemCount() == 0) {
            File folder = new File(this.getActionCommand());
            File[] filteredListFiles = MenuHelper.getFilteredListFiles(folder);
            Arrays.sort(filteredListFiles, MenuHelper.getComparator());
            for (File file : filteredListFiles) {
                try {
                    if (file.isDirectory() && this.hasChildren(file)) {
                        this.add(new ShellLinkMenu(file));
                        continue;
                    }
                    this.add(new ShellLinkMenuItem(file));
                }
                catch (IOException ex) {
                    Log.log(ex);
                }
            }
        }
    }

    public JMenu getMenu() {
        return this;
    }

    public void link(File folder) throws IOException {
        this.setActionCommand(folder.getCanonicalPath());
        this.setIcon(MenuHelper.getIcon(folder));
        this.setEnabled(true);
    }

    public void unlink() {
        this.setEnabled(false);
        this.removeAll();
        this.setActionCommand("");
        this.setIcon(null);
    }

    private boolean hasChildren(File folder) {
        return MenuHelper.getFilteredListFiles(folder).length > 0;
    }
}

