static char sccsid[]="%Z% %M% %I% %D% %T%";
/*************************************************
 *
 *	akxssrch.c
 *
 *		  coded by A.Kobayashi 2001/02/15
 *
 *************************************************/
#include "akxcommon.h"

static int _seqsr();
static int _seqss();
static int _seqsd();
static int _seqsi();

int akxs_seqs(func,hashbp)
char func;
HASHB *hashbp;
{
	int i;

	if (!hashbp) return -1;
/*
printf("akxs_seqs: func=%c hashbp->ha_prereg=%08x\n",func,hashbp->ha_prereg);
*/
	switch (func) {
	  case 'r':
	  case 'R':
			i=_seqsr(hashbp);
			break;
	  case 's':
	  case 'S':
			i=_seqss(hashbp);
			break;
	  case 'd':
	  case 'D':
			i=_seqsd(hashbp);
			break;
	  case 'i':
	  case 'I':
			i=_seqsi(hashbp);
			break;
	  default:
			i=-2;
	}
	return (i);
}

static int _seqsi(hp)
HASHB *hp;
{
	int i=0;

	if (hp->ha_maxreg <= 0) i-=4;
	if (!hp->ha_reg) i -= 8;
	if (!hp->ha_next) i -= 16;

	if (i >= 0) {
		memset(hp->ha_reg,0,hp->ha_maxreg*sizeof(char *));
		memset(hp->ha_next,0,hp->ha_maxreg);
		hp->ha_aux=0;
	}

	return (i);
}

static int _seqss(hp)
HASHB *hp;
{
	int i,lklen,opt;
	char *p,*kp,**rp,*np;
	short klen;

	if (i = _seqsr(hp)) return i;

	rp = (char **)hp->ha_reg;
	np = (char *)hp->ha_next;

	for (i=0;i<hp->ha_aux;i++) {
		if (!np[i]) break;
	}
	if (i >= hp->ha_maxreg) return 0;
	if (i >= hp->ha_aux) hp->ha_aux++;
	klen = hp->ha_keylen;
	kp = hp->ha_key;
	p = rp[i];
	if (!klen) {
		lklen = strlen(kp) + 1;
	}
	else if (klen > 0) {
		lklen = klen;
	}
	else {
		memcpy(&lklen,kp,sizeof(int));
		if (lklen < 0) return -32;
		lklen += sizeof(int);
	}

	if (p) {
		if (klen <= 0) p = Realloc(p,lklen);
	}
	else p = Malloc(lklen);

	if (p) {
		memcpy(p,kp,lklen);
		if (opt=hp->ha_prereg) opt >>= 16;
		np[i] = 1 | opt;
		rp[i] = p;
/*
printf("seqs:i=%d kp=[%s] np[i]=%08x\n",i,p,np[i]);
*/
	}
	else return -33;
	return i+1;
}

static int _seqsr(hp)
HASHB *hp;
{
	int i;
	char *p,*kp,**rp,*np;
	short len,klen;
	int  ldlen,lklen,opt;

	rp = (char **)hp->ha_reg;
	np = (char *)hp->ha_next;
	if (!(kp = hp->ha_key)) return -35;
	if ((klen=hp->ha_keylen) < 0) {
		memcpy(&lklen,kp,sizeof(int));
		if (lklen < 0) return -32;
		kp += sizeof(int);
	}
/*
printf("seqr: klen=%d kp=[%s]\n",klen,kp);
*/
	for (i=0;i<hp->ha_aux;i++) {
		p = rp[i];
		if (!(opt=np[i]) || !p) continue;
		if (opt & ~0x01) opt <<= 16;
		if (!klen) {
/*
printf("seqr:i=%d p=[%s] kp=[%s] opt=%08x\n",i,p,kp,opt);
*/
			if (!akxs_opt_strcmp(p,kp,opt)) break;
		}
		else if (klen > 0) {
			if (!akxs_opt_memcmp(p,kp,klen,opt)) break;
		}
		else {
			memcpy(&ldlen,p,sizeof(int));
			if (lklen == ldlen) {
				if (!akxs_opt_memcmp(p+sizeof(int),kp,lklen,opt)) break;
			}
		}
	}
	if (i >= hp->ha_aux) i = -1;

	return i+1;
}

static int _seqsd(hp)
HASHB *hp;
{
	int i;
	char *np;

	i = hp->ha_hix;
	if (i > 0 ) {
		if (i > hp->ha_aux) return -34;
	}
	else {
		if ((i=_seqsr(hp)) <= 0) return i;
	}
	np = (char *)hp->ha_next;
	np[i-1] = 0;
	return i;
}

HASHB *akxs_seqs_new(sKeyLen,lMaxReg)
short sKeyLen;
int  lMaxReg;
{
	HASHB *tph;
	int l;

	if (lMaxReg <= 0) return NULL;
	if (!(tph=(HASHB *)Malloc(sizeof(HASHB)))) return NULL;
	memset(tph,0,sizeof(HASHB));
	tph->ha_id[0] = 'S';
	tph->ha_id[1] = 'Q';
	tph->ha_keylen = sKeyLen;
	tph->ha_maxreg = lMaxReg;
	if (!(tph->ha_reg=Malloc(lMaxReg*sizeof(char *)))) {
		akxs_seqs_free(tph);
		return NULL;
	}
	if (!(tph->ha_next=(int *)Malloc(lMaxReg))) {
		akxs_seqs_free(tph);
		return NULL;
	}
	if (akxs_seqs('i',tph)) {
		akxs_seqs_free(tph);
		return NULL;
	}
	return tph;
}

int akxs_seqs_free(tph)
HASHB *tph;
{
	if (tph) {
		if (tph->ha_reg) Free(tph->ha_reg);
		if (tph->ha_next) Free(tph->ha_next);
		Free(tph);
	}
	return 0;
}

static int _xseqsf();
static int _xseqs_chk();
static int _xseqs_used();
static int _xseqs_max();

XHASHB *akxs_xseqs_new2(sKeyLen,lMaxReg,lDatLen)
short sKeyLen;
int  lMaxReg,lDatLen;
{
	XHASHB *p;
	int l;
	char c;

	if (lMaxReg <= 0) {
		errno = -1301;
		return NULL;
	}
	if (!(p=(XHASHB *)Malloc(sizeof(XHASHB)))) {
		errno = -1303;
		return NULL;
	}

	if (sKeyLen>0 && sKeyLen<=sizeof(long)) c = 'L';
	else if (sKeyLen>sizeof(long) && sKeyLen<=sizeof(long)*2) c = '2';
	else c = 'X';

	p->xha_id[0] = 'S';
	p->xha_id[1] = c;
	p->xha_keylen = sKeyLen;
	p->xha_maxreg = lMaxReg;
	p->xha_prereg = 0;
	p->xha_datlen = lDatLen;
	p->xha_xhix   = 0;
	p->xha_hashb  = NULL;
	p->xha_xhnext = NULL;
	p->xha_datreg = NULL;
	return p;
}

int akxs_xseqs2(tp_xseqsb,cCmnd,cpKey,cppDat)
XHASHB *tp_xseqsb;
char cCmnd, *cpKey;
char **cppDat;		/* cCmnd='S'or's'̂Ƃ́A(char *)Ɠǂݑւ */
{
	XHASHB *tpcur,*tpnext;
	int l,i,offset,len;
	HASHB *tph,ha;
	int ret,opt;
	char cCmd,c,cc;

	if (!tp_xseqsb) return -1;
	cCmd = akxcupper(cCmnd);
	if ((cCmd=='R'||cCmd=='P'||cCmd=='K') && cppDat) *cppDat = NULL;
	switch (cCmd) {
		case 'R':
		case 'S':
		case 'D':
			if (tp_xseqsb->xha_xhix) return _xseqs_chk(tp_xseqsb,cCmd,cpKey,cppDat);
			break;
		case 'K':
		case 'P':
			return _xseqs_chk(tp_xseqsb,cCmd,cpKey,cppDat);
		case 'U':
			return _xseqs_used(tp_xseqsb);
		case 'M':
			return _xseqs_max(tp_xseqsb);
		default:
			return -72;
	}
	if (!cpKey) return -1;
	l = 0;
	offset = 0;
	tpnext = tp_xseqsb;
	while (tpnext) {
		tpcur = tpnext;
		if (!(tph=tpcur->xha_hashb)) {
			if (cCmd == 'R' || cCmd == 'D') return 0;
			if (tph=akxs_seqs_new(tpcur->xha_keylen,tpcur->xha_maxreg))
				tpcur->xha_hashb = tph;
			else return errno;
			tph->ha_prereg = tpcur->xha_prereg;
			cc = tpcur->xha_id[0];
			c = toupper(cc);
			if (c != cc) tph->ha_prereg |= AKX_ARGV_USE_ICMP;
/*
printf("akxs_xseqs2: cCmd=%c tph->ha_prereg=%08x\n",cCmd,tph->ha_prereg);
*/
		}
		tph->ha_key = cpKey;
		tph->ha_hix = 0;
		if (cCmd=='S' && cppDat && tpcur->xha_datlen == -2 && tph->ha_id[1]=='L')
			tph->ha_next = (int *)cppDat;
		if (i=akxs_seqs(cCmd,tph)) {
			if (i>0) {
				if ((ret=akxs_dreg_proc(tpcur,cCmd,i,cppDat))<0) return ret;
				i += offset;
			}
			return i;
		}
		tpnext = tpcur->xha_xhnext;
		offset += tpcur->xha_maxreg;
	}
	if (cCmd == 'R' || cCmd == 'D') return i;
	if (!(tpnext=(XHASHB *)Malloc(sizeof(XHASHB)))) return -76;
	tpcur->xha_xhnext = tpnext;
	memcpy(tpnext,tpcur,sizeof(XHASHB));
	tpnext->xha_xhix = l;
	tpnext->xha_hashb = NULL;
	tpnext->xha_xhnext = NULL;
	tpnext->xha_datreg = NULL;
	if ((i = akxs_xseqs2(tpnext,cCmd,cpKey,cppDat))>0) i += offset;
	tpnext->xha_xhix = 0;
	return i;
}

int akxs_xseqs_free(tp_xseqsb)
XHASHB *tp_xseqsb;
{
	HASHB *tph;
	int i;
	char **rpp,*p;

	if (tp_xseqsb) {
		if (tph=tp_xseqsb->xha_hashb) {
			akxs_hasx_free(tph);
		}
		if (p=tp_xseqsb->xha_datreg) {
			if (tp_xseqsb->xha_datlen <= 0) {
				rpp=(char **)p;
				akxm_cct_mem_free(rpp[0]);
			}
			Free(tp_xseqsb->xha_datreg);
		}
		akxs_xseqs_free(tp_xseqsb->xha_xhnext);
		Free(tp_xseqsb);
	}
	return 0;
}

XHASHB *akxs_xseqs_new(sKeyLen,lMaxReg,lPreReg)
short sKeyLen;
int  lMaxReg,lPreReg;
{
	return akxs_xseqs_new2(sKeyLen,lMaxReg,lPreReg,-2);
}

int akxs_xseqs(tp_xseqsb,cCmd,cpKey)
XHASHB *tp_xseqsb;
char cCmd, *cpKey;
{
	return akxs_xseqs2(tp_xseqsb,cCmd,cpKey,NULL);
}

static int _xseqs_chk(tp_xseqsb,cCmd,cpKey,cppDat)
XHASHB *tp_xseqsb;
char cCmd, *cpKey,**cppDat;
{
	XHASHB *tpcur;
	int i,offset,max,next,ix;
	HASHB *tph;
	int ret;
	char cCmdw;

	ret = -1029;
	i = tp_xseqsb->xha_xhix;
	tp_xseqsb->xha_xhix = 0;
	offset = 0;
	tpcur = tp_xseqsb;
	max = tpcur->xha_maxreg;
	while (tpcur) {
		next = offset + max;
		if (next >= i) {
			ret = 0;
			if (tph=tpcur->xha_hashb) {
				tph->ha_hix = ix = i - offset;
				if (cCmd != 'P') tph->ha_key = cpKey;
				else if (cCmd=='S' && cppDat && tpcur->xha_datlen == -2 && tph->ha_id[1]=='L')
					tph->ha_next = (int *)cppDat;
				ret = akxs_seqs(cCmd,tph);
				if (ret > 0) {
					if ((cCmdw=cCmd)=='P' || cCmdw=='K') cCmdw = 'R';
					if ((ret=akxs_dreg_proc(tpcur,cCmdw,ix,cppDat))<0) return ret;
					if ((cCmd == 'P') && cpKey) *(char **)cpKey = tph->ha_key;
					return i;
				}
			}
			break;
		}
		tpcur = tpcur->xha_xhnext;
		offset = next;
	}
	return ret;
}

static int _xseqs_used(tp_xseqsb)
XHASHB *tp_xseqsb;
{
	XHASHB *tpcur;
	int ret,count;
	HASHB *tph;

	count = 0;
	tpcur = tp_xseqsb;
	while (tpcur) {
		tpcur->xha_xhix = 0;
		if (tph=tpcur->xha_hashb) {
			ret = akxs_seqs('U',tph);
			tpcur->xha_xhix = ret;
			if (ret > 0) count += ret;
		}
		tpcur = tpcur->xha_xhnext;
	}
	return count;
}

static int _xseqs_max(tp_xseqsb)
XHASHB *tp_xseqsb;
{
	XHASHB *tpcur;
	int ret,m;
	HASHB *tph;

	m = 0;
	tpcur = tp_xseqsb;
	while (tpcur) {
		m += tpcur->xha_maxreg;
		tpcur = tpcur->xha_xhnext;
	}
	return m;
}
