/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.ThreadFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.collections.ReferenceMap;

public class ChatManager {
    private static boolean defaultIsNormalInclude = true;
    private static MatchMode defaultMatchMode = MatchMode.BARE_JID;
    private boolean normalIncluded = defaultIsNormalInclude;
    private MatchMode matchMode = defaultMatchMode;
    private Map<String, Chat> threadChats = Collections.synchronizedMap(new ReferenceMap(0, 2));
    private Map<String, Chat> jidChats = Collections.synchronizedMap(new ReferenceMap(0, 2));
    private Map<String, Chat> baseJidChats = Collections.synchronizedMap(new ReferenceMap(0, 2));
    private Set<ChatManagerListener> chatManagerListeners = new CopyOnWriteArraySet<ChatManagerListener>();
    private Map<PacketInterceptor, PacketFilter> interceptors = new WeakHashMap<PacketInterceptor, PacketFilter>();
    private Connection connection;

    ChatManager(Connection connection) {
        this.connection = connection;
        PacketFilter filter = new PacketFilter(){

            @Override
            public boolean accept(Packet packet) {
                if (!(packet instanceof Message)) {
                    return false;
                }
                Message.Type messageType = ((Message)packet).getType();
                return messageType == Message.Type.chat || ChatManager.this.normalIncluded && messageType == Message.Type.normal;
            }
        };
        connection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Message message = (Message)packet;
                Chat chat = message.getThread() == null ? ChatManager.this.getUserChat(message.getFrom()) : ChatManager.this.getThreadChat(message.getThread());
                if (chat == null) {
                    chat = ChatManager.this.createChat(message);
                }
                ChatManager.this.deliverMessage(chat, message);
            }
        }, filter);
    }

    public boolean isNormalIncluded() {
        return this.normalIncluded;
    }

    public void setNormalIncluded(boolean normalIncluded) {
        this.normalIncluded = normalIncluded;
    }

    public MatchMode getMatchMode() {
        return this.matchMode;
    }

    public void setMatchMode(MatchMode matchMode) {
        this.matchMode = matchMode;
    }

    public Chat createChat(String userJID, MessageListener listener) {
        return this.createChat(userJID, null, listener);
    }

    public Chat createChat(String userJID, String thread, MessageListener listener) {
        Chat chat;
        if (thread == null) {
            thread = ChatManager.nextID();
        }
        if ((chat = this.threadChats.get(thread)) != null) {
            throw new IllegalArgumentException("ThreadID is already used");
        }
        chat = this.createChat(userJID, thread, true);
        chat.addMessageListener(listener);
        return chat;
    }

    private Chat createChat(String userJID, String threadID, boolean createdLocally) {
        Chat chat = new Chat(this, userJID, threadID);
        this.threadChats.put(threadID, chat);
        this.jidChats.put(userJID, chat);
        this.baseJidChats.put(StringUtils.parseBareAddress(userJID), chat);
        for (ChatManagerListener listener : this.chatManagerListeners) {
            listener.chatCreated(chat, createdLocally);
        }
        return chat;
    }

    private Chat createChat(Message message) {
        String threadID = message.getThread();
        if (threadID == null) {
            threadID = ChatManager.nextID();
        }
        String userJID = message.getFrom();
        return this.createChat(userJID, threadID, false);
    }

    private Chat getUserChat(String userJID) {
        if (this.matchMode == MatchMode.NONE) {
            return null;
        }
        Chat match = this.jidChats.get(userJID);
        if (match == null && this.matchMode == MatchMode.BARE_JID) {
            match = this.baseJidChats.get(StringUtils.parseBareAddress(userJID));
        }
        return match;
    }

    public Chat getThreadChat(String thread) {
        return this.threadChats.get(thread);
    }

    public void addChatListener(ChatManagerListener listener) {
        this.chatManagerListeners.add(listener);
    }

    public void removeChatListener(ChatManagerListener listener) {
        this.chatManagerListeners.remove(listener);
    }

    public Collection<ChatManagerListener> getChatListeners() {
        return Collections.unmodifiableCollection(this.chatManagerListeners);
    }

    private void deliverMessage(Chat chat, Message message) {
        chat.deliver(message);
    }

    void sendMessage(Chat chat, Message message) {
        for (Map.Entry<PacketInterceptor, PacketFilter> interceptor : this.interceptors.entrySet()) {
            PacketFilter filter = interceptor.getValue();
            if (filter == null || !filter.accept(message)) continue;
            interceptor.getKey().interceptPacket(message);
        }
        if (message.getFrom() == null) {
            message.setFrom(this.connection.getUser());
        }
        this.connection.sendPacket(message);
    }

    PacketCollector createPacketCollector(Chat chat) {
        return this.connection.createPacketCollector(new AndFilter(new ThreadFilter(chat.getThreadID()), new FromContainsFilter(chat.getParticipant())));
    }

    public void addOutgoingMessageInterceptor(PacketInterceptor packetInterceptor) {
        this.addOutgoingMessageInterceptor(packetInterceptor, null);
    }

    public void addOutgoingMessageInterceptor(PacketInterceptor packetInterceptor, PacketFilter filter) {
        if (packetInterceptor != null) {
            this.interceptors.put(packetInterceptor, filter);
        }
    }

    private static String nextID() {
        return UUID.randomUUID().toString();
    }

    public static void setDefaultMatchMode(MatchMode mode) {
        defaultMatchMode = mode;
    }

    public static void setDefaultIsNormalIncluded(boolean allowNormal) {
        defaultIsNormalInclude = allowNormal;
    }

    public static enum MatchMode {
        NONE,
        SUPPLIED_JID,
        BARE_JID;

    }
}

