/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.ExtensionProviderInfo;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.IQProviderInfo;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderLoader;
import org.xmlpull.mxp1.MXParser;

public class ProviderFileLoader
implements ProviderLoader {
    private static final Logger log = Logger.getLogger(ProviderFileLoader.class.getName());
    private Collection<IQProviderInfo> iqProviders;
    private Collection<ExtensionProviderInfo> extProviders;
    private InputStream providerStream;

    public ProviderFileLoader(InputStream providerFileInputStream) {
        this.setInputStream(providerFileInputStream);
    }

    public ProviderFileLoader() {
    }

    @Override
    public Collection<IQProviderInfo> getIQProviderInfo() {
        this.initialize();
        return this.iqProviders;
    }

    @Override
    public Collection<ExtensionProviderInfo> getExtensionProviderInfo() {
        this.initialize();
        return this.extProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initialize() {
        if (this.iqProviders != null) {
            return;
        }
        if (this.providerStream == null) {
            throw new IllegalArgumentException("No input stream set for loader");
        }
        this.iqProviders = new ArrayList<IQProviderInfo>();
        this.extProviders = new ArrayList<ExtensionProviderInfo>();
        try {
            MXParser parser = new MXParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput(this.providerStream, "UTF-8");
            int eventType = parser.getEventType();
            do {
                if (eventType != 2) continue;
                String typeName = parser.getName();
                try {
                    if ("smackProviders".equals(typeName)) continue;
                    parser.next();
                    parser.next();
                    String elementName = parser.nextText();
                    parser.next();
                    parser.next();
                    String namespace = parser.nextText();
                    parser.next();
                    parser.next();
                    String className = parser.nextText();
                    try {
                        Class<?> provider;
                        if ("iqProvider".equals(typeName)) {
                            provider = Class.forName(className);
                            if (IQProvider.class.isAssignableFrom(provider)) {
                                this.iqProviders.add(new IQProviderInfo(elementName, namespace, (IQProvider)provider.newInstance()));
                                continue;
                            }
                            if (!IQ.class.isAssignableFrom(provider)) continue;
                            this.iqProviders.add(new IQProviderInfo(elementName, namespace, provider));
                            continue;
                        }
                        provider = Class.forName(className);
                        if (PacketExtensionProvider.class.isAssignableFrom(provider)) {
                            this.extProviders.add(new ExtensionProviderInfo(elementName, namespace, (PacketExtensionProvider)provider.newInstance()));
                            continue;
                        }
                        if (!PacketExtension.class.isAssignableFrom(provider)) continue;
                        this.extProviders.add(new ExtensionProviderInfo(elementName, namespace, provider));
                    }
                    catch (ClassNotFoundException cnfe) {
                        log.log(Level.SEVERE, "Could not find provider class", cnfe);
                    }
                }
                catch (IllegalArgumentException illExc) {
                    log.log(Level.SEVERE, "Invalid provider type found [" + typeName + "] when expecting iqProvider or extensionProvider", illExc);
                }
            } while ((eventType = parser.next()) != 1);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unknown error occurred while parsing provider file", e);
        }
        finally {
            try {
                this.providerStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public void setInputStream(InputStream providerFileInput) {
        if (providerFileInput == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        this.providerStream = providerFileInput;
        this.initialize();
    }
}

