﻿using System;
using System.ComponentModel;
using System.Runtime.InteropServices;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Interop;
using System.Windows.Input;
using Forms = System.Windows.Forms;
using System.Diagnostics;

namespace JoinNotes
{
    /// <summary>
    /// Config.xaml の相互作用ロジック
    /// </summary>
    public partial class Config : Window
    {
        public Config()
        {
            InitializeComponent();
            this.Loaded += new RoutedEventHandler(Config_Loaded);
            LoadSettings();
        }

        void LoadSettings()
        {
            // 設定の読み込み・有効化
            try
            {
                //FIXME: ActivateHotkeyを型にあった名前に
                var keys = Properties.Settings.Default.ActivateHotkey;
                //var hotKey = new HotKey(App.mainWindow.Handle,
                var hotKey = new HotKey(new WindowInteropHelper(App.mainWindow).Handle,
                    NotifyTray.HotKey_ActivateHotKeyId,
                    keys & Forms.Keys.KeyCode,
                    keys & Forms.Keys.Modifiers);
                NotifyTray.HotKey_ActivateHotKey = hotKey;
            }
            catch (Win32Exception ex)
            {
                Debug.WriteLine(ex.Message, ex.Source);
            }

            try
            {
                //FIXME: OpenWindowHotKeyを型にあった名前に
                var keys = Properties.Settings.Default.OpenWindowHotKey;
                //var hotKey = new HotKey(App.mainWindow.Handle,
                var hotKey = new HotKey(new WindowInteropHelper(App.mainWindow).Handle,
                    NotifyTray.HotKey_OpenWindowHotKeyId,
                    keys & Forms.Keys.KeyCode,
                    keys & Forms.Keys.Modifiers);
                NotifyTray.HotKey_OpenWindowHotKey = hotKey;
            }
            catch (Win32Exception ex)
            {
                Debug.WriteLine(ex.Message, ex.Source);
            }
        }

        void Config_Loaded(object sender, RoutedEventArgs e)
        {
            this.ActivateHotkeyText.Text = Properties.Settings.Default.ActivateHotkey.ToString();
            this.OpenWindowHotKeyText.Text = Properties.Settings.Default.OpenWindowHotKey.ToString();
            this.StartPageNameText.Text = Properties.Settings.Default.StartPageName;

            {
                var className = Properties.Settings.Default.StartupWindowClassName;
                if (this.comboBox2.HasItems)
                {
                    switch (className)
                    {
                        //FIXME: 設定値とComboBoxでのラベルの対応付け
                        case "Editor":
                            this.comboBox2.SelectedIndex = 0;   // EditorWindow
                            break;

                        case "Search":
                            this.comboBox2.SelectedIndex = 1;   // SearchWindow
                            break;

                        case "Task":
                            this.comboBox2.SelectedIndex = 2;   // TaskTrayMenu
                            break;

                        default:
                            this.comboBox2.SelectedValue = 0;
                            Debug.Fail("comboBox1_SelectionChanged");
                            break;
                    }
                }

            }

        }

        private void HotKeyBox_KeyDown(object sender, KeyEventArgs e)
        {
            var c = (TextBox)sender;

            //FIXME: 各キーで分けずにまとめて
            if (ReferenceEquals(c, this.ActivateHotkeyText))
            {
                try
                {
                    //var hotKey = new HotKey(App.mainWindow.Handle,
                    var hotKey = new HotKey(new WindowInteropHelper(App.mainWindow).Handle,
                        NotifyTray.HotKey_ActivateHotKeyId,
                        Util.InputKeyToFormsKey(e.Key),
                        Util.InputModifierKeyToFormsKey(e.KeyboardDevice.Modifiers));
                    Properties.Settings.Default.ActivateHotkey = hotKey.Keys;
                    Properties.Settings.Default.Save();
                    NotifyTray.HotKey_ActivateHotKey = hotKey;

                    //FIXME: this.ActivateHotkeyText.Text = hotKey.Keys.ToString() にしたい。
                    this.ActivateHotkeyText.Text = e.KeyboardDevice.Modifiers.ToString() + ", " + e.Key.ToString();

                    Debug.WriteLine("ActivateHotKey: " + this.ActivateHotkeyText.Text, "HotKeyBox_KeyDown");
                }
                catch (Win32Exception ex)
                {
                    Debug.WriteLine(ex.Message, ex.Source);
                    this.ActivateHotkeyText.Text = "";
                }
            }
            else if (ReferenceEquals(c, this.OpenWindowHotKeyText))
            {
                try
                {
                    //var hotKey = new HotKey(App.mainWindow.Handle,
                    var hotKey = new HotKey(new WindowInteropHelper(App.mainWindow).Handle,
                        NotifyTray.HotKey_OpenWindowHotKeyId,
                        Util.InputKeyToFormsKey(e.Key),
                        Util.InputModifierKeyToFormsKey(e.KeyboardDevice.Modifiers));
                    Properties.Settings.Default.OpenWindowHotKey = hotKey.Keys;
                    Properties.Settings.Default.Save();
                    NotifyTray.HotKey_OpenWindowHotKey = hotKey;

                    //FIXME: this.OpenWindowHotKeyText.Text = hotKey.Keys.ToString() にしたい。
                    this.OpenWindowHotKeyText.Text = e.KeyboardDevice.Modifiers.ToString() + ", " + e.Key.ToString();

                    Debug.WriteLine("OpenWindowHotKey: " + this.OpenWindowHotKeyText.Text, "HotKeyBox_KeyDown");
                }
                catch (Win32Exception ex)
                {
                    Debug.WriteLine(ex.Message, ex.Source);
                    this.OpenWindowHotKeyText.Text = "";
                }
            }
        }

        private void textBox1_LostFocus(object sender, RoutedEventArgs e)
        {
        }

        private void comboBox1_SelectionChanged(object sender, System.Windows.Controls.SelectionChangedEventArgs e)
        {
            var c = (ComboBox)sender;

            var item = (ComboBoxItem)c.SelectedItem;
            switch (item.Name)
            {
                case "EditorWindow":
                    Properties.Settings.Default.StartupWindowClassName = "Editor";
                    break;

                case "SearchWindow":
                    Properties.Settings.Default.StartupWindowClassName = "Search";
                    break;

                case "TaskTrayMenu":
                    Properties.Settings.Default.StartupWindowClassName = "Task";
                    break;

                default:
                    Properties.Settings.Default.StartupWindowClassName = "";
                    Debug.Fail("comboBox1_SelectionChanged");
                    break;
            }
            Properties.Settings.Default.Save();
        }

        private void button0_Click(object sender, RoutedEventArgs e)
        {
            //FIXME: 対象範囲だけを初期化
            Properties.Settings.Default.Properties.Clear();
        }

        private void button1_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

        private void StartPageBox_KeyDown(object sender, KeyEventArgs e)
        {
        }

        private void StartPageBox_TextChanged(object sender, TextChangedEventArgs e)
        {
            var c = (TextBox)sender;

            Properties.Settings.Default.StartPageName = c.Text;
            Properties.Settings.Default.Save();
        }
    }

    /// <summary>ホットキーの登録・解除を行うためのクラス</summary>
    public class HotKey
    {
        [DllImport("user32", SetLastError = true)]
        private static extern int RegisterHotKey(IntPtr hWnd,
                                                 int id,
                                                 int fsModifier,
                                                 int vk);
        //int vk,
        //int mod);

        [DllImport("user32", SetLastError = true)]
        private static extern int UnregisterHotKey(IntPtr hWnd,
                                                   int id);

        public HotKey(IntPtr hWnd, int id, Forms.Keys keys)
        {
            this.hWnd = hWnd;
            this.id = id;
            this.keys = keys;

            var keycode = (int)(keys & Forms.Keys.KeyCode);
            var modifierscode = (int)(keys & Forms.Keys.Modifiers) >> 16;

            this.lParam = new IntPtr(keycode << 16 | modifierscode);

            Register(hWnd, id, modifierscode, keycode);
        }

        public HotKey(IntPtr hWnd, int id, Forms.Keys keys, Forms.Keys modifiers)
        {
            this.hWnd = hWnd;
            this.id = id;
            this.keys = keys | modifiers;

            var keycode = (int)(keys & Forms.Keys.KeyCode);
            var modifierscode = (int)(modifiers & Forms.Keys.Modifiers) >> 16;

            this.lParam = new IntPtr(keycode << 16 | modifierscode);

            Register(hWnd, id, modifierscode, keycode);
        }

        private void Register(IntPtr hWnd, int id, int modifierscode, int keycode)
        {
            if (RegisterHotKey(hWnd, id, modifierscode, keycode) == 0)
                // ホットキーの登録に失敗
                throw new Win32Exception(Marshal.GetLastWin32Error());
        }

        public void Unregister()
        {
            if (hWnd == IntPtr.Zero)
                return;

            if (UnregisterHotKey(hWnd, id) == 0)
                // ホットキーの解除に失敗
                throw new Win32Exception(Marshal.GetLastWin32Error());

            hWnd = IntPtr.Zero;
        }

        public IntPtr LParam
        {
            get { return lParam; }
        }

        public Forms.Keys Keys
        {
            get { return keys; }
        }

        private IntPtr hWnd; // ホットキーの入力メッセージを受信するウィンドウのhWnd
        private readonly int id; // ホットキーのID(0x0000〜0xBFFF)
        private readonly IntPtr lParam; // WndProcメソッドで押下されたホットキーを識別するためのlParam値
        private readonly Forms.Keys keys;
    }
}
