﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Windows.Interop;
using System.Diagnostics;
using System.Runtime.InteropServices;

namespace JoinNotes
{
    public partial class Menu : Form
    {
        internal const int WM_HOTKEY = 0x312;
        internal const int WM_ACTIVATEAPP = 0x1C;
        internal const int WM_APP = 0x8000;
        internal const int WM_APP_ACTIVATEAPP = WM_APP + 1;
        internal const int SW_RESTORE = 9;
        public const int HotKey_ActivateHotKeyId = 0;
        public const int HotKey_OpenWindowHotKeyId = 1;
        static public HotKey HotKey_ActivateHotKey = null;
        static public HotKey HotKey_OpenWindowHotKey = null;


        public Menu()
        {
            InitializeComponent();
            this.ShowInTaskbar = false;
            //this.Visible = false;
            this.Visible = true;
        }

        protected override void WndProc(ref Message m)
        {
            Debug.WriteLine(m.ToString(), "Menu:WndProc");
            
            if (m.Msg == WM_APP_ACTIVATEAPP)
            {
                //UNDONE:
                Debug.WriteLine("received: " + m.ToString());
                MessageBox.Show("received: " + m.ToString());
                //App.ActivateWindows();
            }

            //if (m.Msg == WM_ACTIVATEAPP)
            //    if (m.WParam.ToInt64() == 0)
            //    {
            //        App.InactivateWindows();
            //    }
            //    else
            //    {
            //        App.ActivateWindows();
            //    }

            if (m.Msg == WM_HOTKEY)
                Debug.WriteLine(this.GetType().Name + ": WM_HOTKEY");

            //if (m.Msg == WM_HOTKEY)
            //{
            //    var ret = Util.PostMessage(new HandleRef(App.Instance, this.Handle), WM_APP_ACTIVATEAPP, IntPtr.Zero, IntPtr.Zero);
            //    Trace.Assert(ret);
            //}

            if (m.Msg == WM_HOTKEY && m.LParam != null && HotKey_ActivateHotKey != null && m.LParam == HotKey_ActivateHotKey.LParam)
            {
                //App.SwitchApplicationVisibility();
                //var editor = new Editor();
                //editor.Show();

                App.SwitchApplicationVisibility();
            }
            else if (m.Msg == WM_HOTKEY && m.LParam != null && HotKey_OpenWindowHotKey != null && m.LParam == HotKey_OpenWindowHotKey.LParam)
            {
                switch (Properties.Settings.Default.StartupWindowClassName)
                {
                    case "Editor":
                        {
                            var editor = new Editor();
                            ((App)App.Current).UntitledEditorWindows.Add(editor);
                            editor.Show();
                            editor.Activate();
                        }
                        break;

                    case "Search":
                        App.searchWindow.Show();
                        break;

                    case "Task":
                        //App.mainWindow.MainMenuStrip.Show();
                        ((NotifyTray)App.mainWindow).ShowNotifyTrayMenu();
                        break;

                    default:
                        break;
                }
                //App.SwitchApplicationVisibility();
                //var editor = new Editor();
                //editor.Show();

                App.SwitchApplicationVisibility();
            }
            else
            {
                base.WndProc(ref m);
            }
        }

        private void configCToolStripMenuItem_Click(object sender, EventArgs e)
        {
            new Config().Show();
        }

        private void editorNToolStripMenuItem_Click(object sender, EventArgs e)
        {
            new Editor().Show();
        }

        private void searchSToolStripMenuItem_Click(object sender, EventArgs e)
        {
            new Search().Show();
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // WPFアプリケーションの終了
            App.Current.Shutdown();
        }

        private void notifyIcon1_MouseDoubleClick(object sender, MouseEventArgs e)
        {

        }

        private void notifyIcon1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == System.Windows.Forms.MouseButtons.Left)
            {
                var w = App.Current.MainWindow;
                if (w.IsVisible)
                    w.Close();
                else
                    w.Show();
            }
        }

        private void contextMenuStrip1_Opening(object sender, CancelEventArgs e)
        {

        }

        private void aboutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            App.aboutWindow.ShowDialog();
        }
    }
}
