#include <sys/syscall.h>
#include <unistd.h>

#ifdef __linux__
# include <linux/types.h>
/* # include <linux/dirent.h> */
# include <linux/unistd.h>
# include <errno.h>
#else
# include <dirent.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <termios.h>
#include <term.h>
/* #include <curses.h> */

#define cls()           printf("\33[2J")
#define locate(x,y)     printf("\33[%d;%dH",y+1,x+1)
#define tc(n)           printf("\33[%dm",n)
#define TC47 43
#define AMAX 1024
#define BMAX 80
#define TA 18
#define TB 18

#define  VER     "np.01.01"
#define  MAX     9
#define  QUES    MAX+7
#define  ANS     MAX+6
#define  MA1     8
#define  MEM     MAX+1
#define  MEM2    MAX+2
#define  MEM3    MAX+3
#define  CH      MAX+4
#define  OJI     MAX+5
 
 static char bb[MAX][MAX]={
    {11,12,13,21,22,23,31,32,33},
    {14,15,16,24,25,26,34,35,36},
    {17,18,19,27,28,29,37,38,39},
    {41,42,43,51,52,53,61,62,63},
    {44,45,46,54,55,56,64,65,66},
    {47,48,49,57,58,59,67,68,69},
    {71,72,73,81,82,83,91,92,93},
    {74,75,76,84,85,86,94,95,96},
    {77,78,79,87,88,89,97,98,99}
};

char aa[MAX+1][MAX+1][MAX+11];
int  cd[90],dd[90],dx[90],dy[90];
int  eflag=2,hflag,zflag;
int  scount=0;
int  lete=0;
int  cq=0,pl,q,ei,ej,ek,eno,fi,fj,fk,fbf,kt=0;
int  ee,ff,ww,gflag,chi;

void intro();
void echeck();
void np1_load();
void shoki(int sh);
void ecopy(int mm1,int mm2);
void eset();
void fcheck();
void gcheck1();
void gcheck2();
void fback();
void gback();
void kekka();
void katei();
void onaji();
int  sank1(int ia,int ja,int la);
int  sank2(int ia,int ja,int la);
void sany1(int ia,int la);
void sann1(int ia,int la);
void sany2(int ja,int la);
void sann2(int ja,int la);
void houkoku();

static struct termios initial_settings, new_settings;
static int peek_character = -1;

void init_keyboard();
void close_keyboard();
int kbhit();
int readch();

int jogen=500;
 
struct dirent {
   long d_ino;
   off_t d_off;
   unsigned short d_reclen;
   char d_name[AMAX];
};

struct node {
   long fileno;
   char filename[AMAX];
   char file1[AMAX];
   char file2[10];
   int tate,yoko;
   char msg[AMAX],comm[20];
   float ftime;
   struct node *back,*next;
};

struct nodef {
   char text[AMAX];
   int gyo,len;
   struct nodef *back,*next;
};

struct nodef *nodef_create();
struct nodef *fldataf,*floldf,*flnowf,*fla1f,*fla2f;
struct nodef *infof,*startf,*lastf,*gcdataf,*gc2f;
struct nodef *infop,*startp,*lastp,*gcdatap,*gc2p;

struct node *node_create();
struct node *shojun(struct node *temp);
struct node *fldata,*flold,*flnow,*sttm1,*sttc1;
struct node *startm1,*startc1,*endm1,*endc1;
struct node *info,*start,*last,*gcdata,*gc2;
struct node *stt,*gmdata,*gm2,*nfnow,*nfold,*nff;

char filename[AMAX],file1[AMAX],file2[10];
char ttt[AMAX],sss[AMAX],ss2[AMAX],tt2[AMAX],tt3[AMAX];
time_t t;
struct tm *tmp;
int normal=0,xl;
int mani,manj;
 
int  init();
void print1(struct node *from);
void print2(struct node *from);
void print3(struct node *from);
char newfile();
void file_open1(struct node *from);
void printb(struct nodef *fromf);
void printp(char *ppp);
void printhelp();
void printhelp2();
void printhelp3();
void ins1(int c);
void uwa1(int c);
void ins2(char *p);
void uwa2(char *p);
void bs1();
void del1();
void kakeru(int ik);
void bedit(char *ppp);
void pedit(struct node *from);
void hitanykey();
int search(struct node *from,char tta[AMAX],int aa);
int position(char text[AMAX],char pattern[AMAX]);
int position2(char *text,char *pattern);

char text[AMAX],str1[AMAX];
int si,pos,gyo,mlen;

int main(){
   int  ch=0,ch1=0,im,i,fbb;
   int fd_r,fd_w;
   char tt5[AMAX],tt6[AMAX],ar3[40],uuu[50];
   long lm;
   FILE *fp;
 
   if(init()!=0) exit(1);
   init_keyboard();
   cls();
   strcpy(tt5,"");

printf("149\n");

   print1(flnow); 
   while(ch != 'q'&& ch != 0x18&& ch != 0x17) {
        kbhit();
        ch = readch();
	if(ch==0x1b){
            kbhit();
            ch = readch();
	    if(ch==0x5b){
        	kbhit();
            	ch = readch();
	       if(ch==0x41){
        	   if(gcdata->back) gcdata=gcdata->back;
		   print1(flnow);
	       }
	       if(ch==0x42){
        	   if(gcdata->next) gcdata=gcdata->next;
		   print1(flnow);
	       }
	       if(ch==0x43){
		   print1(flnow);
	       }
	       if(ch==0x44){
		   print1(flnow);
	       }
	       if(ch==0x31){
        	   kbhit();
            	   ch = readch();
	           if(ch==0x3b){
        	      kbhit();
            	      ch = readch();
	     	      if(ch==0x32){
	       		 kbhit();
            		 ch = readch();
	     		 if(ch==0x41){
			    info=gcdata;
			    im=0;
			    while(info && im<20){
				im++;
				if(info->back) info=info->back;
			    }
			    flnow=gcdata=info;
			    print1(flnow);
			 }
	     		 if(ch==0x42){
			    info=gcdata;
			    im=0;
			    while(info && im<20){
				im++;
				if(info->next) info=info->next;
			    }
			    flnow=gcdata=info;
			    print1(flnow);
			 }
		      }
	     	      if(ch==0x35){
	       		 kbhit();
            		 ch = readch();
	     		 if(ch==0x41){
			     flnow=gcdata=startm1;
			     print1(flnow);
			 }
	     		 if(ch==0x42){
			     flnow=gcdata=endc1;
			     print1(flnow);
			 }
		      }
		   }
	           if(ch==0x35){
        	      kbhit();
            	      ch = readch();
	     	      if(ch==0x7e){
                          info=startm1;
			  while(info){
				info->tate=0;
				info->yoko=0;
				strcpy(info->msg,"");
				strcpy(info->comm,"");
				/* cls(); */
				info=info->next;
			  }
			  print1(flnow);
 		      }
		   }
		}
	    }
	}
	else if(ch==0x0a){
            /*printf("\33[31m");*/
            pedit(gcdata);
            hitanykey();
            print1(flnow);
            ch=0;
        }
	else if(ch=='e'){
            bedit(gcdata->filename);
	    gcdata->tate=0;
	    gcdata->yoko=0;
	    strcpy(gcdata->msg,"");
	    strcpy(gcdata->comm,"");
 	    print1(flnow);
        }
 	else if(ch=='c'){
            ch=newfile();
        }
	else if(ch=='l'){
	   printhelp2();
 	   ch=0;
	}
        /*
	else if(ch=='b'){
	    sprintf(ttt,"gedit %s",gcdata->filename);
	    system(ttt);
        }
        */
	else if(ch=='K'){
            for(i=1;i<=100;i++){
	       sprintf(tt6,"%s.%d",gcdata->file1,i);
               remove(tt6);
/*
               if((fp=fopen(tt6,"r"))!=NULL){
	          sprintf(ttt,"rm %s.%d",gcdata->file1,i);
	          system(ttt);
               }
               else goto tes1;
               fclose(fp);
tes1:i=i;
*/
             }
        }
/* 
	else if(ch=='x'){
	   xl=0;
	   strcpy(tt3,"");
           locate(20,0);
	   printf("\33[0K\33[32mＦキーで検索:%s\n",tt3);
	   while(ch!=0x0a && ch!=0x1b){
	        kbhit();
        	ch = readch();
		if(ch==0x7f){
		   if(xl>0) xl--;
		   tt3[xl]=' ';
		   tt3[xl]='\0';
		   locate(20,0);
	           printf("\33[0K\33[32mＦキーで検索:\33[47m%s\33[0m\n",tt3);
		}
		else if(ch==0x1b){
		   locate(20,0);
	           printf("\33[0K\33[32mＦキーで検索:%sを中止します\n",tt3);
		}
 		else{
		   tt3[xl]=ch;
		   tt3[xl+1]='\0';
		   if(xl<100) xl++;
		   locate(20,0);
	           printf("\33[0K\33[32mＦキーで検索:\33[47m%s\33[0m\n",tt3);
		}
	   }
	   if(ch==0x0a){
		 system(tt3);
 		 hitanykey();
	   }	   
	   ch=0;
	   strcpy(tt3,"");
           print1(flnow);
         }
*/
	else if(ch=='f'){
	   xl=0;
	   strcpy(tt3,"");
           locate(20,0);
	   printf("\33[0K\33[32m検索のコマンド:%s\n",tt3);
	   info=startm1;
           while(info){
		print2(info);		
		info=info->next;
	   }

	   while(ch!=0x0a && ch!=0x1b){
	        kbhit();
        	ch = readch();
		if(ch==0x7f){
		   if(xl>0) xl--;
		   tt3[xl]=' ';
		   tt3[xl]='\0';
		   locate(20,0);
	           printf("\33[0K\33[32m検索のコマンド:\33[47m%s\33[0m\n",tt3);
		}
		else if(ch==0x1b){
		   locate(20,0);
	           printf("\33[0K\33[32m検索のコマンド:%sを中止します\n",tt3);
		}
		else if(ch==0x0a){}
 		else{
		   tt3[xl]=ch;
		   tt3[xl+1]='\0';
		   if(xl<100) xl++;
		   locate(20,0);
	           printf("\33[0K\33[32m検索のコマンド:\33[47m%s\33[0m\n",tt3);
		}
	   }
	   if(ch==0x0a){
		if(strcmp(tt3,"")==0) strcpy(tt3,tt5);
		else strcpy(tt5,tt3);
		 search(startm1,tt3,0);
	   }	   
	   ch=0;
	   /*strcpy(tt3,"");
           print1(flnow);
	   if(ch==0x1b) print1(flnow);*/
        }
	else if(ch=='g'){
		if(gcdata->next) gcdata=gcdata->next;
		 search(gcdata,tt3,0);
        }
	else if(ch=='h'){
		if(gcdata->back) gcdata=gcdata->back;
		 search(gcdata,tt3,1);
        }
    }

   printf("\33[0m");
   if(normal!=-1) cls();
   close_keyboard();
}

void hitanykey(){
   int ch;
   printf("何かキーを押してください\n");
   kbhit();
   ch=readch();
   while(ch==0){
     kbhit();
     ch=readch();
   }
}

int search(struct node *from,char tta[AMAX],int aa){
   struct node *info;
   int i;

   info=from;
   i=-1;
   while(info){
      i=position2(info->filename,tt3);
      if(i>=0) break;
      i=position2(info->msg,tt3);
	/* printf("%d;%s \n",i,info->msg);*/
      if(i>=0) break;
      if(aa==1) info=info->back;
      else      info=info->next;
   }
/*printf("%d \n",i);
   hitanykey();*/
   if(info==NULL){
      locate(0,TB+2); printf("検索文字列は見つかりませんでした\n");
      locate(0,TB+1); printf("\n");
      return 0;
   }
   else{
      gcdata=info;
      if(info->back) info=info->back;
      if(info->back) info=info->back;
      flnow=info;
      print1(flnow);
           locate(20,0);
	   printf("\33[0K\33[32m検索のコマンド:%s\n",tt3);
   }
   return 0;
}
int position2(char *text,char *pattern)
{
   int m,n,i;
   char *p;

   m=strlen(text);
   n=strlen(pattern);
   i=0;
   for(p=text;p<=text+m-n;p++){
      if(strncmp(p,pattern,n)==0) return i;
      i++;
   }
   return -1;
}

int position(char text[AMAX],char pattern[AMAX])
{
	int i, j, k, len,n;
	static int skip[AMAX+1];
	char c, tail;

/*printf("%s :%s :",text,pattern);*/
	len = strlen(pattern);  /* 文字列の長さ */
printf("%s :%s :%d :\n",text,pattern,len);

	if (len == 0) return -1;        /* エラー: 長さ0 */
	tail = pattern[len - 1];        /* 最後の文字 */
	if (len == 1) {                 /* 長さ1なら簡単! */
		for (i = 0; text[i] != '\0'; i++)
			if (text[i] == tail) return i;
	} else {                        /* 長さ2以上なら表を作って… */
		for (i = 0; i <= AMAX; i++) skip[i] = len;
		for (i = 0; i < len - 1; i++)
			skip[pattern[i]] = len - 1 - i;
		i = len - 1;          /* いよいよ照合 */
		n=strlen(text);
		while (i<n) {
			c=text[i];
                        /*  デモンストレーション用*/
			printf("テ: %s\n", text);
			printf("照: %*s\n", i + 1, pattern);
	hitanykey();

			if (c == tail) {
				j = len - 1;  k = i;
				while (pattern[--j] == text[--k])
					if (j == 0) return k;  /* 見つかった */
			}
			i += skip[c];
		}
	}
	return -1;  /* 見つからなかった */
}


void bedit(char *ppp){
   int im,endflg=1,i,j;
   char ch=0,str11[AMAX],yt1;
   char fname[40]="",*arx,arg[40]="",tx[40]=".sok",fold[40];
   char gt1,gt2,gt3;
   long num1,Tnum,Ynum,Tcnt,Ycnt,mlen2;
   struct nodef *Tnodef,*Ynodef,*inf2f,*inf3f;
   int p;
   FILE *fp;


   cls();locate(0,0);
   strcpy(str11,"");
   fp=fopen(ppp,"r");
   if(fp==NULL){
      printf("cannot open file %s \n",ppp);
      exit(1);
   }
   pos=0;gyo=0;
   gcdataf=startf=gc2f=nodef_create();
   while( (p=getc(fp)) != EOF){
      if(p=='\n'){
         gcdataf->text[pos]='\0';
         gcdataf->gyo    =++gyo;
	 gcdataf->len=pos;
         gcdataf->next     =nodef_create();
         gcdataf           =gcdataf->next;
	 gcdataf->back=gc2f;
	 gc2f=gc2f->next;
         pos=0;
      }
      else{
         if(pos>=AMAX) break;
         gcdataf->text[pos++]=p;
      }
   }
   fclose(fp);
   gcdataf->text[pos]='\0';
   gcdataf=gcdataf->back;
   gcdataf->next=NULL;
   lastf=gcdataf;

   flnowf=floldf=gcdataf=startf;

   mlen=0;
   printb(flnowf);

   while(endflg) {
        flnowf=gcdataf;
        kbhit();
        ch = readch();
	/*printf("%c\n",ch);*/
           locate(0,TB+2); printf("                          ");
           locate(0,TB+1);  printf("\33[0m\n");

	if(ch==0x16||ch==0x0a){
	   
           locate(0,TB+2); printf("とりあえずセーブします");
           locate(0,TB+1);  printf("\33[0m\n");
 	   ch=0;
	   fp=fopen(ppp,"w");
	   if(fp==NULL){
	      printf("cannot open file %s \n",ppp);
	      exit(1);
	   }
	   infof=startf;
	   while(infof){
		fprintf(fp,"%s\n",infof->text);
	       infof=infof->next;
	   }
	   fclose(fp);
	}
	else if(ch==0x18){
	   endflg=0;
 	   ch=0;
	   fp=fopen(ppp,"w");
	   if(fp==NULL){
	      printf("cannot open file %s \n",ppp);
	      exit(1);
	   }
	   gcdataf=startf;
	   while(gcdataf){
		fprintf(fp,"%s\n",gcdataf->text);
	       gcdataf=gcdataf->next;
	   }
	   fclose(fp);
	}
	else if(ch<0){
	   ins1(ch);
           kbhit();
           ch = readch();
    	   ins1(ch);
     	   kbhit();
   	   ch = readch();
    	   ins1(ch);
	   ch=0;
           printb(flnowf);
 	}
	else if(ch==0x08){
	   printhelp();
 	   ch=0;
	}
 	else if(ch==0x09){/*ENTERやめて、CTRL+Iで行挿入*/
	   infof=nodef_create();
	   if(gcdataf!=lastf){
		gc2f=gcdataf->next;
		gcdataf->next=infof;
		infof->next=gc2f;
		gc2f->back=infof;
		infof->back=gcdataf;
		gcdataf=infof;
		mlen=gcdataf->len;
		infof=startf;
		gyo=1;
		while(infof){
		   infof->gyo=gyo;
		   infof=infof->next; gyo++;
		}
		printb(flnowf);
	   }
	   else{
		gcdataf->next=infof;
		infof->back=gcdataf;
		gcdataf=lastf=infof;

		mlen=gcdataf->len;
		infof=startf;
		gyo=1;
		while(infof){
		   infof->gyo=gyo;
		   infof=infof->next; gyo++;
		}
		printb(flnowf);
	   }
 	   ch=0;
	}
	else if(ch==0x04){
	   if(gcdataf==startf){
		if(gcdataf->next){
		   startf=gcdataf->next;
		}
		free(gcdataf);
		gcdataf=startf;
		gcdataf->back=NULL;
		mlen=gcdataf->len;
		infof=startf;
		gyo=1;
		while(infof){
		   infof->gyo=gyo;
		   infof=infof->next; gyo++;
		}
		printb(flnowf);
	   }
	   else if(gcdataf==lastf){
		if(gcdataf->back){
		   lastf=gcdataf->back;
		}
		free(gcdataf);
		gcdataf=lastf;
		gcdataf->next=NULL;
		mlen=gcdataf->len;
		infof=startf;
		gyo=1;
		while(infof){
		   infof->gyo=gyo;
		   infof=infof->next; gyo++;
		}
		printb(flnowf);
	   }
	   else{
		gc2f=gcdataf->next;
		infof=gcdataf->back;
		free(gcdataf);
		infof->next=gc2f;
		gc2f->back=infof;
		gcdataf=infof;
		mlen=gcdataf->len;
		infof=startf;
		gyo=1;
		while(infof){
		   infof->gyo=gyo;
		   infof=infof->next; gyo++;
		}
		printb(flnowf);
	   }
 	   ch=0;
	}
	else if(ch==0x17){
	   endflg=0;
 	   ch=0;
	}
	else if(ch==0x0f){
	   gcdataf->text[2]=' ';
           gcdataf->text[3]='\0';
           gcdataf->len=3;
           mlen=3;
           printb(flnowf);
 	   ch=0;
	}
	else if(0x20<=ch && ch<=0x2f){
           if(ch==0x20) ins1(' ');
	   else        ins1(ch);
	   printb(flnowf);
	   ch=0;
	}
 	else if(0x30<=ch && ch<=0x3f){
	   uwa1(ch);
	   printb(flnowf);
	   ch=0;
	}
	else if(0x40<=ch && ch<=0x70){
	   uwa1(ch);
	   printb(flnowf);
	   ch=0;
	}
	else if(0x72<=ch && ch<0x7f){
	   uwa1(ch);
	   printb(flnowf);
	   ch=0;
	}
 	else if(ch==0x71){
	   endflg=0; 
 	   ch=0;
	}
	else if(ch==0x7f){
	   if(mlen>0) bs1();
	   printb(flnowf);
 	   ch=0;
	}
	else if(ch==0x1b){ /* 1 */
            kbhit();
            ch = readch();
 	    if(ch==0x5b){/* 2 */
               kbhit();
               ch = readch();
	       if(ch==0x33){/* 3 */
        	  kbhit();
            	  ch = readch();
	          if(ch==0x7e){/* 4 */
		     if(gcdataf->len>mlen) del1();
	  	     printb(flnowf);
		     ch=0;
		  }
	       }
	       if(ch==0x31){/* 3 */
        	  kbhit();
            	  ch = readch();
 	          if(ch==0x3b){/* 4 */
        	     kbhit();
            	     ch = readch();
	             if(ch==0x32){/* 5 */
        	        kbhit();
            	        ch = readch();
 		        if(ch==0x41){/* 1b 5b 31 3b 32 41 6 */
			   im=0;     /* SHIFT+↑ */
			   while(im<5){
			      if(gcdataf->back) gcdataf=gcdataf->back;
			      im++;
			   }
        		   flnowf=gcdataf;
                           if(gcdataf->len<mlen) mlen=gcdataf->len;
 			   printb(flnowf);
		        }
		        if(ch==0x42){/* 6 */
  
			   im=0;
			   while(im<5){
			      if(gcdataf->next) gcdataf=gcdataf->next;
			      im++;
                              
			   }
        		   flnowf=gcdataf;
                           if(gcdataf->len<mlen) mlen=gcdataf->len;
 			   printb(flnowf);
		        }
 		        if(ch==0x43){/* 6 */
			   mlen+=5;
        		   if(gcdataf->len<mlen) mlen=gcdataf->len;
			   printb(flnowf);
		        }
		        if(ch==0x44){/* 6 S+左*/
			   mlen-=5;
                           /*if(gcdataf->next) gcdataf=gcdataf->next;*/
                           
        		   if(0>mlen) mlen=0;
			   printb(flnowf);
		        }
			ch=0;
		     }
	             if(ch==0x35){/* 5 */
        	        kbhit();
            	        ch = readch();
 		        if(ch==0x41){/* 6 */
        		   gcdataf=flnowf=startf;
			   /*mlen=gcdataf->len;*/
                           if(gcdataf->len<mlen) mlen=gcdataf->len;
			   printb(flnowf);
		        }
		        if(ch==0x42){/* 6 */
 			   gcdataf=flnowf=lastf;
			   im=0;
			   while(im<6){/* 6 */
			      if(flnowf->back) flnowf=flnowf->back;
			      im++;
			   }
                           if(gcdataf->len<mlen) mlen=gcdataf->len;
			   /*mlen=gcdataf->len;*/
  			   printb(flnowf);
		        }
 		        if(ch==0x43){/* 6 */
        		   mlen=gcdataf->len;
			   printb(flnowf);
		        }
		        if(ch==0x44){/* 6 */
        		   mlen=0;
			   printb(flnowf);
		        }
			ch=0;
		     }
		  }
	       }
	       if(ch==0x41){/* 1b 5b 41 (3) */
        	   if(gcdataf->back) gcdataf=gcdataf->back;
		   /*mlen=gcdataf->len;*/
                   if(gcdataf->len<mlen) mlen=gcdataf->len;
		   printb(flnowf);
	       }
	       if(ch==0x42){/* 3 */
        	   if(gcdataf->next) gcdataf=gcdataf->next;
                   if(gcdataf->len<mlen) mlen=gcdataf->len;
		   /*mlen=gcdataf->len;*/
		   printb(flnowf);
	       }
	       if(ch==0x43){/* 3 */
        	   if(gcdataf->len>mlen) mlen++;
		   printb(flnowf);
	       }
	       if(ch==0x44){/* 3 */
        	   if(0<mlen) mlen--;
		   printb(flnowf);
	       }
		ch=0;
	   }
	   ch=0;
	}
	ch=0;
   }
   cls();
   printf("\33[0m");
}


 
void ins1(int c){
   int i,j;
   strcpy(text,gcdataf->text);
   j=gcdataf->len;
   for(i=0;i<mlen;i++) str1[i]=text[i];
   str1[mlen]=c;
   for(i=mlen;i<j;i++) str1[i+1]=text[i];
   str1[j+1]='\0';
   gcdataf->len=j+1;
   mlen++;
   strcpy(gcdataf->text,str1);
}
void uwa1(int c){
   int i,j;
   strcpy(text,gcdataf->text);
   j=gcdataf->len;
   for(i=0;i<mlen;i++) str1[i]=text[i];
   str1[mlen]=c;

   for(i=mlen+1;i<j;i++) str1[i]=text[i];
   str1[j]='\0';
   if(gcdataf->len>mlen) mlen++;
/*
   gcdataf->len=j+1;
   mlen++;
*/
   strcpy(gcdataf->text,str1);
}

void ins2(char *p){
   int i,j,k,m;
   strcpy(text,gcdataf->text);
   j=gcdataf->len;
   for(i=0;i<mlen;i++) str1[i]=text[i];
   while(*p!='\0'){
      str1[i++]=*p;
      p++;
   }
   m=i;
   for(k=mlen;k<j;k++) str1[i++]=text[k];
   str1[i]='\0';
   gcdataf->len=i;
   mlen=m;
   strcpy(gcdataf->text,str1);

}

void uwa2(char *p){
   int i,j,k,m;
   strcpy(text,gcdataf->text);
   j=gcdataf->len;
   for(i=0;i<mlen;i++) str1[i]=text[i];
   while(*p!='\0'){
      str1[i++]=*p;
      p++;
   }
   for(k=i;k<j;k++) str1[k]=text[k];
   str1[j]='\0';
   strcpy(gcdataf->text,str1);

}


void del1(){
   int i,j;
   strcpy(text,gcdataf->text);
   j=gcdataf->len;
   if(text[mlen]>0){
      for(i=0;i<=mlen;i++) str1[i]=text[i];
      for(i=mlen+1;i<j;i++) str1[i-1]=text[i];
      str1[i-1]='\0';
      gcdataf->len=j-1;
      /* mlen; */
   }
   else{
      for(i=0;i<=mlen;i++) str1[i]=text[i];
      for(i=mlen+3;i<j;i++) str1[i-3]=text[i];
      str1[i-3]='\0';
      gcdataf->len=j-3;
   }
   strcpy(gcdataf->text,str1);
}

void bs1(){
   int i,j;
   strcpy(text,gcdataf->text);
   j=gcdataf->len;
   if(text[mlen-1]>0){
      for(i=0;i<mlen;i++) str1[i]=text[i];
      for(i=mlen;i<j;i++) str1[i-1]=text[i];
      str1[i-1]='\0';
      gcdataf->len=j-1;
      mlen--;
   }
   else{
      for(i=0;i<mlen-2;i++) str1[i]=text[i];
      for(i=mlen;i<j;i++) str1[i-3]=text[i];
      str1[i-3]='\0';
      gcdataf->len=j-3;
      mlen-=3;
   }
   strcpy(gcdataf->text,str1);
}

void printhelp(){
   cls(); tc(0);
   locate(0,0); 
printf("ここはエディター部のヘルプ画面です\n");
 printf("CTRL+P　行ペースト　：※ この画面を終わらせるには方向キーを押すと終了\n");
 
}

void printhelp2(){
   cls(); tc(0);
   locate(0,0); 
printf("ここはランチャー部のヘルプ画面です\n\n");
 printf("・CTRL+Xでbmm終了 ※この画面を終了するには方向キーを押す\n");


}
void printhelp3(){
   cls(); tc(0);
   locate(0,0); 
printf("ここは中断ファイルのエディターのヘルプ画面です\n\n");
 printf("※ この画面を終わらせるには方向キーを押すと終了\n");


}
void printb(struct nodef *fromf){
   int im,jm,j,ja,jb,lm,exa,mm;
   char ttc,tts[5];
   struct nodef *testf,*test2f;

   cls();tc(0);
   locate(0,0); printf("CTRL+xで終了:[縦%d,横%d]",gcdataf->gyo,mlen+1);
   locate(0,1); printf("CTRL+hでhelp:");
      fromf=gcdataf;


      im=0;
      while(fromf&&im<4){
        if(fromf->back) fromf=fromf->back;
	im++;
      }

   im=0;
   while(fromf&&im<TA){
      strcpy(text,fromf->text);
      locate(0,im+2);
      if(fromf->gyo == gcdataf->gyo){ tc(TC47);}
      printf("\33[2K%04d:%03d:",fromf->gyo,fromf->len);
      ja=fromf->len;
      exa=0;
      ja=fromf->len;
      jb=0;mm=0;
      for(j=0;j<=ja;j++){
           if(fromf->gyo == gcdataf->gyo && j==mlen){ tc(41);}
           else if(fromf->gyo == gcdataf->gyo){ tc(TC47);}
	   else tc(0);
 	   if(jb>57){ jb=0; mm++; }
	   lm=jb;
	   ttc=text[j];
	   if(ttc<0 && ttc !=0xffffffd0 && ttc != 0xffffffd1 && ttc != 0xffffffc3){
	        tts[0]=text[j]; jb+=2;
		tts[1]=text[j+1];
	        tts[2]=text[j+2];
		tts[3]='\0';j=j+2;exa++;
	        locate(lm+9,im+2+mm); printf("%s ",tts);
           }
	   else if(ttc==0xffffffd0||ttc==0xffffffd1||ttc==0xffffffc3){
	        tts[0]=text[j]; jb+=2;
		tts[1]=text[j+1];
		tts[2]='\0';j=j+1;/*exa++;*/
	      locate(lm+9,im+2+mm); printf("%s ",tts);
           }
	   else if(ttc=='\0'){ jb++;
	      locate(lm+9,im+2+mm); printf("%c",0x20);
	   }
	   else{ jb++;
	      locate(lm+9,im+2+mm); printf("%c ",ttc);
	   }
      }
      locate(40,TA+2); printf("ファイル名：%s",gcdata->filename);
      locate(0,TA+1);  printf("\33[0m\n");
      fromf=fromf->next;
      im++;
      im=mm+im;
   }
}

void printp(char *ppp){
   int im,jm,ja,jb,jc,lm,exa,mm,i,j;
   char ttc,tts[5];
   struct nodef *testf,*test2f;

}

char newfile(){
   long lm;
   char sa[2]="A";
   char sb[AMAX],sc[AMAX],ss3[AMAX];
   FILE *fp,*fr;

   time(&t);
   tmp=localtime(&t);
   sprintf(sss,"%02d%02d%02d",-100+tmp->tm_year,tmp->tm_mon+1,tmp->tm_mday);

   strcpy(ss2,sss);
   strcat(ss2,sa);
   strcpy(sb,ss2);
   strcat(ss2,".np");

   /* locate(40,0); printf("%s\n",ss2); */
   
   fp=fopen(ss2,"r");
   while(fp!=NULL){
      strcpy(ss2,sss);
      if('A'<= sa[0] && sa[0]<'Z'){ sa[0]++; }
      else if(sa[0]=='Z'){sa[0]='a';}
      else if('a'<= sa[0] && sa[0]<'z'){ sa[0]++; }
      else{
         cls(); normal=-1;
         printf("ファイル名が今zまでいったので中止します\n");
         return 'q';
      }
      strcat(ss2,sa);
      strcpy(sb,ss2);
      strcat(ss2,".np");
      /* locate(40,0); printf("%s\n",ss2); */
   
      fp=fopen(ss2,"r");
   }
   nff=node_create();
   nfold->next=nff;
   nff->next=nfnow;
   nfnow->back=nff;
   nff->back=nfold;
   nfold=nff;
   /* nfnow=nfnow->next; */
   strcpy(nff->file1,sb);
   strcpy(nff->file2,"np");
   strcpy(nff->filename,ss2);
   sprintf(ttt,"cp %s %s",gcdata->filename,nff->filename);
   gcdata=nff;
   /*   locate(40,0); printf("%s\n",ttt); */
   system(ttt);
   lm=1;
   info=startm1;
   while(info){
      info->fileno=lm;
      info=info->next;
      lm++;
   }
   print1(flnow);
/*
   sprintf(ttt,"gedit %s",gcdata->filename);
   system(ttt);
*/
   /* locate(40,0); printf("%s\n",ttt); */
   return 0;
}

void file_open1(struct node *from){

   int i=0,j=0,k=0;
   int xx=0,y=0,mtype=0,uti=0,fhajime=0,uti4;
   int tt=0,yy=0,m=0,a,b;
   char msg[AMAX],comm[20];

   FILE *fpin;
   int c;

 
   fpin = fopen(from->filename,"r");
   if(fpin==0){
      printf("ファイル名が %s やて？　そんなのあらへんで\n\n",from->filename);
      exit(0);
   }
   c=fgetc(fpin);
   strcpy(comm,"");
   strcpy(msg,"");
   j=1;
   while(c != EOF){
      mtype=0;
      fhajime=0;
      y=0;
      m=0;
      k=1;
      i=0;
      while(c != '\n'){
         if(i==0){
            if(c == '*' ){
               c=fgetc(fpin);
               if(     c == 'T'){   mtype=1; uti=1;  i++;  }
               else if(c == 'Y'){   mtype=1; uti=2;  i++;  }
               else if(c == 'y'){   mtype=1; uti=4;  i++;  }
               else if(c == 'M'){   mtype=45;        i++;  }
               else if(c == 'm'){   mtype=45;        i++;  }
               else{
                  printf("何かおかしいんと、ちゃいまっか");
                  printf(" %d 行の２文字目が %c \n",j,c);
                  exit(0);
               }
            }
            else if(c == ';'){  mtype=99; i++;   }
            else if(c == '+'){  mtype=99; i++;   }
            else if(c == '#'){  mtype=99; i++;   }
            else if(c == ' '){  mtype=99; i++;   }
            else{
               printf("何かおかしいんと、ちゃいまっか");
               printf(" %d 行の１文字目が %c \n",j,c);
               exit(0);
            }
         }
         else{
            if(mtype==45){
               msg[m]=c;
               m++;msg[m]='\0';
               if(m>478){   goto F_CLOSE;}
            }
            if(c == ' ' && mtype==1 && fhajime==0){
               if(uti==1){ from->tate=xx; }
               if(uti==2){ from->yoko=xx; }
               if(uti==4){ uti4=xx; }
               fhajime=1;
            }
            if('0' <= c && c <= '9' && mtype==1){ 
               xx=c-'0'+y*10;
               y=xx;
            }
         }
         c=fgetc(fpin);
      }
      if(mtype==1 ){
         if(fhajime==0 ){
            if(uti==1){  from->tate=xx; }
            if(uti==2){  from->yoko=xx; }
         }
      }
      c=fgetc(fpin);
      j++;
   }
F_CLOSE:
   fclose(fpin);

   if(strcmp(msg ,"")==0) strcpy(from->msg,"特にメッセージはなし");
   else                   strncpy(from->msg,msg,60);
   if(strcmp(comm,"")==0){strcpy(from->comm,"特に");}
   else    strcpy(from->comm,comm);
}


void print3(struct node *from){
  
}

void print2(struct node *from){
   char fftime[AMAX];
   char ff2[30];
   FILE *fp;
   float tt;
 
   /*if(from->tate==0){ file_open1(from); }*/
   file_open1(from);

 
   if(strcmp(from->file2,"np")==0){
      strcpy(fftime,from->file1);
      strcat(fftime,"1.mt");
   }
  
   fp=fopen(fftime,"r");

   if(fp==NULL){
      from->ftime=0.0;
      return;      
   }
   else{
      fscanf(fp,"%f",&tt);
      from->ftime=tt;
   }
   fclose(fp);
 
  
}

void print1(struct node *from){
   int im;

   cls();tc(0);

   if(from->fileno-1>=gcdata->fileno){
      im=0;
      while(from&&im<TB){
        if(from->back) from=from->back;
        im++;
      }
      flnow=from;
   }
   if(from->fileno+TB<=gcdata->fileno){
      im=0;
      while(from&&im<TB){
        if(from->next) from=from->next;
        im++;
      }
      flnow=from;
   }

/*
  from=start;
  while(from->next) from->next;
  im=0;
  while(from&&im<TB){
     if(from->back) from=from->back;
     im++;
  }
  flnow=from;
*/
   locate(0,1); tc(0);
   printf(" 行番号:ファイル名 　メッセージ\n");

   im=0;
   while(from&&im<TB){
      print2(from);
      locate(0,im+2);
      if(from->fileno == gcdata->fileno){ tc(TC47);}
      else{ tc(0); }
      printf("\33[2K%04ld: %-8s.%s  %s\n",from->fileno,from->file1,from->file2,from->msg);
      from=from->next;
      im++;
   }
   tc(0);
   locate(0,0);
   sprintf(tt2,"%s %s\n",gcdata->comm,gcdata->filename);
   printf("\33[2K\33[31m%s",tt2);
   locate(20,0);
   printf("\33[0K\33[31mＦキーで検索:%s\n",tt3);
   locate(55,0); tc(0); printf("lキーでヘルプ\n");

}

int init(){
   int i,d_size;
   int fd,si,sj,ic,im;
   long lm;
   char buf[4096];
   time_t t;
   struct tm *tmp;

   if((fd=open(".",O_RDONLY))<0){
      perror("open");
      return 1;
   }
   ic=0;im=0;
   while((d_size=syscall(SYS_getdents,fd,(struct dirent *)&buf,sizeof buf))>0){
      for(i=0;i<d_size;i+=((struct dirent *)&buf[i])->d_reclen){
         strcpy(filename,((struct dirent *)&buf[i])->d_name);
         strcpy(file1,"");
         strcpy(file2,"");
         si=0;sj=0;
         while(filename[sj]!='\0' && filename[sj]!='.' && si<40){
            file1[si] = filename[sj];
            si++; 
	    sj++;
         }
         file1[si]='\0';
         si=0;
	 if(filename[sj]=='.')  sj++;
         while(filename[sj]!='\0' && filename[sj]!='.' && si<10){
            file2[si] = filename[sj];
            si++; sj++;
         }
         file2[si]='\0';
         if(strcmp(file2,"np")==0){
	    if(im==0){
		startm1=sttm1=gmdata=gm2=node_create();
                im++;
		strcpy(gmdata->filename,filename);
		strcpy(gmdata->file1,file1);
		strcpy(gmdata->file2,file2);
            }
            else{
	        gmdata->next=node_create();
         	gmdata=gmdata->next;
		gmdata->back=gm2;
		gm2=gm2->next;
		strcpy(gmdata->filename,filename);
		strcpy(gmdata->file1,file1);
		strcpy(gmdata->file2,file2);
	    }
 	 }
      }
   }
   if(!startm1) return -1; 
   info=startm1;
   last=NULL;
   while(info){
      startm1     =info->next;
      info->next=NULL;
      stt       =shojun(info);
      info      =startm1;
   }
   startm1=stt;
   endm1=last;


   time(&t);
   tmp=localtime(&t);
   sprintf(sss,"%02d%02d%02d",-100+tmp->tm_year,tmp->tm_mon+1,tmp->tm_mday+1);

   lm=1;
   info=startm1;
   while(info){
      info->fileno=lm;
      info=info->next;
      lm++;
   }

   info=startm1;
   while(strcmp(info->file1,sss)<0){
      info=info->next;
   }
   gcdata=nfnow=info;
   if(gcdata->back) gcdata=gcdata->back;
   nfold=gcdata;
   lm=0;
   while(info&&lm<TB){
      if(info->back) info=info->back;
      lm++;
   }
   flnow=info;
   info=flnow;
printf("1548\n");

 
   if(d_size<0){
      perror("getdents");
      return 1;
   }
   return 0;
}

struct node *node_create()
{
   struct node *from;
   int size;

   size=sizeof(struct node);

   from = (struct node*)malloc(size);
   if(!from){
      printf("out of memory ¥n");
      exit(0);
   }
   from->next=NULL;
   from->back=NULL;
   from->fileno=0;
   strcpy(from->filename,"");
   strcpy(from->file1,"");
   strcpy(from->file2,"");
   strcpy(from->msg,"");
   strcpy(from->comm,"");
   from->tate=0;
   from->yoko=0;
   from->ftime=0.0;
   return from;
}
 
struct nodef *nodef_create()
{
   struct nodef *from;
   int size;

   size=sizeof(struct nodef);

   from = (struct nodef*)malloc(size);
   if(!from){
      printf("out of memory ¥n");
      exit(0);
   }
   from->gyo=0;
   from->len=0;
   from->next=NULL;
   from->back=NULL;
   return from;
}


struct node *shojun(struct node *temp)
{
   struct node *old;
   struct node *now;

   now=stt;
   old=NULL;

   if(!last){
      temp->next=NULL;
      temp->back=NULL;
      last      =temp;
      return temp;
   }
   while(now){
      if(strcmp(now->file1,temp->file1) < 0){
         old=now;
         now=now->next;
      }
      else{
         if(old){
            old ->next=temp;
	    now->back=temp;
            temp->next=now;
	    temp->back=old;
            return stt;
         }
         else{
            temp->next=now;
	    now->back=temp;
	    temp->back=NULL;
            return temp;
         }
      }
   }
   last->next=temp;
   temp->back=last;
   temp->next=NULL;
   last      =temp;
   return stt;
}

void init_keyboard()
{
    tcgetattr(0, &initial_settings);
    new_settings = initial_settings;
    new_settings.c_lflag &= ~ICANON;
    new_settings.c_lflag &= ~ECHO;
    new_settings.c_lflag &= ~ISIG;
    new_settings.c_cc[VMIN] = 0;
    new_settings.c_cc[VTIME] = 0;
    tcsetattr(0, TCSANOW, &initial_settings);
}

void close_keyboard()
{
    tcsetattr(0, TCSANOW, &initial_settings);
}

int kbhit()
{
    char ch;
    int nread;

    if(peek_character != -1)
        return 1;
    new_settings.c_cc[VMIN]=0;
    tcsetattr(0, TCSANOW, &new_settings);
    nread = read(0, &ch, 1);
    new_settings.c_cc[VMIN]=1;
    tcsetattr(0, TCSANOW, &new_settings);

    if(nread == 1) {
        peek_character = ch;
        return 1;
    }
    return 0;
}


int readch()
{
    char ch;

    if(peek_character != -1) {
        ch = peek_character;
        peek_character = -1;
        return ch;
    }
    read(0, &ch, 1);
    return ch;
}   

void np1_load(file)
char *file;
{
   int i,j,k,n,sp;
   int x,y,xx,yy,mtype,uti;
   int line;
   char msg[80];
   FILE *fp;
   int c;

   locate(3,7);

   fp=fopen(file,"r");
   if(fp==0){
      printf("ファイル名は %s がありません",file);
      exit(0);
   }

   c=fgetc(fp);

   j=1;
   n=0;
   line=0;

   while(c != EOF){
      mtype=0;
      uti=0;
      y=0;
      k=1;
      sp=0;
      i=0;
      line++;
      while(c != '\n' && c != EOF){
         if(i==0){
            if(     c=='*'){ mtype=45; }
            else if(c=='M'){ mtype=45; }
            else if(c=='m'){ mtype=45; }
            else if(c==';'){ mtype=99; }
            else if(c==' '){ mtype=99; }
            else if(c=='#'){ mtype= 5; }
            else{
               printf("%d  %cエラー１３８",j,c);
               exit(0);
            }
            c=getc(fp);
            xx=0;
            if('0'<=c && c<='9'){
                xx=c-'0'+y*10;
                y=xx;
            }
            i++;
         }
         else{
            if(mtype==45){
               while(c != '\n'){
                  msg[i]=c;
                  if(i>77){
                     printf("エラー１５５");
                     exit(0);
                  }
                  c=getc(fp);
                  i++;
               }
               msg[0]=' ';
               msg[1]=' ';
               msg[i]='\0';
               locate(1,0);
               printf("メッセージ: %s",msg);
            }
            else if(mtype==99){
               while(c != '\n'){
                  c=getc(fp);
               }
            }
            else if(mtype==5){
               while(c != '\n'){
                  c=getc(fp);
                  if(c=='#' && i==1){ uti=1; }
                  if(c=='+' && i==1){ uti=2; }
                  if(c==' ' && i==1){ uti=3; n++;}
                  if('0'<=c && c<='9' && i==1){ uti=3; n++;}

                  if('0'<=c && c<='9'){
                     xx=c-'0'+y*10;
                     y=xx;
                  }
                  if(c==' '){
                     sp++;
                  }
                  if(uti==3 && i%3==2){
                     if(c=='#' || c=='+'){
                        if(sp==2) xx=0;
                        aa[n][k][QUES]=xx;
                        aa[n][k][ANS] =xx;
                        y=0; xx=0;
                        sp=0;
                        k++;
                        if(k-1>MAX){
                           printf("エラー１９４ %d 行",line);
                           exit(0);
                        }
                     }
                     else{
                        printf("エラー１９９ %d 行",line);
                        printf("エラー２００ %c ",c);
                        exit(0);
                     }
                  }
                  i++;
               }
            }
         }
      }
      c=getc(fp);
      j++;
      if(n-1>MAX){
         printf("エラー２１２ %d ： %d 行",n-1,line);
         exit(0);
      }
   }
FCLOSE:
   fclose(fp);


}

void houkoku()
{
   int i,j,k;

   char a1[50]="############################";
   char d1[50]="#  +  +  #  +  +  #  +  +  #";
   char e1[50]="#++++++++#++++++++#++++++++#";

   printf("\33[34m");
   locate(3, 2); printf("%s",a1);
   locate(3, 3); printf("%s",d1);
   locate(3, 4); printf("%s",d1);
   locate(3, 5); printf("%s",d1);
   locate(3, 6); printf("%s",a1);
   locate(3, 7); printf("%s",d1);
   locate(3, 8); printf("%s",d1);
   locate(3, 9); printf("%s",d1);
   locate(3,10); printf("%s",a1);
   locate(3,11); printf("%s",d1);
   locate(3,12); printf("%s",d1);
   locate(3,13); printf("%s",d1);
   locate(3,14); printf("%s",a1);

   lete=0;
   for(i=1; i<=MAX; i++){
      for(j=1; j<=MAX; j++){
         if(aa[j][i][OJI]!=0&&aa[j][i][OJI]!=25) lete++;
         locate(i*3+2,j+(j-1)/3+2);
/*
         if(aa[j][i][ANS]==0)   printf("\33[32m%d",aa[j][i][ANS]);
         else                   printf("\33[31m%d",aa[j][i][ANS]);
*/
         if(aa[j][i][OJI]==0)   printf("\33[32m%d",aa[j][i][OJI]);
         else if(aa[j][i][OJI]==25)   printf("\33[32m?");
         else                   printf("\33[31m%d",aa[j][i][OJI]);

         locate(i*3+2,j+(j-1)/3+2);
         k=aa[j][i][QUES];
         if(1<=k&&k<=9)         printf("\33[0m%d",aa[j][i][QUES]);

      }
   }
}

void pedit(struct node *from){

   FILE *fp;
   int si,i,j,k;
   unsigned char kaku[5]=".nq",arg[40],*arx;
   unsigned char test_np1[10]="test.nq";
   char ch=0;

   kt=0;
   eno=0;
   cls();

   strcpy(arg,from->filename);

   locate(42,2);
   printf("\33[32mファイルは : %s",arg);

   for(i=0;i<90;i++) cd[i]=0;
   shoki(QUES);
   np1_load(arg);

   locate(42,3);   printf("バージョン  ver. %s",VER);

   houkoku();
   /*ecopy(ANS,QUES);*/
   ecopy(MEM3,ANS);

   eflag=2;
   while(eflag == 2){
      eflag=0;
      echeck();

      locate(42,8);
      printf("\33[31m完成率は %d/%d",lete,MAX*MAX);
   }
   ecopy(OJI,ANS);
   ecopy(MEM ,ANS);
   ecopy(MEM2,ANS);

   if(lete == MAX*MAX) goto END1;


   pl=1;
   katei();

   while(pl>=2){
      eflag=2;
      houkoku();
      ecopy(ANS,MEM2);
      eset();
      while(eflag==2){
         eflag=0;
         fcheck();
         if(eno>=jogen){
            locate(42,10); printf("仮定法 %d 回目の為打ち切り\n",eno);
            goto END1;
         }
         /*
         kbhit();
         ch = readch();
         if(ch=='q') goto END1;
         */
      }
      ecopy(MEM2,ANS);
      if(pl>=2) katei();
   }

END1:

   /*kekka();*/
   houkoku();
   /* ecopy(ANS,OJI); */

   locate(42,8);
   printf("\33[31m完成率は %d/%d",lete,MAX*MAX);

   locate(42,6);
   if(lete == MAX*MAX)   printf("\33[31m完全燃焼ヴィv(^o^)v");
   else                  printf("\33[31m不完全燃焼(^_^ﾒ;) ﾅﾝﾃﾞﾔｰ");

   if(lete==MAX*MAX&&eno>=1){
      locate(42,10); printf("仮定法 %d 回目\n",eno);
   }
   if(eno>=jogen){
      locate(42,10); printf("仮定法 %d 回目の為打ち切り\n",eno);
   }
   locate(1,22);

}

void shoki(int sh){
   int i,j,k;

   for(i=1;i<=MAX;i++)
      for(j=1;j<=MAX;j++)
         for(k=1;k<=sh;k++)
             aa[i][j][k]=0;

}

void ecopy(int mm1,int mm2){
   int i,j;

   for(i=1;i<=MAX;i++){
      for(j=1;j<=MAX;j++){
         aa[j][i][mm1]=aa[j][i][mm2];
         if(aa[j][i][mm1]==25) aa[j][i][mm1]==0;
      }
   }
}

void echeck()
{
   int i,j,k,l,x1,x2,y1,y2,cc,k1,k2;

   for(i=1; i<=MAX; i++){
      for(j=1; j<=MAX; j++){
         k=aa[j][i][ANS];
         for(l=1; l<=MAX; l++){
            aa[j][l][k]=1;
            aa[l][i][k]=1;
         }
      }
   }

   for(i=0; i<MAX; i++){
      for(j=0; j<MAX; j++){
         x1=bb[i][j]/10;
         x2=bb[i][j]%10;
         k=aa[x1][x2][ANS];

         for(l=0; l<MAX; l++){
            y1=bb[i][l]/10;
            y2=bb[i][l]%10;
            aa[y1][y2][k]=1;
         }
      }
   }

   lete=0;
   for(i=1; i<=MAX; i++){
      for(j=1; j<=MAX; j++){
         if(aa[j][i][ANS]==0){

            cc=0;
            for(k=1; k<=MAX; k++){
               if(aa[j][i][k]==1) cc++;
            }
            aa[j][i][CH]=cc;
            if(cc==MAX-1){
               k=1;
               while(aa[j][i][k]==1 && k <=MAX){
                  k++;
               }
               aa[j][i][ANS]=k;
               eflag=2;

               locate(i*3+2,j+(j-1)/3+2);
               printf("\33[36m%d",aa[j][i][ANS]);

            }
         }

         if(aa[j][i][ANS] != 0){
            lete++;
         }
      }
   }
}

void fcheck()
{
   int i,j,k,l,x1,x2,y1,y2,cc,k1,k2;
   int ic,cdpp;

   fbf=0;
F1:
   if(pl<2)    return;
   if(fbf==1) return;
   /*locate(42,10); printf("1843 %d %d \n",pl,cd[pl]);*/

   fi= cd[pl]/100;
   fj=(cd[pl]/10)%10;
   fk= cd[pl]%10;

   aa[fj][fi][ANS]=fk;

   for(l=1;l<=MAX;l++){
      if(fk==aa[l][fi][ANS]&&aa[l][fi][ANS]!=0&&fj!=l){
         if(fk==9){
            fback();
            goto F1;
         }
         else{
            ecopy(ANS,MEM);
            eset();
            cd[pl]++;
            goto F1;
         }
      }
      if(fk==aa[fj][l][ANS]&&aa[fj][l][ANS]!=0&&fi!=l){
         if(fk==9){
            fback();
            goto F1;
         }
         else{
            ecopy(ANS,MEM);
            eset();
            cd[pl]++;
            goto F1;
         }
      }
   }
   for(i=0;i<MAX;i++){
      for(j=0;j<MAX;j++){
         cdpp=cd[pl]/10;
         if(bb[i][j]==cdpp) goto GETI;
      }
   }
GETI:
   for(l=0;l<MAX;l++){
      y2=bb[i][l]/10;
      y1=bb[i][l]%10;
      if(fk==aa[y1][y2][ANS]&&aa[y1][y2][ANS]!=0&&bb[i][l]!=cdpp){
         if(fk==9){
            fback();
            goto F1;
         }
         else{
            ecopy(ANS,MEM);
            eset();
            cd[pl]++;
            goto F1;
         }
      }
   }

   shoki(MAX);

   for(i=1; i<=MAX; i++){
      for(j=1; j<=MAX; j++){
         k=aa[j][i][ANS];
         for(l=1; l<=MAX; l++){
            aa[j][l][k]=1;
            aa[l][i][k]=1;
         }
      }
   }

   for(i=0; i<MAX; i++){
      for(j=0; j<MAX; j++){
         x2=bb[i][j]/10;
         x1=bb[i][j]%10;
         k=aa[x1][x2][ANS];

         for(l=0; l<MAX; l++){
            y2=bb[i][l]/10;
            y1=bb[i][l]%10;
            aa[y1][y2][k]=1;
         }
      }
   }

   lete=0;
   for(i=1; i<=MAX; i++){
      for(j=1; j<=MAX; j++){
         if(aa[j][i][ANS]==0){

            cc=0;
            for(k=1; k<=MAX; k++){
               if(aa[j][i][k]==1) cc++;
            }
            if(cc==MAX-1){
               k=1;
               while(aa[j][i][k]==1 && k <=MAX){
                  k++;
               }
               aa[j][i][ANS]=k;
               eflag=2;

               locate(i*3+2,j+(j-1)/3+2);
               printf("\33[36m%d",aa[j][i][ANS]);

            }
         }

         if(aa[j][i][ANS] != 0){
            lete++;
         }
      }
   }

   for(i=1;i<=MAX;i++){
      for(j=1;j<=MAX;j++){
         k=aa[j][i][ANS];
         for(l=1;l<=MAX;l++){
            if(k==aa[j][l][ANS]&&k!=0&&i!=l){
               if(fk==9){
                  fback();
                  goto F1;
               }
               else{
                  ecopy(ANS,MEM);
                  eset();
                  cd[pl]++;
                  goto F1;
               }
            }
            if(k==aa[l][i][ANS]&&k!=0&&j!=l){
               if(fk==9){
                  fback();
                  goto F1;
               }
               else{
                  ecopy(ANS,MEM);
                  eset();
                  cd[pl]++;
                  goto F1;
               }
            }
         }
      }
   }
   hflag=2;
   if(lete==MAX*MAX){
      eno++;
      onaji();

      locate(42,10); printf("仮定法 %d 回目\n",eno);
      if(eno>=jogen){
         locate(42,10); printf("仮定法 %d 回目の為打ち切り\n",eno);
         return;
      }

      k=cd[pl]%10;
      if(k==9) fback();
      else{
         ecopy(ANS,MEM);
         eset();
         cd[pl]++;
      }
   }
}

void fback(){
   int k;

   eflag=2;
   fbf=1;
   gback();
   
   if(pl<2) return;
   ecopy(ANS,MEM);
   eset();
}

void gback(){
   int k;

/*printf("2017 %d %d \n",pl,cd[pl]);*/

   cd[pl]=0;
   pl--;
   k=cd[pl]%10;
   if(k==9) gback();
   else     cd[pl]++;
}

void onaji(){
   int i,j;

   for(i=1;i<=MAX;i++){
      for(j=1;j<=MAX;j++){
         if(aa[j][i][OJI]==0) aa[j][i][OJI]=aa[j][i][ANS];
         else{
            if(aa[j][i][OJI]!=aa[j][i][ANS]) aa[j][i][OJI]=25;
         }
      }
   }
}

void eset(){
   for(q=2;q<=pl;q++){
      ei= cd[q]/100;
      ej=(cd[q]/10)%10;
      ek= cd[q]%10;
      aa[ej][ei][ANS]=ek;
   }
}

void katei(){
   int i,j,k;
   kt++;

   k=MAX-1;
   while(k>=0){
      for(i=1;i<=MAX;i++){
         for(j=1;j<=MAX;j++){
            /*if(aa[j][i][ANS]==0&&aa[j][i][CH]==k){*/
            if(aa[j][i][ANS]==0){
               pl++;
               cd[pl]=i*100+j*10+1;
locate(42,10); printf("2069 %d %d %d\n",kt,pl,cd[pl]);
               return;
            }
         }
      }
      k--;
   }
}

