/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.uifontchanger;

import groovy.lang.Closure;
import java.awt.Font;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import jp.sourceforge.users.yutang.omegat.plugin.uifontchanger.Config;
import org.omegat.core.Core;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.util.Log;
import org.omegat.util.StaticUtils;

public class UIFontChanger
implements IApplicationEventListener {
    private static UIFontChanger instance = null;
    private final String VERSION_STRING = "0.1.1";
    private final Config config;

    public UIFontChanger(Config config) throws IOException {
        this.config = config;
        Log.log((String)"UIFontChanger: 0.1.1");
    }

    public static void loadPlugins() {
        try {
            if (instance != null) {
                throw new RuntimeException("UIFontChanger plugin could be instantiated only once.");
            }
            instance = new UIFontChanger(new Config(Config.getConfigFile()));
            instance.initUIFont();
        }
        catch (Throwable ex) {
            String msg = ex.getMessage();
            Log.logErrorRB((String)"LD_ERROR", (Object[])new Object[]{msg});
            Core.pluginLoadingError((String)msg);
        }
    }

    public static void unloadPlugins() {
    }

    public void onApplicationStartup() {
    }

    public void onApplicationShutdown() {
    }

    private void initUIFont() {
        List<String> availableFonts = Arrays.asList(StaticUtils.getFontNames());
        UIDefaults defUI = UIManager.getDefaults();
        Object universalFont = this.config.get("*");
        for (Map.Entry e : defUI.entrySet()) {
            boolean fontAvalable;
            Object val;
            String key = e.getKey().toString();
            if (!key.toLowerCase().endsWith("font")) continue;
            Object oldVal = val = e.getValue();
            if (val instanceof UIDefaults.ActiveValue) {
                oldVal = ((UIDefaults.ActiveValue)val).createValue(defUI);
            }
            if (!(oldVal instanceof Font)) continue;
            Object newVal = this.config.get(key);
            if (newVal == null) {
                newVal = universalFont;
            }
            if (newVal == null) continue;
            if (newVal instanceof Closure) {
                newVal = ((Closure)newVal).call(new Object[]{(Font)oldVal, availableFonts});
            }
            if (!(fontAvalable = newVal instanceof Font ? availableFonts.contains(((Font)newVal).getName()) : availableFonts.contains((String)newVal))) continue;
            if (val instanceof UIDefaults.ActiveValue) {
                defUI.put(key, this.getActiveFont((Font)oldVal, newVal));
                continue;
            }
            if (!(val instanceof FontUIResource)) continue;
            defUI.put(key, this.getFontUIResource((Font)oldVal, newVal));
        }
    }

    private ActiveFont getActiveFont(Font fontOld, Object fontNew) {
        if (fontNew instanceof Font) {
            return ActiveFont.getInstance((Font)fontNew);
        }
        if (fontNew instanceof String) {
            return ActiveFont.getInstance((String)fontNew, fontOld.getStyle(), fontOld.getSize());
        }
        throw new IllegalArgumentException("fontNew argument must be Font type or String.");
    }

    private FontUIResource getFontUIResource(Font fontOld, Object fontNew) {
        if (fontNew instanceof Font) {
            return new FontUIResource((Font)fontNew);
        }
        if (fontNew instanceof String) {
            return new FontUIResource((String)fontNew, fontOld.getStyle(), fontOld.getSize());
        }
        throw new IllegalArgumentException("fontNew argument must be Font type or String.");
    }

    private static class ActiveFont
    implements UIDefaults.ActiveValue {
        private static final Map<FontArgs, ActiveFont> cache = new HashMap<FontArgs, ActiveFont>();
        private final String fontName;
        private final int fontStyle;
        private final int fontSize;

        public static ActiveFont getInstance(Font font) {
            return ActiveFont.getInstance(font.getFontName(), font.getStyle(), font.getSize());
        }

        public static ActiveFont getInstance(String fontName, int fontStyle, int fontSize) {
            FontArgs key = new FontArgs(fontName, fontStyle, fontSize);
            if (cache.containsKey(key)) {
                return cache.get(key);
            }
            ActiveFont activeFont = new ActiveFont(fontName, fontStyle, fontSize);
            cache.put(key, activeFont);
            return activeFont;
        }

        private ActiveFont(String fontName, int fontStyle, int fontSize) {
            this.fontName = fontName;
            this.fontStyle = fontStyle;
            this.fontSize = fontSize;
        }

        @Override
        public Object createValue(UIDefaults table) {
            return new FontUIResource(this.fontName, this.fontStyle, this.fontSize);
        }

        private static class FontArgs {
            private final String fontName;
            private final int fontStyle;
            private final int fontSize;

            public FontArgs(String fontName, int fontStyle, int fontSize) {
                this.fontName = fontName;
                this.fontStyle = fontStyle;
                this.fontSize = fontSize;
            }

            public int hashCode() {
                int hash = 7;
                hash = 11 * hash + (this.fontName != null ? this.fontName.hashCode() : 0);
                hash = 11 * hash + this.fontStyle;
                hash = 11 * hash + this.fontSize;
                return hash;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                FontArgs other = (FontArgs)obj;
                if (this.fontName == null ? other.fontName != null : !this.fontName.equals(other.fontName)) {
                    return false;
                }
                if (this.fontStyle != other.fontStyle) {
                    return false;
                }
                return this.fontSize == other.fontSize;
            }
        }
    }
}

