﻿using System;
using System.Diagnostics;
using System.IO;
using System.Runtime.InteropServices;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows;
using System.Windows.Documents;
using System.Windows.Media;

//TODO: テストコード追加

namespace JoinNotes
{
    abstract internal class Util
    {
        #region † http://tomoemon.hateblo.jp/entry/20080430/p2
        // 外部プロセスのメイン・ウィンドウを起動するためのWin32 API
        [DllImport("user32.dll")]
        private static extern bool SetForegroundWindow(IntPtr hWnd);

        [DllImport("user32.dll")]
        private static extern bool ShowWindowAsync(IntPtr hWnd, int nCmdShow);

        [DllImport("user32.dll")]
        private static extern bool IsIconic(IntPtr hWnd);

        [DllImport("user32.dll")]
        private static extern uint GetWindowThreadProcessId(IntPtr hWnd, ref uint procId);

        [DllImport("user32", EntryPoint = "EnumWindows")]
        private static extern int EnumWindows(EnumerateWindowsCallback lpEnumFunc, int lParam);

        [return: MarshalAs(UnmanagedType.Bool)]
        [DllImport("user32.dll", SetLastError = true)]
        public static extern bool PostMessage(HandleRef hWnd, uint Msg, IntPtr wParam, IntPtr lParam);

        [DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
        public static extern int GetWindowText(IntPtr hWnd, StringBuilder lpString, int nMaxCount);

        private static Process target_proc = null;
        private static IntPtr target_hwnd = IntPtr.Zero;

        private delegate int EnumerateWindowsCallback(IntPtr hWnd, int lParam);
        public static int EnumerateWindows(IntPtr hWnd, int lParam)
        {
            uint procId = 0;
            uint result = GetWindowThreadProcessId(hWnd, ref procId);

            var proc = Process.GetProcessById((int)procId);
            Debug.WriteLine(new { proc.Id, proc.MainWindowHandle, proc.MainWindowTitle }, "EnumerateWindows");

            var procWindowTitle = new StringBuilder(1024);
            GetWindowText(hWnd, procWindowTitle, procWindowTitle.Capacity);

            if (procId == target_proc.Id && procWindowTitle.ToString() == Application.NotifyContainerTitle)
            //if (proc.MainWindowTitle == App.mainWindow.Title)
            //if (procId == target_proc.Id)
            {
                // 同じIDで複数のウィンドウが見つかる場合がある
                // とりあえず最初のウィンドウが見つかった時点で終了する
                target_hwnd = hWnd;
                return 0;
            }

            // 列挙を継続するには0以外を返す必要がある
            return 1;
        }

        // 外部プロセスのウィンドウを最前面に表示する
        public static void WakeupWindow(Process target)
        {
            target_proc = target;
            EnumWindows(new EnumerateWindowsCallback(EnumerateWindows), 0);
            if (target_hwnd == IntPtr.Zero)
            {
                Debug.Fail("window not found");
                return;
            }

            var ret = PostMessage(new HandleRef(Application.mainWindow, target_hwnd), Application.WM_APP_ACTIVATEAPP, IntPtr.Zero, IntPtr.Zero);
            Debug.Assert(ret);
            //MessageBox.Show("PostMessage Handle: 0x" + target_hwnd.ToString("X") + ", Message: 0x" + Menu.WM_APP_ACTIVATEAPP.ToString("X"));
        }
        #endregion

        //public static Hyperlink FindHyperlinkFrom(TextElement from)
        //{
        //    if (from == null)
        //        return null;
        //    else if (from.Parent is Hyperlink)
        //        return (Hyperlink)from.Parent;
        //    else
        //        return FindHyperlinkFrom((TextElement)from.Parent);
        //}

        public static string ValidateFilename(string filename)
        {
            return Regex.Replace(filename, "[" + Regex.Escape(string.Join("", Path.GetInvalidFileNameChars())) + "]", "-", RegexOptions.Singleline);
        }

        //public static  IEnumerable<DependencyObject> GetVisualTreeChildrenByType(DependencyObject reference, Type type)
        //{
        //    var ret = new List<DependencyObject> { };

        //    var count = VisualTreeHelper.GetChildrenCount(reference);
        //    for (var childIndex = 0; childIndex < count; childIndex++)
        //    {
        //        var child = VisualTreeHelper.GetChild(reference, childIndex);
        //        if (child.GetType() == type)
        //            ret.Add(child);
        //        ret.AddRange(GetVisualTreeChildrenByType(child, type));
        //    }

        //    return ret;
        //}

        //public static  IEnumerable<DependencyObject> GetLogicalTreeChildrenByType(DependencyObject reference, Type type)
        //{
        //    var ret = new List<DependencyObject> { };

        //    var children = LogicalTreeHelper.GetChildren(reference);
        //    foreach (var child in children)
        //    {
        //        if (child is DependencyObject)
        //        {
        //            if (child.GetType() == type)
        //                ret.Add((DependencyObject)child);
        //            ret.AddRange(GetLogicalTreeChildrenByType((DependencyObject)child, type));
        //        }
        //    }

        //    return ret;
        //}

        public static string GetFileNameWithoutDocumentExtension(string path)
        {
            return Path.GetFileName(path).Replace(".join.rtf", "");
        }

        public static int GetIndexByTextPointer(TextPointer pointer, TextRange at)
        {
            Debug.Assert(pointer.IsInSameDocument(at.Start));

            // 変換元がTextPointerなので、at.Text[idx]のidxとして使える範囲より大きな値になることがある
            return Util.TextOf(new TextRange(at.Start, pointer)).Length;
        }

        /// <summary>
        /// TextRange.Textを使わずにテキスト化。
        /// </summary>
        public static string TextOf(TextRange range)
        {
            var text = new StringBuilder();
            // range.Endでの処理は含めない。End以降を扱ってしまうので。
            for (var pointer = range.Start; pointer != null && pointer.CompareTo(range.End) < 0; pointer = pointer.GetNextContextPosition(LogicalDirection.Forward))
            {
                if (pointer.GetPointerContext(LogicalDirection.Forward) == TextPointerContext.Text)
                {
                    var textInRun = pointer.GetTextInRun(LogicalDirection.Forward);
                    var textRunLength = pointer.GetTextRunLength(LogicalDirection.Forward);
                    if (range.End.CompareTo(pointer.GetPositionAtOffset(textRunLength)) <= 0)
                    {
                        text.Append(textInRun.Substring(0, pointer.GetOffsetToPosition(range.End)));
                        break;
                    }
                    else
                    {
                        text.Append(textInRun);
                    }
                }
            }

            return text.ToString();
        }

        public static TextRange ContentRangeOf(FlowDocument document)
        {
            Debug.Assert(document != null);
            return new TextRange(document.ContentStart, document.ContentEnd);
        }

        public static TextRange ContentRangeOf(TextElement element)
        {
            Debug.Assert(element != null);
            return new TextRange(element.ContentStart, element.ContentEnd);
        }

        public static TextRange ElementRangeOf(TextElement element)
        {
            Debug.Assert(element != null);
            return new TextRange(element.ElementStart, element.ElementEnd);
        }

        public static System.Windows.Forms.Keys InputModifierKeyToFormsKey(System.Windows.Input.ModifierKeys inputKey)
        {
            System.Windows.Forms.Keys ret = System.Windows.Forms.Keys.None;

            if (inputKey != System.Windows.Input.ModifierKeys.None)
            {
                //HACK: なぜかSystem.Windows.Input.ModifierKeysとSystem.Windows.Forms.Keysの対応が違うので、ここで変更。
                if (inputKey.HasFlag(System.Windows.Input.ModifierKeys.Alt)) ret |= System.Windows.Forms.Keys.Shift; // ModifierKeys.Alt -> Keys.Shift
                if (inputKey.HasFlag(System.Windows.Input.ModifierKeys.Control)) ret |= System.Windows.Forms.Keys.Control;
                if (inputKey.HasFlag(System.Windows.Input.ModifierKeys.Shift)) ret |= System.Windows.Forms.Keys.Alt;  // ModifierKeys.Shift -> Keys.Alt
                if (inputKey.HasFlag(System.Windows.Input.ModifierKeys.Windows))
                {
                    ret |= System.Windows.Forms.Keys.LWin;
                    ret |= System.Windows.Forms.Keys.RWin;
                }
            }

            Debug.WriteLine(inputKey.ToString() + " -> " + ret.ToString(), "InputModifierKeyToFormsKey");

            return ret;
        }

        public static System.Windows.Forms.Keys InputKeyToFormsKey(System.Windows.Input.Key inputKey)
        {
            System.Windows.Forms.Keys ret = System.Windows.Forms.Keys.None;

            try
            {
                // System.Windows.Input.Key http://msdn.microsoft.com/ja-jp/library/vstudio/system.windows.input.hotKey.aspx
                // System.Windows.Forms.Keys http://msdn.microsoft.com/ja-jp/library/vstudio/system.windows.forms.keys.aspx
                ret = (System.Windows.Forms.Keys)Enum.Parse(typeof(System.Windows.Forms.Keys), inputKey.ToString());
            }
            catch (ArgumentException ex)
            {
                Debug.WriteLine(ex.Message, ex.Source);
            }

            if (inputKey.ToString() != ret.ToString()) Debug.WriteLine(inputKey.ToString() + " -> " + ret.ToString(), "InputKeyToFormsKey");

            Debug.WriteLine(inputKey.ToString() + " -> " + ret.ToString(), "InputKeyToFormsKey");

            return ret;
        }

        //public static  bool Contain(TextRange range, TextPointer pointer)
        //{
        //    return range.Start.CompareTo(pointer) <= 0 && pointer.CompareTo(range.End) <= 0;
        //}

        #region GetTextPointerByIndex
        /// <param name="indexInDocument">（左側にある文字数で指定。例えばatに3文字しか含まれていなくても3を指定していい。）</param>
        /// <param name="at"></param>
        /// <param name="sideOfBound"></param>
        /// <returns></returns>
        public static TextPointer GetTextPointerByIndex(int indexInDocument, FlowDocument at, LogicalDirection sideOfBound)
        {
            Debug.Assert(0 <= indexInDocument && indexInDocument <= TextOf(new TextRange(at.ContentStart, at.ContentEnd)).Length);
            TextPointer ret = null;

            var loop = 0;

            // at.ContentEndでGetPointerContext(LogicalDirection.Forward)するのは範囲外を取得することになるので、ループ範囲にat.ContentEndを含めない。
            int lengthCount = 0;
            for (var pointer = at.ContentStart; pointer != null && pointer.CompareTo(at.ContentEnd) < 0; pointer = pointer.GetNextContextPosition(LogicalDirection.Forward))
            {
                if (pointer.GetPointerContext(LogicalDirection.Forward) == TextPointerContext.Text)
                {
                    Debug.Assert(pointer.GetPointerContext(LogicalDirection.Backward) == TextPointerContext.ElementStart && pointer.Parent is Run, "ElementStart - Text");
                    if ((lengthCount + pointer.GetTextRunLength(LogicalDirection.Forward) == indexInDocument && sideOfBound == LogicalDirection.Backward)
                        || lengthCount + pointer.GetTextRunLength(LogicalDirection.Forward) > indexInDocument)
                    {
                        ret = pointer.GetPositionAtOffset(indexInDocument - lengthCount);
                        break;
                    }

                    lengthCount += pointer.GetTextRunLength(LogicalDirection.Forward);
                }
                loop++;
            }

            Debug.Assert(ret == null || (at.ContentStart.CompareTo(ret) <= 0 && ret.CompareTo(at.ContentEnd) <= 0 && TextOf(new TextRange(at.ContentStart, ret)).Length == indexInDocument));
            return ret;
        }
        #endregion

        //TODO: 検証
        public static Size Ppi(Visual visual)
        {
            //†: http://social.msdn.microsoft.com/Forums/vstudio/en-US/61e93dca-e24c-4953-9719-22ce3f705353/finding-dpi-using-wpf
            var source = PresentationSource.FromVisual(visual);
            Debug.Assert(source is PresentationSource);
            var m = source.CompositionTarget.TransformToDevice;
            return new Size(m.M11 * 96.0, m.M22 * 96.0);
        }

        public static void p(string category)
        {
            Debug.WriteLine(category);
        }
        public static void p(object value)
        {
            Debug.WriteLine(value);
        }
        public static void p(object value, string category)
        {
            Debug.WriteLine(value, category);
        }

        public static void p(Exception ex)
        {
            Debug.WriteLine(ex.Message, ex.Source);
        }
    }
}
