// Lucas Lehmer test program
//
// g++ -o this this.cpp -std=c++11 -O2

#include <iostream>
#include <fstream>
#include <array>
#include <cstdio>
#include <ctime>

#define N 10000
#define A 2
#define B 250
#define TXT "luc40a.txt"
#define F(X) ((double)(clock()-X)/CLOCKS_PER_SEC)

/*
技術評論社　奥村晴彦　著
C言語による最新アルゴリズム事典　２３３０円＋税
P160〜161より引用・改変

A=始める数字
B=計算をここまでの数字までやる
TXT=実行結果を書き込むファイル名

AからBまでの素数のみリュカ・レーマー・テストをする
メルセンヌ素数は、2,3,5,7,13,17,19,31,61,89,107,127,
521,607,1279,2203,2281,3217,4253,4423,9689,9941,11213,
19937,21701,23209,44497,86243,110503,132049,216091


リュカ・レーマー・テストのアルゴリズムは

M(P)=2^P-1;　として、

x(1)=4;
x(i+1)=(x(i)^2-2) mod M(P)
x(P-1)=0　なら素数


*/

using namespace std;
typedef array<int,N> ary;

class Calc {
private:
	ary a,x;
	clock_t begin,begin2;
public:
	int Prime(int p);
	void Mainz(void);
};

int main()
{
	Calc pm;
	pm.Mainz();
	return 0;
}

void Calc::Mainz(void){
   int p,m,s,i;

   begin=clock();
   ofstream ofs(TXT,ios_base::app);

   ofs << "From A= " << A << " To B= " << B << endl;
   ofs << "File : " << TXT << endl;
   ofs << "CALC START:" << endl;
   ofs.close();

   for(m=A; m<=B; m++){
      s=m;
      i=2;
      while(i<=s){
         if(s<i*i){
            break;
         }
         else if(s%i==0){
            s/=i;
            i=2;
         }
         else{
            if(i==2) i++;
            else     i+=2;
         }
      }
      if(s==m){
         if(Prime(m)){
		   cout << "p=" << m << "はM素数である t=" << F(begin2) << " pt=" << F(begin) << endl;
		   ofstream ofs2(TXT,ios_base::app);
		   ofs2 << "p=" << m << "はM素数である t=" << F(begin2) << " pt=" << F(begin) << endl;
		   ofs2.close();
         }
         else {
 		cout << "p=" << m << "はM素数でない t=" << F(begin2) << " pt=" << F(begin) << endl;
	      }
      }
   }
   ofstream ofs3(TXT,ios_base::app);
   ofs3 << "CALC END:  t=" << F(begin2) << " pt=" << F(begin) << endl;
   ofs3.close();
}

 

int Calc::Prime(int p){
   int h,i,j,k,s;

   begin2=clock();
   for(i=0;i<p;i++) a[i]=0;
   a[2]=1;
   for(k=2;k<p;k++){
      for(i=0;i<p;i++){
         x[i]=a[i];
         a[i]=1;
      }
      a[1]=0;
      for(i=0;i<p;i++){
         if(x[i]){
            s=0;
            h=i;
            for(j=0;j<p;j++){
               s=(s>>1)+a[h]+x[j];
               a[h]=s&1;
               h=(h+1)%p;
            }
            if(s>1){
               while(a[h]){
                   a[h]=0;
                   h=(h+1)%p;
               }
               a[h]=1;
            }
         }
      }
   }
   a[p]=1-a[0];
   i=1;
   while(a[i]==a[0]) i++;
   return (i==p);
}
