/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2006-2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: upd72001.c 873 2008-04-11 10:32:26Z hiro $
 */

/*
 *		PD72001p ȈSIOhCo
 */

#include <sil.h>
#include "target_syssvc.h"
#include "upd72001.h"

/*
 *  foCXWX^̃ANZXԊuԁinsecPʁj
 *
 *  200Ƃlɂ܂荪͂ȂD
 */
#define	UPD72001_DELAY	200U

/*
 *  PD72001̃WX^̔ԍ
 */
#define	UPD72001_CR0	0x00U		/* Rg[WX^ */
#define	UPD72001_CR1	0x01U
#define	UPD72001_CR2	0x02U
#define	UPD72001_CR3	0x03U
#define	UPD72001_CR4	0x04U
#define	UPD72001_CR5	0x05U
#define	UPD72001_CR10	0x0aU
#define	UPD72001_CR12	0x0cU
#define	UPD72001_CR14	0x0eU
#define	UPD72001_CR15	0x0fU

#define	UPD72001_SR0	0x00U		/* Xe[^XWX^ */

/*
 *  Rg[WX^̐ݒl
 */
#define CR_RESET	0x18U		/* |[gZbgR}h */

#define CR0_EOI		0x38U		/* EOIiEnd of Interruptj*/

#define CR1_DOWN	0x00U		/* S݂֎~ */
#define CR1_RECV	0x10U		/* M݋rbg */
#define CR1_SEND	0x02U		/* M݋rbg */

#define CR3_DEF		0xc1U		/* f[^ 8bitCMCl[u */
#define CR4_DEF		0x44U		/* Xgbvrbg 1bitCpeBȂ */
#define CR5_DEF		0xeaU		/* f[^ 8bitCMCl[u */

#define CR10_DEF	0x00U		/* NRZ */
#define CR14_DEF	0x07U		/* {[[gWFl[^Cl[u */
#define CR15_DEF	0x56U		/* {[[gWFl[^gp */

#define SR0_RECV	0x01U		/* Mʒmrbg */
#define SR0_SEND	0x04U		/* M\rbg */

/*
 *  VAI/O|[gubN̒`
 */
typedef struct sio_port_initialization_block {
	void		*data;			/* f[^WX^̔Ԓn */
	void		*ctrl;			/* Rg[WX^̔Ԓn */

	uint8_t		cr3_def;		/* CR3̐ݒliMrbgj*/
	uint8_t		cr4_def;		/* CR4̐ݒliXgbvrbgCpeBj*/
	uint8_t		cr5_def;		/* CR5̐ݒliMrbgj*/
	uint8_t		brg1_def;		/* {[[gʂ̐ݒl */
	uint8_t		brg2_def;		/* {[[gʂ̐ݒl */
} SIOPINIB;

/*
 *  VAI/O|[gǗubN̒`
 */
struct sio_port_control_block {
	const SIOPINIB *p_siopinib;	/* VAI/O|[gubN */
	intptr_t	exinf;			/* g */
	bool_t		openflag;		/* I[vς݃tO */
	uint8_t		cr1;			/* CR1̐ݒli݋j*/
	bool_t		getready;		/* M */
	bool_t		putready;		/* 𑗐Mł */
};

/*
 *  VAI/O|[gubN
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {
	{ (void *) TADR_UPD72001_DATAA, (void *) TADR_UPD72001_CTRLA,
					CR3_DEF, CR4_DEF, CR5_DEF, BRG1_DEF, BRG2_DEF },
	{ (void *) TADR_UPD72001_DATAB, (void *) TADR_UPD72001_CTRLB,
					CR3_DEF, CR4_DEF, CR5_DEF, BRG1_DEF, BRG2_DEF }
};

/*
 *  VAI/O|[gǗubÑGA
 */
SIOPCB	siopcb_table[TNUM_SIOP];

/*
 *  VAI/O|[gIDǗubNo߂̃}N
 */
#define INDEX_SIOP(siopid)	((uint_t)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  foCXWX^ւ̃ANZX֐
 */
Inline uint8_t
upd72001_read_reg(void *addr)
{
	uint8_t	val;

	val = upd72001_reb_reg(addr);
	sil_dly_nse(UPD72001_DELAY);
	return(val);
}

Inline void
upd72001_write_reg(void *addr, uint8_t val)
{
	upd72001_wrb_reg(addr, val);
	sil_dly_nse(UPD72001_DELAY);
}

Inline uint8_t
upd72001_read_ctrl(void *addr, uint8_t reg)
{
	upd72001_write_reg(addr, reg);
	return(upd72001_read_reg(addr));
}

Inline void
upd72001_write_ctrl(void *addr, uint8_t reg, uint8_t val)
{
	upd72001_write_reg(addr, reg);
	upd72001_write_reg(addr, val);
}

Inline void
upd72001_write_brg(void *addr, uint8_t reg, uint8_t val,
									uint8_t brg2, uint8_t brg1)
{
	upd72001_write_reg(addr, reg);
	upd72001_write_reg(addr, val);
	upd72001_write_reg(addr, brg2);
	upd72001_write_reg(addr, brg1);
	(void) upd72001_read_reg(addr);		/* _~[[h */
}

/*
 *  Ԃ̓ǏoiSR0̓Ǐoj
 *
 *  PD72001́CԁiSR0jxǂނƎMʒmrbgĂ܂
 *  ߁CԂǂݏo֐݂CVAI/O|[gǗubN
 *  getreadyɎMʒmԁCputreadyɑM\ԂۑĂiM
 *  \Ԃ̕ۑ͕svȂjD
 *  ԃWX^ǂłMʒmrbgȂfoCXi炪
 *  ʂƎvjł́C̊֐͕KvȂD
 */
static void
upd72001_get_stat(SIOPCB *p_siopcb)
{
	uint8_t	sr0;

	sr0 = upd72001_read_ctrl(p_siopcb->p_siopinib->ctrl, UPD72001_SR0);
	if ((sr0 & SR0_RECV) != 0) {
		p_siopcb->getready = true;
	}
	if ((sr0 & SR0_SEND) != 0) {
		p_siopcb->putready = true;
	}
}

/*
 *  Mł邩H
 */
Inline bool_t
upd72001_getready(SIOPCB *p_siopcb)
{
	upd72001_get_stat(p_siopcb);
	return(p_siopcb->getready);
}

/*
 *  𑗐Mł邩H
 */
Inline bool_t
upd72001_putready(SIOPCB *p_siopcb)
{
	upd72001_get_stat(p_siopcb);
	return(p_siopcb->putready);
}

/*
 *  M̎o
 */
Inline char_t
upd72001_getchar(SIOPCB *p_siopcb)
{
	p_siopcb->getready = false;
	return((char_t) upd72001_read_reg(p_siopcb->p_siopinib->data));
}

/*
 *  M镶̏
 */
Inline void
upd72001_putchar(SIOPCB *p_siopcb, char_t c)
{
	p_siopcb->putready = false;
	upd72001_write_reg(p_siopcb->p_siopinib->data, (uint8_t) c);
}

/*
 *  EOIiEnd Of Interruptjs
 */
Inline void
upd72001_eoi(void)
{
	upd72001_write_ctrl((void *) TADR_UPD72001_CTRLA, UPD72001_CR0, CR0_EOI);
}

/*
 *  SIOhCȍ
 */
void
upd72001_initialize(void)
{
	SIOPCB	*p_siopcb;
	uint_t	i;

	/*
	 *  VAI/O|[gǗubN̏
	 */
	for (p_siopcb = siopcb_table, i = 0; i < TNUM_SIOP; p_siopcb++, i++) {
		p_siopcb->p_siopinib = &(siopinib_table[i]);
		p_siopcb->openflag = false;
	}
}

/*
 *  I[vĂ|[g邩H
 */
bool_t
upd72001_openflag(void)
{
	return(siopcb_table[0].openflag || siopcb_table[1].openflag);
}

/*
 *  VAI/O|[g̃I[v
 */
SIOPCB *
upd72001_opn_por(ID siopid, intptr_t exinf)
{
	SIOPCB		*p_siopcb;
	const SIOPINIB	*p_siopinib;

	p_siopcb = get_siopcb(siopid);
	p_siopinib = p_siopcb->p_siopinib;

	upd72001_write_reg(p_siopinib->ctrl, CR_RESET);
	if (!upd72001_openflag()) {
		upd72001_write_ctrl((void *) TADR_UPD72001_CTRLA, UPD72001_CR2, 0x18);
		upd72001_write_ctrl((void *) TADR_UPD72001_CTRLB, UPD72001_CR2, 0x00);
	}
	p_siopcb->cr1 = CR1_DOWN;
	upd72001_write_ctrl(p_siopinib->ctrl, UPD72001_CR1, p_siopcb->cr1);
	upd72001_write_ctrl(p_siopinib->ctrl, UPD72001_CR4, p_siopinib->cr4_def);
	upd72001_write_brg(p_siopinib->ctrl, UPD72001_CR12, 0x01U,
							p_siopinib->brg2_def, p_siopinib->brg1_def);
	upd72001_write_brg(p_siopinib->ctrl, UPD72001_CR12, 0x02U,
							p_siopinib->brg2_def, p_siopinib->brg1_def);
	upd72001_write_ctrl(p_siopinib->ctrl, UPD72001_CR15, CR15_DEF);
	upd72001_write_ctrl(p_siopinib->ctrl, UPD72001_CR14, CR14_DEF);
	upd72001_write_ctrl(p_siopinib->ctrl, UPD72001_CR10, CR10_DEF);
	upd72001_write_ctrl(p_siopinib->ctrl, UPD72001_CR3, p_siopinib->cr3_def);
	upd72001_write_ctrl(p_siopinib->ctrl, UPD72001_CR5, p_siopinib->cr5_def);
	p_siopcb->exinf = exinf;
	p_siopcb->getready = p_siopcb->putready = false;
	p_siopcb->openflag = true;
	return(p_siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
upd72001_cls_por(SIOPCB *p_siopcb)
{
	upd72001_write_ctrl(p_siopcb->p_siopinib->ctrl, UPD72001_CR1, CR1_DOWN);
	p_siopcb->openflag = false;
}

/*
 *  VAI/O|[gւ̕M
 */
bool_t
upd72001_snd_chr(SIOPCB *p_siopcb, char_t c)
{
	if (upd72001_putready(p_siopcb)) {
		upd72001_putchar(p_siopcb, c);
		return(true);
	}
	return(false);
}

/*
 *  VAI/O|[g̕M
 */
int_t
upd72001_rcv_chr(SIOPCB *p_siopcb)
{
	if (upd72001_getready(p_siopcb)) {
		return((int_t)(uint8_t) upd72001_getchar(p_siopcb));
	}
	return(-1);
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void
upd72001_ena_cbr(SIOPCB *p_siopcb, uint_t cbrtn)
{
	uint8_t	cr1_bit = 0;

	switch (cbrtn) {
	case SIO_RDY_SND:
		cr1_bit = CR1_SEND;
		break;
	case SIO_RDY_RCV:
		cr1_bit = CR1_RECV;
		break;
	}
	p_siopcb->cr1 |= cr1_bit;
	upd72001_write_ctrl(p_siopcb->p_siopinib->ctrl,
									UPD72001_CR1, p_siopcb->cr1);
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
upd72001_dis_cbr(SIOPCB *p_siopcb, uint_t cbrtn)
{
	uint8_t	cr1_bit = 0;

	switch (cbrtn) {
	case SIO_RDY_SND:
		cr1_bit = CR1_SEND;
		break;
	case SIO_RDY_RCV:
		cr1_bit = CR1_RECV;
		break;
	}
	p_siopcb->cr1 &= ~cr1_bit;
	upd72001_write_ctrl(p_siopcb->p_siopinib->ctrl,
									UPD72001_CR1, p_siopcb->cr1);
}

/*
 *  VAI/O|[gɑ΂銄ݏ
 */
static void
upd72001_isr_siop(SIOPCB *p_siopcb)
{
	if ((p_siopcb->cr1 & CR1_RECV) != 0U && upd72001_getready(p_siopcb)) {
		/*
		 *  MʒmR[obN[`ĂяoD
		 */
		upd72001_irdy_rcv(p_siopcb->exinf);
	}
	if ((p_siopcb->cr1 & CR1_SEND) != 0U && upd72001_putready(p_siopcb)) {
		/*
		 *  M\R[obN[`ĂяoD
		 */
		upd72001_irdy_snd(p_siopcb->exinf);
	}
}

/*
 *  SIO̊݃T[rX[`
 */
void
upd72001_isr(void)
{
	if (siopcb_table[0].openflag) {
		upd72001_isr_siop(&(siopcb_table[0]));
	}
	if (siopcb_table[1].openflag) {
		upd72001_isr_siop(&(siopcb_table[1]));
	}
	upd72001_eoi();
}
