/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2008 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́CFree Software Foundation ɂČ\Ă 
 *  GNU General Public License  Version 2 ɋLqĂC
 *  (1)`(4)̏𖞂ꍇɌC{\tgEFAi{\tgEF
 *  Aς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFAėp\ȃoCiR[hiP[^uIu
 *      WFNgt@C⃉CuȂǁǰ`ŗpꍇɂ́Cp
 *      ɔhLgip҃}jAȂǁjɁCL̒쌠\C
 *      ̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAėps\ȃoCiR[ȟ`܂͋@ɑg
 *      ݍ񂾌`ŗpꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) pɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) p̌`ԂCʂɒ߂@ɂāCL쌠҂ɕ񍐂
 *        ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂́C
 *  {\tgEFAɊւāC̓Kp\܂߂āCȂۏ؂s
 *  ȂD܂C{\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ
 *  Ȃ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	^[QbgVXeˑW[iRSK-M16C-62Ppj
 */

#include "kernel_impl.h"
#include <sil.h>
#include "RSK-M16C-62P.h"
#include "m16c/m16c_uart.h"

/*
 *  ^[QbgVXeˑ [`
 */

void
target_initialize(void)
{
	volatile char_t pd6;

#ifndef	USE_KD3083

	/* UART0gp */
	pd6 = sil_reb_mem((void *)TADR_SFR_PD6);
	pd6 |= 0x08;		/* TxD0 |[gP6_3 o͂ */
	pd6 &= ~0x04;		/* RxD0 |[gP6_2 ͂ */
	sil_wrb_mem((void *)TADR_SFR_PD6, pd6);

	m16c_uart_init(TARGET_PUTC_PORTID , UART_BAUDRATE , UART_CLKSRC);
#endif
}

/*
 *  ^[QbgVXȅI[`
 */

void
target_exit(void)
{
	/* CPUˑ̏I[` */
	prc_terminate();
	
  while (1);
}

void
target_fput_log(char_t c)
{
#ifndef	USE_KD3083
	if(c == '\n'){
	    m16c_uart_pol_putc('\r' , TARGET_PUTC_PORTID);
	}
    m16c_uart_pol_putc(c , TARGET_PUTC_PORTID);
#endif
}
