/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2008 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */

/*
 *		^[QbgˑW[iRSK-M16C-62Ppj
 *
 *  J[l̃^[Qbgˑ̃CN[ht@CDkernel_impl.h̃^[
 *  Qbgˑ̈ʒutƂȂD
 */

#ifndef TOPPERS_TARGET_CONFIG_H
#define TOPPERS_TARGET_CONFIG_H

/*
 *  ^[QbgVXẽn[hEFA̒`
 */
#include "RSK-M16C-62P.h"
#include "m16c_nc30/m16c62p_config.h"



/*
 *  ASPJ[l쎞̃}bvƊ֘A`
 *
 *	00400 - 07fff		RAM(31KB)
 *  0F000 - FFFF		ROM̈(ubNA)(4K)
 *	80000 - fffff		ROM̈i512KBj
 *	00000 -				f[^̈i3MBj
 *		  - 07fff		ftHg̔^XNReLXgp̃X^bN̈
 */

/*
 *  ftHg̔^XNReLXgp̃X^bN̈̒`
 */
#define DEFAULT_ISTKSZ		0x00400U
#define DEFAULT_ISTK		(void *)(0x8000 - DEFAULT_ISTKSZ)

/*
 *  ^[Qbgˑ̕o͂Ɏgp|[g̒`  
 */
#define TARGET_PUTC_PORTID	 1


#ifndef TOPPERS_MACRO_ONLY
/*
 *  ^[QbgVXeˑ̏
 */
extern void	target_initialize(void);

/*
 *  ^[QbgVXȅI
 *
 *  VXeI鎞ɎgD
 */
extern void	target_exit(void) NoReturn;

/*
 *  ^[QbgVXe̕o
 */
extern void	target_fput_log(char_t c);

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  vZbTˑW[iM16Cpj
 */
#include "m16c_nc30/prc_config.h"

/*
 *  g[XOɊւݒ
 */

#define TCNT_TRACE_BUFFER	(32)

#ifdef TOPPERS_ENABLE_TRACE
#include "logtrace/trace_config.h"
#endif /* TOPPERS_ENABLE_TRACE */

#endif /* TOPPERS_TARGET_CONFIG_H */
