/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2006-2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: perf1.c 818 2008-03-18 12:56:15Z hiro $
 */

/*
 *		J[l\]vO(1)
 *
 *  slp_tskCwup_tskɂ^XN؊Ԃv邽߂̃vOD
 */

#include <kernel.h>
#include <t_syslog.h>
#include <histogram.h>
#include "syssvc/logtask.h"
#include "kernel_cfg.h"
#include "perf1.h"

/*
 *  v񐔂ƎsԕzL^ő厞
 */
#define NO_MEASURE	10000U			/* v */
#define MAX_TIME	1000U			/* sԕzL^ő厞 */

/*
 *  sԕzL^郁̈
 */
static uint_t	histarea1[MAX_TIME + 1];
static uint_t	histarea2[MAX_TIME + 1];

/*
 *  v^XN1iDxj
 */
void task1(intptr_t exinf)
{
	uint_t	i;

	slp_tsk();
	end_measure(1);
	for (i = 1; i < NO_MEASURE; i++) {
		begin_measure(2);
		slp_tsk();
		end_measure(1);
	}
	begin_measure(2);
	slp_tsk();
}

/*
 *  v^XN2iDxj
 */
void task2(intptr_t exinf)
{
	uint_t	i;

	for (i = 0; i < NO_MEASURE; i++) {
		begin_measure(1);
		wup_tsk(TASK1);
		end_measure(2);
	}
	wup_tsk(TASK1);
}

/*
 *  C^XNiDxj
 */
void main_task(intptr_t exinf)
{
	syslog_0(LOG_NOTICE, "Performance evaluation program (1)");
	init_hist(1, MAX_TIME, histarea1);
	init_hist(2, MAX_TIME, histarea2);
	logtask_flush(0U);

	sus_tsk(LOGTASK);		/* VXeO^XN̓~߂ */
	act_tsk(TASK1);
	act_tsk(TASK2);
	rsm_tsk(LOGTASK);		/* VXeO^XN̓ĊJ */

	syslog_0(LOG_NOTICE, "Execution times of wup_tsk -> slp_tsk");
	print_hist(1);
	syslog_0(LOG_NOTICE, "Execution times of slp_tsk -> wup_tsk");
	print_hist(2);
	ext_ker();
}
