/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2007,2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: test_tex2.c 818 2008-03-18 12:56:15Z hiro $
 */

/* 
 *		^XNOɊւeXg(2)
 *
 * yeXg̖ړIz
 *
 *  ݃nhiA[nhjCPUOnh^XN
 *  O[`N鏈ԗIɃeXgD
 *
 * yeXgځz
 *
 *	(A) iras_tex̃G[o
 *		(A-1) Ώۃ^XNx~
 *		(A-2) Ώۃ^XÑ^XNO[``ĂȂ
 *	(B) ݃nhĂ΂ꂽiras_tex̐폈
 *		(B-1) Ώۃ^XNsԂ̃^XN^XNO
 *		(B-2) Ώۃ^XNsԂ̃^XNłȂ
 *		(B-3) Ώۃ^XNsԂ̃^XN^XNO֎~
 *	(C) CPUOnhĂ΂ꂽiras_tex̐폈
 *		(C-1) Ώۃ^XNsԂ̃^XN^XNO
 *		(C-2) Ώۃ^XNsԂ̃^XNłȂ
 *		(C-3) Ώۃ^XNsԂ̃^XN^XNO֎~
 *				 {Ȃi^[QbgˑɎłȂj
 *	(D) ݃nh̏oɂN
 *		(D-1) fBXpb`̃^XN^XNOŃ^XNOv
 *			  
 *	(E) CPUOnh̏oɂN
 *		(E-1) fBXpb`̃^XN^XNOŃ^XNOv
 *			  
 *	(F) sns_texŎsԂ̃^XNȂ
 *
 * ygp\[Xz
 *
 *	TASK1: C̃^XNDsԂ̃^XNɑ΂ă^XNOv
 *		   Ώۃ^XN
 *	TASK2: sԂłȂ^XNɑ΂ă^XNOvΏۃ^XN
 *	TASK3: ^XNO[``ĂȂ^XN
 *	TASK4: x~Ԃ̃^XN
 *	ALM1:  A[nh1
 *	ALM2:  A[nh2
 *	ALM3:  A[nh3
 *	CPUEXC1: CPUOnh
 *
 * yeXgV[PXz
 *
 *	== TASK1iDxF10j==
 *	1:	Ԃ̃`FbN
 *		ref_tex(TSK_SELF, &rtex)
 *	2:	sta_alm(ALM1, 1U)
 *		A[nh1̎s҂
 *	== ALM1 ==
 *	3:	Ԃ̃`FbN
 *		iras_tex(TASK3, 0x0001)		... (A-2)
 *		iras_tex(TASK4, 0x0001)		... (A-1)
 *		iras_tex(TASK2, 0x0001)		... (B-2)
 *		iras_tex(TASK1, 0x0001)		... (B-3)
 *		^[
 *	== TASK1ij==
 *	4:	ena_tex()
 *	== TASK1^XNO[`i1ځj==
 *	5:	Ԃ̃`FbN
 *	6:	dis_dsp() ... 4̏Ԃꂼω
 *		chg_ipm(TMAX_INTPRI)
 *		ena_tex()
 *		loc_cpu()
 *		^[
 *	== TASK1ij==
 *	7:	߂ĂԂ̃`FbN
 *		ref_tex(TSK_SELF, &rtex)
 *	8:	sta_alm(ALM2, 1U)
 *		A[nh2̎s҂
 *	== ALM2 ==
 *	9:	Ԃ̃`FbN
 *		iras_tex(TASK1, 0x0002)		... (B-1)
 *		^[					... (D-1)
 *	== TASK1^XNO[`i2ځj==
 *	10:	Ԃ̃`FbN
 *		^[
 *	== TASK1ij==
 *	11:	sus_tsk(TASK2)
 *		sus_tsk(TASK3)
 *		sus_tsk(LOGTASK)
 *	12:	sta_alm(ALM3, 10U)
 *	13:	dly_tsk(50U)
 *	== ALM3 ==
 *	14:	Ԃ̃`FbN
 *		msns_tex()܂ށn			... (F)
 *		iget_tid(&tskid)
 *		iras_tex(TASK1, 0x0004)		... (B-2)
 *		^[
 *	== TASK1^XNO[`i3ځj==
 *	15:	Ԃ̃`FbN
 *		^[
 *	== TASK1ij==
 *	16:	rsm_tsk(TASK2)
 *		rsm_tsk(TASK3)
 *		rsm_tsk(LOGTASK)
 *		dis_dsp()
 *	17:	RAISE_CPU_EXCEPTION
 *	== CPUEXC1 ==
 *	18:	Ԃ̃`FbN
 *		xsns_xpn(p_excinf)
 *		iras_tex(TASK3, 0x0010)		... (A-2)
 *		iras_tex(TASK4, 0x0010)		... (A-1)
 *		iras_tex(TASK2, 0x0010)		... (C-2)
 *		iras_tex(TASK1, 0x0010)		... (C-1)
 *		^[					... (E-1)
 *	== TASK1^XNO[`i4ځj==
 *	19:	Ԃ̃`FbN
 *	20:	ext_tsk()
 *	== TASK2iDxF10j==
 *	21:	Ԃ̃`FbN
 *	22:	ena_tex()
 *	== TASK2^XNO[` ==
 *	23:	Ԃ̃`FbN
 *		^[
 *	== TASK2ij==
 *	24:	sus_tsk(TASK3)
 *	25:	eXgI
 */

#include <kernel.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "test_lib.h"
#include "test_tex2.h"

volatile bool_t	alm1_flag = false;
volatile bool_t	alm2_flag = false;
volatile bool_t	alm3_flag = false;

void
tex_task1(TEXPTN texptn, intptr_t exinf)
{
	ER		ercd;

	switch (texptn) {
	case 0x0001:
		check_point(5);
		check_state(false, false, TIPM_ENAALL, false, false, true);

		/*
		 *  fBXpb`֎~CݗDx}XNύXC^XNOC
		 *  CPUbN
		 */
		check_point(6);
		ercd = dis_dsp();
		check_ercd(ercd, E_OK);
		ercd = chg_ipm(TMAX_INTPRI);
		check_ercd(ercd, E_OK);
		ercd = ena_tex();
		check_ercd(ercd, E_OK);
		ercd = loc_cpu();
		check_ercd(ercd, E_OK);
		check_state(false, true, TMAX_INTPRI, true, true, false);
		break;

	case 0x0002:
		check_point(10);
		check_state(false, false, TIPM_ENAALL, false, false, true);
		break;

	case 0x0004:
		check_point(15);
		check_state(false, false, TIPM_ENAALL, false, false, true);
		break;

	case 0x0010:
		check_point(19);
		check_state(false, false, TIPM_ENAALL, true, true, true);

		/*
		 *  ^XNI
		 */
		check_point(20);
		ercd = ext_tsk();
		check_point(0);
		break;

	default:
		check_point(0);
		break;
	}
}

void
task1(intptr_t exinf)
{
	ER		ercd;
	T_RTEX	rtex;

	/*
	 *  Ԃ̃`FbN
	 */
	check_point(1);
	check_state(false, false, TIPM_ENAALL, false, false, true);
	ercd = ref_tex(TSK_SELF, &rtex);
	check_ercd(ercd, E_OK);
	check_assert((rtex.texstat & TTEX_DIS) != 0);
	check_assert(rtex.pndptn == 0);

	/*
	 *  A[nh1̓Jn
	 */
	check_point(2);
	ercd = sta_alm(ALM1, 1U);
	check_ercd(ercd, E_OK);

	/*
	 *  A[nh1̎s҂
	 */
	while (!(alm1_flag));

	/*
	 *  ^XNO
	 */
	check_point(4);
	ercd = ena_tex();
	/* Ń^XNO[`삷 */
	check_ercd(ercd, E_OK);

	/*
	 *  ^XNÕ^[ɂ茳̏Ԃɖ߂Ă邱Ƃ
	 *  `FbN
	 */
	check_point(7);
	check_state(false, false, TIPM_ENAALL, false, false, false);
	ercd = ref_tex(TSK_SELF, &rtex);
	check_ercd(ercd, E_OK);
	check_assert((rtex.texstat & TTEX_ENA) != 0);
	check_assert(rtex.pndptn == 0);

	/*
	 *  A[nh2̓Jn
	 */
	check_point(8);
	ercd = sta_alm(ALM2, 1U);
	check_ercd(ercd, E_OK);

	/*
	 *  A[nh2̎s҂
	 */
	while (!(alm2_flag));

	/*
	 *  TASK2TASK3~߂D
	 */
	check_point(11);
	ercd = sus_tsk(TASK2);
	check_ercd(ercd, E_OK);
	ercd = sus_tsk(TASK3);
	check_ercd(ercd, E_OK);
	ercd = sus_tsk(LOGTASK);
	check_ercd(ercd, E_OK);

	/*
	 *  A[nh3̓Jn
	 */
	check_point(12);
	ercd = sta_alm(ALM3, 10U);
	check_ercd(ercd, E_OK);

	/*
	 *  sx
	 */
	check_point(13);
	ercd = dly_tsk(50U);
	/* A[nh3삷 */
	check_ercd(ercd, E_OK);

	/*
	 *  TASK2TASK3ĊJD
	 */
	check_point(16);
	ercd = rsm_tsk(TASK2);
	check_ercd(ercd, E_OK);
	ercd = rsm_tsk(TASK3);
	check_ercd(ercd, E_OK);
	ercd = rsm_tsk(LOGTASK);
	check_ercd(ercd, E_OK);

	/*
	 *  fBXpb`֎~
	 */
	ercd = dis_dsp();
	check_ercd(ercd, E_OK);

	/*
	 *  CPUO𔭐
	 */
	check_point(17);
	RAISE_CPU_EXCEPTION;

	check_point(0);
}

void
tex_task2(TEXPTN texptn, intptr_t exinf)
{
	switch (texptn) {
	case 0x0011:
		check_point(23);
		check_state(false, false, TIPM_ENAALL, false, false, true);
		break;

	default:
		check_point(0);
		break;
	}
}

void
task2(intptr_t exinf)
{
	ER		ercd;

	/*
	 *  Ԃ̃`FbN
	 */
	check_point(21);
	check_state(false, false, TIPM_ENAALL, false, false, true);

	/*
	 *  ^XNO
	 */
	check_point(22);
	ercd = ena_tex();
	/* Ń^XNO[`삷 */
	check_ercd(ercd, E_OK);

	/*
	 *  TASK3~߂D
	 */
	check_point(24);
	ercd = sus_tsk(TASK3);
	check_ercd(ercd, E_OK);

	/*
	 *  eXgI
	 */
	check_finish(25);
}

void
task3(intptr_t exinf)
{
	check_point(0);
}

void
task4(intptr_t exinf)
{
	check_point(0);
}

void
tex_task4(TEXPTN texptn, intptr_t exinf)
{
	check_point(0);
}

void
alarm1_handler(intptr_t exinf)
{
	ER		ercd;

	/*
	 *  Ԃ̃`FbN
	 */
	check_point(3);
	check_state_i(true, false, false, true, true);

	/*
	 *  iras_tex̃G[o
	 */
	ercd = iras_tex(TASK3, 0x0001);
	check_ercd(ercd, E_OBJ);
	ercd = iras_tex(TASK4, 0x0001);
	check_ercd(ercd, E_OBJ);

	/*
	 *  ^XNOv
	 */
	ercd = iras_tex(TASK2, 0x0001);
	check_ercd(ercd, E_OK);
	ercd = iras_tex(TASK1, 0x0001);
	check_ercd(ercd, E_OK);

	alm1_flag = true;
}

void
alarm2_handler(intptr_t exinf)
{
	ER		ercd;

	/*
	 *  Ԃ̃`FbN
	 */
	check_point(9);
	check_state_i(true, false, false, true, false);

	/*
	 *  ^XNOv
	 */
	ercd = iras_tex(TASK1, 0x0002);
	check_ercd(ercd, E_OK);

	alm2_flag = true;
}

void
alarm3_handler(intptr_t exinf)
{
	ER		ercd;
	ID		tskid;

	check_point(14);
	check_state_i(true, false, false, true, true);
	ercd = iget_tid(&tskid);
	check_ercd(ercd, E_OK);
	check_assert(tskid == TSK_NONE);

	/*
	 *  ^XNOv
	 */
	ercd = iras_tex(TASK1, 0x0004);
	check_ercd(ercd, E_OK);

	alm3_flag = true;
}

void
cpuexc_handler(void *p_excinf)
{
	ER		ercd;

	/*
	 *  Ԃ̃`FbN
	 */
	check_point(18);
	check_state_i(true, false, true, true, false);
	check_assert(xsns_xpn(p_excinf) == false);

	/*
	 *  iras_tex̃G[o
	 */
	ercd = iras_tex(TASK3, 0x0010);
	check_ercd(ercd, E_OBJ);
	ercd = iras_tex(TASK4, 0x0010);
	check_ercd(ercd, E_OBJ);

	/*
	 *  ^XNOv
	 */
	ercd = iras_tex(TASK2, 0x0010);
	check_ercd(ercd, E_OK);
	ercd = iras_tex(TASK1, 0x0010);
	check_ercd(ercd, E_OK);
}
