/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2003-2004 by Platform Development Center
 *                                          RICOH COMPANY,LTD. JAPAN
 *  Copyright (C) 2008-2010 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */

/*
 *		^C}hCoiFRK-RX62Npj
 */

#include "kernel_impl.h"
#include "time_event.h"
#include <sil.h>
#include "target_timer.h"

/*
 *  ^C}̏
 */
void
target_timer_initialize(intptr_t exinf)
{
	/*
	 * W[Xgbv@\̐ݒ(CMTASCI1)
	 */
	*SYSTEM_MSTPCRA_ADDR &= ~(SYSTEM_MSTPCRA_MSTPA15_BIT); /* CMT0 */

	/* 
	 * ^C}~ 
	 */
	*CMT_CMSTR0_ADDR &= ~CMT_CMSTR0_STR0_BIT;
	
	/*
 	 * JEgAbvɗpNbNݒ
	 * PCLK/32I
	 */
	*CMT0_CMCR_ADDR = CMT_PCLK_DIV_8;

	/* 
	 * RyA}b`^C}JE^ݒ
	 */
	*CMT0_CMCNT_ADDR = 0U;

	/* 
	 * RyA}b`^C}ݒ
	 */
	*CMT0_CMCOR_ADDR = CMCOR_PERIOD;

	/*
	 * RyA}b`^C}荞ݗvݒ背WX^iISELR28j
	 */
	*ICU_ISELR028_ADDR = ICU_ISEL_CPU;

	/*
	 *  ^C}JnO̊ݗvNA
	 */
	x_clear_int(INTNO_TIMER);

	/* 
	 * RyA}b`^C}荞݂
	 */
	*CMT0_CMCR_ADDR |= CMT0_CMCR_CMIE_BIT;
	
	/* 
	 * ^C}Jn
	 */
	*CMT_CMSTR0_ADDR |= CMT_CMSTR0_STR0_BIT;
}

/*
 *  ^C}̒~
 */
void
target_timer_terminate(intptr_t exinf)
{
	/* 
	 * ^C}~ 
	 */
	*CMT_CMSTR0_ADDR &= ~CMT_CMSTR0_STR0_BIT;
}

/*
 *  ^C}݃nh
 */
void target_timer_handler(void)
{
	i_begin_int(INTNO_TIMER);
	
	signal_time();				/* ^CeBbN̋ */
	
	i_end_int(INTNO_TIMER);
}
