/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2010 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEEρE
 *  ĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒쌠
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[X
 *      R[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎgp
 *      ł`ōĔzzꍇɂ́CĔzzɔhLgip҃}
 *      jAȂǁjɁCL̒쌠\C̗pщL̖
 *      ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎgp
 *      łȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNgɕ
 *        邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹Q
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD܂C
 *      {\tgEFÃ[U܂̓Gh[ÛȂ闝RɊ
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړIɑ΂
 *  K܂߂āCȂۏ؂sȂD܂C{\tgEFA̗p
 *  ɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC
 *  ȂD
 * 
 */

/*
 *		TOPPERS/ASPJ[lWwb_t@C
 *
 *  ̃wb_t@ĆCJ[l\vÕ\[Xt@C
 *  ŕKCN[hׂWwb_t@CłD
 *
 *  AZũ\[Xt@C炱̃t@CCN[h鎞
 *  ́CTOPPERS_MACRO_ONLY`ĂDɂC}N`ȊO
 *  悤ɂȂĂD
 */

#ifndef TOPPERS_KERNEL_IMPL_H
#define TOPPERS_KERNEL_IMPL_H

/*
 *  J[l̓ʖ̃l[
 */
#include "kernel_rename.h"

/*
 *  AvP[VƋʂ̃wb_t@C
 */
#include <kernel.h>

/*
 *  ^LXgs}N̒`
 */
#ifndef CAST
#define CAST(type, val)		((type)(val))
#endif /* CAST */

/*
 *  ^[Qbgˑ̒`
 */
#include "target_config.h"

/*
 *  ׂĂ̊֐RpC邽߂̒`
 */
#ifdef ALLFUNC
#include "allfunc.h"
#endif /* ALLFUNC */

/*
 *  rbgtB[hł̕^
 *
 *  8rbgȉ̃̕rbgtB[hŁClێꍇ
 *  ɗpׂf[^^DANSI Cł́CrbgtB[h̃f[^^ɂ
 *  intunsigned intȂ߁CftHg̒`unsigned
 *  intƂĂ邪C^[Qbgуc[ˑŁCunsigned char܂
 *  unsigned shortɒ`ǂꍇD
 */
#ifndef BIT_FIELD_UINT
#define BIT_FIELD_UINT		unsigned int
#endif /* BIT_FIELD_UINT */

/*
 *  rbgtB[hł̃u[^
 *
 *  1rbg̃rbgtB[hŁCu[lێꍇɗpׂ
 *  f[^^DftHgłBIT_FIELD_UINTƓɒ`Ă邪Cu[
 *  lێ邱Ƃ𖾎邽߂ɕʂ̖̂ƂĂD
 */
#ifndef BIT_FIELD_BOOL
#define BIT_FIELD_BOOL		BIT_FIELD_UINT
#endif /* BIT_FIELD_BOOL */

/*
 *  IuWFNgID̍ŏl̒`
 */
#define TMIN_TSKID		1		/* ^XNID̍ŏl */
#define TMIN_CYCID		1		/* nhID̍ŏl */
#define TMIN_ALMID		1		/* A[nhID̍ŏl */

/*
 *  Dx̒iK̒`
 */
#define TNUM_TPRI		(TMAX_TPRI - TMIN_TPRI + 1)
#define TNUM_INTPRI		(TMAX_INTPRI - TMIN_INTPRI + 1)

/*
 *  wb_t@CȂW[̊֐Eϐ̐錾
 */
#ifndef TOPPERS_MACRO_ONLY

/*
 *  eW[̏ikernel_cfg.cj
 */
extern void	initialize_object(void);

/*
 *  [`̎sikernel_cfg.cj
 */
extern void	call_inirtn(void);

/*
 *  I[`̎sikernel_cfg.cj
 */
extern void	call_terrtn(void);

/*
 *  ^XNReLXgp̃X^bN̈ikernel_cfg.cj
 */
extern const SIZE	istksz;		/* X^bN̈̃TCYiۂ߂lj */
extern STK_T *const	istk;		/* X^bN̈̐擪Ԓn */
#ifdef TOPPRES_ISTKPT
extern STK_T *const	istkpt;		/* X^bN|C^̏l */
#endif /* TOPPERS_ISTKPT */

/*
 *  J[lԃtOistartup.cj
 */
extern bool_t	kerflg;

/*
 *  J[l̋Nistartup.cj
 */
extern void	sta_ker(void);

/*
 *  J[l̏Iistartup.cj
 */
extern void	exit_kernel(void);

#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_KERNEL_IMPL_H */
