#!/bin/bash
set -ex
NEW_FONTNAME=Takao
ADD_VERSION=01
ADD_COPYRIGHT="Copyright (c) Takao Fonts Maintainers Team, 2010."
URL="https://launchpad.net/takao-fonts"
for in_ttf; do
    tmp_ttx=$(echo -n "$in_ttf" | sed -e 's/\..*$/.ttx/')
    new_ttx=$(echo -n "$in_ttf" | sed -e 's/ipa/'"$NEW_FONTNAME"'/' \
                                      -e 's/gp\./PGothic\./' -e 's/exg\./ExGothic\./' -e 's/g\./Gothic\./' \
                                      -e 's/mjm\./MjMincho\./' -e 's/mp\./PMincho\./' -e 's/exm\./ExMincho\./' -e 's/m\./Mincho\./' \
                                      -e 's/\..*$/.ttx/' )
    rm -fv "$tmp_ttx"
    ttx -t name -t post "$in_ttf"
    cp $tmp_ttx $new_ttx
    LANG=C perl -pi -e "
      s/\s*<namerecord nameID=\"13\" platformID=\"([0-9]+)\" platEncID=\"([0-9]+)\" langID=\"0x([0-9a-f]+)\">/    <namerecord nameID=\"11\" platformID=\"\$1\" platEncID=\"\$2\" langID=\"0x\$3\">
      $(echo -n $URL|sed -e 's/\//\\\//g')
    <\/namerecord>\n$&/g; # name
      s/Copyright.*/$&&#10;${ADD_COPYRIGHT}/; # name
      s/\bIPAex(?![()])/${NEW_FONTNAME}Ex/; # name
      s/\bIPAmj(?![()])/${NEW_FONTNAME}Mj/; # name
      s/\bIPA(?![()])/${NEW_FONTNAME}/; # name
      s/Version ([0-9\.]+)/Version \$1.$(echo -n $ADD_VERSION|sed -e 's/\./\\./g')/; # name
      s/value=\"-[0-9]+\"/value=\"-20\"/ if /<underlinePosition/; # post (see meguri-fonts-20090604/README)
    " "$new_ttx"
    ttx -m "$in_ttf" "$new_ttx"
    #rm -fv "$tmp_ttx" "$new_ttx"
done
