/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.DefaultDataBag;
import org.apache.pig.data.SelfSpillBag;
import org.apache.pig.data.SizeUtil;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POPartialAgg
extends PhysicalOperator {
    public static final String PROP_PARTAGG_MINREDUCTION = "pig.exec.mapPartAgg.minReduction";
    private static final Log log = LogFactory.getLog(POPartialAgg.class);
    private static final long serialVersionUID = 1L;
    private PhysicalPlan keyPlan;
    private ExpressionOperator keyLeaf;
    private List<PhysicalPlan> valuePlans;
    private List<ExpressionOperator> valueLeaves;
    private static final Result ERR_RESULT = new Result();
    private static final Result EOP_RESULT = new Result(3, null);
    private transient Object currentKey = null;
    private transient Map<Object, Tuple> aggMap;
    private transient Tuple valueTuple = null;
    private boolean isFinished = false;
    private transient Iterator<Tuple> mapDumpIterator;
    private transient int numToDump;
    private static final int MAX_SIZE_CURVAL_CACHE = 1024;
    private static final int NUM_RESRECS_TO_SAMPLE_SZ_ESTIMATE = 100;
    private static final int NUM_INPRECS_TO_SAMPLE_SZ_REDUCTION = 1000;
    private static final int DEFAULT_MIN_REDUCTION = 10;
    private boolean disableMapAgg = false;
    private int num_inp_recs;
    private boolean sizeReductionChecked = false;
    private transient int maxHashMapSize;
    private transient TupleFactory tupleFact;
    private transient SelfSpillBag.MemoryLimits memLimits;

    public POPartialAgg(OperatorKey k) {
        super(k);
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitPartialAgg(this);
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        Result inp;
        if (this.disableMapAgg) {
            if (this.mapDumpIterator != null) {
                return this.getNextResFromMap();
            }
            inp = this.processInput();
            if (this.disableMapAgg) {
                return inp;
            }
        }
        if (this.mapDumpIterator != null) {
            if (this.isFinished) {
                return this.getNextResFromMap();
            }
            if (this.numToDump > 0) {
                --this.numToDump;
                return this.getNextResFromMap();
            }
            this.mapDumpIterator = null;
        }
        if (this.isFinished) {
            return new Result(3, null);
        }
        while (true) {
            boolean keyChanged;
            inp = this.processInput();
            if (inp.returnStatus == 2) {
                return inp;
            }
            if (inp.returnStatus == 3) {
                if (this.parentPlan.endOfAllInput) {
                    this.isFinished = true;
                    this.logCapacityOfAggMap();
                    if (this.valueTuple == null) {
                        return EOP_RESULT;
                    }
                    Result output = this.getOutput();
                    this.aggMap.remove(this.currentKey);
                    this.mapDumpIterator = this.aggMap.values().iterator();
                    this.currentKey = null;
                    this.valueTuple = null;
                    return output;
                }
                return inp;
            }
            if (inp.returnStatus == 1) continue;
            if (!this.sizeReductionChecked) {
                this.checkSizeReduction();
                if (this.disableMapAgg) {
                    return inp;
                }
            }
            Tuple inpTuple = (Tuple)inp.result;
            this.keyPlan.attachInput(inpTuple);
            Result keyRes = this.getResult(this.keyLeaf);
            if (keyRes == ERR_RESULT) {
                return ERR_RESULT;
            }
            Object key = keyRes.result;
            this.keyPlan.detachInput();
            if (this.valueTuple == null) {
                this.init(key, inpTuple);
                continue;
            }
            boolean bl = keyChanged = this.currentKey != null && key == null || key != null && !key.equals(this.currentKey);
            if (!keyChanged) {
                this.addToCurrentValues(inpTuple);
                if (((DefaultDataBag)this.valueTuple.get(1)).size() < 1024L) continue;
                this.aggregateCurrentValues();
                continue;
            }
            Result output = this.getOutput();
            if (output.returnStatus != 0) {
                return ERR_RESULT;
            }
            this.currentKey = key;
            this.resetCurrentValues();
            this.addToCurrentValues(inpTuple);
            Tuple existingResult = this.aggMap.get(key);
            if (existingResult != null) {
                this.addToCurrentValues(existingResult);
            }
            if (this.memLimits.getNumObjectsSizeAdded() < 100L) {
                this.updateMaxMapSize(output.result);
            }
            if (this.aggMap.size() >= this.maxHashMapSize) {
                this.numToDump = this.maxHashMapSize / 10;
                this.mapDumpIterator = this.aggMap.values().iterator();
                return output;
            }
            this.addOutputToAggMap(output);
        }
    }

    private void updateMaxMapSize(Object result) {
        long size = SizeUtil.getMapEntrySize(this.currentKey, result);
        this.memLimits.addNewObjSize(size);
        this.maxHashMapSize = this.memLimits.getCacheLimit();
    }

    private void aggregateCurrentValues() throws ExecException {
        for (int i = 0; i < this.valuePlans.size(); ++i) {
            this.valuePlans.get(i).attachInput(this.valueTuple);
            Result valRes = this.getResult(this.valueLeaves.get(i));
            if (valRes == ERR_RESULT) {
                throw new ExecException("Error computing aggregate during in-map partial aggregation");
            }
            Tuple aggVal = this.getAggResultTuple(valRes.result);
            DataBag valBag = (DataBag)this.valueTuple.get(i + 1);
            valBag.clear();
            valBag.add(aggVal);
            this.valuePlans.get(i).detachInput();
        }
    }

    private void init(Object key, Tuple inpTuple) throws ExecException {
        this.tupleFact = TupleFactory.getInstance();
        this.valueTuple = this.tupleFact.newTuple(this.valuePlans.size() + 1);
        for (int i = 0; i < this.valuePlans.size(); ++i) {
            this.valueTuple.set(i + 1, new DefaultDataBag(new ArrayList<Tuple>(1024)));
        }
        this.currentKey = key;
        this.addToCurrentValues(inpTuple);
        this.aggMap = new HashMap<Object, Tuple>();
        this.memLimits = new SelfSpillBag.MemoryLimits(3, -1.0f);
        this.maxHashMapSize = Integer.MAX_VALUE;
    }

    private Tuple getAggResultTuple(Object result) throws ExecException {
        try {
            return (Tuple)result;
        }
        catch (ClassCastException ex) {
            throw new ExecException("Intermediate Algebraic functions must implement EvalFunc<Tuple>");
        }
    }

    private void checkSizeReduction() throws ExecException {
        ++this.num_inp_recs;
        if (this.num_inp_recs == 1000 || this.aggMap != null && this.aggMap.size() == this.maxHashMapSize - 1) {
            int min_output_reduction;
            this.sizeReductionChecked = true;
            int outputReduction = this.aggMap.size() == 0 ? Integer.MAX_VALUE : this.num_inp_recs / this.aggMap.size();
            if (outputReduction < (min_output_reduction = this.getMinOutputReductionFromProp())) {
                this.disableMapAgg = true;
                log.info((Object)("Disabling in-map partial aggregation because the reduction in tuples (" + outputReduction + ") is lower than threshold (" + min_output_reduction + ")"));
                this.logCapacityOfAggMap();
                Result output = this.getOutput();
                this.currentKey = null;
                this.valueTuple = null;
                this.addOutputToAggMap(output);
                this.mapDumpIterator = this.aggMap.values().iterator();
            }
        }
    }

    private void logCapacityOfAggMap() {
        log.info((Object)("Maximum capacity of hashmap used for map partial aggregation was " + this.maxHashMapSize + " entries"));
    }

    private void addOutputToAggMap(Result output) throws ExecException {
        this.aggMap.put(((Tuple)output.result).get(0), (Tuple)output.result);
    }

    private int getMinOutputReductionFromProp() {
        int minReduction = ((Configuration)PigMapReduce.sJobConfInternal.get()).getInt(PROP_PARTAGG_MINREDUCTION, 0);
        if (minReduction <= 0) {
            minReduction = 10;
        }
        return minReduction;
    }

    private Result getNextResFromMap() {
        if (!this.mapDumpIterator.hasNext()) {
            this.mapDumpIterator = null;
            return EOP_RESULT;
        }
        Tuple outTuple = this.mapDumpIterator.next();
        this.mapDumpIterator.remove();
        return new Result(0, outTuple);
    }

    private Result getOutput() throws ExecException {
        Tuple output = this.tupleFact.newTuple(this.valuePlans.size() + 1);
        output.set(0, this.currentKey);
        for (int i = 0; i < this.valuePlans.size(); ++i) {
            this.valuePlans.get(i).attachInput(this.valueTuple);
            Result valRes = this.getResult(this.valueLeaves.get(i));
            if (valRes == ERR_RESULT) {
                return ERR_RESULT;
            }
            output.set(i + 1, valRes.result);
        }
        return new Result(0, output);
    }

    private void resetCurrentValues() throws ExecException {
        for (int i = 1; i < this.valueTuple.size(); ++i) {
            ((DataBag)this.valueTuple.get(i)).clear();
        }
    }

    private void addToCurrentValues(Tuple inpTuple) throws ExecException {
        for (int i = 1; i < inpTuple.size(); ++i) {
            DataBag bag = (DataBag)this.valueTuple.get(i);
            bag.add((Tuple)inpTuple.get(i));
        }
    }

    private Result getResult(ExpressionOperator op) throws ExecException {
        Result res = ERR_RESULT;
        switch (op.getResultType()) {
            case 5: 
            case 10: 
            case 15: 
            case 20: 
            case 25: 
            case 50: 
            case 55: 
            case 100: 
            case 110: 
            case 120: {
                res = op.getNext(POPartialAgg.getDummy(op.getResultType()), op.getResultType());
                break;
            }
            default: {
                String msg = "Invalid result type: " + DataType.findType(op.getResultType());
                throw new ExecException(msg, 2270, 4);
            }
        }
        if (res.returnStatus == 0 || res.returnStatus == 1) {
            return res;
        }
        return ERR_RESULT;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public String name() {
        return this.getAliasString() + "Partial Agg" + "[" + DataType.findTypeName(this.resultType) + "]" + this.mKey.toString();
    }

    public PhysicalPlan getKeyPlan() {
        return this.keyPlan;
    }

    public void setKeyPlan(PhysicalPlan keyPlan) {
        this.keyPlan = keyPlan;
        this.keyLeaf = (ExpressionOperator)keyPlan.getLeaves().get(0);
    }

    public List<PhysicalPlan> getValuePlans() {
        return this.valuePlans;
    }

    public void setValuePlans(List<PhysicalPlan> valuePlans) {
        this.valuePlans = valuePlans;
        this.valueLeaves = new ArrayList<ExpressionOperator>();
        for (PhysicalPlan plan : valuePlans) {
            this.valueLeaves.add((ExpressionOperator)plan.getLeaves().get(0));
        }
    }
}

