/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.pig.Expression;
import org.apache.pig.FileInputLoadFunc;
import org.apache.pig.LoadCaster;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFunc;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.StoreMetadata;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigTextInputFormat;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigTextOutputFormat;
import org.apache.pig.builtin.JsonMetadata;
import org.apache.pig.bzip2r.Bzip2TextInputFormat;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.CastUtils;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.StorageUtil;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.parser.ParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PigStorage
extends FileInputLoadFunc
implements StoreFuncInterface,
LoadPushDown,
LoadMetadata,
StoreMetadata {
    protected RecordReader in = null;
    protected RecordWriter writer = null;
    protected final Log mLog = LogFactory.getLog(this.getClass());
    protected String signature;
    private byte fieldDel = (byte)9;
    private ArrayList<Object> mProtoTuple = null;
    private TupleFactory mTupleFactory = TupleFactory.getInstance();
    private String loadLocation;
    boolean isSchemaOn = false;
    boolean dontLoadSchema = false;
    protected ResourceSchema schema;
    protected LoadCaster caster;
    private final CommandLine configuredOptions;
    private final Options validOptions = new Options();
    private static final CommandLineParser parser = new GnuParser();
    protected boolean[] mRequiredColumns = null;
    private boolean mRequiredColumnsInitialized = false;
    private boolean tagSource = false;
    private static final String TAG_SOURCE_PATH = "tagsource";
    private Path sourcePath = null;

    private void populateValidOptions() {
        this.validOptions.addOption("schema", false, "Loads / Stores the schema of the relation using a hidden JSON file.");
        this.validOptions.addOption("noschema", false, "Disable attempting to load data schema from the filesystem.");
        this.validOptions.addOption(TAG_SOURCE_PATH, false, "Appends input source file path to beginning of each tuple. ");
    }

    public PigStorage() {
        this("\t", "");
    }

    public PigStorage(String delimiter) {
        this(delimiter, "");
    }

    public PigStorage(String delimiter, String options) {
        this.populateValidOptions();
        this.fieldDel = StorageUtil.parseFieldDel(delimiter);
        String[] optsArr = options.split(" ");
        try {
            this.configuredOptions = parser.parse(this.validOptions, optsArr);
            this.isSchemaOn = this.configuredOptions.hasOption("schema");
            this.dontLoadSchema = this.configuredOptions.hasOption("noschema");
            this.tagSource = this.configuredOptions.hasOption(TAG_SOURCE_PATH);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("PigStorage(',', '[options]')", this.validOptions);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Tuple getNext() throws IOException {
        this.mProtoTuple = new ArrayList();
        if (!this.mRequiredColumnsInitialized) {
            if (this.signature != null) {
                Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass());
                this.mRequiredColumns = (boolean[])ObjectSerializer.deserialize(p.getProperty(this.signature));
            }
            this.mRequiredColumnsInitialized = true;
        }
        if (this.tagSource) {
            this.mProtoTuple.add(new DataByteArray(this.sourcePath.getName()));
        }
        try {
            boolean notDone = this.in.nextKeyValue();
            if (!notDone) {
                return null;
            }
            Text value = (Text)this.in.getCurrentValue();
            byte[] buf = value.getBytes();
            int len = value.getLength();
            int start = 0;
            int fieldID = 0;
            for (int i = 0; i < len; ++i) {
                if (buf[i] != this.fieldDel) continue;
                if (this.mRequiredColumns == null || this.mRequiredColumns.length > fieldID && this.mRequiredColumns[fieldID]) {
                    this.readField(buf, start, i);
                }
                start = i + 1;
                ++fieldID;
            }
            if (start <= len && (this.mRequiredColumns == null || this.mRequiredColumns.length > fieldID && this.mRequiredColumns[fieldID])) {
                this.readField(buf, start, len);
            }
            Tuple t = this.mTupleFactory.newTupleNoCopy(this.mProtoTuple);
            return this.dontLoadSchema ? t : this.applySchema(t);
        }
        catch (InterruptedException e) {
            int errCode = 6018;
            String errMsg = "Error while reading input";
            throw new ExecException(errMsg, errCode, 16, e);
        }
    }

    private Tuple applySchema(Tuple tup) throws IOException {
        if (this.caster == null) {
            this.caster = this.getLoadCaster();
        }
        if (this.signature != null && this.schema == null) {
            Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass(), new String[]{this.signature});
            String serializedSchema = p.getProperty(this.signature + ".schema");
            if (serializedSchema == null) {
                return tup;
            }
            try {
                this.schema = new ResourceSchema(Utils.getSchemaFromString(serializedSchema));
            }
            catch (ParserException e) {
                this.mLog.error((Object)("Unable to parse serialized schema " + serializedSchema), (Throwable)e);
            }
        }
        if (this.schema != null) {
            ResourceSchema.ResourceFieldSchema[] fieldSchemas = this.schema.getFields();
            int tupleIdx = 0;
            for (int i = 0; i < fieldSchemas.length; ++i) {
                if (this.mRequiredColumns != null && (this.mRequiredColumns.length <= i || !this.mRequiredColumns[i])) continue;
                Object val = null;
                if (tup.get(tupleIdx) != null) {
                    byte[] bytes = ((DataByteArray)tup.get(tupleIdx)).get();
                    val = CastUtils.convertToType(this.caster, bytes, fieldSchemas[i], fieldSchemas[i].getType());
                }
                tup.set(tupleIdx, val);
                ++tupleIdx;
            }
        }
        return tup;
    }

    @Override
    public void putNext(Tuple f) throws IOException {
        try {
            this.writer.write(null, (Object)f);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void readField(byte[] buf, int start, int end) {
        if (start == end) {
            this.mProtoTuple.add(null);
        } else {
            this.mProtoTuple.add(new DataByteArray(buf, start, end));
        }
    }

    @Override
    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        if (requiredFieldList == null) {
            return null;
        }
        if (requiredFieldList.getFields() != null) {
            int lastColumn = -1;
            for (LoadPushDown.RequiredField rf : requiredFieldList.getFields()) {
                if (rf.getIndex() <= lastColumn) continue;
                lastColumn = rf.getIndex();
            }
            this.mRequiredColumns = new boolean[lastColumn + 1];
            for (LoadPushDown.RequiredField rf : requiredFieldList.getFields()) {
                if (rf.getIndex() == -1) continue;
                this.mRequiredColumns[rf.getIndex()] = true;
            }
            Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass());
            try {
                p.setProperty(this.signature, ObjectSerializer.serialize((Serializable)this.mRequiredColumns));
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot serialize mRequiredColumns");
            }
        }
        return new LoadPushDown.RequiredFieldResponse(true);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PigStorage) {
            return this.equals((PigStorage)obj);
        }
        return false;
    }

    public boolean equals(PigStorage other) {
        return this.fieldDel == other.fieldDel;
    }

    @Override
    public InputFormat getInputFormat() {
        if (this.loadLocation.endsWith(".bz2") || this.loadLocation.endsWith(".bz")) {
            return new Bzip2TextInputFormat();
        }
        return new PigTextInputFormat();
    }

    @Override
    public void prepareToRead(RecordReader reader, PigSplit split) {
        this.in = reader;
        if (this.tagSource) {
            this.sourcePath = ((FileSplit)split.getWrappedSplit()).getPath();
        }
    }

    @Override
    public void setLocation(String location, Job job) throws IOException {
        this.loadLocation = location;
        FileInputFormat.setInputPaths((Job)job, (String)location);
    }

    @Override
    public OutputFormat getOutputFormat() {
        return new PigTextOutputFormat(this.fieldDel);
    }

    @Override
    public void prepareToWrite(RecordWriter writer) {
        this.writer = writer;
    }

    @Override
    public void setStoreLocation(String location, Job job) throws IOException {
        job.getConfiguration().set("mapred.textoutputformat.separator", "");
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(location));
        if ("true".equals(job.getConfiguration().get("output.compression.enabled"))) {
            FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
            String codec = job.getConfiguration().get("output.compression.codec");
            try {
                FileOutputFormat.setOutputCompressorClass((Job)job, Class.forName(codec));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class not found: " + codec);
            }
        } else {
            this.setCompression(new Path(location), job);
        }
    }

    private void setCompression(Path path, Job job) {
        String location = path.getName();
        if (location.endsWith(".bz2") || location.endsWith(".bz")) {
            FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
            FileOutputFormat.setOutputCompressorClass((Job)job, BZip2Codec.class);
        } else if (location.endsWith(".gz")) {
            FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
            FileOutputFormat.setOutputCompressorClass((Job)job, GzipCodec.class);
        } else {
            FileOutputFormat.setCompressOutput((Job)job, (boolean)false);
        }
    }

    @Override
    public void checkSchema(ResourceSchema s) throws IOException {
    }

    @Override
    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return LoadFunc.getAbsolutePath(location, curDir);
    }

    public int hashCode() {
        return this.fieldDel;
    }

    @Override
    public void setUDFContextSignature(String signature) {
        this.signature = signature;
    }

    @Override
    public List<LoadPushDown.OperatorSet> getFeatures() {
        return Arrays.asList(LoadPushDown.OperatorSet.PROJECTION);
    }

    @Override
    public void setStoreFuncUDFContextSignature(String signature) {
    }

    @Override
    public void cleanupOnFailure(String location, Job job) throws IOException {
        StoreFunc.cleanupOnFailureImpl(location, job);
    }

    @Override
    public ResourceSchema getSchema(String location, Job job) throws IOException {
        if (!this.dontLoadSchema) {
            this.schema = new JsonMetadata().getSchema(location, job, this.isSchemaOn);
            if (this.signature != null && this.schema != null) {
                if (this.tagSource) {
                    this.schema = Utils.getSchemaWithInputSourceTag(this.schema);
                }
                Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass(), new String[]{this.signature});
                p.setProperty(this.signature + ".schema", this.schema.toString());
            }
        }
        return this.schema;
    }

    @Override
    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        return null;
    }

    @Override
    public void setPartitionFilter(Expression partitionFilter) throws IOException {
    }

    @Override
    public String[] getPartitionKeys(String location, Job job) throws IOException {
        return null;
    }

    @Override
    public void storeSchema(ResourceSchema schema, String location, Job job) throws IOException {
        if (this.isSchemaOn) {
            JsonMetadata metadataWriter = new JsonMetadata();
            byte recordDel = 10;
            metadataWriter.setFieldDel(this.fieldDel);
            metadataWriter.setRecordDel(recordDel);
            metadataWriter.storeSchema(schema, location, job);
        }
    }

    @Override
    public void storeStatistics(ResourceStatistics stats, String location, Job job) throws IOException {
    }
}

