/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataReaderWriter;
import org.apache.pig.data.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleTupleBag
implements DataBag {
    private static final long serialVersionUID = 1L;
    Tuple item;

    public SingleTupleBag(Tuple t) {
        this.item = t;
    }

    @Override
    public void add(Tuple t) {
        this.item = t;
    }

    @Override
    public void addAll(DataBag b) {
        throw new RuntimeException("Cannot create SingleTupleBag from another DataBag");
    }

    @Override
    public void clear() {
        throw new RuntimeException("Cannot clear SingleTupleBag");
    }

    @Override
    public boolean isDistinct() {
        return false;
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public Iterator<Tuple> iterator() {
        return new TBIterator();
    }

    @Override
    public void markStale(boolean stale) {
        throw new RuntimeException("SingleTupleBag cannot be marked stale");
    }

    @Override
    public long size() {
        return 1L;
    }

    @Override
    public long getMemorySize() {
        return 0L;
    }

    @Override
    public long spill() {
        return 0L;
    }

    public void readFields(DataInput in) throws IOException {
        long size = in.readLong();
        for (long i = 0L; i < size; ++i) {
            Object o = DataReaderWriter.readDatum(in);
            this.add((Tuple)o);
            continue;
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.size());
        for (Tuple item : this) {
            item.write(out);
        }
    }

    public int compareTo(Object o) {
        return 0;
    }

    public boolean equals(Object o) {
        return true;
    }

    public int hashCode() {
        return 42;
    }

    public String toString() {
        return "{" + this.item + "}";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TBIterator
    implements Iterator<Tuple> {
        boolean nextDone = false;

        TBIterator() {
        }

        @Override
        public boolean hasNext() {
            return !this.nextDone;
        }

        @Override
        public Tuple next() {
            this.nextDone = true;
            return SingleTupleBag.this.item;
        }

        @Override
        public void remove() {
            throw new RuntimeException("SingleTupleBag.iterator().remove() is not allowed");
        }
    }
}

