/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.File;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hive.hcatalog.templeton.ProxyUserSupport;
import org.apache.hive.hcatalog.templeton.tool.JobState;

public class AppConfig
extends Configuration {
    public static final String[] HADOOP_CONF_FILENAMES = new String[]{"core-default.xml", "core-site.xml", "mapred-default.xml", "mapred-site.xml", "hdfs-site.xml"};
    public static final String[] HADOOP_PREFIX_VARS = new String[]{"HADOOP_PREFIX", "HADOOP_HOME"};
    public static final String TEMPLETON_HOME_VAR = "TEMPLETON_HOME";
    public static final String[] TEMPLETON_CONF_FILENAMES = new String[]{"webhcat-default.xml", "webhcat-site.xml"};
    public static final String PORT = "templeton.port";
    public static final String EXEC_ENCODING_NAME = "templeton.exec.encoding";
    public static final String EXEC_ENVS_NAME = "templeton.exec.envs";
    public static final String EXEC_MAX_BYTES_NAME = "templeton.exec.max-output-bytes";
    public static final String EXEC_MAX_PROCS_NAME = "templeton.exec.max-procs";
    public static final String EXEC_TIMEOUT_NAME = "templeton.exec.timeout";
    public static final String HADOOP_QUEUE_NAME = "templeton.hadoop.queue.name";
    public static final String HADOOP_NAME = "templeton.hadoop";
    public static final String HADOOP_CONF_DIR = "templeton.hadoop.conf.dir";
    public static final String HCAT_NAME = "templeton.hcat";
    public static final String PYTHON_NAME = "templeton.python";
    public static final String HIVE_ARCHIVE_NAME = "templeton.hive.archive";
    public static final String HIVE_PATH_NAME = "templeton.hive.path";
    public static final String HIVE_PROPS_NAME = "templeton.hive.properties";
    public static final String LIB_JARS_NAME = "templeton.libjars";
    public static final String PIG_ARCHIVE_NAME = "templeton.pig.archive";
    public static final String PIG_PATH_NAME = "templeton.pig.path";
    public static final String STREAMING_JAR_NAME = "templeton.streaming.jar";
    public static final String TEMPLETON_JAR_NAME = "templeton.jar";
    public static final String OVERRIDE_JARS_NAME = "templeton.override.jars";
    public static final String OVERRIDE_JARS_ENABLED = "templeton.override.enabled";
    public static final String TEMPLETON_CONTROLLER_MR_CHILD_OPTS = "templeton.controller.mr.child.opts";
    public static final String KERBEROS_SECRET = "templeton.kerberos.secret";
    public static final String KERBEROS_PRINCIPAL = "templeton.kerberos.principal";
    public static final String KERBEROS_KEYTAB = "templeton.kerberos.keytab";
    public static final String CALLBACK_INTERVAL_NAME = "templeton.callback.retry.interval";
    public static final String CALLBACK_RETRY_NAME = "templeton.callback.retry.attempts";
    public static final String HADOOP_END_INTERVAL_NAME = "job.end.retry.interval";
    public static final String HADOOP_END_RETRY_NAME = "job.end.retry.attempts";
    public static final String HADOOP_END_URL_NAME = "job.end.notification.url";
    public static final String HADOOP_SPECULATIVE_NAME = "mapred.map.tasks.speculative.execution";
    public static final String HADOOP_CHILD_JAVA_OPTS = "mapred.child.java.opts";
    public static final String UNIT_TEST_MODE = "templeton.unit.test.mode";
    private static final Log LOG = LogFactory.getLog(AppConfig.class);

    public AppConfig() {
        this.init();
        LOG.info((Object)("Using Hadoop version " + VersionInfo.getVersion()));
    }

    private void init() {
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            this.set("env." + e.getKey(), e.getValue());
        }
        String templetonDir = AppConfig.getTempletonDir();
        for (String fname : TEMPLETON_CONF_FILENAMES) {
            if (this.loadOneClasspathConfig(fname)) continue;
            this.loadOneFileConfig(templetonDir, fname);
        }
        String hadoopConfDir = this.getHadoopConfDir();
        for (String fname : HADOOP_CONF_FILENAMES) {
            this.loadOneFileConfig(hadoopConfDir, fname);
        }
        ProxyUserSupport.processProxyuserConfig(this);
    }

    public void startCleanup() {
        JobState.getStorageInstance(this).startCleanup(this);
    }

    public String getHadoopConfDir() {
        return this.get(HADOOP_CONF_DIR);
    }

    public static String getTempletonDir() {
        return System.getenv(TEMPLETON_HOME_VAR);
    }

    private boolean loadOneFileConfig(String dir, String fname) {
        File f;
        if (dir != null && (f = new File(dir, fname)).exists()) {
            this.addResource(new Path(f.getAbsolutePath()));
            LOG.info((Object)("loaded config file " + f.getAbsolutePath()));
            return true;
        }
        return false;
    }

    private boolean loadOneClasspathConfig(String fname) {
        URL x = this.getResource(fname);
        if (x != null) {
            this.addResource(x);
            LOG.debug((Object)("loaded config from classpath " + x));
            return true;
        }
        return false;
    }

    public String templetonJar() {
        return this.get(TEMPLETON_JAR_NAME);
    }

    public String libJars() {
        return this.get(LIB_JARS_NAME);
    }

    public String hadoopQueueName() {
        return this.get(HADOOP_QUEUE_NAME);
    }

    public String clusterHadoop() {
        return this.get(HADOOP_NAME);
    }

    public String clusterHcat() {
        return this.get(HCAT_NAME);
    }

    public String clusterPython() {
        return this.get(PYTHON_NAME);
    }

    public String pigPath() {
        return this.get(PIG_PATH_NAME);
    }

    public String pigArchive() {
        return this.get(PIG_ARCHIVE_NAME);
    }

    public String hivePath() {
        return this.get(HIVE_PATH_NAME);
    }

    public String hiveArchive() {
        return this.get(HIVE_ARCHIVE_NAME);
    }

    public String streamingJar() {
        return this.get(STREAMING_JAR_NAME);
    }

    public String kerberosSecret() {
        return this.get(KERBEROS_SECRET);
    }

    public String kerberosPrincipal() {
        return this.get(KERBEROS_PRINCIPAL);
    }

    public String kerberosKeytab() {
        return this.get(KERBEROS_KEYTAB);
    }

    public String controllerMRChildOpts() {
        return this.get(TEMPLETON_CONTROLLER_MR_CHILD_OPTS);
    }

    public String[] overrideJars() {
        if (this.getBoolean(OVERRIDE_JARS_ENABLED, true)) {
            return this.getStrings(OVERRIDE_JARS_NAME);
        }
        return null;
    }

    public String overrideJarsString() {
        if (this.getBoolean(OVERRIDE_JARS_ENABLED, true)) {
            return this.get(OVERRIDE_JARS_NAME);
        }
        return null;
    }

    public long zkCleanupInterval() {
        return this.getLong("templeton.zookeeper.cleanup.interval", 43200000L);
    }

    public long zkMaxAge() {
        return this.getLong("templeton.zookeeper.cleanup.maxage", 604800000L);
    }

    public String zkHosts() {
        return this.get("templeton.zookeeper.hosts");
    }

    public int zkSessionTimeout() {
        return this.getInt("templeton.zookeeper.session-timeout", 30000);
    }
}

