/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.CallbackFailedException;
import org.apache.hive.hcatalog.templeton.CompleteBean;
import org.apache.hive.hcatalog.templeton.Main;
import org.apache.hive.hcatalog.templeton.TempletonDelegator;
import org.apache.hive.hcatalog.templeton.tool.JobState;
import org.apache.hive.hcatalog.templeton.tool.TempletonUtils;

public class CompleteDelegator
extends TempletonDelegator {
    private static final Log LOG = LogFactory.getLog(CompleteDelegator.class);

    public CompleteDelegator(AppConfig appConf) {
        super(appConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompleteBean run(String id) throws CallbackFailedException, IOException {
        if (id == null) {
            this.acceptWithError("No jobid given");
        }
        try (JobState state = null;){
            Long notified;
            state = new JobState(id, Main.getAppConfigInstance());
            if (state.getCompleteStatus() == null) {
                this.failed("Job not yet complete. jobId=" + id, null);
            }
            if ((notified = state.getNotifiedTime()) != null) {
                CompleteBean completeBean = this.acceptWithError("Callback already run for jobId=" + id + " at " + new Date(notified));
                return completeBean;
            }
            String callback = state.getCallback();
            if (callback == null) {
                CompleteBean completeBean = new CompleteBean("No callback registered");
                return completeBean;
            }
            try {
                CompleteDelegator.doCallback(state.getId(), callback);
            }
            catch (Exception e) {
                this.failed("Callback failed " + callback + " for " + id, e);
            }
            state.setNotifiedTime(System.currentTimeMillis());
            CompleteBean completeBean = new CompleteBean("Callback sent");
            return completeBean;
        }
    }

    public static void doCallback(String jobid, String url) throws MalformedURLException, IOException {
        if (url.contains("$jobId")) {
            url = url.replace("$jobId", jobid);
        }
        TempletonUtils.fetchUrl(new URL(url));
    }

    private void failed(String msg, Exception e) throws CallbackFailedException {
        if (e != null) {
            LOG.error((Object)msg, (Throwable)e);
        } else {
            LOG.error((Object)msg);
        }
        throw new CallbackFailedException(msg);
    }

    private CompleteBean acceptWithError(String msg) {
        LOG.error((Object)msg);
        return new CompleteBean(msg);
    }
}

