/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.BadParam;
import org.apache.hive.hcatalog.templeton.Main;
import org.apache.hive.hcatalog.templeton.NotAuthorizedException;
import org.apache.hive.hcatalog.templeton.QueueStatusBean;
import org.apache.hive.hcatalog.templeton.StatusDelegator;
import org.apache.hive.hcatalog.templeton.TempletonDelegator;
import org.apache.hive.hcatalog.templeton.UgiFactory;
import org.apache.hive.hcatalog.templeton.tool.JobState;

public class DeleteDelegator
extends TempletonDelegator {
    public DeleteDelegator(AppConfig appConf) {
        super(appConf);
    }

    public QueueStatusBean run(String user, String id) throws NotAuthorizedException, BadParam, IOException, InterruptedException {
        UserGroupInformation ugi = UgiFactory.getUgi(user);
        HadoopShims.WebHCatJTShim tracker = null;
        JobState state = null;
        try {
            tracker = ShimLoader.getHadoopShims().getWebHCatShim((Configuration)this.appConf, ugi);
            JobID jobid = StatusDelegator.StringToJobID(id);
            if (jobid == null) {
                throw new BadParam("Invalid jobid: " + id);
            }
            tracker.killJob(jobid);
            state = new JobState(id, Main.getAppConfigInstance());
            String childid = state.getChildId();
            if (childid != null) {
                tracker.killJob(StatusDelegator.StringToJobID(childid));
            }
            QueueStatusBean queueStatusBean = StatusDelegator.makeStatus(tracker, jobid, state);
            return queueStatusBean;
        }
        catch (IllegalStateException e) {
            throw new BadParam(e.getMessage());
        }
        finally {
            if (tracker != null) {
                tracker.close();
            }
            if (state != null) {
                state.close();
            }
        }
    }
}

