/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.ExecuteException;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.BadParam;
import org.apache.hive.hcatalog.templeton.BusyException;
import org.apache.hive.hcatalog.templeton.EnqueueBean;
import org.apache.hive.hcatalog.templeton.LauncherDelegator;
import org.apache.hive.hcatalog.templeton.NotAuthorizedException;
import org.apache.hive.hcatalog.templeton.QueueException;
import org.apache.hive.hcatalog.templeton.tool.TempletonUtils;

public class HiveDelegator
extends LauncherDelegator {
    public HiveDelegator(AppConfig appConf) {
        super(appConf);
    }

    public EnqueueBean run(String user, Map<String, Object> userArgs, String execute, String srcFile, List<String> defines, List<String> hiveArgs, String otherFiles, String statusdir, String callback, String completedUrl, boolean enablelog) throws NotAuthorizedException, BadParam, BusyException, QueueException, ExecuteException, IOException, InterruptedException {
        this.runAs = user;
        List<String> args = this.makeArgs(execute, srcFile, defines, hiveArgs, otherFiles, statusdir, completedUrl, enablelog);
        return this.enqueueController(user, userArgs, callback, args);
    }

    private List<String> makeArgs(String execute, String srcFile, List<String> defines, List<String> hiveArgs, String otherFiles, String statusdir, String completedUrl, boolean enablelog) throws BadParam, IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        try {
            args.addAll(this.makeBasicArgs(execute, srcFile, otherFiles, statusdir, completedUrl, enablelog));
            args.add("--");
            TempletonUtils.addCmdForWindows(args);
            args.add(this.appConf.hivePath());
            args.add("--service");
            args.add("cli");
            args.add("--hiveconf");
            args.add("__WEBHCAT_TOKEN_FILE_LOCATION__");
            for (String prop : this.appConf.getStrings("templeton.hive.properties")) {
                args.add("--hiveconf");
                args.add(TempletonUtils.quoteForWindows(prop));
            }
            for (String prop : defines) {
                args.add("--hiveconf");
                args.add(TempletonUtils.quoteForWindows(prop));
            }
            for (String hiveArg : hiveArgs) {
                args.add(TempletonUtils.quoteForWindows(hiveArg));
            }
            if (TempletonUtils.isset(execute)) {
                args.add("-e");
                args.add(TempletonUtils.quoteForWindows(execute));
            } else if (TempletonUtils.isset(srcFile)) {
                args.add("-f");
                args.add(TempletonUtils.hadoopFsPath(srcFile, this.appConf, this.runAs).getName());
            }
        }
        catch (FileNotFoundException e) {
            throw new BadParam(e.getMessage());
        }
        catch (URISyntaxException e) {
            throw new BadParam(e.getMessage());
        }
        return args;
    }

    private List<String> makeBasicArgs(String execute, String srcFile, String otherFiles, String statusdir, String completedUrl, boolean enablelog) throws URISyntaxException, FileNotFoundException, IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<String> allFiles = new ArrayList<String>();
        if (TempletonUtils.isset(srcFile)) {
            allFiles.add(TempletonUtils.hadoopFsFilename(srcFile, this.appConf, this.runAs));
        }
        if (TempletonUtils.isset(otherFiles)) {
            String[] ofs = TempletonUtils.hadoopFsListAsArray(otherFiles, this.appConf, this.runAs);
            allFiles.addAll(Arrays.asList(ofs));
        }
        args.addAll(this.makeLauncherArgs(this.appConf, statusdir, completedUrl, allFiles, enablelog, LauncherDelegator.JobType.HIVE));
        if (this.appConf.hiveArchive() != null && !this.appConf.hiveArchive().equals("")) {
            args.add("-archives");
            args.add(this.appConf.hiveArchive());
        }
        return args;
    }
}

