/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton.tool;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hive.hcatalog.templeton.tool.JobStateTracker;
import org.apache.hive.hcatalog.templeton.tool.NotFoundException;
import org.apache.hive.hcatalog.templeton.tool.TempletonStorage;
import org.apache.hive.hcatalog.templeton.tool.ZooKeeperCleanup;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class ZooKeeperStorage
implements TempletonStorage {
    public static final String TRACKINGDIR = "/created";
    public String storage_root = null;
    public String job_path = null;
    public String job_trackingpath = null;
    public String overhead_path = null;
    public static final String ZK_HOSTS = "templeton.zookeeper.hosts";
    public static final String ZK_SESSION_TIMEOUT = "templeton.zookeeper.session-timeout";
    public static final String ENCODING = "UTF-8";
    private static final Log LOG = LogFactory.getLog(ZooKeeperStorage.class);
    private ZooKeeper zk;

    public static ZooKeeper zkOpen(String zkHosts, int zkSessionTimeout) throws IOException {
        return new ZooKeeper(zkHosts, zkSessionTimeout, new Watcher(){

            public synchronized void process(WatchedEvent event) {
            }
        });
    }

    public static ZooKeeper zkOpen(Configuration conf) throws IOException {
        return ZooKeeperStorage.zkOpen(conf.get(ZK_HOSTS), conf.getInt(ZK_SESSION_TIMEOUT, 30000));
    }

    public void close() throws IOException {
        if (this.zk != null) {
            try {
                this.zk.close();
                this.zk = null;
            }
            catch (InterruptedException e) {
                throw new IOException("Closing ZooKeeper connection", e);
            }
        }
    }

    @Override
    public void startCleanup(Configuration config) {
        try {
            ZooKeeperCleanup.startInstance(config);
        }
        catch (Exception e) {
            LOG.warn((Object)"Cleanup instance didn't start.");
        }
    }

    public void create(TempletonStorage.Type type, String id) throws IOException {
        block13: {
            try {
                String[] paths = ZooKeeperStorage.getPaths(this.makeZnode(type, id));
                boolean wasCreated = false;
                for (String znode : paths) {
                    try {
                        this.zk.create(znode, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                        wasCreated = true;
                    }
                    catch (KeeperException.NodeExistsException e) {
                        // empty catch block
                    }
                }
                if (wasCreated) {
                    try {
                        if (type.equals((Object)TempletonStorage.Type.JOB)) {
                            JobStateTracker jt = new JobStateTracker(id, this.zk, false, this.job_trackingpath);
                            jt.create();
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Error tracking: " + e.getMessage()));
                        this.zk.delete(this.makeZnode(type, id), -1);
                    }
                }
                if (this.zk.exists(this.makeZnode(type, id), false) == null) {
                    throw new IOException("Unable to create " + this.makeZnode(type, id));
                }
                if (!wasCreated) break block13;
                try {
                    this.saveField(type, id, "created", Long.toString(System.currentTimeMillis()));
                }
                catch (NotFoundException nfe) {
                    throw new IOException("Couldn't write to node " + id, nfe);
                }
            }
            catch (KeeperException e) {
                throw new IOException("Creating " + id, e);
            }
            catch (InterruptedException e) {
                throw new IOException("Creating " + id, e);
            }
        }
    }

    public String getPath(TempletonStorage.Type type) {
        String typepath = this.overhead_path;
        switch (type) {
            case JOB: {
                typepath = this.job_path;
                break;
            }
            case JOBTRACKING: {
                typepath = this.job_trackingpath;
            }
        }
        return typepath;
    }

    public static String[] getPaths(String fullpath) {
        ArrayList<String> paths = new ArrayList<String>();
        if (fullpath.length() < 2) {
            paths.add(fullpath);
        } else {
            int location = 0;
            while ((location = fullpath.indexOf("/", location + 1)) > 0) {
                paths.add(fullpath.substring(0, location));
            }
            paths.add(fullpath);
        }
        String[] strings = new String[paths.size()];
        return paths.toArray(strings);
    }

    private void setFieldData(TempletonStorage.Type type, String id, String name, String val) throws KeeperException, UnsupportedEncodingException, InterruptedException {
        try {
            this.zk.create(this.makeFieldZnode(type, id, name), val.getBytes(ENCODING), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException e) {
            this.zk.setData(this.makeFieldZnode(type, id, name), val.getBytes(ENCODING), -1);
        }
    }

    public String makeFieldZnode(TempletonStorage.Type type, String id, String name) {
        return this.makeZnode(type, id) + "/" + name;
    }

    public String makeZnode(TempletonStorage.Type type, String id) {
        return this.getPath(type) + "/" + id;
    }

    @Override
    public void saveField(TempletonStorage.Type type, String id, String key, String val) throws NotFoundException {
        try {
            if (val != null) {
                this.create(type, id);
                this.setFieldData(type, id, key, val);
            }
        }
        catch (Exception e) {
            throw new NotFoundException("Writing " + key + ": " + val + ", " + e.getMessage());
        }
    }

    @Override
    public String getField(TempletonStorage.Type type, String id, String key) {
        try {
            byte[] b = this.zk.getData(this.makeFieldZnode(type, id, key), false, null);
            return new String(b, ENCODING);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Map<String, String> getFields(TempletonStorage.Type type, String id) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            for (String node : this.zk.getChildren(this.makeZnode(type, id), false)) {
                byte[] b = this.zk.getData(this.makeFieldZnode(type, id, node), false, null);
                map.put(node, new String(b, ENCODING));
            }
        }
        catch (Exception e) {
            return map;
        }
        return map;
    }

    @Override
    public boolean delete(TempletonStorage.Type type, String id) throws NotFoundException {
        try {
            for (String child : this.zk.getChildren(this.makeZnode(type, id), false)) {
                try {
                    this.zk.delete(this.makeFieldZnode(type, id, child), -1);
                }
                catch (Exception e) {
                    throw new NotFoundException("Couldn't delete " + this.makeFieldZnode(type, id, child));
                }
            }
            try {
                this.zk.delete(this.makeZnode(type, id), -1);
            }
            catch (Exception e) {
                throw new NotFoundException("Couldn't delete " + this.makeZnode(type, id));
            }
        }
        catch (Exception e) {
            throw new NotFoundException("Couldn't get children of " + this.makeZnode(type, id));
        }
        return true;
    }

    @Override
    public List<String> getAll() {
        ArrayList<String> allNodes = new ArrayList<String>();
        for (TempletonStorage.Type type : TempletonStorage.Type.values()) {
            allNodes.addAll(this.getAllForType(type));
        }
        return allNodes;
    }

    @Override
    public List<String> getAllForType(TempletonStorage.Type type) {
        try {
            return this.zk.getChildren(this.getPath(type), false);
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    @Override
    public List<String> getAllForKey(String key, String value) {
        ArrayList<String> allNodes = new ArrayList<String>();
        try {
            for (TempletonStorage.Type type : TempletonStorage.Type.values()) {
                allNodes.addAll(this.getAllForTypeAndKey(type, key, value));
            }
        }
        catch (Exception e) {
            LOG.info((Object)"Couldn't find children.");
        }
        return allNodes;
    }

    @Override
    public List<String> getAllForTypeAndKey(TempletonStorage.Type type, String key, String value) {
        ArrayList<String> allNodes = new ArrayList<String>();
        try {
            for (String id : this.zk.getChildren(this.getPath(type), false)) {
                for (String field : this.zk.getChildren(id, false)) {
                    byte[] b;
                    if (!field.endsWith("/" + key) || !new String(b = this.zk.getData(field, false, null), ENCODING).equals(value)) continue;
                    allNodes.add(id);
                }
            }
        }
        catch (Exception e) {
            LOG.info((Object)("Couldn't find children of " + this.getPath(type)));
        }
        return allNodes;
    }

    @Override
    public void openStorage(Configuration config) throws IOException {
        this.storage_root = config.get("templeton.storage.root");
        this.job_path = this.storage_root + "/jobs";
        this.job_trackingpath = this.storage_root + TRACKINGDIR;
        this.overhead_path = this.storage_root + "/overhead";
        if (this.zk == null) {
            this.zk = ZooKeeperStorage.zkOpen(config);
        }
    }

    @Override
    public void closeStorage() throws IOException {
        this.close();
    }
}

