/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.messaging;

public abstract class HCatEventMessage {
    protected EventType eventType;

    protected HCatEventMessage(EventType eventType) {
        this.eventType = eventType;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public abstract String getServer();

    public abstract String getServicePrincipal();

    public abstract String getDB();

    public abstract Long getTimestamp();

    public HCatEventMessage checkValid() {
        if (this.getServer() == null || this.getServicePrincipal() == null) {
            throw new IllegalStateException("Server-URL/Service-Principal shouldn't be null.");
        }
        if (this.getEventType() == null) {
            throw new IllegalStateException("Event-type unset.");
        }
        if (this.getDB() == null) {
            throw new IllegalArgumentException("DB-name unset.");
        }
        return this;
    }

    public static enum EventType {
        CREATE_DATABASE("CREATE_DATABASE"),
        DROP_DATABASE("DROP_DATABASE"),
        CREATE_TABLE("CREATE_TABLE"),
        DROP_TABLE("DROP_TABLE"),
        ADD_PARTITION("ADD_PARTITION"),
        DROP_PARTITION("DROP_PARTITION");

        private String typeString;

        private EventType(String typeString) {
            this.typeString = typeString;
        }

        public String toString() {
            return this.typeString;
        }
    }
}

