/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LoadTestTool;

public abstract class IngestIntegrationTestBase {
    private static String tableName = null;
    private static final String RUN_TIME_KEY = "hbase.%s.runtime";
    protected static final Log LOG = LogFactory.getLog(IngestIntegrationTestBase.class);
    protected IntegrationTestingUtility util;
    protected HBaseCluster cluster;
    private LoadTestTool loadTool;

    protected void setUp(int numSlavesBase) throws Exception {
        tableName = this.getClass().getSimpleName();
        this.util = new IntegrationTestingUtility();
        LOG.info((Object)("Initializing cluster with " + numSlavesBase + " servers"));
        this.util.initializeCluster(numSlavesBase);
        LOG.info((Object)"Done initializing cluster");
        this.cluster = this.util.getHBaseClusterInterface();
        this.deleteTableIfNecessary();
        this.loadTool = new LoadTestTool();
        this.loadTool.setConf(this.util.getConfiguration());
        int ret = this.loadTool.run(new String[]{"-tn", tableName, "-init_only"});
        Assert.assertEquals((String)"Failed to initialize LoadTestTool", (int)0, (int)ret);
    }

    protected void tearDown() throws Exception {
        LOG.info((Object)"Restoring the cluster");
        this.util.restoreCluster();
        LOG.info((Object)"Done restoring the cluster");
    }

    private void deleteTableIfNecessary() throws IOException {
        if (this.util.getHBaseAdmin().tableExists(tableName)) {
            this.util.deleteTable(Bytes.toBytes((String)tableName));
        }
    }

    protected void runIngestTest(long defaultRunTime, int keysPerServerPerIter, int colsPerKey, int recordSize, int writeThreads) throws Exception {
        LOG.info((Object)"Running ingest");
        LOG.info((Object)("Cluster size:" + this.util.getHBaseClusterInterface().getClusterStatus().getServersSize()));
        long start = System.currentTimeMillis();
        String runtimeKey = String.format(RUN_TIME_KEY, this.getClass().getSimpleName());
        long runtime = this.util.getConfiguration().getLong(runtimeKey, defaultRunTime);
        long startKey = 0L;
        long numKeys = this.getNumKeys(keysPerServerPerIter);
        while ((double)(System.currentTimeMillis() - start) < 0.9 * (double)runtime) {
            String errorMsg;
            LOG.info((Object)("Intended run time: " + runtime / 60000L + " min, left:" + (runtime - (System.currentTimeMillis() - start)) / 60000L + " min"));
            int ret = this.loadTool.run(new String[]{"-tn", tableName, "-write", String.format("%d:%d:%d", colsPerKey, recordSize, writeThreads), "-start_key", String.valueOf(startKey), "-num_keys", String.valueOf(numKeys), "-skip_init"});
            if (0 != ret) {
                errorMsg = "Load failed with error code " + ret;
                LOG.error((Object)errorMsg);
                Assert.fail((String)errorMsg);
            }
            if (0 != (ret = this.loadTool.run(new String[]{"-tn", tableName, "-read", "100:20", "-start_key", String.valueOf(startKey), "-num_keys", String.valueOf(numKeys), "-skip_init"}))) {
                errorMsg = "Verification failed with error code " + ret;
                LOG.error((Object)errorMsg);
                Assert.fail((String)errorMsg);
            }
            startKey += numKeys;
        }
    }

    private long getNumKeys(int keysPerServer) throws IOException {
        int numRegionServers = this.cluster.getClusterStatus().getServersSize();
        return keysPerServer * numRegionServers;
    }
}

