/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ClassFinder;
import org.apache.hadoop.hbase.ClassTestFinder;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.IntegrationTests;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

public class IntegrationTestsDriver
extends AbstractHBaseTool {
    private static final String TESTS_ARG = "test";
    private static final Log LOG = LogFactory.getLog(IntegrationTestsDriver.class);
    private IntegrationTestFilter intTestFilter = new IntegrationTestFilter();

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run((Tool)new IntegrationTestsDriver(), (String[])args);
        System.exit(ret);
    }

    protected void addOptions() {
        this.addOptWithArg(TESTS_ARG, "a Java regular expression to filter tests on");
    }

    protected void processOptions(CommandLine cmd) {
        String testFilterString = cmd.getOptionValue(TESTS_ARG, null);
        if (testFilterString != null) {
            this.intTestFilter.setPattern(testFilterString);
        }
    }

    private Class<?>[] findIntegrationTestClasses() throws ClassNotFoundException, LinkageError, IOException {
        ClassTestFinder.TestFileNameFilter nameFilter = new ClassTestFinder.TestFileNameFilter();
        ClassFinder classFinder = new ClassFinder(nameFilter, this.intTestFilter);
        Set<Class<?>> classes = classFinder.findClasses(true);
        return classes.toArray(new Class[classes.size()]);
    }

    protected int doWork() throws Exception {
        IntegrationTestingUtility.setUseDistributedCluster(this.conf);
        Class[] classes = this.findIntegrationTestClasses();
        LOG.info((Object)("Found " + classes.length + " integration tests to run"));
        JUnitCore junit = new JUnitCore();
        junit.addListener((RunListener)new TextListener(System.out));
        Result result = junit.run(classes);
        return result.wasSuccessful() ? 0 : 1;
    }

    private class IntegrationTestFilter
    extends ClassTestFinder.TestClassFilter {
        private Pattern testFilterRe;

        public IntegrationTestFilter() {
            super(IntegrationTests.class);
            this.testFilterRe = Pattern.compile(".*");
        }

        public void setPattern(String pattern) {
            this.testFilterRe = Pattern.compile(pattern);
        }

        @Override
        public boolean isCandidateClass(Class<?> c) {
            return super.isCandidateClass(c) && this.testFilterRe.matcher(c.getName()).find();
        }
    }
}

