/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.ResourceChecker;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class ResourceCheckerJUnitRule
extends TestWatcher {
    private ResourceChecker cu;
    private boolean endDone;

    private void start(String testName) {
        this.cu = new ResourceChecker("before " + testName);
        this.endDone = false;
    }

    private void end(String testName) {
        if (!this.endDone) {
            this.endDone = true;
            this.cu.logInfo(ResourceChecker.Phase.END, "after " + testName);
            this.cu.check("after " + testName);
        }
    }

    private String descriptionToShortTestName(Description description) {
        int toRemove = "org.apache.hadoop.hbase.".length();
        return description.getTestClass().getName().substring(toRemove) + "#" + description.getMethodName();
    }

    protected void succeeded(Description description) {
        this.end(this.descriptionToShortTestName(description));
    }

    protected void failed(Throwable e, Description description) {
        this.end(this.descriptionToShortTestName(description));
    }

    protected void starting(Description description) {
        this.start(this.descriptionToShortTestName(description));
    }

    protected void finished(Description description) {
        this.end(this.descriptionToShortTestName(description));
    }
}

