/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MultithreadedTestUtil;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestAcidGuarantees
implements Tool {
    protected static final Log LOG = LogFactory.getLog(TestAcidGuarantees.class);
    public static final byte[] TABLE_NAME = Bytes.toBytes((String)"TestAcidGuarantees");
    public static final byte[] FAMILY_A = Bytes.toBytes((String)"A");
    public static final byte[] FAMILY_B = Bytes.toBytes((String)"B");
    public static final byte[] FAMILY_C = Bytes.toBytes((String)"C");
    public static final byte[] QUALIFIER_NAME = Bytes.toBytes((String)"data");
    public static final byte[][] FAMILIES = new byte[][]{FAMILY_A, FAMILY_B, FAMILY_C};
    private HBaseTestingUtility util;
    public static int NUM_COLS_TO_CHECK = 50;
    private Configuration conf;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    private void createTableIfMissing() throws IOException {
        try {
            this.util.createTable(TABLE_NAME, FAMILIES);
        }
        catch (TableExistsException tableExistsException) {
            // empty catch block
        }
    }

    public TestAcidGuarantees() {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.hregion.memstore.flush.size", String.valueOf(131072));
        conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        this.util = new HBaseTestingUtility(conf);
    }

    public void runTestAtomicity(long millisToRun, int numWriters, int numGetters, int numScanners, int numUniqueRows) throws Exception {
        this.createTableIfMissing();
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext(this.util.getConfiguration());
        byte[][] rows = new byte[numUniqueRows][];
        for (int i = 0; i < numUniqueRows; ++i) {
            rows[i] = Bytes.toBytes((String)("test_row_" + i));
        }
        ArrayList writers = Lists.newArrayList();
        for (int i = 0; i < numWriters; ++i) {
            AtomicityWriter writer = new AtomicityWriter(ctx, rows, FAMILIES);
            writers.add(writer);
            ctx.addThread(writer);
        }
        ctx.addThread(new MultithreadedTestUtil.RepeatingTestThread(ctx){
            HBaseAdmin admin;
            {
                this.admin = new HBaseAdmin(TestAcidGuarantees.this.util.getConfiguration());
            }

            @Override
            public void doAnAction() throws Exception {
                this.admin.flush(TABLE_NAME);
            }
        });
        ArrayList getters = Lists.newArrayList();
        for (int i = 0; i < numGetters; ++i) {
            AtomicGetReader getter = new AtomicGetReader(ctx, rows[i % numUniqueRows], FAMILIES);
            getters.add(getter);
            ctx.addThread(getter);
        }
        ArrayList scanners = Lists.newArrayList();
        for (int i = 0; i < numScanners; ++i) {
            AtomicScanReader scanner = new AtomicScanReader(ctx, FAMILIES);
            scanners.add(scanner);
            ctx.addThread(scanner);
        }
        ctx.startThreads();
        ctx.waitFor(millisToRun);
        ctx.stop();
        LOG.info((Object)"Finished test. Writers:");
        for (AtomicityWriter writer : writers) {
            LOG.info((Object)("  wrote " + writer.numWritten.get()));
        }
        LOG.info((Object)"Readers:");
        for (AtomicGetReader reader : getters) {
            LOG.info((Object)("  read " + reader.numRead.get()));
        }
        LOG.info((Object)"Scanners:");
        for (AtomicScanReader scanner : scanners) {
            LOG.info((Object)("  scanned " + scanner.numScans.get()));
            LOG.info((Object)("  verified " + scanner.numRowsScanned.get() + " rows"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAtomicity() throws Exception {
        this.util.startMiniCluster(1);
        try {
            this.runTestAtomicity(20000L, 5, 5, 0, 3);
        }
        finally {
            this.util.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanAtomicity() throws Exception {
        this.util.startMiniCluster(1);
        try {
            this.runTestAtomicity(20000L, 5, 0, 5, 3);
        }
        finally {
            this.util.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMixedAtomicity() throws Exception {
        this.util.startMiniCluster(1);
        try {
            this.runTestAtomicity(20000L, 5, 2, 2, 3);
        }
        finally {
            this.util.shutdownMiniCluster();
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration c) {
        this.conf = c;
        this.util = new HBaseTestingUtility(c);
    }

    public int run(String[] arg0) throws Exception {
        Configuration c = this.getConf();
        int millis = c.getInt("millis", 5000);
        int numWriters = c.getInt("numWriters", 50);
        int numGetters = c.getInt("numGetters", 2);
        int numScanners = c.getInt("numScanners", 2);
        int numUniqueRows = c.getInt("numUniqueRows", 3);
        this.runTestAtomicity(millis, numWriters, numGetters, numScanners, numUniqueRows);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int status;
        Configuration c = HBaseConfiguration.create();
        try {
            TestAcidGuarantees test = new TestAcidGuarantees();
            status = ToolRunner.run((Configuration)c, (Tool)test, (String[])args);
        }
        catch (Exception e) {
            LOG.error((Object)"Exiting due to error", (Throwable)e);
            status = -1;
        }
        System.exit(status);
    }

    public static class AtomicScanReader
    extends MultithreadedTestUtil.RepeatingTestThread {
        byte[][] targetFamilies;
        HTable table;
        AtomicLong numScans = new AtomicLong();
        AtomicLong numRowsScanned = new AtomicLong();

        public AtomicScanReader(MultithreadedTestUtil.TestContext ctx, byte[][] targetFamilies) throws IOException {
            super(ctx);
            this.targetFamilies = targetFamilies;
            this.table = new HTable(ctx.getConf(), TABLE_NAME);
        }

        @Override
        public void doAnAction() throws Exception {
            Scan s = new Scan();
            for (byte[] family : this.targetFamilies) {
                s.addFamily(family);
            }
            ResultScanner scanner = this.table.getScanner(s);
            for (Result res : scanner) {
                byte[] gotValue = null;
                for (byte[] family : this.targetFamilies) {
                    for (int i = 0; i < NUM_COLS_TO_CHECK; ++i) {
                        byte[] qualifier = Bytes.toBytes((String)("col" + i));
                        byte[] thisValue = res.getValue(family, qualifier);
                        if (gotValue != null && !Bytes.equals((byte[])gotValue, (byte[])thisValue)) {
                            this.gotFailure(gotValue, res);
                        }
                        gotValue = thisValue;
                    }
                }
                this.numRowsScanned.getAndIncrement();
            }
            this.numScans.getAndIncrement();
        }

        private void gotFailure(byte[] expected, Result res) {
            StringBuilder msg = new StringBuilder();
            msg.append("Failed after ").append(this.numRowsScanned).append("!");
            msg.append("Expected=").append(Bytes.toStringBinary((byte[])expected));
            msg.append("Got:\n");
            for (KeyValue kv : res.list()) {
                msg.append(kv.toString());
                msg.append(" val= ");
                msg.append(Bytes.toStringBinary((byte[])kv.getValue()));
                msg.append("\n");
            }
            throw new RuntimeException(msg.toString());
        }
    }

    public static class AtomicGetReader
    extends MultithreadedTestUtil.RepeatingTestThread {
        byte[] targetRow;
        byte[][] targetFamilies;
        HTable table;
        int numVerified = 0;
        AtomicLong numRead = new AtomicLong();

        public AtomicGetReader(MultithreadedTestUtil.TestContext ctx, byte[] targetRow, byte[][] targetFamilies) throws IOException {
            super(ctx);
            this.targetRow = targetRow;
            this.targetFamilies = targetFamilies;
            this.table = new HTable(ctx.getConf(), TABLE_NAME);
        }

        @Override
        public void doAnAction() throws Exception {
            Get g = new Get(this.targetRow);
            Result res = this.table.get(g);
            byte[] gotValue = null;
            if (res.getRow() == null) {
                return;
            }
            for (byte[] family : this.targetFamilies) {
                for (int i = 0; i < NUM_COLS_TO_CHECK; ++i) {
                    byte[] qualifier = Bytes.toBytes((String)("col" + i));
                    byte[] thisValue = res.getValue(family, qualifier);
                    if (gotValue != null && !Bytes.equals(gotValue, (byte[])thisValue)) {
                        this.gotFailure(gotValue, res);
                    }
                    ++this.numVerified;
                    gotValue = thisValue;
                }
            }
            this.numRead.getAndIncrement();
        }

        private void gotFailure(byte[] expected, Result res) {
            StringBuilder msg = new StringBuilder();
            msg.append("Failed after ").append(this.numVerified).append("!");
            msg.append("Expected=").append(Bytes.toStringBinary((byte[])expected));
            msg.append("Got:\n");
            for (KeyValue kv : res.list()) {
                msg.append(kv.toString());
                msg.append(" val= ");
                msg.append(Bytes.toStringBinary((byte[])kv.getValue()));
                msg.append("\n");
            }
            throw new RuntimeException(msg.toString());
        }
    }

    public static class AtomicityWriter
    extends MultithreadedTestUtil.RepeatingTestThread {
        Random rand = new Random();
        byte[] data = new byte[10];
        byte[][] targetRows;
        byte[][] targetFamilies;
        HTable table;
        AtomicLong numWritten = new AtomicLong();

        public AtomicityWriter(MultithreadedTestUtil.TestContext ctx, byte[][] targetRows, byte[][] targetFamilies) throws IOException {
            super(ctx);
            this.targetRows = targetRows;
            this.targetFamilies = targetFamilies;
            this.table = new HTable(ctx.getConf(), TABLE_NAME);
        }

        @Override
        public void doAnAction() throws Exception {
            byte[] targetRow = this.targetRows[this.rand.nextInt(this.targetRows.length)];
            Put p = new Put(targetRow);
            this.rand.nextBytes(this.data);
            for (byte[] family : this.targetFamilies) {
                for (int i = 0; i < NUM_COLS_TO_CHECK; ++i) {
                    byte[] qualifier = Bytes.toBytes((String)("col" + i));
                    p.add(family, qualifier, this.data);
                }
            }
            this.table.put(p);
            this.numWritten.getAndIncrement();
        }
    }
}

