/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SmallTests;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHRegionLocation {
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testHashAndEqualsCode() {
        ServerName hsa1 = new ServerName("localhost", 1234, -1L);
        HRegionLocation hrl1 = new HRegionLocation(HRegionInfo.FIRST_META_REGIONINFO, hsa1.getHostname(), hsa1.getPort());
        HRegionLocation hrl2 = new HRegionLocation(HRegionInfo.FIRST_META_REGIONINFO, hsa1.getHostname(), hsa1.getPort());
        Assert.assertEquals((long)hrl1.hashCode(), (long)hrl2.hashCode());
        Assert.assertTrue((boolean)hrl1.equals((Object)hrl2));
        HRegionLocation hrl3 = new HRegionLocation(HRegionInfo.ROOT_REGIONINFO, hsa1.getHostname(), hsa1.getPort());
        Assert.assertNotSame((Object)hrl1, (Object)hrl3);
        Assert.assertTrue((boolean)hrl1.equals((Object)hrl3));
        ServerName hsa2 = new ServerName("localhost", 12345, -1L);
        HRegionLocation hrl4 = new HRegionLocation(HRegionInfo.ROOT_REGIONINFO, hsa2.getHostname(), hsa2.getPort());
        Assert.assertFalse((boolean)hrl3.equals((Object)hrl4));
    }

    @Test
    public void testToString() {
        ServerName hsa1 = new ServerName("localhost", 1234, -1L);
        HRegionLocation hrl1 = new HRegionLocation(HRegionInfo.FIRST_META_REGIONINFO, hsa1.getHostname(), hsa1.getPort());
        System.out.println(hrl1.toString());
    }

    @Test
    public void testCompareTo() {
        ServerName hsa1 = new ServerName("localhost", 1234, -1L);
        HRegionLocation hsl1 = new HRegionLocation(HRegionInfo.ROOT_REGIONINFO, hsa1.getHostname(), hsa1.getPort());
        ServerName hsa2 = new ServerName("localhost", 1235, -1L);
        HRegionLocation hsl2 = new HRegionLocation(HRegionInfo.ROOT_REGIONINFO, hsa2.getHostname(), hsa2.getPort());
        Assert.assertTrue((hsl1.compareTo(hsl1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((hsl2.compareTo(hsl2) == 0 ? 1 : 0) != 0);
        int compare1 = hsl1.compareTo(hsl2);
        int compare2 = hsl2.compareTo(hsl1);
        Assert.assertTrue((boolean)(compare1 > 0 ? compare2 < 0 : compare2 > 0));
    }
}

