/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHServerAddress {
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testHashCode() {
        HServerAddress hsa1 = new HServerAddress("localhost", 1234);
        HServerAddress hsa2 = new HServerAddress("localhost", 1234);
        Assert.assertEquals((long)hsa1.hashCode(), (long)hsa2.hashCode());
        HServerAddress hsa3 = new HServerAddress("localhost", 1235);
        Assert.assertNotSame((Object)hsa1.hashCode(), (Object)hsa3.hashCode());
    }

    @Test
    public void testHServerAddress() {
        new HServerAddress();
    }

    @Test
    public void testHServerAddressInetSocketAddress() {
        HServerAddress hsa1 = new HServerAddress(new InetSocketAddress("localhost", 1234));
        System.out.println(hsa1.toString());
    }

    @Test
    public void testHServerAddressString() {
        HServerAddress hsa1 = new HServerAddress("localhost", 1234);
        HServerAddress hsa2 = new HServerAddress(new InetSocketAddress("localhost", 1234));
        Assert.assertTrue((boolean)hsa1.equals((Object)hsa2));
    }

    @Test
    public void testHServerAddressHServerAddress() {
        HServerAddress hsa1 = new HServerAddress("localhost", 1234);
        HServerAddress hsa2 = new HServerAddress(hsa1);
        Assert.assertEquals((Object)hsa1, (Object)hsa2);
    }

    @Test
    public void testReadFields() throws IOException {
        HServerAddress hsa1 = new HServerAddress("localhost", 1234);
        HServerAddress hsa2 = new HServerAddress("localhost", 1235);
        byte[] bytes = Writables.getBytes((Writable)hsa1);
        HServerAddress deserialized = (HServerAddress)Writables.getWritable((byte[])bytes, (Writable)new HServerAddress());
        Assert.assertEquals((Object)hsa1, (Object)deserialized);
        bytes = Writables.getBytes((Writable)hsa2);
        deserialized = (HServerAddress)Writables.getWritable((byte[])bytes, (Writable)new HServerAddress());
        Assert.assertNotSame((Object)hsa1, (Object)deserialized);
    }
}

