/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestLocalHBaseCluster {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalHBaseCluster() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.rootdir", TEST_UTIL.getDataTestDir("hbase.rootdir").makeQualified(TEST_UTIL.getTestFileSystem().getUri(), TEST_UTIL.getTestFileSystem().getWorkingDirectory()).toString());
        MiniZooKeeperCluster zkCluster = TEST_UTIL.startMiniZKCluster();
        conf.set("hbase.zookeeper.property.clientPort", Integer.toString(zkCluster.getClientPort()));
        LocalHBaseCluster cluster = new LocalHBaseCluster(conf, 1, 1, MyHMaster.class, MyHRegionServer.class);
        try {
            ((MyHMaster)cluster.getMaster(0)).setZKCluster(zkCluster);
        }
        catch (ClassCastException e) {
            Assert.fail((String)"Could not cast master to our class");
        }
        try {
            ((MyHRegionServer)cluster.getRegionServer(0)).echo(42);
        }
        catch (ClassCastException e) {
            Assert.fail((String)"Could not cast regionserver to our class");
        }
        try {
            cluster.startup();
            this.waitForClusterUp(conf);
        }
        catch (IOException e) {
            Assert.fail((String)"LocalHBaseCluster did not start successfully");
        }
        finally {
            cluster.shutdown();
        }
    }

    private void waitForClusterUp(Configuration conf) throws IOException {
        HTable t = new HTable(conf, HConstants.META_TABLE_NAME);
        ResultScanner s = t.getScanner(new Scan());
        while (s.next() != null) {
        }
        s.close();
        t.close();
    }

    public static class MyHRegionServer
    extends HRegionServer {
        public MyHRegionServer(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        public int echo(int val) {
            return val;
        }
    }

    public static class MyHMaster
    extends HMaster {
        private MiniZooKeeperCluster zkcluster = null;

        public MyHMaster(Configuration conf) throws IOException, KeeperException, InterruptedException {
            super(conf);
        }

        public void run() {
            super.run();
            if (this.zkcluster != null) {
                try {
                    this.zkcluster.shutdown();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        void setZKCluster(MiniZooKeeperCluster zkcluster) {
            this.zkcluster = zkcluster;
        }
    }
}

