/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HealthCheckChore;
import org.apache.hadoop.hbase.HealthChecker;
import org.apache.hadoop.hbase.HealthReport;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.Stoppable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestNodeHealthCheckChore {
    private static final Log LOG = LogFactory.getLog(TestNodeHealthCheckChore.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private File healthScriptFile;

    @After
    public void cleanUp() throws IOException {
        UTIL.cleanupTestDir();
    }

    @Test
    public void testHealthChecker() throws Exception {
        Configuration config = this.getConfForNodeHealthScript();
        config.addResource(this.healthScriptFile.getName());
        String location = this.healthScriptFile.getAbsolutePath();
        long timeout = config.getLong("hbase.node.health.script.timeout", 200L);
        HealthChecker checker = new HealthChecker();
        checker.init(location, timeout);
        String normalScript = "echo \"I am all fine\"";
        this.createScript(normalScript, true);
        HealthReport report = checker.checkHealth();
        Assert.assertEquals((Object)HealthChecker.HealthCheckerExitStatus.SUCCESS, (Object)report.getStatus());
        LOG.info((Object)("Health Status:" + checker));
        String errorScript = "echo ERROR\n echo \"Node not healthy\"";
        this.createScript(errorScript, true);
        report = checker.checkHealth();
        Assert.assertEquals((Object)HealthChecker.HealthCheckerExitStatus.FAILED, (Object)report.getStatus());
        LOG.info((Object)("Health Status:" + report.getHealthReport()));
        String timeOutScript = "sleep 4\n echo\"I am fine\"";
        this.createScript(timeOutScript, true);
        report = checker.checkHealth();
        Assert.assertEquals((Object)HealthChecker.HealthCheckerExitStatus.TIMED_OUT, (Object)report.getStatus());
        LOG.info((Object)("Health Status:" + report.getHealthReport()));
        this.healthScriptFile.delete();
    }

    @Test
    public void testNodeHealthChore() throws Exception {
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = this.getConfForNodeHealthScript();
        String errorScript = "echo ERROR\n echo \"Node not healthy\"";
        this.createScript(errorScript, true);
        HealthCheckChore rsChore = new HealthCheckChore(100, (Stoppable)stop, conf);
        rsChore.chore();
        rsChore.chore();
        Assert.assertFalse((String)"Stoppable must not be stopped.", (boolean)stop.isStopped());
        rsChore.chore();
        Assert.assertTrue((String)"Stoppable must have been stopped.", (boolean)stop.isStopped());
    }

    private void createScript(String scriptStr, boolean setExecutable) throws Exception {
        this.healthScriptFile.createNewFile();
        PrintWriter pw = new PrintWriter(new FileOutputStream(this.healthScriptFile));
        pw.println(scriptStr);
        pw.flush();
        pw.close();
        this.healthScriptFile.setExecutable(setExecutable);
    }

    private Configuration getConfForNodeHealthScript() {
        Configuration conf = UTIL.getConfiguration();
        File tempDir = new File(UTIL.getDataTestDir().toString());
        tempDir.mkdirs();
        this.healthScriptFile = new File(tempDir.getAbsolutePath(), "HealthScript.sh");
        conf.set("hbase.node.health.script.location", this.healthScriptFile.getAbsolutePath());
        conf.setLong("hbase.node.health.failure.threshold", 3L);
        conf.setLong("hbase.node.health.script.timeout", 200L);
        return conf;
    }

    private static class StoppableImplementation
    implements Stoppable {
        private volatile boolean stop = false;

        private StoppableImplementation() {
        }

        public void stop(String why) {
            this.stop = true;
        }

        public boolean isStopped() {
            return this.stop;
        }
    }
}

