/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestRegionRebalancing {
    final Log LOG = LogFactory.getLog((String)this.getClass().getName());
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    HTable table;
    HTableDescriptor desc;
    private static final byte[] FAMILY_NAME = Bytes.toBytes((String)"col");
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() {
        this.desc = new HTableDescriptor("test");
        this.desc.addFamily(new HColumnDescriptor(FAMILY_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRebalanceOnRegionServerNumberChange() throws IOException, InterruptedException {
        HBaseAdmin admin = new HBaseAdmin(UTIL.getConfiguration());
        admin.createTable(this.desc, (byte[][])Arrays.copyOfRange(HBaseTestingUtility.KEYS, 1, HBaseTestingUtility.KEYS.length));
        this.table = new HTable(UTIL.getConfiguration(), this.desc.getName());
        CatalogTracker ct = new CatalogTracker(UTIL.getConfiguration());
        ct.start();
        try {
            MetaReader.fullScanMetaAndPrint((CatalogTracker)ct);
        }
        finally {
            ct.stop();
        }
        Assert.assertEquals((String)"Test table should have right number of regions", (long)HBaseTestingUtility.KEYS.length, (long)this.table.getStartKeys().length);
        this.assertRegionsAreBalanced();
        this.LOG.info((Object)("Started second server=" + UTIL.getHBaseCluster().startRegionServer().getRegionServer().getServerName()));
        UTIL.getHBaseCluster().getMaster().balance();
        this.assertRegionsAreBalanced();
        this.LOG.info((Object)("Started third server=" + UTIL.getHBaseCluster().startRegionServer().getRegionServer().getServerName()));
        UTIL.getHBaseCluster().getMaster().balance();
        this.assertRegionsAreBalanced();
        this.LOG.info((Object)("Stopped third server=" + UTIL.getHBaseCluster().stopRegionServer(2, false)));
        UTIL.getHBaseCluster().waitOnRegionServer(2);
        UTIL.getHBaseCluster().getMaster().balance();
        this.assertRegionsAreBalanced();
        this.LOG.info((Object)("Readding third server=" + UTIL.getHBaseCluster().startRegionServer().getRegionServer().getServerName()));
        this.LOG.info((Object)("Added fourth server=" + UTIL.getHBaseCluster().startRegionServer().getRegionServer().getServerName()));
        UTIL.getHBaseCluster().getMaster().balance();
        this.assertRegionsAreBalanced();
        for (int i = 0; i < 6; ++i) {
            this.LOG.info((Object)("Adding " + (i + 5) + "th region server"));
            UTIL.getHBaseCluster().startRegionServer();
        }
        UTIL.getHBaseCluster().getMaster().balance();
        this.assertRegionsAreBalanced();
        this.table.close();
    }

    private int getRegionCount() throws IOException {
        int total = 0;
        for (HRegionServer server : this.getOnlineRegionServers()) {
            total += server.getOnlineRegions().size();
        }
        return total;
    }

    private void assertRegionsAreBalanced() throws IOException {
        boolean success = false;
        float slop = UTIL.getConfiguration().getFloat("hbase.regions.slop", 0.1f);
        if (slop <= 0.0f) {
            slop = 1.0f;
        }
        for (int i = 0; i < 5; ++i) {
            success = true;
            this.waitForAllRegionsAssigned();
            int regionCount = this.getRegionCount();
            List<HRegionServer> servers = this.getOnlineRegionServers();
            double avg = UTIL.getHBaseCluster().getMaster().getAverageLoad();
            int avgLoadPlusSlop = (int)Math.ceil(avg * (double)(1.0f + slop));
            int avgLoadMinusSlop = (int)Math.floor(avg * (double)(1.0f - slop)) - 1;
            this.LOG.debug((Object)("There are " + servers.size() + " servers and " + regionCount + " regions. Load Average: " + avg + " low border: " + avgLoadMinusSlop + ", up border: " + avgLoadPlusSlop + "; attempt: " + i));
            for (HRegionServer server : servers) {
                int serverLoad = server.getOnlineRegions().size();
                this.LOG.debug((Object)(server.getServerName() + " Avg: " + avg + " actual: " + serverLoad));
                if (avg > 2.0 && serverLoad <= avgLoadPlusSlop && serverLoad >= avgLoadMinusSlop) continue;
                for (HRegionInfo hri : server.getOnlineRegions()) {
                    if (!hri.isMetaRegion() && !hri.isRootRegion()) continue;
                    --serverLoad;
                }
                if (serverLoad <= avgLoadPlusSlop && serverLoad >= avgLoadMinusSlop) continue;
                this.LOG.debug((Object)(server.getServerName() + " Isn't balanced!!! Avg: " + avg + " actual: " + serverLoad + " slop: " + slop));
                success = false;
                break;
            }
            if (!success) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } else {
                return;
            }
            UTIL.getHBaseCluster().getMaster().balance();
        }
        Assert.fail((String)"After 5 attempts, region assignments were not balanced.");
    }

    private List<HRegionServer> getOnlineRegionServers() {
        ArrayList<HRegionServer> list = new ArrayList<HRegionServer>();
        for (JVMClusterUtil.RegionServerThread rst : UTIL.getHBaseCluster().getRegionServerThreads()) {
            if (!rst.getRegionServer().isOnline()) continue;
            list.add(rst.getRegionServer());
        }
        return list;
    }

    private void waitForAllRegionsAssigned() throws IOException {
        int totalRegions = HBaseTestingUtility.KEYS.length + 2;
        while (this.getRegionCount() < totalRegions) {
            this.LOG.debug((Object)("Waiting for there to be " + totalRegions + " regions, but there are " + this.getRegionCount() + " right now."));
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

