/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.hbase.HServerLoad092;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.io.HbaseMapWritable;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSerialization {
    protected static final int MAXVERSIONS = 3;
    protected static final byte[] fam1 = Bytes.toBytes((String)"colfamily1");
    protected static final byte[] fam2 = Bytes.toBytes((String)"colfamily2");
    protected static final byte[] fam3 = Bytes.toBytes((String)"colfamily3");
    protected static final byte[][] COLUMNS = new byte[][]{fam1, fam2, fam3};
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testHServerLoadVersioning() throws IOException {
        HashSet<String> cps = new HashSet<String>(0);
        TreeMap<byte[], HServerLoad092.RegionLoad> regions = new TreeMap<byte[], HServerLoad092.RegionLoad>(Bytes.BYTES_COMPARATOR);
        regions.put(HConstants.META_TABLE_NAME, new HServerLoad092.RegionLoad(HConstants.META_TABLE_NAME, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0L, 0L, cps));
        HServerLoad092 hsl092 = new HServerLoad092(0, 0, 0, 0, regions, cps);
        byte[] hsl092bytes = Writables.getBytes((Writable)hsl092);
        HServerLoad hsl = (HServerLoad)Writables.getWritable((byte[])hsl092bytes, (Writable)new HServerLoad());
    }

    @Test
    public void testCompareFilter() throws Exception {
        RowFilter f = new RowFilter(CompareFilter.CompareOp.EQUAL, (WritableByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testRowOne-2")));
        byte[] bytes = Writables.getBytes((Writable)f);
        Filter ff = (Filter)Writables.getWritable((byte[])bytes, (Writable)new RowFilter());
        Assert.assertNotNull((Object)ff);
    }

    @Test
    public void testKeyValue() throws Exception {
        byte[] bytes;
        KeyValue newone;
        byte[] qualifier;
        byte[] family;
        String name = "testKeyValue";
        byte[] row = Bytes.toBytes((String)"testKeyValue");
        KeyValue original = new KeyValue(row, family = Bytes.toBytes((String)"testKeyValue"), qualifier = Bytes.toBytes((String)"testKeyValue"));
        Assert.assertTrue((KeyValue.COMPARATOR.compare(original, newone = (KeyValue)Writables.getWritable((byte[])(bytes = Writables.getBytes((Writable)original)), (Writable)new KeyValue())) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testHbaseMapWritable() throws Exception {
        HbaseMapWritable hmw = new HbaseMapWritable();
        hmw.put("key".getBytes(), (Object)"value".getBytes());
        byte[] bytes = Writables.getBytes((Writable)hmw);
        hmw = (HbaseMapWritable)Writables.getWritable((byte[])bytes, (Writable)new HbaseMapWritable());
        Assert.assertTrue((hmw.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])"value".getBytes(), (byte[])((byte[])hmw.get((Object)"key".getBytes()))));
    }

    @Test
    public void testTableDescriptor() throws Exception {
        String name = "testTableDescriptor";
        HTableDescriptor htd = this.createTableDescriptor("testTableDescriptor");
        byte[] mb = Writables.getBytes((Writable)htd);
        HTableDescriptor deserializedHtd = (HTableDescriptor)Writables.getWritable((byte[])mb, (Writable)new HTableDescriptor());
        Assert.assertEquals((Object)htd.getNameAsString(), (Object)deserializedHtd.getNameAsString());
    }

    @Test
    public void testRegionInfo() throws Exception {
        HRegionInfo hri = this.createRandomRegion("testRegionInfo");
        byte[] hrib = Writables.getBytes((Writable)hri);
        HRegionInfo deserializedHri = (HRegionInfo)Writables.getWritable((byte[])hrib, (Writable)new HRegionInfo());
        Assert.assertEquals((Object)hri.getEncodedName(), (Object)deserializedHri.getEncodedName());
    }

    @Test
    public void testRegionInfos() throws Exception {
        HRegionInfo hri = this.createRandomRegion("testRegionInfos");
        byte[] hrib = Writables.getBytes((Writable)hri);
        byte[] triple = new byte[3 * hrib.length];
        System.arraycopy(hrib, 0, triple, 0, hrib.length);
        System.arraycopy(hrib, 0, triple, hrib.length, hrib.length);
        System.arraycopy(hrib, 0, triple, hrib.length * 2, hrib.length);
        List regions = Writables.getHRegionInfos((byte[])triple, (int)0, (int)triple.length);
        Assert.assertTrue((regions.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((HRegionInfo)regions.get(0)).equals(regions.get(1)));
        Assert.assertTrue((boolean)((HRegionInfo)regions.get(0)).equals(regions.get(2)));
    }

    private HRegionInfo createRandomRegion(String name) {
        HTableDescriptor htd = new HTableDescriptor(name);
        String[] families = new String[]{"info", "anchor"};
        for (int i = 0; i < families.length; ++i) {
            htd.addFamily(new HColumnDescriptor(families[i]));
        }
        return new HRegionInfo(htd.getName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
    }

    @Test
    public void testPut() throws Exception {
        byte[] row = "row".getBytes();
        byte[] fam = "fam".getBytes();
        byte[] qf1 = "qf1".getBytes();
        byte[] qf2 = "qf2".getBytes();
        byte[] qf3 = "qf3".getBytes();
        byte[] qf4 = "qf4".getBytes();
        byte[] qf5 = "qf5".getBytes();
        byte[] qf6 = "qf6".getBytes();
        byte[] qf7 = "qf7".getBytes();
        byte[] qf8 = "qf8".getBytes();
        long ts = System.currentTimeMillis();
        byte[] val = "val".getBytes();
        Put put = new Put(row);
        put.setWriteToWAL(false);
        put.add(fam, qf1, ts, val);
        put.add(fam, qf2, ts, val);
        put.add(fam, qf3, ts, val);
        put.add(fam, qf4, ts, val);
        put.add(fam, qf5, ts, val);
        put.add(fam, qf6, ts, val);
        put.add(fam, qf7, ts, val);
        put.add(fam, qf8, ts, val);
        byte[] sb = Writables.getBytes((Writable)put);
        Put desPut = (Put)Writables.getWritable((byte[])sb, (Writable)new Put());
        Assert.assertTrue((boolean)Bytes.equals((byte[])put.getRow(), (byte[])desPut.getRow()));
        List list = null;
        List desList = null;
        for (Map.Entry entry : put.getFamilyMap().entrySet()) {
            Assert.assertTrue((boolean)desPut.getFamilyMap().containsKey(entry.getKey()));
            list = (List)entry.getValue();
            desList = (List)desPut.getFamilyMap().get(entry.getKey());
            for (int i = 0; i < list.size(); ++i) {
                Assert.assertTrue((boolean)((KeyValue)list.get(i)).equals(desList.get(i)));
            }
        }
    }

    @Test
    public void testPut2() throws Exception {
        byte[] row = "testAbort,,1243116656250".getBytes();
        byte[] fam = "historian".getBytes();
        byte[] qf1 = "creation".getBytes();
        long ts = Long.MAX_VALUE;
        byte[] val = "dont-care".getBytes();
        Put put = new Put(row);
        put.add(fam, qf1, ts, val);
        byte[] sb = Writables.getBytes((Writable)put);
        Put desPut = (Put)Writables.getWritable((byte[])sb, (Writable)new Put());
        Assert.assertTrue((boolean)Bytes.equals((byte[])put.getRow(), (byte[])desPut.getRow()));
        List list = null;
        List desList = null;
        for (Map.Entry entry : put.getFamilyMap().entrySet()) {
            Assert.assertTrue((boolean)desPut.getFamilyMap().containsKey(entry.getKey()));
            list = (List)entry.getValue();
            desList = (List)desPut.getFamilyMap().get(entry.getKey());
            for (int i = 0; i < list.size(); ++i) {
                Assert.assertTrue((boolean)((KeyValue)list.get(i)).equals(desList.get(i)));
            }
        }
    }

    @Test
    public void testDelete() throws Exception {
        byte[] row = "row".getBytes();
        byte[] fam = "fam".getBytes();
        byte[] qf1 = "qf1".getBytes();
        long ts = System.currentTimeMillis();
        Delete delete = new Delete(row);
        delete.deleteColumn(fam, qf1, ts);
        byte[] sb = Writables.getBytes((Writable)delete);
        Delete desDelete = (Delete)Writables.getWritable((byte[])sb, (Writable)new Delete());
        Assert.assertTrue((boolean)Bytes.equals((byte[])delete.getRow(), (byte[])desDelete.getRow()));
        List list = null;
        List desList = null;
        for (Map.Entry entry : delete.getFamilyMap().entrySet()) {
            Assert.assertTrue((boolean)desDelete.getFamilyMap().containsKey(entry.getKey()));
            list = (List)entry.getValue();
            desList = (List)desDelete.getFamilyMap().get(entry.getKey());
            for (int i = 0; i < list.size(); ++i) {
                Assert.assertTrue((boolean)((KeyValue)list.get(i)).equals(desList.get(i)));
            }
        }
    }

    @Test
    public void testGet() throws Exception {
        byte[] row = "row".getBytes();
        byte[] fam = "fam".getBytes();
        byte[] qf1 = "qf1".getBytes();
        long ts = System.currentTimeMillis();
        int maxVersions = 2;
        long lockid = 5L;
        RowLock rowLock = new RowLock(lockid);
        Get get = new Get(row, rowLock);
        get.addColumn(fam, qf1);
        get.setTimeRange(ts, ts + 1L);
        get.setMaxVersions(maxVersions);
        byte[] sb = Writables.getBytes((Writable)get);
        Get desGet = (Get)Writables.getWritable((byte[])sb, (Writable)new Get());
        Assert.assertTrue((boolean)Bytes.equals((byte[])get.getRow(), (byte[])desGet.getRow()));
        Set set = null;
        Set desSet = null;
        for (Map.Entry entry : get.getFamilyMap().entrySet()) {
            Assert.assertTrue((boolean)desGet.getFamilyMap().containsKey(entry.getKey()));
            set = (Set)entry.getValue();
            desSet = (Set)desGet.getFamilyMap().get(entry.getKey());
            for (byte[] qualifier : set) {
                Assert.assertTrue((boolean)desSet.contains(qualifier));
            }
        }
        Assert.assertEquals((long)get.getLockId(), (long)desGet.getLockId());
        Assert.assertEquals((long)get.getMaxVersions(), (long)desGet.getMaxVersions());
        TimeRange tr = get.getTimeRange();
        TimeRange desTr = desGet.getTimeRange();
        Assert.assertEquals((long)tr.getMax(), (long)desTr.getMax());
        Assert.assertEquals((long)tr.getMin(), (long)desTr.getMin());
    }

    @Test
    public void testScan() throws Exception {
        byte[] startRow = "startRow".getBytes();
        byte[] stopRow = "stopRow".getBytes();
        byte[] fam = "fam".getBytes();
        byte[] qf1 = "qf1".getBytes();
        long ts = System.currentTimeMillis();
        int maxVersions = 2;
        Scan scan = new Scan(startRow, stopRow);
        scan.addColumn(fam, qf1);
        scan.setTimeRange(ts, ts + 1L);
        scan.setMaxVersions(maxVersions);
        byte[] sb = Writables.getBytes((Writable)scan);
        Scan desScan = (Scan)Writables.getWritable((byte[])sb, (Writable)new Scan());
        Assert.assertTrue((boolean)Bytes.equals((byte[])scan.getStartRow(), (byte[])desScan.getStartRow()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])scan.getStopRow(), (byte[])desScan.getStopRow()));
        Assert.assertEquals((Object)scan.getCacheBlocks(), (Object)desScan.getCacheBlocks());
        Set set = null;
        Set desSet = null;
        for (Map.Entry entry : scan.getFamilyMap().entrySet()) {
            Assert.assertTrue((boolean)desScan.getFamilyMap().containsKey(entry.getKey()));
            set = (Set)entry.getValue();
            desSet = (Set)desScan.getFamilyMap().get(entry.getKey());
            for (byte[] column : set) {
                Assert.assertTrue((boolean)desSet.contains(column));
            }
            scan = new Scan(startRow);
            String name = "testScan";
            byte[] prefix = Bytes.toBytes((String)"testScan");
            scan.setFilter((Filter)new PrefixFilter(prefix));
            sb = Writables.getBytes((Writable)scan);
            desScan = (Scan)Writables.getWritable((byte[])sb, (Writable)new Scan());
            Filter f = desScan.getFilter();
            Assert.assertTrue((boolean)(f instanceof PrefixFilter));
        }
        Assert.assertEquals((long)scan.getMaxVersions(), (long)desScan.getMaxVersions());
        TimeRange tr = scan.getTimeRange();
        TimeRange desTr = desScan.getTimeRange();
        Assert.assertEquals((long)tr.getMax(), (long)desTr.getMax());
        Assert.assertEquals((long)tr.getMin(), (long)desTr.getMin());
    }

    @Test
    public void testResultEmpty() throws Exception {
        ArrayList keys = new ArrayList();
        Result r = new Result(keys);
        Assert.assertTrue((boolean)r.isEmpty());
        byte[] rb = Writables.getBytes((Writable)r);
        Result deserializedR = (Result)Writables.getWritable((byte[])rb, (Writable)new Result());
        Assert.assertTrue((boolean)deserializedR.isEmpty());
    }

    @Test
    public void testResult() throws Exception {
        byte[] rowA = Bytes.toBytes((String)"rowA");
        byte[] famA = Bytes.toBytes((String)"famA");
        byte[] qfA = Bytes.toBytes((String)"qfA");
        byte[] valueA = Bytes.toBytes((String)"valueA");
        byte[] rowB = Bytes.toBytes((String)"rowB");
        byte[] famB = Bytes.toBytes((String)"famB");
        byte[] qfB = Bytes.toBytes((String)"qfB");
        byte[] valueB = Bytes.toBytes((String)"valueB");
        KeyValue kvA = new KeyValue(rowA, famA, qfA, valueA);
        KeyValue kvB = new KeyValue(rowB, famB, qfB, valueB);
        Result result = new Result(new KeyValue[]{kvA, kvB});
        byte[] rb = Writables.getBytes((Writable)result);
        Result deResult = (Result)Writables.getWritable((byte[])rb, (Writable)new Result());
        Assert.assertTrue((String)"results are not equivalent, first key mismatch", (boolean)result.raw()[0].equals((Object)deResult.raw()[0]));
        Assert.assertTrue((String)"results are not equivalent, second key mismatch", (boolean)result.raw()[1].equals((Object)deResult.raw()[1]));
        Result r = new Result();
        byte[] b = Writables.getBytes((Writable)r);
        Result deserialized = (Result)Writables.getWritable((byte[])b, (Writable)new Result());
        Assert.assertEquals((long)r.size(), (long)deserialized.size());
    }

    @Test
    public void testResultDynamicBuild() throws Exception {
        byte[] rowA = Bytes.toBytes((String)"rowA");
        byte[] famA = Bytes.toBytes((String)"famA");
        byte[] qfA = Bytes.toBytes((String)"qfA");
        byte[] valueA = Bytes.toBytes((String)"valueA");
        byte[] rowB = Bytes.toBytes((String)"rowB");
        byte[] famB = Bytes.toBytes((String)"famB");
        byte[] qfB = Bytes.toBytes((String)"qfB");
        byte[] valueB = Bytes.toBytes((String)"valueB");
        KeyValue kvA = new KeyValue(rowA, famA, qfA, valueA);
        KeyValue kvB = new KeyValue(rowB, famB, qfB, valueB);
        Result result = new Result(new KeyValue[]{kvA, kvB});
        byte[] rb = Writables.getBytes((Writable)result);
        Result deResult = (Result)Writables.getWritable((byte[])rb, (Writable)new Result());
        byte[] row = deResult.getRow();
        Assert.assertTrue((boolean)Bytes.equals((byte[])row, (byte[])rowA));
        deResult = (Result)Writables.getWritable((byte[])rb, (Writable)new Result());
        Assert.assertTrue((String)"results are not equivalent, first key mismatch", (boolean)result.raw()[0].equals((Object)deResult.raw()[0]));
        Assert.assertTrue((String)"results are not equivalent, second key mismatch", (boolean)result.raw()[1].equals((Object)deResult.raw()[1]));
        deResult = (Result)Writables.getWritable((byte[])rb, (Writable)new Result());
        Assert.assertTrue((String)"results are not equivalent, first key mismatch", (boolean)result.raw()[0].equals((Object)deResult.raw()[0]));
        Assert.assertTrue((String)"results are not equivalent, second key mismatch", (boolean)result.raw()[1].equals((Object)deResult.raw()[1]));
    }

    @Test
    public void testResultArray() throws Exception {
        byte[] rowA = Bytes.toBytes((String)"rowA");
        byte[] famA = Bytes.toBytes((String)"famA");
        byte[] qfA = Bytes.toBytes((String)"qfA");
        byte[] valueA = Bytes.toBytes((String)"valueA");
        byte[] rowB = Bytes.toBytes((String)"rowB");
        byte[] famB = Bytes.toBytes((String)"famB");
        byte[] qfB = Bytes.toBytes((String)"qfB");
        byte[] valueB = Bytes.toBytes((String)"valueB");
        KeyValue kvA = new KeyValue(rowA, famA, qfA, valueA);
        KeyValue kvB = new KeyValue(rowB, famB, qfB, valueB);
        Result result1 = new Result(new KeyValue[]{kvA, kvB});
        Result result2 = new Result(new KeyValue[]{kvB});
        Result result3 = new Result(new KeyValue[]{kvB});
        Result[] results = new Result[]{result1, result2, result3};
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        Result.writeArray((DataOutput)out, (Result[])results);
        byte[] rb = byteStream.toByteArray();
        DataInputBuffer in = new DataInputBuffer();
        in.reset(rb, 0, rb.length);
        Result[] deResults = Result.readArray((DataInput)in);
        Assert.assertTrue((results.length == deResults.length ? 1 : 0) != 0);
        for (int i = 0; i < results.length; ++i) {
            KeyValue[] keysB;
            KeyValue[] keysA = results[i].raw();
            Assert.assertTrue((keysA.length == (keysB = deResults[i].raw()).length ? 1 : 0) != 0);
            for (int j = 0; j < keysA.length; ++j) {
                Assert.assertTrue((String)("Expected equivalent keys but found:\nKeyA : " + keysA[j].toString() + "\n" + "KeyB : " + keysB[j].toString() + "\n" + keysA.length + " total keys, " + i + "th so far"), (boolean)keysA[j].equals((Object)keysB[j]));
            }
        }
    }

    @Test
    public void testResultArrayEmpty() throws Exception {
        ArrayList keys = new ArrayList();
        Result r = new Result(keys);
        Result[] results = new Result[]{r};
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        Result.writeArray((DataOutput)out, (Result[])results);
        results = null;
        byteStream = new ByteArrayOutputStream();
        out = new DataOutputStream(byteStream);
        Result.writeArray((DataOutput)out, (Result[])results);
        byte[] rb = byteStream.toByteArray();
        DataInputBuffer in = new DataInputBuffer();
        in.reset(rb, 0, rb.length);
        Result[] deResults = Result.readArray((DataInput)in);
        Assert.assertTrue((deResults.length == 0 ? 1 : 0) != 0);
        results = new Result[]{};
        byteStream = new ByteArrayOutputStream();
        out = new DataOutputStream(byteStream);
        Result.writeArray((DataOutput)out, (Result[])results);
        rb = byteStream.toByteArray();
        in = new DataInputBuffer();
        in.reset(rb, 0, rb.length);
        deResults = Result.readArray((DataInput)in);
        Assert.assertTrue((deResults.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTimeRange() throws Exception {
        TimeRange tr = new TimeRange(0L, 5L);
        byte[] mb = Writables.getBytes((Writable)tr);
        TimeRange deserializedTr = (TimeRange)Writables.getWritable((byte[])mb, (Writable)new TimeRange());
        Assert.assertEquals((long)tr.getMax(), (long)deserializedTr.getMax());
        Assert.assertEquals((long)tr.getMin(), (long)deserializedTr.getMin());
    }

    @Test
    public void testKeyValue2() throws Exception {
        String name = "testKeyValue2";
        byte[] row = "testKeyValue2".getBytes();
        byte[] fam = "fam".getBytes();
        byte[] qf = "qf".getBytes();
        long ts = System.currentTimeMillis();
        byte[] val = "val".getBytes();
        KeyValue kv = new KeyValue(row, fam, qf, ts, val);
        byte[] mb = Writables.getBytes((Writable)kv);
        KeyValue deserializedKv = (KeyValue)Writables.getWritable((byte[])mb, (Writable)new KeyValue());
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getBuffer(), (byte[])deserializedKv.getBuffer()));
        Assert.assertEquals((long)kv.getOffset(), (long)deserializedKv.getOffset());
        Assert.assertEquals((long)kv.getLength(), (long)deserializedKv.getLength());
    }

    protected HTableDescriptor createTableDescriptor(String name) {
        return this.createTableDescriptor(name, 3);
    }

    protected HTableDescriptor createTableDescriptor(String name, int versions) {
        HTableDescriptor htd = new HTableDescriptor(name);
        htd.addFamily(new HColumnDescriptor(fam1).setMaxVersions(versions).setBlockCacheEnabled(false));
        htd.addFamily(new HColumnDescriptor(fam2).setMaxVersions(versions).setBlockCacheEnabled(false));
        htd.addFamily(new HColumnDescriptor(fam3).setMaxVersions(versions).setBlockCacheEnabled(false));
        return htd;
    }
}

