/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.regex.Pattern;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestServerName {
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testRegexPatterns() {
        Assert.assertTrue((boolean)Pattern.matches("[\\d]+", "123"));
        Assert.assertFalse((boolean)Pattern.matches("[\\d]+", ""));
        Assert.assertTrue((boolean)ServerName.SERVERNAME_PATTERN.matcher("www1.example.org,1234,567").matches());
        ServerName.parseServerName((String)"a.b.c,58102,1319771740322");
        ServerName.parseServerName((String)"192.168.1.199,58102,1319771740322");
        ServerName.parseServerName((String)"a.b.c:58102");
        ServerName.parseServerName((String)"192.168.1.199:58102");
    }

    @Test
    public void testParseOfBytes() {
        String snStr = "www.example.org,1234,5678";
        ServerName sn = new ServerName("www.example.org,1234,5678");
        byte[] versionedBytes = sn.getVersionedBytes();
        Assert.assertEquals((Object)"www.example.org,1234,5678", (Object)ServerName.parseVersionedServerName((byte[])versionedBytes).toString());
        String hostnamePortStr = "www.example.org:1234";
        byte[] bytes = Bytes.toBytes((String)"www.example.org:1234");
        String expecting = "www.example.org:1234".replace(":", ",") + "," + -1;
        Assert.assertEquals((Object)expecting, (Object)ServerName.parseVersionedServerName((byte[])bytes).toString());
    }

    @Test
    public void testServerName() {
        ServerName sn = new ServerName("www.example.org", 1234, 5678L);
        ServerName sn2 = new ServerName("www.example.org", 1234, 5678L);
        ServerName sn3 = new ServerName("www.example.org", 1234, 56789L);
        Assert.assertTrue((boolean)sn.equals((Object)sn2));
        Assert.assertFalse((boolean)sn.equals((Object)sn3));
        Assert.assertEquals((long)sn.hashCode(), (long)sn2.hashCode());
        Assert.assertNotSame((Object)sn.hashCode(), (Object)sn3.hashCode());
        Assert.assertEquals((Object)sn.toString(), (Object)ServerName.getServerName((String)"www.example.org", (int)1234, (long)5678L));
        Assert.assertEquals((Object)sn.toString(), (Object)ServerName.getServerName((String)"www.example.org:1234", (long)5678L));
        Assert.assertEquals((Object)sn.toString(), (Object)"www.example.org,1234,5678");
    }

    @Test
    public void getServerStartcodeFromServerName() {
        ServerName sn = new ServerName("www.example.org", 1234, 5678L);
        Assert.assertEquals((long)5678L, (long)ServerName.getServerStartcodeFromServerName((String)sn.toString()));
        Assert.assertNotSame((Object)5677, (Object)ServerName.getServerStartcodeFromServerName((String)sn.toString()));
    }
}

