/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestGet {
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testAttributesSerialization() throws IOException {
        Get get = new Get();
        get.setAttribute("attribute1", Bytes.toBytes((String)"value1"));
        get.setAttribute("attribute2", Bytes.toBytes((String)"value2"));
        get.setAttribute("attribute3", Bytes.toBytes((String)"value3"));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteArrayOutputStream);
        get.write((DataOutput)out);
        Get get2 = new Get();
        Assert.assertTrue((boolean)get2.getAttributesMap().isEmpty());
        get2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
        Assert.assertNull((Object)get2.getAttribute("absent"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value1"), get2.getAttribute("attribute1")));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value2"), get2.getAttribute("attribute2")));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value3"), get2.getAttribute("attribute3")));
        Assert.assertEquals((long)3L, (long)get2.getAttributesMap().size());
    }

    @Test
    public void testGetAttributes() {
        Get get = new Get();
        Assert.assertTrue((boolean)get.getAttributesMap().isEmpty());
        Assert.assertNull((Object)get.getAttribute("absent"));
        get.setAttribute("absent", null);
        Assert.assertTrue((boolean)get.getAttributesMap().isEmpty());
        Assert.assertNull((Object)get.getAttribute("absent"));
        get.setAttribute("attribute1", Bytes.toBytes((String)"value1"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value1"), get.getAttribute("attribute1")));
        Assert.assertEquals((long)1L, (long)get.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value1"), (byte[])get.getAttributesMap().get("attribute1")));
        get.setAttribute("attribute1", Bytes.toBytes((String)"value12"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value12"), get.getAttribute("attribute1")));
        Assert.assertEquals((long)1L, (long)get.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value12"), (byte[])get.getAttributesMap().get("attribute1")));
        get.setAttribute("attribute2", Bytes.toBytes((String)"value2"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value2"), get.getAttribute("attribute2")));
        Assert.assertEquals((long)2L, (long)get.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value2"), (byte[])get.getAttributesMap().get("attribute2")));
        get.setAttribute("attribute2", null);
        Assert.assertNull((Object)get.getAttribute("attribute2"));
        Assert.assertEquals((long)1L, (long)get.getAttributesMap().size());
        Assert.assertNull(get.getAttributesMap().get("attribute2"));
        get.setAttribute("attribute2", null);
        Assert.assertNull((Object)get.getAttribute("attribute2"));
        Assert.assertEquals((long)1L, (long)get.getAttributesMap().size());
        Assert.assertNull(get.getAttributesMap().get("attribute2"));
        get.setAttribute("attribute1", null);
        Assert.assertNull((Object)get.getAttribute("attribute1"));
        Assert.assertTrue((boolean)get.getAttributesMap().isEmpty());
        Assert.assertNull(get.getAttributesMap().get("attribute1"));
    }
}

