/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MultithreadedTestUtil;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestHConnection {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final long MILLIS_TO_WAIT_FOR_RACE = 1000L;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testTableDisabledRace() throws Exception {
        HConnectionRaceTester connection = new HConnectionRaceTester(TEST_UTIL.getConfiguration(), true);
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext(TEST_UTIL.getConfiguration());
        MultithreadedTestUtil.RepeatingTestThread disabledChecker = new MultithreadedTestUtil.RepeatingTestThread(ctx, (HConnection)connection){
            final /* synthetic */ HConnection val$connection;
            {
                this.val$connection = hConnection;
                super(x0);
            }

            @Override
            public void doAnAction() throws IOException {
                try {
                    this.val$connection.isTableDisabled(Bytes.toBytes((String)"tableToCheck"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        AbortThread abortThread = new AbortThread(ctx, (HConnection)connection);
        ctx.addThread(disabledChecker);
        ctx.addThread(abortThread);
        ctx.startThreads();
        ctx.waitFor(1000L);
        ctx.stop();
    }

    @Test
    public void testGetCurrentNrHRSRace() throws Exception {
        HConnectionRaceTester connection = new HConnectionRaceTester(TEST_UTIL.getConfiguration(), true);
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext(TEST_UTIL.getConfiguration());
        MultithreadedTestUtil.RepeatingTestThread getCurrentNrHRSCaller = new MultithreadedTestUtil.RepeatingTestThread(ctx, (HConnection)connection){
            final /* synthetic */ HConnection val$connection;
            {
                this.val$connection = hConnection;
                super(x0);
            }

            @Override
            public void doAnAction() throws IOException {
                try {
                    this.val$connection.getCurrentNrHRS();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        AbortThread abortThread = new AbortThread(ctx, (HConnection)connection);
        ctx.addThread(getCurrentNrHRSCaller);
        ctx.addThread(abortThread);
        ctx.startThreads();
        ctx.waitFor(1000L);
        ctx.stop();
    }

    class HConnectionRaceTester
    extends HConnectionManager.HConnectionImplementation {
        public HConnectionRaceTester(Configuration configuration, boolean managed) throws ZooKeeperConnectionException {
            super(configuration, managed);
        }

        public ZooKeeperWatcher getZooKeeperWatcher() throws ZooKeeperConnectionException {
            ZooKeeperWatcher zkw = super.getZooKeeperWatcher();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return zkw;
        }
    }

    class AbortThread
    extends MultithreadedTestUtil.RepeatingTestThread {
        final HConnection connection;

        public AbortThread(MultithreadedTestUtil.TestContext ctx, HConnection connection) {
            super(ctx);
            this.connection = connection;
        }

        @Override
        public void doAnAction() throws IOException {
            this.connection.abort("test session expired", (Throwable)new KeeperException.SessionExpiredException());
        }
    }
}

