/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.WALCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.WALObserver;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;

public class SampleRegionWALObserver
extends BaseRegionObserver
implements WALObserver {
    private static final Log LOG = LogFactory.getLog(SampleRegionWALObserver.class);
    private byte[] tableName;
    private byte[] row;
    private byte[] ignoredFamily;
    private byte[] ignoredQualifier;
    private byte[] addedFamily;
    private byte[] addedQualifier;
    private byte[] changedFamily;
    private byte[] changedQualifier;
    private boolean preWALWriteCalled = false;
    private boolean postWALWriteCalled = false;
    private boolean preWALRestoreCalled = false;
    private boolean postWALRestoreCalled = false;

    public void setTestValues(byte[] tableName, byte[] row, byte[] igf, byte[] igq, byte[] chf, byte[] chq, byte[] addf, byte[] addq) {
        this.row = row;
        this.tableName = tableName;
        this.ignoredFamily = igf;
        this.ignoredQualifier = igq;
        this.addedFamily = addf;
        this.addedQualifier = addq;
        this.changedFamily = chf;
        this.changedQualifier = chq;
    }

    public void postWALWrite(ObserverContext<WALCoprocessorEnvironment> env, HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        this.postWALWriteCalled = true;
    }

    public boolean preWALWrite(ObserverContext<WALCoprocessorEnvironment> env, HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        boolean bypass = false;
        if (!Arrays.equals(HRegionInfo.getTableName((byte[])info.getRegionName()), this.tableName)) {
            return bypass;
        }
        this.preWALWriteCalled = true;
        List kvs = logEdit.getKeyValues();
        KeyValue deletedKV = null;
        for (KeyValue kv : kvs) {
            byte[] family = kv.getFamily();
            byte[] qulifier = kv.getQualifier();
            if (Arrays.equals(family, this.ignoredFamily) && Arrays.equals(qulifier, this.ignoredQualifier)) {
                LOG.debug((Object)"Found the KeyValue from WALEdit which should be ignored.");
                deletedKV = kv;
            }
            if (!Arrays.equals(family, this.changedFamily) || !Arrays.equals(qulifier, this.changedQualifier)) continue;
            LOG.debug((Object)"Found the KeyValue from WALEdit which should be changed.");
            byte[] byArray = kv.getBuffer();
            int n = kv.getValueOffset();
            byArray[n] = (byte)(byArray[n] + 1);
        }
        kvs.add(new KeyValue(this.row, this.addedFamily, this.addedQualifier));
        if (deletedKV != null) {
            LOG.debug((Object)"About to delete a KeyValue from WALEdit.");
            kvs.remove(deletedKV);
        }
        return bypass;
    }

    public void preWALRestore(ObserverContext<RegionCoprocessorEnvironment> env, HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        this.preWALRestoreCalled = true;
    }

    public void postWALRestore(ObserverContext<RegionCoprocessorEnvironment> env, HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        this.postWALRestoreCalled = true;
    }

    public boolean isPreWALWriteCalled() {
        return this.preWALWriteCalled;
    }

    public boolean isPostWALWriteCalled() {
        return this.postWALWriteCalled;
    }

    public boolean isPreWALRestoreCalled() {
        LOG.debug((Object)(SampleRegionWALObserver.class.getName() + ".isPreWALRestoreCalled is called."));
        return this.preWALRestoreCalled;
    }

    public boolean isPostWALRestoreCalled() {
        LOG.debug((Object)(SampleRegionWALObserver.class.getName() + ".isPostWALRestoreCalled is called."));
        return this.postWALRestoreCalled;
    }
}

