/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.coprocessor.BaseMasterObserver;
import org.apache.hadoop.hbase.coprocessor.ColumnAggregationEndpoint;
import org.apache.hadoop.hbase.coprocessor.CoprocessorClassLoader;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.GenericEndpoint;
import org.apache.hadoop.hbase.coprocessor.SampleRegionWALObserver;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestClassLoading {
    private static final Log LOG = LogFactory.getLog(TestClassLoading.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static MiniDFSCluster cluster;
    static final int BUFFER_SIZE = 4096;
    static final String tableName = "TestClassLoading";
    static final String cpName1 = "TestCP1";
    static final String cpName2 = "TestCP2";
    static final String cpName3 = "TestCP3";
    static final String cpName4 = "TestCP4";
    static final String cpName5 = "TestCP5";
    static final String cpName6 = "TestCP6";
    static final String cpNameInvalid = "TestCPInvalid";
    private static Class<?> regionCoprocessor1;
    private static Class<?> regionCoprocessor2;
    private static Class<?> regionServerCoprocessor;
    private static Class<?> masterCoprocessor;
    private static final String[] regionServerSystemCoprocessors;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{regionCoprocessor1.getName()});
        conf.setStrings("hbase.coprocessor.user.region.classes", new String[]{regionCoprocessor2.getName()});
        conf.setStrings("hbase.coprocessor.wal.classes", new String[]{regionServerCoprocessor.getName()});
        conf.setStrings("hbase.coprocessor.master.classes", new String[]{masterCoprocessor.getName()});
        TEST_UTIL.startMiniCluster(1);
        cluster = TEST_UTIL.getDFSCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private boolean createJarArchive(File archiveFile, File[] tobeJared) {
        try {
            byte[] buffer = new byte[4096];
            FileOutputStream stream = new FileOutputStream(archiveFile);
            JarOutputStream out = new JarOutputStream((OutputStream)stream, new Manifest());
            for (int i = 0; i < tobeJared.length; ++i) {
                int nRead;
                if (tobeJared[i] == null || !tobeJared[i].exists() || tobeJared[i].isDirectory()) continue;
                JarEntry jarAdd = new JarEntry(tobeJared[i].getName());
                jarAdd.setTime(tobeJared[i].lastModified());
                out.putNextEntry(jarAdd);
                FileInputStream in = new FileInputStream(tobeJared[i]);
                while ((nRead = in.read(buffer, 0, buffer.length)) > 0) {
                    out.write(buffer, 0, nRead);
                }
                in.close();
            }
            out.close();
            stream.close();
            LOG.info((Object)"Adding classes to jar file completed");
            return true;
        }
        catch (Exception ex) {
            LOG.error((Object)("Error: " + ex.getMessage()));
            return false;
        }
    }

    private File buildCoprocessorJar(String className) throws Exception {
        String javaCode = "import org.apache.hadoop.hbase.coprocessor.*;public class " + className + " extends BaseRegionObserver {}";
        Path baseDir = TEST_UTIL.getDataTestDir();
        Path srcDir = new Path(TEST_UTIL.getDataTestDir(), "src");
        File srcDirPath = new File(srcDir.toString());
        srcDirPath.mkdirs();
        File sourceCodeFile = new File(srcDir.toString(), className + ".java");
        BufferedWriter bw = new BufferedWriter(new FileWriter(sourceCodeFile));
        bw.write(javaCode);
        bw.close();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        ArrayList<String> srcFileNames = new ArrayList<String>();
        srcFileNames.add(sourceCodeFile.toString());
        StandardJavaFileManager fm = compiler.getStandardFileManager(null, null, null);
        Iterable<? extends JavaFileObject> cu = fm.getJavaFileObjects(sourceCodeFile);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-classpath");
        String currentDir = new File(".").getAbsolutePath();
        String classpath = currentDir + File.separator + "target" + File.separator + "classes" + System.getProperty("path.separator") + System.getProperty("surefire.test.class.path");
        options.add(classpath);
        LOG.debug((Object)("Setting classpath to: " + classpath));
        JavaCompiler.CompilationTask task = compiler.getTask(null, fm, null, options, null, cu);
        Assert.assertTrue((String)("Compile file " + sourceCodeFile + " failed."), (boolean)task.call());
        String jarFileName = className + ".jar";
        File jarFile = new File(baseDir.toString(), jarFileName);
        if (!this.createJarArchive(jarFile, new File[]{new File(srcDir.toString(), className + ".class")})) {
            Assert.assertTrue((String)"Build jar file failed.", (boolean)false);
        }
        return jarFile;
    }

    @Test
    public void testClassLoadingFromHDFS() throws Exception {
        FileSystem fs = cluster.getFileSystem();
        File jarFile1 = this.buildCoprocessorJar(cpName1);
        File jarFile2 = this.buildCoprocessorJar(cpName2);
        fs.copyFromLocalFile(new Path(jarFile1.getPath()), new Path(fs.getUri().toString() + "/"));
        String jarFileOnHDFS1 = fs.getUri().toString() + "/" + jarFile1.getName();
        Path pathOnHDFS1 = new Path(jarFileOnHDFS1);
        Assert.assertTrue((String)"Copy jar file to HDFS failed.", (boolean)fs.exists(pathOnHDFS1));
        LOG.info((Object)("Copied jar file to HDFS: " + jarFileOnHDFS1));
        fs.copyFromLocalFile(new Path(jarFile2.getPath()), new Path(fs.getUri().toString() + "/"));
        String jarFileOnHDFS2 = fs.getUri().toString() + "/" + jarFile2.getName();
        Path pathOnHDFS2 = new Path(jarFileOnHDFS2);
        Assert.assertTrue((String)"Copy jar file to HDFS failed.", (boolean)fs.exists(pathOnHDFS2));
        LOG.info((Object)("Copied jar file to HDFS: " + jarFileOnHDFS2));
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor("test"));
        htd.setValue("COPROCESSOR$1", jarFileOnHDFS1.toString() + "|" + cpName1 + "|" + 0x3FFFFFFF);
        htd.setValue("COPROCESSOR$2", jarFileOnHDFS2.toString() + "|" + cpName2 + "|" + 0x3FFFFFFF + "|k1=v1,k2=v2,k3=v3");
        htd.setValue("COPROCESSOR$3", jarFileOnHDFS2.toString() + "|" + cpNameInvalid + "|" + 0x3FFFFFFF);
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        CoprocessorHost.classLoadersCache.clear();
        byte[] startKey = new byte[]{10, 63};
        byte[] endKey = new byte[]{12, 43};
        admin.createTable(htd, startKey, endKey, 4);
        this.waitForTable(htd.getName());
        boolean foundTableRegion = false;
        boolean found_invalid = true;
        boolean found1 = true;
        boolean found2 = true;
        boolean found2_k1 = true;
        boolean found2_k2 = true;
        boolean found2_k3 = true;
        HashMap<HRegion, Set> regionsActiveClassLoaders = new HashMap<HRegion, Set>();
        MiniHBaseCluster hbase = TEST_UTIL.getHBaseCluster();
        for (HRegion region : hbase.getRegionServer(0).getOnlineRegionsLocalContext()) {
            if (!region.getRegionNameAsString().startsWith(tableName)) continue;
            foundTableRegion = true;
            CoprocessorEnvironment env = region.getCoprocessorHost().findCoprocessorEnvironment(cpName1);
            found1 = found1 && env != null;
            env = region.getCoprocessorHost().findCoprocessorEnvironment(cpName2);
            boolean bl = found2 = found2 && env != null;
            if (env != null) {
                Configuration conf = env.getConfiguration();
                found2_k1 = found2_k1 && conf.get("k1") != null;
                found2_k2 = found2_k2 && conf.get("k2") != null;
                found2_k3 = found2_k3 && conf.get("k3") != null;
            } else {
                found2_k3 = false;
                found2_k2 = false;
                found2_k1 = false;
            }
            env = region.getCoprocessorHost().findCoprocessorEnvironment(cpNameInvalid);
            found_invalid = found_invalid && env != null;
            regionsActiveClassLoaders.put(region, region.getCoprocessorHost().getExternalClassLoaders());
        }
        Assert.assertTrue((String)"No region was found for table TestClassLoading", (boolean)foundTableRegion);
        Assert.assertTrue((String)"Class TestCP1 was missing on a region", (boolean)found1);
        Assert.assertTrue((String)"Class TestCP2 was missing on a region", (boolean)found2);
        Assert.assertFalse((String)"Class TestCPInvalid was found on a region", (boolean)found_invalid);
        Assert.assertTrue((String)"Configuration key 'k1' was missing on a region", (boolean)found2_k1);
        Assert.assertTrue((String)"Configuration key 'k2' was missing on a region", (boolean)found2_k2);
        Assert.assertTrue((String)"Configuration key 'k3' was missing on a region", (boolean)found2_k3);
        Assert.assertTrue((String)(jarFileOnHDFS1 + " was not cached"), (boolean)CoprocessorHost.classLoadersCache.containsKey(pathOnHDFS1));
        Assert.assertTrue((String)(jarFileOnHDFS2 + " was not cached"), (boolean)CoprocessorHost.classLoadersCache.containsKey(pathOnHDFS2));
        Assert.assertEquals((String)"The number of cached classloaders should be equal to the number of external jar files", (long)2L, (long)CoprocessorHost.classLoadersCache.size());
        HashSet externalClassLoaders = new HashSet(CoprocessorHost.classLoadersCache.values());
        for (Map.Entry regionCP : regionsActiveClassLoaders.entrySet()) {
            Assert.assertTrue((String)("Some CP classloaders for region " + regionCP.getKey() + " are not cached." + " ClassLoader Cache:" + externalClassLoaders + " Region ClassLoaders:" + regionCP.getValue()), (boolean)externalClassLoaders.containsAll((Collection)regionCP.getValue()));
        }
    }

    private String getLocalPath(File file) {
        return new Path(file.toURI()).toString();
    }

    @Test
    public void testClassLoadingFromLocalFS() throws Exception {
        File jarFile = this.buildCoprocessorJar(cpName3);
        HTableDescriptor htd = new HTableDescriptor(cpName3);
        htd.addFamily(new HColumnDescriptor("test"));
        htd.setValue("COPROCESSOR$1", this.getLocalPath(jarFile) + "|" + cpName3 + "|" + 0x3FFFFFFF);
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        admin.createTable(htd);
        this.waitForTable(htd.getName());
        boolean found = false;
        MiniHBaseCluster hbase = TEST_UTIL.getHBaseCluster();
        for (HRegion region : hbase.getRegionServer(0).getOnlineRegionsLocalContext()) {
            if (!region.getRegionNameAsString().startsWith(cpName3)) continue;
            found = region.getCoprocessorHost().findCoprocessor(cpName3) != null;
        }
        Assert.assertTrue((String)"Class TestCP3 was missing on a region", (boolean)found);
    }

    @Test
    public void testPrivateClassLoader() throws Exception {
        File jarFile = this.buildCoprocessorJar(cpName4);
        HTableDescriptor htd = new HTableDescriptor(cpName4);
        htd.addFamily(new HColumnDescriptor("test"));
        htd.setValue("COPROCESSOR$1", this.getLocalPath(jarFile) + "|" + cpName4 + "|" + 0x3FFFFFFF);
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        admin.createTable(htd);
        this.waitForTable(htd.getName());
        boolean found = false;
        MiniHBaseCluster hbase = TEST_UTIL.getHBaseCluster();
        for (HRegion region : hbase.getRegionServer(0).getOnlineRegionsLocalContext()) {
            Coprocessor cp;
            if (!region.getRegionNameAsString().startsWith(cpName4) || (cp = region.getCoprocessorHost().findCoprocessor(cpName4)) == null) continue;
            found = true;
            Assert.assertEquals((String)"Class TestCP4 was not loaded by CoprocessorClassLoader", cp.getClass().getClassLoader().getClass(), CoprocessorClassLoader.class);
        }
        Assert.assertTrue((String)"Class TestCP4 was missing on a region", (boolean)found);
    }

    @Test
    public void testHBase3810() throws Exception {
        File jarFile1 = this.buildCoprocessorJar(cpName1);
        File jarFile2 = this.buildCoprocessorJar(cpName2);
        File jarFile5 = this.buildCoprocessorJar(cpName5);
        File jarFile6 = this.buildCoprocessorJar(cpName6);
        String cpKey1 = "COPROCESSOR$1";
        String cpKey2 = " Coprocessor$2 ";
        String cpKey3 = " coprocessor$03 ";
        String cpValue1 = this.getLocalPath(jarFile1) + "|" + cpName1 + "|" + 0x3FFFFFFF;
        String cpValue2 = this.getLocalPath(jarFile2) + " | " + cpName2 + " | ";
        String cpValue3 = " | org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver | | k=v ";
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor("test"));
        htd.setValue(cpKey1, cpValue1);
        htd.setValue(cpKey2, cpValue2);
        htd.setValue(cpKey3, cpValue3);
        htd.addCoprocessor(cpName5, new Path(this.getLocalPath(jarFile5)), 0x3FFFFFFF, null);
        HashMap<String, String> kvs = new HashMap<String, String>();
        kvs.put("k1", "v1");
        kvs.put("k2", "v2");
        kvs.put("k3", "v3");
        htd.addCoprocessor(cpName6, new Path(this.getLocalPath(jarFile6)), 0x3FFFFFFF, kvs);
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        admin.createTable(htd);
        this.waitForTable(htd.getName());
        boolean found_2 = false;
        boolean found_1 = false;
        boolean found_3 = false;
        boolean found_5 = false;
        boolean found_6 = false;
        boolean found6_k1 = false;
        boolean found6_k2 = false;
        boolean found6_k3 = false;
        boolean found6_k4 = false;
        MiniHBaseCluster hbase = TEST_UTIL.getHBaseCluster();
        for (HRegion region : hbase.getRegionServer(0).getOnlineRegionsLocalContext()) {
            if (!region.getRegionNameAsString().startsWith(tableName)) continue;
            found_1 = found_1 || region.getCoprocessorHost().findCoprocessor(cpName1) != null;
            found_2 = found_2 || region.getCoprocessorHost().findCoprocessor(cpName2) != null;
            found_3 = found_3 || region.getCoprocessorHost().findCoprocessor("SimpleRegionObserver") != null;
            boolean bl = found_5 = found_5 || region.getCoprocessorHost().findCoprocessor(cpName5) != null;
            CoprocessorEnvironment env = region.getCoprocessorHost().findCoprocessorEnvironment(cpName6);
            if (env == null) continue;
            found_6 = true;
            Configuration conf = env.getConfiguration();
            found6_k1 = conf.get("k1") != null;
            found6_k2 = conf.get("k2") != null;
            found6_k3 = conf.get("k3") != null;
        }
        Assert.assertTrue((String)"Class TestCP1 was missing on a region", (boolean)found_1);
        Assert.assertTrue((String)"Class TestCP2 was missing on a region", (boolean)found_2);
        Assert.assertTrue((String)"Class SimpleRegionObserver was missing on a region", (boolean)found_3);
        Assert.assertTrue((String)"Class TestCP5 was missing on a region", (boolean)found_5);
        Assert.assertTrue((String)"Class TestCP6 was missing on a region", (boolean)found_6);
        Assert.assertTrue((String)"Configuration key 'k1' was missing on a region", (boolean)found6_k1);
        Assert.assertTrue((String)"Configuration key 'k2' was missing on a region", (boolean)found6_k2);
        Assert.assertTrue((String)"Configuration key 'k3' was missing on a region", (boolean)found6_k3);
        Assert.assertFalse((String)"Configuration key 'k4' wasn't configured", (boolean)found6_k4);
    }

    @Test
    public void testClassLoadingFromLibDirInJar() throws Exception {
        FileSystem fs = cluster.getFileSystem();
        File innerJarFile1 = this.buildCoprocessorJar(cpName1);
        File innerJarFile2 = this.buildCoprocessorJar(cpName2);
        File outerJarFile = new File(TEST_UTIL.getDataTestDir().toString(), "outer.jar");
        byte[] buffer = new byte[4096];
        FileOutputStream stream = new FileOutputStream(outerJarFile);
        JarOutputStream out = new JarOutputStream((OutputStream)stream, new Manifest());
        for (File jarFile : new File[]{innerJarFile1, innerJarFile2}) {
            int nRead;
            JarEntry jarAdd = new JarEntry("/lib/" + jarFile.getName());
            jarAdd.setTime(jarFile.lastModified());
            out.putNextEntry(jarAdd);
            FileInputStream in = new FileInputStream(jarFile);
            while ((nRead = in.read(buffer, 0, buffer.length)) > 0) {
                out.write(buffer, 0, nRead);
            }
            in.close();
        }
        out.close();
        stream.close();
        LOG.info((Object)"Adding jar file to outer jar file completed");
        fs.copyFromLocalFile(new Path(outerJarFile.getPath()), new Path(fs.getUri().toString() + "/"));
        String jarFileOnHDFS = fs.getUri().toString() + "/" + outerJarFile.getName();
        Assert.assertTrue((String)"Copy jar file to HDFS failed.", (boolean)fs.exists(new Path(jarFileOnHDFS)));
        LOG.info((Object)("Copied jar file to HDFS: " + jarFileOnHDFS));
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor("test"));
        htd.setValue("COPROCESSOR$1", jarFileOnHDFS.toString() + "|" + cpName1 + "|" + 0x3FFFFFFF);
        htd.setValue("COPROCESSOR$2", jarFileOnHDFS.toString() + "|" + cpName2 + "|" + 0x3FFFFFFF + "|k1=v1,k2=v2,k3=v3");
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        admin.createTable(htd);
        this.waitForTable(htd.getName());
        boolean found1 = false;
        boolean found2 = false;
        boolean found2_k1 = false;
        boolean found2_k2 = false;
        boolean found2_k3 = false;
        MiniHBaseCluster hbase = TEST_UTIL.getHBaseCluster();
        for (HRegion region : hbase.getRegionServer(0).getOnlineRegionsLocalContext()) {
            if (!region.getRegionNameAsString().startsWith(tableName)) continue;
            CoprocessorEnvironment env = region.getCoprocessorHost().findCoprocessorEnvironment(cpName1);
            if (env != null) {
                found1 = true;
            }
            if ((env = region.getCoprocessorHost().findCoprocessorEnvironment(cpName2)) == null) continue;
            found2 = true;
            Configuration conf = env.getConfiguration();
            found2_k1 = conf.get("k1") != null;
            found2_k2 = conf.get("k2") != null;
            found2_k3 = conf.get("k3") != null;
        }
        Assert.assertTrue((String)"Class TestCP1 was missing on a region", (boolean)found1);
        Assert.assertTrue((String)"Class TestCP2 was missing on a region", (boolean)found2);
        Assert.assertTrue((String)"Configuration key 'k1' was missing on a region", (boolean)found2_k1);
        Assert.assertTrue((String)"Configuration key 'k2' was missing on a region", (boolean)found2_k2);
        Assert.assertTrue((String)"Configuration key 'k3' was missing on a region", (boolean)found2_k3);
    }

    @Test
    public void testRegionServerCoprocessorsReported() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        this.assertAllRegionServers(regionServerSystemCoprocessors, null);
    }

    Map<ServerName, HServerLoad> serversForTable(String tableName) {
        HashMap<ServerName, HServerLoad> serverLoadHashMap = new HashMap<ServerName, HServerLoad>();
        block0: for (Map.Entry server : TEST_UTIL.getMiniHBaseCluster().getMaster().getServerManager().getOnlineServers().entrySet()) {
            for (Map.Entry region : ((HServerLoad)server.getValue()).getRegionsLoad().entrySet()) {
                if (!((HServerLoad.RegionLoad)region.getValue()).getNameAsString().equals(tableName)) continue;
                serverLoadHashMap.put((ServerName)server.getKey(), (HServerLoad)server.getValue());
                continue block0;
            }
        }
        return serverLoadHashMap;
    }

    void assertAllRegionServers(String[] expectedCoprocessors, String tableName) throws InterruptedException {
        Object[] actualCoprocessors = null;
        boolean success = false;
        for (int i = 0; i < 5; ++i) {
            Map servers = tableName == null ? TEST_UTIL.getMiniHBaseCluster().getMaster().getServerManager().getOnlineServers() : this.serversForTable(tableName);
            boolean any_failed = false;
            for (Map.Entry server : servers.entrySet()) {
                actualCoprocessors = ((HServerLoad)server.getValue()).getRsCoprocessors();
                if (Arrays.equals(actualCoprocessors, expectedCoprocessors)) continue;
                LOG.debug((Object)("failed comparison: actual: " + Arrays.toString(actualCoprocessors) + " ; expected: " + Arrays.toString(expectedCoprocessors)));
                any_failed = true;
                break;
            }
            if (!any_failed) {
                success = true;
                break;
            }
            LOG.debug((Object)("retrying after failed comparison: " + i));
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)success);
    }

    @Test
    public void testMasterCoprocessorsReported() {
        String loadedMasterCoprocessorsVerify = "[" + masterCoprocessor.getSimpleName() + "]";
        String loadedMasterCoprocessors = Arrays.toString(TEST_UTIL.getHBaseCluster().getMaster().getCoprocessors());
        Assert.assertEquals((Object)loadedMasterCoprocessorsVerify, (Object)loadedMasterCoprocessors);
    }

    private void waitForTable(byte[] name) throws InterruptedException, IOException {
        TEST_UTIL.waitTableEnabled(name, 5000L);
        Thread.sleep(1000L);
    }

    static {
        regionCoprocessor1 = ColumnAggregationEndpoint.class;
        regionCoprocessor2 = GenericEndpoint.class;
        regionServerCoprocessor = SampleRegionWALObserver.class;
        masterCoprocessor = BaseMasterObserver.class;
        regionServerSystemCoprocessors = new String[]{regionServerCoprocessor.getSimpleName()};
    }
}

