/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.client.coprocessor.Exec;
import org.apache.hadoop.hbase.coprocessor.ColumnAggregationProtocol;
import org.apache.hadoop.hbase.coprocessor.GenericProtocol;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestCoprocessorEndpoint {
    private static final byte[] TEST_TABLE = Bytes.toBytes((String)"TestTable");
    private static final byte[] TEST_FAMILY = Bytes.toBytes((String)"TestFamily");
    private static final byte[] TEST_QUALIFIER = Bytes.toBytes((String)"TestQualifier");
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static final String protocolName = "org.apache.hadoop.hbase.CustomProtocol";
    private static final String methodName = "myFunc";
    private static final int ROWSIZE = 20;
    private static final int rowSeperator1 = 5;
    private static final int rowSeperator2 = 12;
    private static byte[][] ROWS = TestCoprocessorEndpoint.makeN(ROW, 20);
    private static HBaseTestingUtility util = new HBaseTestingUtility();
    private static MiniHBaseCluster cluster = null;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = util.getConfiguration();
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{"org.apache.hadoop.hbase.coprocessor.ColumnAggregationEndpoint", "org.apache.hadoop.hbase.coprocessor.GenericEndpoint"});
        conf.setStrings("hbase.coprocessor.master.classes", new String[]{"org.apache.hadoop.hbase.coprocessor.GenericEndpoint"});
        util.startMiniCluster(2);
        cluster = util.getMiniHBaseCluster();
        HTable table = util.createTable(TEST_TABLE, TEST_FAMILY);
        util.createMultiRegions(util.getConfiguration(), table, TEST_FAMILY, new byte[][]{HConstants.EMPTY_BYTE_ARRAY, ROWS[5], ROWS[12]});
        for (int i = 0; i < 20; ++i) {
            Put put = new Put(ROWS[i]);
            put.setWriteToWAL(false);
            put.add(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((int)i));
            table.put(put);
        }
        long timeout = System.currentTimeMillis() + 15000L;
        while (System.currentTimeMillis() < timeout && table.getRegionsInfo().size() != 2) {
            Thread.sleep(250L);
        }
        table.close();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    @Test
    public void testGeneric() throws Throwable {
        HTable table = new HTable(util.getConfiguration(), TEST_TABLE);
        GenericProtocol protocol = (GenericProtocol)table.coprocessorProxy(GenericProtocol.class, Bytes.toBytes((String)"testRow"));
        String workResult1 = protocol.doWork("foo");
        Assert.assertEquals((Object)"foo", (Object)workResult1);
        byte[] workResult2 = protocol.doWork(new byte[]{1});
        Assert.assertArrayEquals((byte[])new byte[]{1}, (byte[])workResult2);
        byte workResult3 = protocol.doWork((byte)1);
        Assert.assertEquals((long)1L, (long)workResult3);
        char workResult4 = protocol.doWork(Character.valueOf('c')).charValue();
        Assert.assertEquals((long)99L, (long)workResult4);
        boolean workResult5 = protocol.doWork(true);
        Assert.assertEquals((Object)true, (Object)workResult5);
        short workResult6 = protocol.doWork((short)1);
        Assert.assertEquals((long)1L, (long)workResult6);
        int workResult7 = protocol.doWork(5);
        Assert.assertEquals((long)5L, (long)workResult7);
        long workResult8 = protocol.doWork(5L);
        Assert.assertEquals((long)5L, (long)workResult8);
        double workResult9 = protocol.doWork(6.0);
        Assert.assertEquals((double)6.0, (double)workResult9, (double)0.01);
        float workResult10 = protocol.doWork(Float.valueOf(6.0f)).floatValue();
        Assert.assertEquals((double)6.0, (double)workResult10, (double)0.01);
        Text workResult11 = protocol.doWork(new Text("foo"));
        Assert.assertEquals((Object)new Text("foo"), (Object)workResult11);
        table.close();
    }

    @Test
    public void testMasterGeneric() throws Throwable {
        HBaseAdmin admin = new HBaseAdmin(util.getConfiguration());
        GenericProtocol protocol = (GenericProtocol)admin.coprocessorProxy(GenericProtocol.class);
        String workResult1 = protocol.doWork("foo");
        Assert.assertEquals((Object)"foo", (Object)workResult1);
        byte[] workResult2 = protocol.doWork(new byte[]{1});
        Assert.assertArrayEquals((byte[])new byte[]{1}, (byte[])workResult2);
        byte workResult3 = protocol.doWork((byte)1);
        Assert.assertEquals((long)1L, (long)workResult3);
        char workResult4 = protocol.doWork(Character.valueOf('c')).charValue();
        Assert.assertEquals((long)99L, (long)workResult4);
        boolean workResult5 = protocol.doWork(true);
        Assert.assertEquals((Object)true, (Object)workResult5);
        short workResult6 = protocol.doWork((short)1);
        Assert.assertEquals((long)1L, (long)workResult6);
        int workResult7 = protocol.doWork(5);
        Assert.assertEquals((long)5L, (long)workResult7);
        long workResult8 = protocol.doWork(5L);
        Assert.assertEquals((long)5L, (long)workResult8);
        double workResult9 = protocol.doWork(6.0);
        Assert.assertEquals((double)6.0, (double)workResult9, (double)0.01);
        float workResult10 = protocol.doWork(Float.valueOf(6.0f)).floatValue();
        Assert.assertEquals((double)6.0, (double)workResult10, (double)0.01);
        Text workResult11 = protocol.doWork(new Text("foo"));
        Assert.assertEquals((Object)new Text("foo"), (Object)workResult11);
    }

    @Ignore
    @Test
    public void testAggregation() throws Throwable {
        HTable table = new HTable(util.getConfiguration(), TEST_TABLE);
        Map results = table.coprocessorExec(ColumnAggregationProtocol.class, ROWS[4], ROWS[13], (Batch.Call)new Batch.Call<ColumnAggregationProtocol, Long>(){

            public Long call(ColumnAggregationProtocol instance) throws IOException {
                return instance.sum(TEST_FAMILY, TEST_QUALIFIER);
            }
        });
        int sumResult = 0;
        int expectedResult = 0;
        for (Map.Entry e : results.entrySet()) {
            sumResult = (int)((long)sumResult + (Long)e.getValue());
        }
        for (int i = 0; i < 20; ++i) {
            expectedResult += i;
        }
        Assert.assertEquals((String)"Invalid result", (long)sumResult, (long)expectedResult);
        results.clear();
        results = table.coprocessorExec(ColumnAggregationProtocol.class, ROWS[6], ROWS[13], (Batch.Call)new Batch.Call<ColumnAggregationProtocol, Long>(){

            public Long call(ColumnAggregationProtocol instance) throws IOException {
                return instance.sum(TEST_FAMILY, TEST_QUALIFIER);
            }
        });
        sumResult = 0;
        expectedResult = 0;
        for (Map.Entry e : results.entrySet()) {
            sumResult = (int)((long)sumResult + (Long)e.getValue());
        }
        for (int i = 5; i < 20; ++i) {
            expectedResult += i;
        }
        Assert.assertEquals((String)"Invalid result", (long)sumResult, (long)expectedResult);
        table.close();
    }

    @Test
    public void testExecDeserialization() throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        dob.writeUTF(methodName);
        dob.writeInt(1);
        Scan scan = new Scan();
        HbaseObjectWritable.writeObject((DataOutput)dob, (Object)scan, Scan.class, (Configuration)new Configuration());
        dob.writeUTF("org.apache.hadoop.hbase.client.Scan");
        Bytes.writeByteArray((DataOutput)dob, (byte[])new byte[]{97});
        dob.writeUTF(protocolName);
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(dob.getData(), dob.getLength());
        Exec after = new Exec();
        after.setConf(HBaseConfiguration.create());
        after.readFields((DataInput)dib);
        Assert.assertEquals((Object)after.getProtocolName(), (Object)protocolName);
        Assert.assertEquals((Object)after.getMethodName(), (Object)methodName);
    }

    private static byte[][] makeN(byte[] base, int n) {
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            ret[i] = Bytes.add((byte[])base, (byte[])Bytes.toBytes((String)String.format("%02d", i)));
        }
        return ret;
    }
}

