/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMasterObserver {
    private static final Log LOG = LogFactory.getLog(TestMasterObserver.class);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static byte[] TEST_SNAPSHOT = Bytes.toBytes((String)"observed_snapshot");
    private static byte[] TEST_TABLE = Bytes.toBytes((String)"observed_table");
    private static byte[] TEST_CLONE = Bytes.toBytes((String)"observed_clone");
    private static byte[] TEST_FAMILY = Bytes.toBytes((String)"fam1");
    private static byte[] TEST_FAMILY2 = Bytes.toBytes((String)"fam2");
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.coprocessor.master.classes", CPMasterObserver.class.getName());
        conf.setBoolean("hbase.snapshot.enabled", true);
        UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testStarted() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        Assert.assertTrue((String)"Master should be active", (boolean)master.isActiveMaster());
        MasterCoprocessorHost host = master.getCoprocessorHost();
        Assert.assertNotNull((String)"CoprocessorHost should not be null", (Object)host);
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class.getName());
        Assert.assertNotNull((String)"CPMasterObserver coprocessor not found or not installed!", (Object)cp);
        Assert.assertTrue((String)"MasterObserver should have been started", (boolean)cp.wasStarted());
        Assert.assertTrue((String)"postStartMaster() hook should have been called", (boolean)cp.wasStartMasterCalled());
    }

    @Test
    public void testTableOperations() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        MasterCoprocessorHost host = master.getCoprocessorHost();
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class.getName());
        cp.enableBypass(true);
        cp.resetStates();
        Assert.assertFalse((String)"No table created yet", (boolean)cp.wasCreateTableCalled());
        HTableDescriptor htd = new HTableDescriptor(TEST_TABLE);
        htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        admin.createTable(htd);
        Assert.assertTrue((String)"Test table should be created", (boolean)cp.wasCreateTableCalled());
        admin.disableTable(TEST_TABLE);
        Assert.assertTrue((boolean)admin.isTableDisabled(TEST_TABLE));
        Assert.assertTrue((String)"Coprocessor should have been called on table disable", (boolean)cp.wasDisableTableCalled());
        Assert.assertFalse((boolean)cp.wasEnableTableCalled());
        admin.enableTable(TEST_TABLE);
        Assert.assertTrue((boolean)admin.isTableEnabled(TEST_TABLE));
        Assert.assertTrue((String)"Coprocessor should have been called on table enable", (boolean)cp.wasEnableTableCalled());
        admin.disableTable(TEST_TABLE);
        Assert.assertTrue((boolean)admin.isTableDisabled(TEST_TABLE));
        htd.setMaxFileSize(0x20000000L);
        this.modifyTableSync(admin, TEST_TABLE, htd);
        Assert.assertTrue((String)"Test table should have been modified", (boolean)cp.wasModifyTableCalled());
        admin.addColumn(TEST_TABLE, new HColumnDescriptor(TEST_FAMILY2));
        Assert.assertTrue((String)"New column family shouldn't have been added to test table", (boolean)cp.preAddColumnCalledOnly());
        HColumnDescriptor hcd1 = new HColumnDescriptor(TEST_FAMILY2);
        hcd1.setMaxVersions(25);
        admin.modifyColumn(TEST_TABLE, hcd1);
        Assert.assertTrue((String)"Second column family should be modified", (boolean)cp.preModifyColumnCalledOnly());
        admin.deleteTable(TEST_TABLE);
        Assert.assertFalse((String)"Test table should have been deleted", (boolean)admin.tableExists(TEST_TABLE));
        Assert.assertTrue((String)"Coprocessor should have been called on table delete", (boolean)cp.wasDeleteTableCalled());
        cp.enableBypass(false);
        cp.resetStates();
        admin.createTable(htd);
        Assert.assertTrue((String)"Test table should be created", (boolean)cp.wasCreateTableCalled());
        Assert.assertFalse((boolean)cp.wasDisableTableCalled());
        admin.disableTable(TEST_TABLE);
        Assert.assertTrue((boolean)admin.isTableDisabled(TEST_TABLE));
        Assert.assertTrue((String)"Coprocessor should have been called on table disable", (boolean)cp.wasDisableTableCalled());
        htd.setMaxFileSize(0x20000000L);
        this.modifyTableSync(admin, TEST_TABLE, htd);
        Assert.assertTrue((String)"Test table should have been modified", (boolean)cp.wasModifyTableCalled());
        admin.addColumn(TEST_TABLE, new HColumnDescriptor(TEST_FAMILY2));
        Assert.assertTrue((String)"New column family should have been added to test table", (boolean)cp.wasAddColumnCalled());
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY2);
        hcd.setMaxVersions(25);
        admin.modifyColumn(TEST_TABLE, hcd);
        Assert.assertTrue((String)"Second column family should be modified", (boolean)cp.wasModifyColumnCalled());
        Assert.assertFalse((boolean)cp.wasEnableTableCalled());
        admin.enableTable(TEST_TABLE);
        Assert.assertTrue((boolean)admin.isTableEnabled(TEST_TABLE));
        Assert.assertTrue((String)"Coprocessor should have been called on table enable", (boolean)cp.wasEnableTableCalled());
        admin.disableTable(TEST_TABLE);
        Assert.assertTrue((boolean)admin.isTableDisabled(TEST_TABLE));
        Assert.assertFalse((String)"No column family deleted yet", (boolean)cp.wasDeleteColumnCalled());
        admin.deleteColumn(TEST_TABLE, TEST_FAMILY2);
        HTableDescriptor tableDesc = admin.getTableDescriptor(TEST_TABLE);
        Assert.assertNull((String)("'" + Bytes.toString((byte[])TEST_FAMILY2) + "' should have been removed"), (Object)tableDesc.getFamily(TEST_FAMILY2));
        Assert.assertTrue((String)"Coprocessor should have been called on column delete", (boolean)cp.wasDeleteColumnCalled());
        Assert.assertFalse((String)"No table deleted yet", (boolean)cp.wasDeleteTableCalled());
        admin.deleteTable(TEST_TABLE);
        Assert.assertFalse((String)"Test table should have been deleted", (boolean)admin.tableExists(TEST_TABLE));
        Assert.assertTrue((String)"Coprocessor should have been called on table delete", (boolean)cp.wasDeleteTableCalled());
    }

    private void modifyTableSync(HBaseAdmin admin, byte[] tableName, HTableDescriptor htd) throws IOException {
        HTableDescriptor td;
        admin.modifyTable(tableName, htd);
        for (int t = 0; t < 100 && !(td = admin.getTableDescriptor(htd.getName())).equals((Object)htd); ++t) {
            Threads.sleep((long)100L);
        }
    }

    @Test
    public void testRegionTransitionOperations() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        MasterCoprocessorHost host = master.getCoprocessorHost();
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class.getName());
        cp.enableBypass(false);
        cp.resetStates();
        HTable table = UTIL.createTable(TEST_TABLE, TEST_FAMILY);
        int countOfRegions = UTIL.createMultiRegions(table, TEST_FAMILY);
        UTIL.waitUntilAllRegionsAssigned(countOfRegions);
        NavigableMap regions = table.getRegionLocations();
        Map.Entry firstGoodPair = null;
        for (Map.Entry e : regions.entrySet()) {
            if (e.getValue() == null) continue;
            firstGoodPair = e;
            break;
        }
        Assert.assertNotNull((String)"Found a non-null entry", firstGoodPair);
        LOG.info((Object)("Found " + firstGoodPair.toString()));
        Collection servers = master.getClusterStatus().getServers();
        String destName = null;
        String firstRegionHostnamePortStr = ((ServerName)firstGoodPair.getValue()).toString();
        LOG.info((Object)("firstRegionHostnamePortStr=" + firstRegionHostnamePortStr));
        boolean found = false;
        for (ServerName info : servers) {
            LOG.info((Object)("ServerName=" + info));
            if (firstRegionHostnamePortStr.equals(info.getHostAndPort())) continue;
            destName = info.toString();
            found = true;
            break;
        }
        Assert.assertTrue((String)"Found server", (boolean)found);
        LOG.info((Object)("Found " + destName));
        master.move(((HRegionInfo)firstGoodPair.getKey()).getEncodedNameAsBytes(), Bytes.toBytes(destName));
        Assert.assertTrue((String)"Coprocessor should have been called on region move", (boolean)cp.wasMoveCalled());
        master.balanceSwitch(true);
        Assert.assertTrue((String)"Coprocessor should have been called on balance switch", (boolean)cp.wasBalanceSwitchCalled());
        master.balanceSwitch(false);
        HRegionServer rs = cluster.getRegionServer(0);
        byte[] destRS = Bytes.toBytes((String)cluster.getRegionServer(1).getServerName().toString());
        this.waitForRITtoBeZero(master);
        List openRegions = rs.getOnlineRegions();
        int moveCnt = openRegions.size() / 2;
        for (int i = 0; i < moveCnt; ++i) {
            HRegionInfo info = (HRegionInfo)openRegions.get(i);
            if (info.isMetaTable()) continue;
            master.move(((HRegionInfo)openRegions.get(i)).getEncodedNameAsBytes(), destRS);
        }
        this.waitForRITtoBeZero(master);
        master.balanceSwitch(true);
        boolean balanceRun = master.balance();
        Assert.assertTrue((String)"Coprocessor should be called on region rebalancing", (boolean)cp.wasBalanceCalled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotOperations() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        MasterCoprocessorHost host = master.getCoprocessorHost();
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class.getName());
        cp.resetStates();
        HTableDescriptor htd = new HTableDescriptor(TEST_TABLE);
        htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        if (admin.tableExists(TEST_TABLE)) {
            UTIL.deleteTable(TEST_TABLE);
        }
        admin.createTable(htd);
        admin.disableTable(TEST_TABLE);
        Assert.assertTrue((boolean)admin.isTableDisabled(TEST_TABLE));
        try {
            Assert.assertFalse((String)"Coprocessor should not have been called yet", (boolean)cp.wasSnapshotCalled());
            admin.snapshot(TEST_SNAPSHOT, TEST_TABLE);
            Assert.assertTrue((String)"Coprocessor should have been called on snapshot", (boolean)cp.wasSnapshotCalled());
            admin.cloneSnapshot(TEST_SNAPSHOT, TEST_CLONE);
            Assert.assertTrue((String)"Coprocessor should have been called on snapshot clone", (boolean)cp.wasCloneSnapshotCalled());
            Assert.assertFalse((String)"Coprocessor restore should not have been called on snapshot clone", (boolean)cp.wasRestoreSnapshotCalled());
            admin.disableTable(TEST_CLONE);
            Assert.assertTrue((boolean)admin.isTableDisabled(TEST_TABLE));
            admin.deleteTable(TEST_CLONE);
            cp.resetStates();
            admin.restoreSnapshot(TEST_SNAPSHOT);
            Assert.assertTrue((String)"Coprocessor should have been called on snapshot restore", (boolean)cp.wasRestoreSnapshotCalled());
            Assert.assertFalse((String)"Coprocessor clone should not have been called on snapshot restore", (boolean)cp.wasCloneSnapshotCalled());
            admin.deleteSnapshot(TEST_SNAPSHOT);
            Assert.assertTrue((String)"Coprocessor should have been called on snapshot delete", (boolean)cp.wasDeleteSnapshotCalled());
        }
        finally {
            admin.deleteTable(TEST_TABLE);
        }
    }

    private void waitForRITtoBeZero(HMaster master) throws IOException {
        AssignmentManager mgr = master.getAssignmentManager();
        Collection transRegions = mgr.getRegionsInTransition().values();
        for (AssignmentManager.RegionState state : transRegions) {
            mgr.waitOnRegionToClearRegionsInTransition(state.getRegion());
        }
    }

    public static class CPMasterObserver
    implements MasterObserver {
        private boolean bypass = false;
        private boolean preCreateTableCalled;
        private boolean postCreateTableCalled;
        private boolean preDeleteTableCalled;
        private boolean postDeleteTableCalled;
        private boolean preModifyTableCalled;
        private boolean postModifyTableCalled;
        private boolean preAddColumnCalled;
        private boolean postAddColumnCalled;
        private boolean preModifyColumnCalled;
        private boolean postModifyColumnCalled;
        private boolean preDeleteColumnCalled;
        private boolean postDeleteColumnCalled;
        private boolean preEnableTableCalled;
        private boolean postEnableTableCalled;
        private boolean preDisableTableCalled;
        private boolean postDisableTableCalled;
        private boolean preMoveCalled;
        private boolean postMoveCalled;
        private boolean preAssignCalled;
        private boolean postAssignCalled;
        private boolean preUnassignCalled;
        private boolean postUnassignCalled;
        private boolean preBalanceCalled;
        private boolean postBalanceCalled;
        private boolean preBalanceSwitchCalled;
        private boolean postBalanceSwitchCalled;
        private boolean preShutdownCalled;
        private boolean preStopMasterCalled;
        private boolean postStartMasterCalled;
        private boolean startCalled;
        private boolean stopCalled;
        private boolean preSnapshotCalled;
        private boolean postSnapshotCalled;
        private boolean preCloneSnapshotCalled;
        private boolean postCloneSnapshotCalled;
        private boolean preRestoreSnapshotCalled;
        private boolean postRestoreSnapshotCalled;
        private boolean preDeleteSnapshotCalled;
        private boolean postDeleteSnapshotCalled;

        public void enableBypass(boolean bypass) {
            this.bypass = bypass;
        }

        public void resetStates() {
            this.preCreateTableCalled = false;
            this.postCreateTableCalled = false;
            this.preDeleteTableCalled = false;
            this.postDeleteTableCalled = false;
            this.preModifyTableCalled = false;
            this.postModifyTableCalled = false;
            this.preAddColumnCalled = false;
            this.postAddColumnCalled = false;
            this.preModifyColumnCalled = false;
            this.postModifyColumnCalled = false;
            this.preDeleteColumnCalled = false;
            this.postDeleteColumnCalled = false;
            this.preEnableTableCalled = false;
            this.postEnableTableCalled = false;
            this.preDisableTableCalled = false;
            this.postDisableTableCalled = false;
            this.preMoveCalled = false;
            this.postMoveCalled = false;
            this.preAssignCalled = false;
            this.postAssignCalled = false;
            this.preUnassignCalled = false;
            this.postUnassignCalled = false;
            this.preBalanceCalled = false;
            this.postBalanceCalled = false;
            this.preBalanceSwitchCalled = false;
            this.postBalanceSwitchCalled = false;
            this.preSnapshotCalled = false;
            this.postSnapshotCalled = false;
            this.preCloneSnapshotCalled = false;
            this.postCloneSnapshotCalled = false;
            this.preRestoreSnapshotCalled = false;
            this.postRestoreSnapshotCalled = false;
            this.preDeleteSnapshotCalled = false;
            this.postDeleteSnapshotCalled = false;
        }

        public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> env, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preCreateTableCalled = true;
        }

        public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> env, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
            this.postCreateTableCalled = true;
        }

        public boolean wasCreateTableCalled() {
            return this.preCreateTableCalled && this.postCreateTableCalled;
        }

        public boolean preCreateTableCalledOnly() {
            return this.preCreateTableCalled && !this.postCreateTableCalled;
        }

        public void preDeleteTable(ObserverContext<MasterCoprocessorEnvironment> env, byte[] tableName) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preDeleteTableCalled = true;
        }

        public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> env, byte[] tableName) throws IOException {
            this.postDeleteTableCalled = true;
        }

        public boolean wasDeleteTableCalled() {
            return this.preDeleteTableCalled && this.postDeleteTableCalled;
        }

        public boolean preDeleteTableCalledOnly() {
            return this.preDeleteTableCalled && !this.postDeleteTableCalled;
        }

        public void preModifyTable(ObserverContext<MasterCoprocessorEnvironment> env, byte[] tableName, HTableDescriptor htd) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preModifyTableCalled = true;
        }

        public void postModifyTable(ObserverContext<MasterCoprocessorEnvironment> env, byte[] tableName, HTableDescriptor htd) throws IOException {
            this.postModifyTableCalled = true;
        }

        public boolean wasModifyTableCalled() {
            return this.preModifyTableCalled && this.postModifyTableCalled;
        }

        public boolean preModifyTableCalledOnly() {
            return this.preModifyTableCalled && !this.postModifyTableCalled;
        }

        public void preAddColumn(ObserverContext<MasterCoprocessorEnvironment> env, byte[] tableName, HColumnDescriptor column) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preAddColumnCalled = true;
        }

        public void postAddColumn(ObserverContext<MasterCoprocessorEnvironment> env, byte[] tableName, HColumnDescriptor column) throws IOException {
            this.postAddColumnCalled = true;
        }

        public boolean wasAddColumnCalled() {
            return this.preAddColumnCalled && this.postAddColumnCalled;
        }

        public boolean preAddColumnCalledOnly() {
            return this.preAddColumnCalled && !this.postAddColumnCalled;
        }

        public void preModifyColumn(ObserverContext<MasterCoprocessorEnvironment> env, byte[] tableName, HColumnDescriptor descriptor) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preModifyColumnCalled = true;
        }

        public void postModifyColumn(ObserverContext<MasterCoprocessorEnvironment> env, byte[] tableName, HColumnDescriptor descriptor) throws IOException {
            this.postModifyColumnCalled = true;
        }

        public boolean wasModifyColumnCalled() {
            return this.preModifyColumnCalled && this.postModifyColumnCalled;
        }

        public boolean preModifyColumnCalledOnly() {
            return this.preModifyColumnCalled && !this.postModifyColumnCalled;
        }

        public void preDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> env, byte[] tableName, byte[] c) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preDeleteColumnCalled = true;
        }

        public void postDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> env, byte[] tableName, byte[] c) throws IOException {
            this.postDeleteColumnCalled = true;
        }

        public boolean wasDeleteColumnCalled() {
            return this.preDeleteColumnCalled && this.postDeleteColumnCalled;
        }

        public boolean preDeleteColumnCalledOnly() {
            return this.preDeleteColumnCalled && !this.postDeleteColumnCalled;
        }

        public void preEnableTable(ObserverContext<MasterCoprocessorEnvironment> env, byte[] tableName) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preEnableTableCalled = true;
        }

        public void postEnableTable(ObserverContext<MasterCoprocessorEnvironment> env, byte[] tableName) throws IOException {
            this.postEnableTableCalled = true;
        }

        public boolean wasEnableTableCalled() {
            return this.preEnableTableCalled && this.postEnableTableCalled;
        }

        public boolean preEnableTableCalledOnly() {
            return this.preEnableTableCalled && !this.postEnableTableCalled;
        }

        public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> env, byte[] tableName) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preDisableTableCalled = true;
        }

        public void postDisableTable(ObserverContext<MasterCoprocessorEnvironment> env, byte[] tableName) throws IOException {
            this.postDisableTableCalled = true;
        }

        public boolean wasDisableTableCalled() {
            return this.preDisableTableCalled && this.postDisableTableCalled;
        }

        public boolean preDisableTableCalledOnly() {
            return this.preDisableTableCalled && !this.postDisableTableCalled;
        }

        public void preMove(ObserverContext<MasterCoprocessorEnvironment> env, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preMoveCalled = true;
        }

        public void postMove(ObserverContext<MasterCoprocessorEnvironment> env, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
            this.postMoveCalled = true;
        }

        public boolean wasMoveCalled() {
            return this.preMoveCalled && this.postMoveCalled;
        }

        public boolean preMoveCalledOnly() {
            return this.preMoveCalled && !this.postMoveCalled;
        }

        public void preAssign(ObserverContext<MasterCoprocessorEnvironment> env, HRegionInfo regionInfo) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preAssignCalled = true;
        }

        public void postAssign(ObserverContext<MasterCoprocessorEnvironment> env, HRegionInfo regionInfo) throws IOException {
            this.postAssignCalled = true;
        }

        public boolean wasAssignCalled() {
            return this.preAssignCalled && this.postAssignCalled;
        }

        public boolean preAssignCalledOnly() {
            return this.preAssignCalled && !this.postAssignCalled;
        }

        public void preUnassign(ObserverContext<MasterCoprocessorEnvironment> env, HRegionInfo regionInfo, boolean force) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preUnassignCalled = true;
        }

        public void postUnassign(ObserverContext<MasterCoprocessorEnvironment> env, HRegionInfo regionInfo, boolean force) throws IOException {
            this.postUnassignCalled = true;
        }

        public boolean wasUnassignCalled() {
            return this.preUnassignCalled && this.postUnassignCalled;
        }

        public boolean preUnassignCalledOnly() {
            return this.preUnassignCalled && !this.postUnassignCalled;
        }

        public void preBalance(ObserverContext<MasterCoprocessorEnvironment> env) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preBalanceCalled = true;
        }

        public void postBalance(ObserverContext<MasterCoprocessorEnvironment> env) throws IOException {
            this.postBalanceCalled = true;
        }

        public boolean wasBalanceCalled() {
            return this.preBalanceCalled && this.postBalanceCalled;
        }

        public boolean preBalanceCalledOnly() {
            return this.preBalanceCalled && !this.postBalanceCalled;
        }

        public boolean preBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> env, boolean b) throws IOException {
            if (this.bypass) {
                env.bypass();
            }
            this.preBalanceSwitchCalled = true;
            return b;
        }

        public void postBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> env, boolean oldValue, boolean newValue) throws IOException {
            this.postBalanceSwitchCalled = true;
        }

        public boolean wasBalanceSwitchCalled() {
            return this.preBalanceSwitchCalled && this.postBalanceSwitchCalled;
        }

        public boolean preBalanceSwitchCalledOnly() {
            return this.preBalanceSwitchCalled && !this.postBalanceSwitchCalled;
        }

        public void preShutdown(ObserverContext<MasterCoprocessorEnvironment> env) throws IOException {
            this.preShutdownCalled = true;
        }

        public void preStopMaster(ObserverContext<MasterCoprocessorEnvironment> env) throws IOException {
            this.preStopMasterCalled = true;
        }

        public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
            this.postStartMasterCalled = true;
        }

        public boolean wasStartMasterCalled() {
            return this.postStartMasterCalled;
        }

        public void start(CoprocessorEnvironment env) throws IOException {
            this.startCalled = true;
        }

        public void stop(CoprocessorEnvironment env) throws IOException {
            this.stopCalled = true;
        }

        public boolean wasStarted() {
            return this.startCalled;
        }

        public boolean wasStopped() {
            return this.stopCalled;
        }

        public void preSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
            this.preSnapshotCalled = true;
        }

        public void postSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
            this.postSnapshotCalled = true;
        }

        public boolean wasSnapshotCalled() {
            return this.preSnapshotCalled && this.postSnapshotCalled;
        }

        public void preCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
            this.preCloneSnapshotCalled = true;
        }

        public void postCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
            this.postCloneSnapshotCalled = true;
        }

        public boolean wasCloneSnapshotCalled() {
            return this.preCloneSnapshotCalled && this.postCloneSnapshotCalled;
        }

        public void preRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
            this.preRestoreSnapshotCalled = true;
        }

        public void postRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
            this.postRestoreSnapshotCalled = true;
        }

        public boolean wasRestoreSnapshotCalled() {
            return this.preRestoreSnapshotCalled && this.postRestoreSnapshotCalled;
        }

        public void preDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
            this.preDeleteSnapshotCalled = true;
        }

        public void postDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
            this.postDeleteSnapshotCalled = true;
        }

        public boolean wasDeleteSnapshotCalled() {
            return this.preDeleteSnapshotCalled && this.postDeleteSnapshotCalled;
        }
    }
}

